/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.logging.view.ui;

import java.io.InputStream;
import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.logging.view.stub.LogViewerLogViewerException;
import org.wso2.carbon.logging.view.stub.LogViewerStub;
import org.wso2.carbon.logging.view.stub.types.carbon.LogEvent;
import org.wso2.carbon.logging.view.stub.types.carbon.PaginatedLogEvent;
import org.wso2.carbon.logging.view.stub.types.carbon.PaginatedLogInfo;

public class LogViewerClient {
    private static final Log log = LogFactory.getLog(LogViewerClient.class);
    public LogViewerStub stub;

    public LogViewerClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "LogViewer";
        this.stub = new LogViewerStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
        option.setProperty("enableMTOM", (Object)"true");
    }

    public boolean isValidTenantDomain(String tenantDomain) throws Exception {
        try {
            return this.stub.isValidTenantDomain(tenantDomain);
        }
        catch (Exception e) {
            String msg = "Error occurred while getting logger data. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void cleaLogs() throws Exception {
        this.stub.clearLogs();
    }

    public void downloadLogFiles(String logFile, String tenantDomain, String serviceName, HttpServletResponse response) throws Exception {
        try {
            int c;
            ServletOutputStream outputStream = response.getOutputStream();
            response.setContentType("application/zip");
            response.setHeader("Content-Disposition", "attachment;filename=" + logFile.replaceAll("\\s", "_"));
            DataHandler data = this.stub.downloadLogFiles(logFile, tenantDomain, serviceName);
            InputStream fileToDownload = data.getInputStream();
            while ((c = fileToDownload.read()) != -1) {
                outputStream.write(c);
            }
            outputStream.flush();
            outputStream.flush();
        }
        catch (Exception e) {
            String msg = "Error occurred while getting logger data. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public int getLineNumbers(String logFile, String domainName, String serviceName) throws Exception {
        try {
            return this.stub.getLineNumbers(logFile, domainName, serviceName);
        }
        catch (RemoteException e) {
            String msg = "Error occurred while getting logger data. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public PaginatedLogInfo getPaginatedLogInfo(int pageNumber, String tenantDomain, String serviceName) throws Exception {
        try {
            return this.stub.getPaginatedLogInfo(pageNumber, tenantDomain, serviceName);
        }
        catch (RemoteException e) {
            String msg = "Error occurred while getting logger data. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public LogEvent[] getLogs(String type, String keyword) throws Exception {
        if (type == null || type.equals("")) {
            type = "ALL";
        }
        try {
            return this.stub.getLogs(type, keyword);
        }
        catch (RemoteException e) {
            String msg = "Error occurred while getting logger data. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public LogEvent[] getApplicationLogs(String type, String keyword, String applicationName) throws Exception {
        if (type == null || type.equals("")) {
            type = "ALL";
        }
        if (applicationName == null || applicationName.equals("")) {
            applicationName = "FIRST";
        }
        try {
            return this.stub.getApplicationLogs(type, keyword, applicationName);
        }
        catch (RemoteException e) {
            String msg = "Error occurred while getting logger data. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public String[] getLogLinesFromFile(String logFile, int maxLogs, int start, int end, String domainName, String serviceName) throws Exception {
        try {
            return this.stub.getLogLinesFromFile(logFile, maxLogs, start, end, domainName, serviceName);
        }
        catch (RemoteException e) {
            String msg = "Error occurred while getting logger data. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public boolean isManager() throws RemoteException {
        try {
            return this.stub.isManager();
        }
        catch (RemoteException e) {
            String msg = "Error occurred while getting logger data. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public String[] getApplicationNames() throws LogViewerLogViewerException, RemoteException {
        try {
            return this.stub.getApplicationNames();
        }
        catch (RemoteException e) {
            String msg = "Error occurred while getting logger data. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public String[] getServiceNames() throws RemoteException, LogViewerLogViewerException {
        try {
            return this.stub.getServiceNames();
        }
        catch (RemoteException e) {
            String msg = "Error occurred while getting logger data. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public boolean isFileAppenderConfiguredForST() throws RemoteException {
        try {
            return this.stub.isFileAppenderConfiguredForST();
        }
        catch (RemoteException e) {
            String msg = "Error occurred while getting logger data. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public PaginatedLogEvent getPaginatedLogEvents(int pageNumber, String type, String keyword) throws Exception {
        try {
            return this.stub.getPaginatedLogEvents(pageNumber, type, keyword);
        }
        catch (RemoteException e) {
            String msg = "Error occurred while getting logger data. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public PaginatedLogEvent getPaginatedApplicationLogEvents(int pageNumber, String type, String keyword, String appName) throws Exception {
        try {
            return this.stub.getPaginatedApplicationLogEvents(pageNumber, type, keyword, appName);
        }
        catch (RemoteException e) {
            String msg = "Error occurred while getting logger data. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public PaginatedLogInfo getLocalLogFiles(int pageNo) throws RemoteException {
        try {
            return this.stub.getLocalLogFiles(pageNo);
        }
        catch (RemoteException e) {
            String msg = "Error occurred while getting logger data. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public boolean isLogEventReciverConfigured() throws RemoteException {
        try {
            return this.stub.isLogEventReciverConfigured();
        }
        catch (RemoteException e) {
            String msg = "Error occurred while getting logger data. Backend service may be unavailable";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public String getImageName(String type) {
        if (type.equals("INFO")) {
            return "images/information.gif";
        }
        if (type.equals("ERROR")) {
            return "images/error.png";
        }
        if (type.equals("WARN")) {
            return "images/warn.png";
        }
        if (type.equals("DEBUG")) {
            return "images/debug.png";
        }
        if (type.equals("TRACE")) {
            return "images/trace.png";
        }
        if (type.equals("FATAL")) {
            return "images/fatal.png";
        }
        return "";
    }

    public String[] getLogLevels() {
        return new String[]{"ALL", "FATAL", "ERROR", "WARN", "INFO", "DEBUG", "TRACE"};
    }
}

