/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.logging.appender;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.ApplicationContext;
import org.wso2.carbon.utils.logging.TenantAwareLoggingEvent;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;

public class LogEventAppender
extends AppenderSkeleton
implements Appender {
    private String url;
    private String password;
    private String userName;
    private String columnList;
    private static final Log log = LogFactory.getLog(LogEventAppender.class);
    private static final BlockingQueue<TenantAwareLoggingEvent> loggingEventQueue = new LinkedBlockingDeque<TenantAwareLoggingEvent>();

    public LogEventAppender() {
        this.startLogger();
    }

    private String getCurrentServerName() {
        String serverName = ServerConfiguration.getInstance().getFirstProperty("Name");
        return serverName.replace(" ", ".");
    }

    private String getStacktrace(Throwable e) {
        StackTraceElement[] stackTraceElements;
        StringBuilder stackTrace = new StringBuilder();
        for (StackTraceElement ele : stackTraceElements = e.getStackTrace()) {
            stackTrace.append(ele.toString()).append("\n");
        }
        return stackTrace.toString();
    }

    private void processLoggingEventQueue() {
        while (true) {
            try {
                while (true) {
                    TenantAwareLoggingEvent event;
                    if ((event = loggingEventQueue.poll(1L, TimeUnit.SECONDS)) == null) continue;
                }
            }
            catch (InterruptedException e) {
                LogLog.error((String)e.toString());
                continue;
            }
            break;
        }
    }

    private void startLogger() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                LogEventAppender.this.processLoggingEventQueue();
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public void close() {
    }

    protected void append(LoggingEvent event) {
        Logger logger = Logger.getLogger((String)event.getLoggerName());
        TenantAwareLoggingEvent tenantEvent = event.getThrowableInformation() != null ? new TenantAwareLoggingEvent(event.fqnOfCategoryClass, (Category)logger, event.timeStamp, (Priority)event.getLevel(), event.getMessage(), event.getThrowableInformation().getThrowable()) : new TenantAwareLoggingEvent(event.fqnOfCategoryClass, (Category)logger, event.timeStamp, (Priority)event.getLevel(), event.getMessage(), null);
        tenantEvent.setTenantId(Integer.toString(CarbonContextHolder.getCurrentCarbonContextHolder().getTenantId()));
        tenantEvent.setServiceName(ApplicationContext.getCurrentApplicationContext().getApplicationName());
        loggingEventQueue.add(tenantEvent);
    }

    public boolean requiresLayout() {
        return false;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getColumnList() {
        return this.columnList;
    }

    public void setColumnList(String columnList) {
        this.columnList = columnList;
    }

    public static BlockingQueue<TenantAwareLoggingEvent> getLoggingeventqueue() {
        return loggingEventQueue;
    }
}

