/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriUtils;

public class UrlPathHelper {
    private static final String WEBSPHERE_URI_ATTRIBUTE = "com.ibm.websphere.servlet.uri_non_decoded";
    private static final Log logger = LogFactory.getLog(UrlPathHelper.class);
    static volatile Boolean websphereComplianceFlag;
    private boolean alwaysUseFullPath = false;
    private boolean urlDecode = true;
    private String defaultEncoding = "ISO-8859-1";

    public void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
        this.alwaysUseFullPath = alwaysUseFullPath;
    }

    public void setUrlDecode(boolean urlDecode) {
        this.urlDecode = urlDecode;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    protected String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getLookupPathForRequest(HttpServletRequest request) {
        if (this.alwaysUseFullPath) {
            return this.getPathWithinApplication(request);
        }
        String rest = this.getPathWithinServletMapping(request);
        if (!"".equals(rest)) {
            return rest;
        }
        return this.getPathWithinApplication(request);
    }

    public String getPathWithinServletMapping(HttpServletRequest request) {
        String servletPath;
        String pathWithinApp = this.getPathWithinApplication(request);
        if (pathWithinApp.startsWith(servletPath = this.getServletPath(request))) {
            return pathWithinApp.substring(servletPath.length());
        }
        String pathInfo = request.getPathInfo();
        return pathInfo != null ? pathInfo : servletPath;
    }

    public String getPathWithinApplication(HttpServletRequest request) {
        String contextPath = this.getContextPath(request);
        String requestUri = this.getRequestUri(request);
        if (StringUtils.startsWithIgnoreCase(requestUri, contextPath)) {
            String path = requestUri.substring(contextPath.length());
            return StringUtils.hasText(path) ? path : "/";
        }
        return requestUri;
    }

    public String getRequestUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.request_uri");
        if (uri == null) {
            uri = request.getRequestURI();
        }
        return this.decodeAndCleanUriString(request, uri);
    }

    public String getContextPath(HttpServletRequest request) {
        String contextPath = (String)request.getAttribute("javax.servlet.include.context_path");
        if (contextPath == null) {
            contextPath = request.getContextPath();
        }
        if ("/".equals(contextPath)) {
            contextPath = "";
        }
        return this.decodeRequestString(request, contextPath);
    }

    public String getServletPath(HttpServletRequest request) {
        String servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = request.getServletPath();
        }
        if (servletPath.length() > 1 && servletPath.endsWith("/") && this.shouldRemoveTrailingServletPathSlash(request)) {
            servletPath = servletPath.substring(0, servletPath.length() - 1);
        }
        return servletPath;
    }

    public String getOriginatingRequestUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute(WEBSPHERE_URI_ATTRIBUTE);
        if (uri == null && (uri = (String)request.getAttribute("javax.servlet.forward.request_uri")) == null) {
            uri = request.getRequestURI();
        }
        return this.decodeAndCleanUriString(request, uri);
    }

    public String getOriginatingContextPath(HttpServletRequest request) {
        String contextPath = (String)request.getAttribute("javax.servlet.forward.context_path");
        if (contextPath == null) {
            contextPath = request.getContextPath();
        }
        return this.decodeRequestString(request, contextPath);
    }

    public String getOriginatingServletPath(HttpServletRequest request) {
        String servletPath = (String)request.getAttribute("javax.servlet.forward.servlet_path");
        if (servletPath == null) {
            servletPath = request.getServletPath();
        }
        return servletPath;
    }

    public String getOriginatingQueryString(HttpServletRequest request) {
        if (request.getAttribute("javax.servlet.forward.request_uri") != null || request.getAttribute("javax.servlet.error.request_uri") != null) {
            return (String)request.getAttribute("javax.servlet.forward.query_string");
        }
        return request.getQueryString();
    }

    private String decodeAndCleanUriString(HttpServletRequest request, String uri) {
        int semicolonIndex = (uri = this.decodeRequestString(request, uri)).indexOf(59);
        return semicolonIndex != -1 ? uri.substring(0, semicolonIndex) : uri;
    }

    public String decodeRequestString(HttpServletRequest request, String source) {
        if (this.urlDecode) {
            String enc = this.determineEncoding(request);
            try {
                return UriUtils.decode(source, enc);
            }
            catch (UnsupportedEncodingException ex) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Could not decode request string [" + source + "] with encoding '" + enc + "': falling back to platform default encoding; exception message: " + ex.getMessage()));
                }
                return URLDecoder.decode(source);
            }
        }
        return source;
    }

    protected String determineEncoding(HttpServletRequest request) {
        String enc = request.getCharacterEncoding();
        if (enc == null) {
            enc = this.getDefaultEncoding();
        }
        return enc;
    }

    private boolean shouldRemoveTrailingServletPathSlash(HttpServletRequest request) {
        if (request.getAttribute(WEBSPHERE_URI_ATTRIBUTE) == null) {
            return false;
        }
        if (websphereComplianceFlag == null) {
            boolean flag;
            block4: {
                ClassLoader classLoader = UrlPathHelper.class.getClassLoader();
                String className = "com.ibm.ws.webcontainer.WebContainer";
                String methodName = "getWebContainerProperties";
                String propName = "com.ibm.ws.webcontainer.removetrailingservletpathslash";
                flag = false;
                try {
                    Class<?> cl = classLoader.loadClass(className);
                    Properties prop = (Properties)cl.getMethod(methodName, new Class[0]).invoke(null, new Object[0]);
                    flag = Boolean.parseBoolean(prop.getProperty(propName));
                }
                catch (Throwable ex) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)("Could not introspect WebSphere web container properties: " + ex));
                }
            }
            websphereComplianceFlag = flag;
        }
        return websphereComplianceFlag == false;
    }
}

