/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Property {
    private final Class<?> objectType;
    private final Method readMethod;
    private final Method writeMethod;
    private final String name;
    private final MethodParameter methodParameter;
    private final Annotation[] annotations;

    public Property(Class<?> objectType, Method readMethod, Method writeMethod) {
        this.objectType = objectType;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.methodParameter = this.resolveMethodParameter();
        this.name = this.resolveName();
        this.annotations = this.resolveAnnotations();
    }

    public Class<?> getObjectType() {
        return this.objectType;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.methodParameter.getParameterType();
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    Annotation[] getAnnotations() {
        return this.annotations;
    }

    private String resolveName() {
        if (this.readMethod != null) {
            int index = this.readMethod.getName().indexOf("get");
            if (index != -1) {
                index += 3;
            } else {
                index = this.readMethod.getName().indexOf("is");
                if (index == -1) {
                    throw new IllegalArgumentException("Not a getter method");
                }
                index += 2;
            }
            return StringUtils.uncapitalize(this.readMethod.getName().substring(index));
        }
        int index = this.writeMethod.getName().indexOf("set") + 3;
        if (index == -1) {
            throw new IllegalArgumentException("Not a setter method");
        }
        return StringUtils.uncapitalize(this.writeMethod.getName().substring(index));
    }

    private MethodParameter resolveMethodParameter() {
        MethodParameter read = this.resolveReadMethodParameter();
        MethodParameter write = this.resolveWriteMethodParameter();
        if (read == null && write == null) {
            throw new IllegalStateException("Property is neither readable nor writeable");
        }
        if (read != null && write != null && !write.getParameterType().isAssignableFrom(read.getParameterType())) {
            throw new IllegalStateException("Write parameter is not assignable from read parameter");
        }
        return read != null ? read : write;
    }

    private MethodParameter resolveReadMethodParameter() {
        if (this.getReadMethod() == null) {
            return null;
        }
        return this.resolveParameterType(new MethodParameter(this.getReadMethod(), -1));
    }

    private MethodParameter resolveWriteMethodParameter() {
        if (this.getWriteMethod() == null) {
            return null;
        }
        return this.resolveParameterType(new MethodParameter(this.getWriteMethod(), 0));
    }

    private MethodParameter resolveParameterType(MethodParameter parameter) {
        GenericTypeResolver.resolveParameterType(parameter, this.getObjectType());
        return parameter;
    }

    private Annotation[] resolveAnnotations() {
        Field field;
        Method writeMethod;
        int n;
        LinkedHashMap<Class<? extends Annotation>, Annotation> annMap = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
        Method readMethod = this.getReadMethod();
        if (readMethod != null) {
            Annotation[] annotationArray = readMethod.getAnnotations();
            n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation ann = annotationArray[n2];
                annMap.put(ann.annotationType(), ann);
                ++n2;
            }
        }
        if ((writeMethod = this.getWriteMethod()) != null) {
            Annotation[] annotationArray = writeMethod.getAnnotations();
            int n3 = annotationArray.length;
            n = 0;
            while (n < n3) {
                Annotation ann = annotationArray[n];
                annMap.put(ann.annotationType(), ann);
                ++n;
            }
        }
        if ((field = this.getField()) != null) {
            Annotation[] annotationArray = field.getAnnotations();
            int n4 = annotationArray.length;
            int n5 = 0;
            while (n5 < n4) {
                Annotation ann = annotationArray[n5];
                annMap.put(ann.annotationType(), ann);
                ++n5;
            }
        }
        return annMap.values().toArray(new Annotation[annMap.size()]);
    }

    private Field getField() {
        String name = this.getName();
        if (!StringUtils.hasLength(name)) {
            return null;
        }
        Class<?> declaringClass = this.declaringClass();
        Field field = ReflectionUtils.findField(declaringClass, name);
        if (field == null && (field = ReflectionUtils.findField(declaringClass, String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1))) == null) {
            field = ReflectionUtils.findField(declaringClass, String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1));
        }
        return field;
    }

    private Class<?> declaringClass() {
        if (this.getReadMethod() != null) {
            return this.getReadMethod().getDeclaringClass();
        }
        return this.getWriteMethod().getDeclaringClass();
    }
}

