/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.logging.service;

import java.util.Arrays;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Logger;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.logging.appender.CarbonMemoryAppender;
import org.wso2.carbon.logging.appender.LogEventAppender;
import org.wso2.carbon.logging.config.ServiceConfigManager;
import org.wso2.carbon.logging.service.LogViewerException;
import org.wso2.carbon.logging.service.data.LogEvent;
import org.wso2.carbon.logging.service.data.LogInfo;
import org.wso2.carbon.logging.service.data.LogMessage;
import org.wso2.carbon.logging.service.data.PaginatedLogEvent;
import org.wso2.carbon.logging.service.data.PaginatedLogInfo;
import org.wso2.carbon.logging.util.LoggingUtil;
import org.wso2.carbon.utils.DataPaginator;
import org.wso2.carbon.utils.Pageable;

public class LogViewer {
    private static final LogMessage[] NO_LOGS_MESSAGE = new LogMessage[]{new LogMessage("NO_LOGS", "INFO")};

    public PaginatedLogInfo getPaginatedLogInfo(int pageNumber, String tenantDomain, String serviceName) throws Exception {
        LogInfo[] logs = LoggingUtil.getLogsIndex(tenantDomain, serviceName);
        if (logs != null) {
            List<LogInfo> logInfoList = Arrays.asList(logs);
            PaginatedLogInfo paginatedLogInfo = new PaginatedLogInfo();
            DataPaginator.doPaging((int)pageNumber, logInfoList, (Pageable)paginatedLogInfo);
            return paginatedLogInfo;
        }
        return null;
    }

    public PaginatedLogInfo getLocalLogFiles(int pageNumber) {
        LogInfo[] logs = LoggingUtil.getLocalLogInfo();
        if (logs != null) {
            List<LogInfo> logInfoList = Arrays.asList(logs);
            PaginatedLogInfo paginatedLogInfo = new PaginatedLogInfo();
            DataPaginator.doPaging((int)pageNumber, logInfoList, (Pageable)paginatedLogInfo);
            return paginatedLogInfo;
        }
        return null;
    }

    public DataHandler downloadLogFiles(String logFile, String tenantDomain, String serviceName) throws Exception {
        return LoggingUtil.downloadLogFiles(logFile, tenantDomain, serviceName);
    }

    public boolean isValidTenantDomain(String tenantDomain) {
        return LoggingUtil.isValidTenantDomain(tenantDomain);
    }

    public String[] getServiceNames() throws LogViewerException {
        return ServiceConfigManager.getServiceNames();
    }

    public boolean isManager() {
        return LoggingUtil.isManager();
    }

    public int getLineNumbers(String logFile, String tenantDomain, String serviceName) throws Exception {
        return LoggingUtil.getLineNumbers(logFile, tenantDomain, serviceName);
    }

    public String[] getLogLinesFromFile(String logFile, int maxLogs, int start, int end, String tenantDomain, String serviceName) throws LogViewerException {
        return LoggingUtil.getLogLinesFromFile(logFile, maxLogs, start, end, tenantDomain, serviceName);
    }

    public String[] getApplicationNames() {
        return LoggingUtil.getApplicationNames();
    }

    public boolean isLogEventReciverConfigured() {
        Logger rootLogger = Logger.getRootLogger();
        LogEventAppender logger = (LogEventAppender)rootLogger.getAppender("LOGEVENT");
        return logger != null;
    }

    public boolean isFileAppenderConfiguredForST() {
        Logger rootLogger = Logger.getRootLogger();
        DailyRollingFileAppender logger = (DailyRollingFileAppender)rootLogger.getAppender("CARBON_LOGFILE");
        return logger != null && CarbonContext.getCurrentContext().getTenantId() == -1234;
    }

    public PaginatedLogEvent getPaginatedLogEvents(int pageNumber, String type, String keyword) {
        LogEvent[] list = this.getLogs(type, keyword);
        if (list != null) {
            List<LogEvent> logMsgList = Arrays.asList(list);
            PaginatedLogEvent paginatedLogEvent = new PaginatedLogEvent();
            DataPaginator.doPaging((int)pageNumber, logMsgList, (Pageable)paginatedLogEvent);
            return paginatedLogEvent;
        }
        return null;
    }

    public PaginatedLogEvent getPaginatedApplicationLogEvents(int pageNumber, String type, String keyword, String applicationName) throws Exception {
        LogEvent[] list = this.getApplicationLogs(type, keyword, applicationName);
        if (list != null) {
            List<LogEvent> logMsgList = Arrays.asList(list);
            PaginatedLogEvent paginatedLogEvent = new PaginatedLogEvent();
            DataPaginator.doPaging((int)pageNumber, logMsgList, (Pageable)paginatedLogEvent);
            return paginatedLogEvent;
        }
        return null;
    }

    public LogEvent[] getLogs(String type, String keyword) {
        if (keyword == null || keyword.equals("")) {
            if (type == null || type.equals("") || type.equalsIgnoreCase("ALL")) {
                return LoggingUtil.getLogs("");
            }
            return LoggingUtil.getLogsForType(type, "");
        }
        if (type == null || type.equals("")) {
            return LoggingUtil.getLogsForKey(keyword, "");
        }
        return LoggingUtil.searchLog(type, keyword, "");
    }

    public LogEvent[] getApplicationLogs(String type, String keyword, String appName) {
        if (keyword == null || keyword.equals("")) {
            if (type == null || type.equals("") || type.equalsIgnoreCase("ALL")) {
                return LoggingUtil.getLogs(appName);
            }
            return LoggingUtil.getLogsForType(type, appName);
        }
        if (type == null || type.equals("")) {
            return LoggingUtil.getLogsForKey(keyword, appName);
        }
        return LoggingUtil.searchLog(type, keyword, appName);
    }

    public boolean clearLogs() {
        Appender appender = Logger.getRootLogger().getAppender("CARBON_MEMORY");
        if (appender instanceof CarbonMemoryAppender) {
            try {
                CarbonMemoryAppender memoryAppender = (CarbonMemoryAppender)appender;
                if (memoryAppender.getCircularQueue() != null) {
                    memoryAppender.getCircularQueue().clear();
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }
}

