/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.logging.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.logging.service.data.CassandraConfig;
import org.wso2.carbon.utils.CarbonUtils;

public class CassandraConfigManager {
    private static final Log log = LogFactory.getLog(CassandraConfigManager.class);
    private static CassandraConfigManager cassandraConfig;
    private static BundleContext bundleContext;

    public static CassandraConfigManager getCassandraConfig() {
        return cassandraConfig;
    }

    public static void setBundleContext(BundleContext bundleContext) {
        CassandraConfigManager.bundleContext = bundleContext;
    }

    public static void setCassandraConfig(CassandraConfigManager syslogConfig) {
        cassandraConfig = syslogConfig;
    }

    public static Log getLog() {
        return log;
    }

    public CassandraConfig getSyslogData() {
        return null;
    }

    public static CassandraConfig loadCassandraConfiguration() {
        String cassandraConfigFileName = CarbonUtils.getCarbonConfigDirPath() + "/" + "etc" + "/" + "cassandra-config.xml";
        return CassandraConfigManager.loadCassandraConfiguration(cassandraConfigFileName);
    }

    private InputStream getInputStream(String configFilename) throws IOException {
        InputStream inStream = null;
        File configFile = new File(configFilename);
        if (configFile.exists()) {
            inStream = new FileInputStream(configFile);
        }
        String warningMessage = "";
        if (inStream == null) {
            if (bundleContext != null) {
                URL url = bundleContext.getBundle().getResource("cassandra-config.xml");
                if (url != null) {
                    inStream = url.openStream();
                } else {
                    warningMessage = "Bundle context could not find resource cassandra-config.xml or user does not have sufficient permission to access the resource.";
                    log.warn((Object)warningMessage);
                }
            } else {
                URL url = this.getClass().getClassLoader().getResource("cassandra-config.xml");
                if (url != null) {
                    inStream = url.openStream();
                } else {
                    warningMessage = "Could not find resource cassandra-config.xml or user does not have sufficient permission to access the resource.";
                    log.warn((Object)warningMessage);
                }
            }
        }
        return inStream;
    }

    private static CassandraConfig loadDefaultConfiguration() {
        CassandraConfig config = new CassandraConfig();
        config.setCassandraServerAvailable(false);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CassandraConfig loadCassandraConfiguration(String configFilename) {
        CassandraConfig config = new CassandraConfig();
        InputStream inputStream = null;
        try {
            inputStream = new CassandraConfigManager().getInputStream(configFilename);
        }
        catch (IOException e1) {
            log.error((Object)("Could not close the Configuration File " + configFilename));
        }
        if (inputStream != null) {
            try {
                XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
                StAXOMBuilder builder = new StAXOMBuilder(parser);
                OMElement documentElement = builder.getDocumentElement();
                Iterator it = documentElement.getChildElements();
                while (it.hasNext()) {
                    OMElement element = (OMElement)it.next();
                    if ("isCassandraAvailable".equals(element.getLocalName())) {
                        String isCassandraOn = element.getText();
                        boolean isCassandraAvailable = false;
                        if (isCassandraOn.trim().equalsIgnoreCase("true")) {
                            isCassandraAvailable = true;
                        }
                        config.setCassandraServerAvailable(isCassandraAvailable);
                        continue;
                    }
                    if ("cassandraHost".equals(element.getLocalName())) {
                        config.setUrl(element.getText());
                        continue;
                    }
                    if ("columnfamily".equals(element.getLocalName())) {
                        config.setColFamily(element.getText());
                        continue;
                    }
                    if ("keyspace".equals(element.getLocalName())) {
                        config.setKeyspace(element.getText());
                        continue;
                    }
                    if ("user".equals(element.getLocalName())) {
                        config.setUser(element.getText());
                        continue;
                    }
                    if (!"password".equals(element.getLocalName())) continue;
                    config.setPassword(element.getText());
                }
                CassandraConfig cassandraConfig = config;
                return cassandraConfig;
            }
            catch (Exception e) {
                String msg = "Error in loading Stratos Configurations File: " + configFilename + ". Default Settings will be used.";
                log.error((Object)msg, (Throwable)e);
                CassandraConfig cassandraConfig = CassandraConfigManager.loadDefaultConfiguration();
                return cassandraConfig;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.error((Object)("Could not close the Configuration File " + configFilename));
                    }
                }
            }
        }
        log.error((Object)"Unable to locate the stratos configurations file. Default Settings will be used.");
        return CassandraConfigManager.loadDefaultConfiguration();
    }
}

