/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apacheds;

import java.util.Arrays;
import org.wso2.carbon.apacheds.AdminInfo;
import org.wso2.carbon.apacheds.DomainNameEntry;

public class PartitionInfo
extends DomainNameEntry {
    private String partitionId;
    private String realm;
    private String rootDN;
    private AdminInfo partitionAdministrator;
    private String partitionKdcPassword = "secret";
    private String ldapServerPrinciplePassword = "randall";
    private boolean kdcEnabled = false;

    public PartitionInfo() {
        this.objectClassList.addAll(Arrays.asList("top", "organization", "dcObject", "extensibleObject"));
    }

    public PartitionInfo(String partitionId, String realm, String rootDN, AdminInfo partitionAdministrator) {
        this.partitionId = partitionId;
        this.realm = realm;
        this.rootDN = rootDN;
        this.partitionAdministrator = partitionAdministrator;
        this.objectClassList.addAll(Arrays.asList("top", "organization", "dcObject", "extensibleObject"));
    }

    public boolean isKdcEnabled() {
        return this.kdcEnabled;
    }

    public void setKdcEnabled(boolean kdcEnabled) {
        this.kdcEnabled = kdcEnabled;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(String partitionId) {
        if (partitionId == null) {
            return;
        }
        this.partitionId = partitionId;
    }

    public String getRealm() {
        return this.realm.toUpperCase();
    }

    public void setRealm(String realm) {
        if (realm == null) {
            return;
        }
        this.realm = realm;
    }

    public String getRootDN() {
        return this.rootDN;
    }

    public void setRootDN(String rootDN) {
        if (rootDN == null) {
            return;
        }
        this.rootDN = rootDN;
    }

    public AdminInfo getPartitionAdministrator() {
        return this.partitionAdministrator;
    }

    public void setPartitionAdministrator(AdminInfo partitionAdministrator) {
        if (partitionAdministrator == null) {
            return;
        }
        this.partitionAdministrator = partitionAdministrator;
    }

    public String getAdminDomainName() {
        StringBuilder builder = new StringBuilder("uid=");
        builder.append(this.getPartitionAdministrator().getAdminUID());
        builder.append(",");
        builder.append("ou=Users");
        builder.append(",");
        builder.append(this.getRootDN());
        return builder.toString();
    }

    public String getPreferredDomainComponent() {
        String[] parts;
        for (String part : parts = this.rootDN.split(",")) {
            String[] elements = part.split("=");
            if (!elements[0].equals("dc")) continue;
            return elements[1];
        }
        return null;
    }

    public String getPartitionKdcPassword() {
        return this.partitionKdcPassword;
    }

    public void setPartitionKdcPassword(String partitionKdcPassword) {
        if (partitionKdcPassword == null) {
            return;
        }
        this.partitionKdcPassword = partitionKdcPassword;
    }

    public String getLdapServerPrinciplePassword() {
        return this.ldapServerPrinciplePassword;
    }

    public void setLdapServerPrinciplePassword(String ldapServerPrinciplePassword) {
        if (ldapServerPrinciplePassword == null) {
            return;
        }
        this.ldapServerPrinciplePassword = ldapServerPrinciplePassword;
    }
}

