/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apacheds.impl;

import java.io.File;
import java.util.List;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.factory.DirectoryServiceFactory;
import org.apache.directory.server.core.factory.JdbmPartitionFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.core.schema.SchemaPartition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.loader.ldif.LdifSchemaLoader;
import org.apache.directory.shared.ldap.schema.manager.impl.DefaultSchemaManager;
import org.apache.directory.shared.ldap.schema.registries.SchemaLoader;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.apacheds.impl.CarbonSchemaLdifExtractor;
import org.wso2.carbon.ldap.server.exception.DirectoryServerException;

class CarbonDirectoryServiceFactory
implements DirectoryServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CarbonDirectoryServiceFactory.class);
    public static final DirectoryServiceFactory DEFAULT = new CarbonDirectoryServiceFactory();
    private DirectoryService directoryService;
    private PartitionFactory partitionFactory;
    private String schemaZipStore;
    private static final int PARTITION_CACHE_SIZE = 500;
    private static final int INDEX_CACHE_SIZE = 100;

    CarbonDirectoryServiceFactory() {
        try {
            this.directoryService = new DefaultDirectoryService();
        }
        catch (Exception e) {
            String errorMessage = "Error in initializing the default directory service.";
            LOG.error(errorMessage);
            throw new RuntimeException(errorMessage, e);
        }
        try {
            String typeName = System.getProperty("apacheds.partition.factory");
            if (typeName != null) {
                Class<?> type = Class.forName(typeName);
                this.partitionFactory = (PartitionFactory)type.newInstance();
            } else {
                this.partitionFactory = new JdbmPartitionFactory();
            }
        }
        catch (Exception e) {
            String errorMessage = "Error instantiating custom partition factory";
            LOG.error(errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
    }

    public void init(String name) throws Exception {
        this.schemaZipStore = System.getProperty("schema.zip.store.location");
        if (this.schemaZipStore == null) {
            throw new DirectoryServerException("Schema Jar repository is not set. Please set schema.jar.location property with proper schema storage");
        }
        if (this.directoryService != null && this.directoryService.isStarted()) {
            return;
        }
        this.build(name);
    }

    private void buildWorkingDirectory(String name) {
        String workingDirectory = System.getProperty("workingDirectory");
        if (workingDirectory == null) {
            workingDirectory = System.getProperty("java.io.tmpdir") + File.separator + "server-work-" + name;
        }
        this.directoryService.setWorkingDirectory(new File(workingDirectory));
    }

    private void initSchema() throws Exception {
        SchemaPartition schemaPartition = this.directoryService.getSchemaService().getSchemaPartition();
        LdifPartition ldifPartition = new LdifPartition();
        String workingDirectory = this.directoryService.getWorkingDirectory().getPath();
        ldifPartition.setWorkingDirectory(workingDirectory + File.separator + "schema");
        File schemaRepository = new File(workingDirectory, "schema");
        if (!schemaRepository.exists()) {
            CarbonSchemaLdifExtractor extractor = new CarbonSchemaLdifExtractor(new File(workingDirectory), new File(this.schemaZipStore));
            extractor.extractOrCopy();
        }
        schemaPartition.setWrappedPartition((Partition)ldifPartition);
        LdifSchemaLoader loader = new LdifSchemaLoader(schemaRepository);
        DefaultSchemaManager schemaManager = new DefaultSchemaManager((SchemaLoader)loader);
        this.directoryService.setSchemaManager((SchemaManager)schemaManager);
        schemaManager.loadAllEnabled();
        schemaPartition.setSchemaManager((SchemaManager)schemaManager);
        List errors = schemaManager.getErrors();
        if (errors.size() != 0) {
            throw new Exception(I18n.err((String)I18n.ERR_317, (Object[])new Object[]{ExceptionUtils.printErrors((List)errors)}));
        }
    }

    private void initSystemPartition() throws Exception {
        Partition systemPartition = this.partitionFactory.createPartition("system", "ou=system", 500, new File(this.directoryService.getWorkingDirectory(), "system"));
        systemPartition.setSchemaManager(this.directoryService.getSchemaManager());
        this.partitionFactory.addIndex(systemPartition, "objectClass", 100);
        this.directoryService.setSystemPartition(systemPartition);
    }

    private void build(String name) throws Exception {
        this.directoryService.setInstanceId(name);
        this.buildWorkingDirectory(name);
        this.initSchema();
        this.initSystemPartition();
        this.directoryService.startup();
    }

    public DirectoryService getDirectoryService() throws Exception {
        return this.directoryService;
    }

    public PartitionFactory getPartitionFactory() throws Exception {
        return this.partitionFactory;
    }
}

