/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apacheds.impl;

import java.io.IOException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.jndi.CoreContextFactory;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.mina.util.AvailablePortFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.apacheds.KDCServer;
import org.wso2.carbon.apacheds.KdcConfiguration;
import org.wso2.carbon.apacheds.LDAPServer;
import org.wso2.carbon.apacheds.PartitionInfo;
import org.wso2.carbon.apacheds.impl.ApacheLDAPServer;
import org.wso2.carbon.ldap.server.exception.DirectoryServerException;

public class ApacheKDCServer
implements KDCServer {
    private static final Logger logger = LoggerFactory.getLogger(ApacheKDCServer.class);
    private static final int START_PORT = 6088;
    private KdcServer kdcServer = new KdcServer();
    protected LdapContext schemaRoot;

    @Override
    public void init(KdcConfiguration configuration, LDAPServer ldapServer) throws DirectoryServerException {
        if (configuration == null) {
            throw new DirectoryServerException("Could not initialize KDC server. KDC configurations are null");
        }
        if (ldapServer == null) {
            throw new DirectoryServerException("Could not initialize KDC server. Directory service is null.");
        }
        if (!(ldapServer instanceof ApacheLDAPServer)) {
            throw new DirectoryServerException("Apache KDC server is only compatible with ApacheLDAPServer");
        }
        ApacheLDAPServer apacheLDAP = (ApacheLDAPServer)ldapServer;
        this.kdcServer.setServiceName(configuration.getKdcName());
        this.kdcServer.setKdcPrincipal(configuration.getKdcPrinciple());
        this.kdcServer.setPrimaryRealm(configuration.getPrimaryRealm());
        this.kdcServer.setMaximumTicketLifetime(configuration.getMaxTicketLifeTime());
        this.kdcServer.setMaximumRenewableLifetime(configuration.getMaxRenewableLifeTime());
        this.kdcServer.setSearchBaseDn(configuration.getSearchBaseDomainName());
        this.kdcServer.setPaEncTimestampRequired(configuration.isPreAuthenticateTimeStampRequired());
        this.configureTransportHandlers(configuration);
        DirectoryService directoryService = apacheLDAP.getService();
        if (directoryService == null) {
            throw new DirectoryServerException("LDAP service is null. Could not configure Kerberos.");
        }
        this.kdcServer.setDirectoryService(directoryService);
        this.setSchemaContext(configuration, directoryService, ldapServer.getConnectionDomainName());
        this.enableKerberoseSchema();
    }

    private void enableKerberoseSchema() throws DirectoryServerException {
        try {
            Attributes krb5kdcAttrs = this.schemaRoot.getAttributes("cn=Krb5kdc");
            boolean isKrb5KdcDisabled = false;
            if (krb5kdcAttrs.get("m-disabled") != null) {
                isKrb5KdcDisabled = ((String)krb5kdcAttrs.get("m-disabled").get()).equalsIgnoreCase("TRUE");
            }
            if (isKrb5KdcDisabled) {
                BasicAttribute disabled = new BasicAttribute("m-disabled");
                ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, disabled)};
                this.schemaRoot.modifyAttributes("cn=Krb5kdc", mods);
            }
        }
        catch (NamingException e) {
            String msg = "An error occurred while enabling Kerberos schema.";
            logger.error(msg, (Throwable)e);
            throw new DirectoryServerException(msg, e);
        }
    }

    @Override
    public void kerberizePartition(PartitionInfo partitionInfo, LDAPServer ldapServer) throws DirectoryServerException {
        Context ctx = null;
        try {
            if (!(ldapServer instanceof ApacheLDAPServer)) {
                throw new DirectoryServerException("Apache KDC server is only compatible with ApacheLDAPServer");
            }
            ApacheLDAPServer apacheLDAP = (ApacheLDAPServer)ldapServer;
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            env.put(DirectoryService.JNDI_KEY, apacheLDAP.getService());
            env.put("java.naming.factory.initial", "org.apache.directory.server.core.jndi.CoreContextFactory");
            env.put("java.naming.provider.url", "ou=Users," + partitionInfo.getRootDN());
            env.put("java.naming.security.principal", partitionInfo.getAdminDomainName());
            env.put("java.naming.security.credentials", partitionInfo.getPartitionAdministrator().getAdminPassword());
            env.put("java.naming.security.authentication", "simple");
            ctx = new InitialDirContext(env);
            Attributes attrs = this.getPrincipalAttributes("Service", "KDC Service", "krbtgt", partitionInfo.getPartitionKdcPassword(), this.getKDCPrincipleName(partitionInfo));
            ctx.createSubcontext("uid=krbtgt", attrs);
            attrs = this.getPrincipalAttributes("Service", "LDAP Service", "ldap", partitionInfo.getLdapServerPrinciplePassword(), this.getLDAPPrincipleName(partitionInfo));
            ctx.createSubcontext("uid=ldap", attrs);
        }
        catch (NamingException e) {
            String msg = "Unable to add server principles for KDC and LDAP. Incorrect domain names.";
            logger.error(msg, (Throwable)e);
            throw new DirectoryServerException(msg, e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    logger.error("Error closing LDAP context.", (Throwable)e);
                }
            }
        }
    }

    private String getKDCPrincipleName(PartitionInfo partitionInfo) {
        return "krbtgt/" + partitionInfo.getRealm() + "@" + partitionInfo.getRealm();
    }

    private String getLDAPPrincipleName(PartitionInfo partitionInfo) {
        return "ldap/localhost@" + partitionInfo.getRealm();
    }

    protected Attributes getPrincipalAttributes(String sn, String cn, String uid, String userPassword, String principal) {
        BasicAttributes attributes = new BasicAttributes(true);
        BasicAttribute basicAttribute = new BasicAttribute("objectClass");
        basicAttribute.add("top");
        basicAttribute.add("person");
        basicAttribute.add("inetOrgPerson");
        basicAttribute.add("krb5principal");
        basicAttribute.add("krb5kdcentry");
        attributes.put(basicAttribute);
        attributes.put("cn", cn);
        attributes.put("sn", sn);
        attributes.put("uid", uid);
        attributes.put("userPassword", userPassword);
        attributes.put("krb5PrincipalName", principal);
        attributes.put("krb5KeyVersionNumber", "0");
        return attributes;
    }

    private void setSchemaContext(KdcConfiguration configuration, DirectoryService service, String connectionUser) throws DirectoryServerException {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put(DirectoryService.JNDI_KEY, service);
        env.put("java.naming.security.principal", connectionUser);
        env.put("java.naming.security.credentials", configuration.getSystemAdminPassword());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.factory.initial", CoreContextFactory.class.getName());
        env.put("java.naming.provider.url", "ou=schema");
        try {
            this.schemaRoot = new InitialLdapContext(env, null);
        }
        catch (NamingException e) {
            throw new DirectoryServerException("Unable to create Schema context with user " + connectionUser);
        }
    }

    @Override
    public void start() throws DirectoryServerException {
        try {
            this.kdcServer.start();
            logger.info("KDC server started ...");
        }
        catch (IOException e) {
            String msg = "Could not start KDC server due to an IOException";
            logger.error(msg, (Throwable)e);
            throw new DirectoryServerException(msg, e);
        }
        catch (LdapInvalidDnException e) {
            String msg = "Could not start KDC server due to an error in a domain name.";
            logger.error(msg, (Throwable)e);
            throw new DirectoryServerException(msg, e);
        }
    }

    @Override
    public boolean isKDCServerStarted() {
        return this.kdcServer.isStarted();
    }

    @Override
    public void stop() throws DirectoryServerException {
        this.kdcServer.stop();
        logger.info("KDC server stopped ...");
    }

    private void configureTransportHandlers(KdcConfiguration configuration) {
        int port = this.getServerPort(configuration);
        if (configuration.getKdcCommunicationProtocol() == KdcConfiguration.ProtocolType.UDP_PROTOCOL) {
            logger.info("Starting KDC on UDP mode at port - " + port + " at host - " + configuration.getKdcHostAddress());
            UdpTransport defaultTransport = new UdpTransport(port);
            this.kdcServer.addTransports(new Transport[]{defaultTransport});
        } else {
            logger.info("Starting KDC on a TCP port " + port + " at host " + configuration.getKdcHostAddress());
            TcpTransport tcp = new TcpTransport(configuration.getKdcHostAddress(), port, configuration.getNumberOfThreads(), configuration.getBackLogCount());
            this.kdcServer.addTransports(new Transport[]{tcp});
        }
    }

    private int getServerPort(KdcConfiguration configuration) {
        int port = configuration.getKdcCommunicationPort();
        if (port == -1) {
            port = AvailablePortFinder.getNextAvailable((int)6088);
        }
        return port;
    }
}

