/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apacheds;

import org.wso2.carbon.apacheds.PartitionInfo;
import org.wso2.carbon.ldap.server.exception.DirectoryServerException;

public class KdcConfiguration {
    private String kdcName;
    private String kdcHostAddress;
    private ProtocolType kdcCommunicationProtocol;
    private int kdcCommunicationPort = -1;
    private String systemAdminPassword;
    private int numberOfThreads;
    private int backLogCount;
    private long maxTicketLifeTime;
    private long maxRenewableLifeTime;
    private boolean preAuthenticateTimeStampRequired = true;
    private PartitionInfo partitionInfo;

    public KdcConfiguration(PartitionInfo partitionInfo) {
        this.partitionInfo = partitionInfo;
        this.kdcCommunicationProtocol = ProtocolType.UDP_PROTOCOL;
        this.kdcName = "DefaultKrbServer";
        this.kdcHostAddress = "localhost";
        this.systemAdminPassword = "secret";
        this.numberOfThreads = 3;
        this.backLogCount = 50;
        this.maxTicketLifeTime = 86400000L;
        this.maxRenewableLifeTime = 604800000L;
    }

    public KdcConfiguration() {
        this(null);
    }

    public ProtocolType getKdcCommunicationProtocol() {
        return this.kdcCommunicationProtocol;
    }

    public void setPartitionInfo(PartitionInfo partitionInfo) {
        this.partitionInfo = partitionInfo;
    }

    public void setKdcCommunicationProtocol(String protocolName) throws DirectoryServerException {
        if (protocolName == null) {
            return;
        }
        this.kdcCommunicationProtocol = ProtocolType.getProtocolType(protocolName);
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(int numberOfThreads) {
        if (numberOfThreads == -1) {
            return;
        }
        this.numberOfThreads = numberOfThreads;
    }

    public int getBackLogCount() {
        return this.backLogCount;
    }

    public void setBackLogCount(int backLogCount) {
        if (backLogCount == -1) {
            return;
        }
        this.backLogCount = backLogCount;
    }

    public String getKdcHostAddress() {
        return this.kdcHostAddress;
    }

    public void setKdcHostAddress(String kdcHostAddress) {
        if (kdcHostAddress == null) {
            return;
        }
        this.kdcHostAddress = kdcHostAddress;
    }

    public String getKdcName() {
        return this.kdcName;
    }

    public void setKdcName(String kdcName) {
        if (kdcName == null) {
            return;
        }
        this.kdcName = kdcName;
    }

    public String getKdcPrinciple() {
        return "krbtgt/" + this.partitionInfo.getRealm().toUpperCase() + "@" + this.partitionInfo.getRealm().toUpperCase();
    }

    public String getPrimaryRealm() {
        return this.partitionInfo.getRealm();
    }

    public long getMaxTicketLifeTime() {
        return this.maxTicketLifeTime;
    }

    public void setMaxTicketLifeTime(long maxTicketLifeTime) {
        if (maxTicketLifeTime == -1L) {
            return;
        }
        this.maxTicketLifeTime = maxTicketLifeTime;
    }

    public long getMaxRenewableLifeTime() {
        return this.maxRenewableLifeTime;
    }

    public void setMaxRenewableLifeTime(long maxRenewableLifeTime) {
        if (maxRenewableLifeTime == -1L) {
            return;
        }
        this.maxRenewableLifeTime = maxRenewableLifeTime;
    }

    public int getKdcCommunicationPort() {
        return this.kdcCommunicationPort;
    }

    public void setKdcCommunicationPort(int kdcCommunicationPort) {
        if (kdcCommunicationPort == -1) {
            return;
        }
        this.kdcCommunicationPort = kdcCommunicationPort;
    }

    public String getSystemAdminPassword() {
        return this.systemAdminPassword;
    }

    public void setSystemAdminPassword(String systemAdminPassword) {
        if (systemAdminPassword == null) {
            return;
        }
        this.systemAdminPassword = systemAdminPassword;
    }

    public String getSearchBaseDomainName() {
        return "ou=Users," + this.partitionInfo.getRootDN();
    }

    public boolean isPreAuthenticateTimeStampRequired() {
        return this.preAuthenticateTimeStampRequired;
    }

    public void setPreAuthenticateTimeStampRequired(boolean preAuthenticateTimeStampRequired) {
        this.preAuthenticateTimeStampRequired = preAuthenticateTimeStampRequired;
    }

    public static enum ProtocolType {
        TCP_PROTOCOL,
        UDP_PROTOCOL;


        public static ProtocolType getProtocolType(String protocolName) throws DirectoryServerException {
            if (protocolName.equals("TCP")) {
                return TCP_PROTOCOL;
            }
            if (protocolName.equals("UDP")) {
                return UDP_PROTOCOL;
            }
            throw new DirectoryServerException("Invalid protocol name. Only supported protocols for KDC are TCP and UDP.");
        }
    }
}

