/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apacheds;

import org.wso2.carbon.apacheds.KDCServer;
import org.wso2.carbon.apacheds.LDAPServer;
import org.wso2.carbon.apacheds.impl.ApacheKDCServer;
import org.wso2.carbon.apacheds.impl.ApacheLDAPServer;

public class DirectoryServiceFactory {
    public static LDAPServer createLDAPServer(LDAPServerType serverType) {
        if (serverType == LDAPServerType.APACHE_DIRECTORY_SERVICE) {
            return new ApacheLDAPServer();
        }
        throw new IllegalArgumentException("Does not support LDAP server type " + serverType.name());
    }

    public static KDCServer createKDCServer(LDAPServerType serverType) {
        if (serverType == LDAPServerType.APACHE_DIRECTORY_SERVICE) {
            return new ApacheKDCServer();
        }
        throw new IllegalArgumentException("Does not support LDAP server type " + serverType.name());
    }

    public static enum LDAPServerType {
        APACHE_DIRECTORY_SERVICE;

    }
}

