/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import java.util.concurrent.TimeUnit;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.ReferralManager;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.event.DirectoryListener;
import org.apache.directory.server.core.event.EventType;
import org.apache.directory.server.core.event.NotificationCriteria;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.PersistentSearchListener;
import org.apache.directory.server.ldap.handlers.ReferralAwareRequestHandler;
import org.apache.directory.server.ldap.handlers.SearchAbandonListener;
import org.apache.directory.server.ldap.handlers.SearchTimeLimitingMonitor;
import org.apache.directory.server.ldap.handlers.controls.PagedSearchContext;
import org.apache.directory.shared.ldap.codec.search.controls.pagedSearch.PagedResultsControl;
import org.apache.directory.shared.ldap.codec.search.controls.persistentSearch.PersistentSearchControl;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.cursor.ClosureMonitor;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.OperationAbandonedException;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.ReferralImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.SearchResponseEntryImpl;
import org.apache.directory.shared.ldap.message.SearchResponseReferenceImpl;
import org.apache.directory.shared.ldap.message.control.Control;
import org.apache.directory.shared.ldap.message.internal.InternalLdapResult;
import org.apache.directory.shared.ldap.message.internal.InternalReferral;
import org.apache.directory.shared.ldap.message.internal.InternalResponse;
import org.apache.directory.shared.ldap.message.internal.InternalSearchRequest;
import org.apache.directory.shared.ldap.message.internal.InternalSearchResponseDone;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchHandler
extends ReferralAwareRequestHandler<InternalSearchRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(SearchHandler.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private AttributeType objectClassAttributeType;

    private EqualityNode<String> newIsReferralEqualityNode(LdapSession session) throws Exception {
        if (this.objectClassAttributeType == null) {
            this.objectClassAttributeType = session.getCoreSession().getDirectoryService().getSchemaManager().lookupAttributeTypeRegistry("objectClass");
        }
        EqualityNode ocIsReferral = new EqualityNode("objectClass", (Value)new StringValue(this.objectClassAttributeType, "referral"));
        return ocIsReferral;
    }

    private void handlePersistentSearch(LdapSession session, InternalSearchRequest req, PersistentSearchControl psearchControl) throws Exception {
        InternalSearchResponseDone done;
        if (!psearchControl.isChangesOnly() && (done = this.doSimpleSearch(session, req)).getLdapResult().getResultCode() != ResultCodeEnum.SUCCESS) {
            session.getIoSession().write((Object)done);
            return;
        }
        if (req.isAbandoned()) {
            return;
        }
        PersistentSearchListener handler = new PersistentSearchListener(session, req);
        NotificationCriteria criteria = new NotificationCriteria();
        criteria.setAliasDerefMode(req.getDerefAliases());
        criteria.setBase(req.getBase());
        criteria.setFilter(req.getFilter());
        criteria.setScope(req.getScope());
        criteria.setEventMask(EventType.getEventTypes((int)psearchControl.getChangeTypes()));
        this.getLdapServer().getDirectoryService().getEventService().addListener((DirectoryListener)handler, criteria);
        req.addAbandonListener(new SearchAbandonListener(this.ldapServer, handler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRootDseSearch(LdapSession session, InternalSearchRequest req) throws Exception {
        EntryFilteringCursor cursor = null;
        try {
            cursor = session.getCoreSession().search(req);
            cursor.beforeFirst();
            boolean hasRootDSE = false;
            while (cursor.next()) {
                if (hasRootDSE) {
                    LOG.error(I18n.err(I18n.ERR_167, new Object[0]));
                    continue;
                }
                hasRootDSE = true;
                ClonedServerEntry entry = (ClonedServerEntry)cursor.get();
                session.getIoSession().write((Object)this.generateResponse(session, req, entry));
            }
            session.getIoSession().write((Object)req.getResultResponse());
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception e) {
                    LOG.error(I18n.err(I18n.ERR_168, new Object[0]), (Throwable)e);
                }
            }
        }
    }

    private void setTimeLimitsOnCursor(InternalSearchRequest req, LdapSession session, EntryFilteringCursor cursor) {
        if (session.getCoreSession().isAnAdministrator() && req.getTimeLimit() == 0) {
            return;
        }
        if (this.ldapServer.getMaxTimeLimit() == 0 && req.getTimeLimit() == 0) {
            return;
        }
        if (req.getTimeLimit() == 0) {
            cursor.setClosureMonitor((ClosureMonitor)new SearchTimeLimitingMonitor(this.ldapServer.getMaxTimeLimit(), TimeUnit.SECONDS));
            return;
        }
        if (this.ldapServer.getMaxTimeLimit() >= req.getTimeLimit()) {
            cursor.setClosureMonitor((ClosureMonitor)new SearchTimeLimitingMonitor(req.getTimeLimit(), TimeUnit.SECONDS));
            return;
        }
        cursor.setClosureMonitor((ClosureMonitor)new SearchTimeLimitingMonitor(this.ldapServer.getMaxTimeLimit(), TimeUnit.SECONDS));
    }

    private long getServerSizeLimit(LdapSession session, InternalSearchRequest request) {
        if (session.getCoreSession().isAnAdministrator()) {
            if (request.getSizeLimit() == 0L) {
                return Long.MAX_VALUE;
            }
            return request.getSizeLimit();
        }
        if (this.ldapServer.getMaxSizeLimit() == 0L) {
            return Long.MAX_VALUE;
        }
        return this.ldapServer.getMaxSizeLimit();
    }

    private void readResults(LdapSession session, InternalSearchRequest req, InternalLdapResult ldapResult, EntryFilteringCursor cursor, long sizeLimit) throws Exception {
        long count;
        for (count = 0L; count < sizeLimit && cursor.next(); ++count) {
            if (session.getIoSession().isClosing()) {
                LOG.debug("Request terminated for message {}, the client has closed the session", (Object)req.getMessageId());
                break;
            }
            if (req.isAbandoned()) {
                LOG.debug("Request terminated by an AbandonRequest for message {}", (Object)req.getMessageId());
                break;
            }
            ClonedServerEntry entry = (ClonedServerEntry)cursor.get();
            session.getIoSession().write((Object)this.generateResponse(session, req, entry));
            LOG.debug("Sending {}", (Object)entry.getDn());
        }
        ldapResult.setResultCode(ResultCodeEnum.SUCCESS);
        if (count >= sizeLimit && cursor.next()) {
            cursor.previous();
            ldapResult.setResultCode(ResultCodeEnum.SIZE_LIMIT_EXCEEDED);
        }
    }

    private void readPagedResults(LdapSession session, InternalSearchRequest req, InternalLdapResult ldapResult, EntryFilteringCursor cursor, long sizeLimit, int pagedLimit, boolean isPaged, PagedSearchContext pagedContext, PagedResultsControl pagedResultsControl) throws Exception {
        int pageCount;
        req.addAbandonListener(new SearchAbandonListener(this.ldapServer, cursor));
        this.setTimeLimitsOnCursor(req, session, cursor);
        LOG.debug("using <{},{}> for size limit", (Object)sizeLimit, (Object)pagedLimit);
        long cookieValue = 0L;
        int count = pagedContext.getCurrentPosition();
        for (pageCount = 0; (long)count < sizeLimit && pageCount < pagedLimit && cursor.next() && !session.getIoSession().isClosing(); ++pageCount) {
            ClonedServerEntry entry = (ClonedServerEntry)cursor.get();
            session.getIoSession().write((Object)this.generateResponse(session, req, entry));
            ++count;
        }
        ldapResult.setResultCode(ResultCodeEnum.SUCCESS);
        boolean hasMoreEntry = cursor.next();
        if (hasMoreEntry) {
            cursor.previous();
        }
        if (!hasMoreEntry) {
            cookieValue = pagedContext.getCookieValue();
            PagedSearchContext psCookie = session.removePagedSearchContext(cookieValue);
            if (psCookie != null && (cursor = psCookie.getCursor()) != null) {
                cursor.close();
            }
            pagedResultsControl = new PagedResultsControl();
            pagedResultsControl.setCritical(true);
            pagedResultsControl.setSize(0);
            req.getResultResponse().add((Control)pagedResultsControl);
            return;
        }
        if ((long)count < sizeLimit) {
            ldapResult.setResultCode(ResultCodeEnum.SUCCESS);
            req.getResultResponse().add((Control)pagedResultsControl);
            pagedContext.incrementCurrentPosition(pageCount);
            return;
        }
        ldapResult.setResultCode(ResultCodeEnum.SIZE_LIMIT_EXCEEDED);
        if (cursor != null) {
            cursor.close();
        }
        session.removePagedSearchContext(cookieValue);
    }

    private InternalSearchResponseDone abandonPagedSearch(LdapSession session, InternalSearchRequest req) throws Exception {
        PagedResultsControl pagedResultsControl = null;
        PagedResultsControl pagedSearchControl = (PagedResultsControl)req.getControls().get("1.2.840.113556.1.4.319");
        byte[] cookie = pagedSearchControl.getCookie();
        if (!StringTools.isEmpty(cookie)) {
            int cookieValue = pagedSearchControl.getCookieValue();
            PagedSearchContext psCookie = session.removePagedSearchContext(cookieValue);
            pagedResultsControl = new PagedResultsControl();
            pagedResultsControl.setCookie(psCookie.getCookie());
            pagedResultsControl.setSize(0);
            pagedResultsControl.setCritical(true);
            EntryFilteringCursor cursor = psCookie.getCursor();
            if (cursor != null) {
                cursor.close();
            }
        } else {
            pagedResultsControl = new PagedResultsControl();
            pagedResultsControl.setSize(0);
            pagedResultsControl.setCritical(true);
        }
        InternalLdapResult ldapResult = req.getResultResponse().getLdapResult();
        ldapResult.setResultCode(ResultCodeEnum.SUCCESS);
        req.getResultResponse().add((Control)pagedResultsControl);
        return (InternalSearchResponseDone)req.getResultResponse();
    }

    private PagedSearchContext removeContext(LdapSession session, PagedSearchContext cookieInstance) {
        if (cookieInstance == null) {
            return null;
        }
        long cookieValue = cookieInstance.getCookieValue();
        return session.removePagedSearchContext(cookieValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalSearchResponseDone doPagedSearch(LdapSession session, InternalSearchRequest req, PagedResultsControl control) throws Exception {
        block20: {
            PagedResultsControl pagedSearchControl = control;
            PagedResultsControl pagedResultsControl = null;
            long serverLimit = this.getServerSizeLimit(session, req);
            long requestLimit = req.getSizeLimit() == 0L ? Long.MAX_VALUE : req.getSizeLimit();
            long sizeLimit = Math.min(serverLimit, requestLimit);
            int pagedLimit = pagedSearchControl.getSize();
            EntryFilteringCursor cursor = null;
            PagedSearchContext pagedContext = null;
            if ((long)pagedLimit == 0L) {
                return this.abandonPagedSearch(session, req);
            }
            byte[] cookie = pagedSearchControl.getCookie();
            InternalLdapResult ldapResult = req.getResultResponse().getLdapResult();
            if (StringTools.isEmpty(cookie)) {
                if ((long)pagedLimit > sizeLimit) {
                    try {
                        cursor = session.getCoreSession().search(req);
                        cursor.beforeFirst();
                        this.readResults(session, req, ldapResult, cursor, sizeLimit);
                    }
                    finally {
                        try {
                            cursor.close();
                        }
                        catch (Exception e) {
                            LOG.error(I18n.err(I18n.ERR_168, new Object[0]), (Throwable)e);
                        }
                    }
                    this.removeContext(session, pagedContext);
                    return (InternalSearchResponseDone)req.getResultResponse();
                }
                pagedContext = new PagedSearchContext(req);
                session.addPagedSearchContext(pagedContext);
                cookie = pagedContext.getCookie();
                pagedResultsControl = new PagedResultsControl();
                pagedResultsControl.setCookie(cookie);
                pagedResultsControl.setSize(0);
                pagedResultsControl.setCritical(true);
                cursor = session.getCoreSession().search(req);
                cursor.beforeFirst();
                pagedContext.setCursor(cursor);
            } else {
                int cookieValue = pagedSearchControl.getCookieValue();
                pagedContext = session.getPagedSearchContext(cookieValue);
                if (pagedContext == null) {
                    ldapResult.setErrorMessage("Invalid cookie for this PagedSearch request.");
                    ldapResult.setResultCode(ResultCodeEnum.UNWILLING_TO_PERFORM);
                    return (InternalSearchResponseDone)req.getResultResponse();
                }
                if (pagedContext.hasSameRequest(req, session)) {
                    cursor = pagedContext.getCursor();
                    cookie = pagedContext.getCookie();
                    pagedResultsControl = new PagedResultsControl();
                    pagedResultsControl.setCookie(cookie);
                    pagedResultsControl.setSize(0);
                    pagedResultsControl.setCritical(true);
                } else {
                    cursor = pagedContext.getCursor();
                    if (cursor != null) {
                        cursor.close();
                    }
                    pagedContext = new PagedSearchContext(req);
                    session.addPagedSearchContext(pagedContext);
                    cookie = pagedContext.getCookie();
                    pagedResultsControl = new PagedResultsControl();
                    pagedResultsControl.setCookie(cookie);
                    pagedResultsControl.setSize(0);
                    pagedResultsControl.setCritical(true);
                }
            }
            try {
                this.readPagedResults(session, req, ldapResult, cursor, sizeLimit, pagedLimit, true, pagedContext, pagedResultsControl);
            }
            catch (Exception e) {
                if (cursor == null) break block20;
                try {
                    cursor.close();
                }
                catch (Exception ne) {
                    LOG.error(I18n.err(I18n.ERR_168, new Object[0]), (Throwable)ne);
                }
            }
        }
        return (InternalSearchResponseDone)req.getResultResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalSearchResponseDone doSimpleSearch(LdapSession session, InternalSearchRequest req) throws Exception {
        InternalLdapResult ldapResult = req.getResultResponse().getLdapResult();
        Control control = req.getControls().get("1.2.840.113556.1.4.319");
        if (control != null) {
            return this.doPagedSearch(session, req, (PagedResultsControl)control);
        }
        EntryFilteringCursor cursor = session.getCoreSession().search(req);
        cursor.beforeFirst();
        try {
            long serverLimit = this.getServerSizeLimit(session, req);
            long requestLimit = req.getSizeLimit() == 0L ? Long.MAX_VALUE : req.getSizeLimit();
            req.addAbandonListener(new SearchAbandonListener(this.ldapServer, cursor));
            this.setTimeLimitsOnCursor(req, session, cursor);
            LOG.debug("using <{},{}> for size limit", (Object)requestLimit, (Object)serverLimit);
            long sizeLimit = Math.min(requestLimit, serverLimit);
            this.readResults(session, req, ldapResult, cursor, sizeLimit);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception e) {
                    LOG.error(I18n.err(I18n.ERR_168, new Object[0]), (Throwable)e);
                }
            }
        }
        return (InternalSearchResponseDone)req.getResultResponse();
    }

    private InternalResponse generateResponse(LdapSession session, InternalSearchRequest req, ClonedServerEntry entry) throws Exception {
        EntryAttribute ref = entry.getOriginalEntry().get("ref");
        boolean hasManageDsaItControl = req.getControls().containsKey("2.16.840.1.113730.3.4.2");
        if (ref != null && !hasManageDsaItControl) {
            SearchResponseReferenceImpl respRef = new SearchResponseReferenceImpl(req.getMessageId());
            respRef.setReferral(new ReferralImpl());
            for (Value val : ref) {
                String url = val.getString();
                if (!url.startsWith("ldap")) {
                    respRef.getReferral().addLdapUrl(url);
                }
                LdapURL ldapUrl = new LdapURL();
                ldapUrl.setForceScopeRendering(true);
                try {
                    ldapUrl.parse(url.toCharArray());
                }
                catch (LdapURLEncodingException e) {
                    LOG.error(I18n.err(I18n.ERR_165, url, entry));
                }
                switch (req.getScope()) {
                    case SUBTREE: {
                        ldapUrl.setScope(SearchScope.SUBTREE.getScope());
                        break;
                    }
                    case ONELEVEL: {
                        ldapUrl.setScope(SearchScope.OBJECT.getScope());
                        break;
                    }
                    default: {
                        throw new IllegalStateException(I18n.err(I18n.ERR_686, new Object[0]));
                    }
                }
                respRef.getReferral().addLdapUrl(ldapUrl.toString());
            }
            return respRef;
        }
        SearchResponseEntryImpl respEntry = new SearchResponseEntryImpl(req.getMessageId());
        respEntry.setEntry((Entry)entry);
        respEntry.setObjectName(entry.getDn());
        if (session.getCoreSession().getDirectoryService().isPasswordHidden()) {
            respEntry.getEntry().removeAttributes("userPassword");
        }
        return respEntry;
    }

    public void modifyFilter(LdapSession session, InternalSearchRequest req) throws Exception {
        if (req.hasControl("2.16.840.1.113730.3.4.2")) {
            return;
        }
        if (SearchHandler.isSubSchemaSubEntrySearch(session, req)) {
            return;
        }
        if (req.getFilter() instanceof PresenceNode) {
            PresenceNode presenceNode = (PresenceNode)req.getFilter();
            AttributeType at = session.getCoreSession().getDirectoryService().getSchemaManager().lookupAttributeTypeRegistry(presenceNode.getAttribute());
            if (at.getOid().equals("2.5.4.0")) {
                return;
            }
        }
        req.setFilter((ExprNode)new OrNode(new ExprNode[]{req.getFilter(), this.newIsReferralEqualityNode(session)}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleIgnoringReferrals(LdapSession session, InternalSearchRequest req) {
        if (IS_DEBUG) {
            LOG.debug("Message received:  {}", (Object)req.toString());
        }
        boolean isPersistentSearch = false;
        boolean persistentSearchException = false;
        session.registerOutstandingRequest(req);
        try {
            if (SearchHandler.isRootDSESearch(req)) {
                this.handleRootDseSearch(session, req);
                return;
            }
            this.modifyFilter(session, req);
            PersistentSearchControl psearchControl = (PersistentSearchControl)req.getControls().get("2.16.840.1.113730.3.4.3");
            if (psearchControl != null) {
                isPersistentSearch = true;
                this.handlePersistentSearch(session, req, psearchControl);
                return;
            }
            InternalSearchResponseDone done = this.doSimpleSearch(session, req);
            session.getIoSession().write((Object)done);
        }
        catch (Exception e) {
            if (e instanceof OperationAbandonedException) {
                return;
            }
            if (isPersistentSearch) {
                persistentSearchException = true;
            }
            this.handleException(session, req, e);
        }
        finally {
            if (!isPersistentSearch || persistentSearchException) {
                session.unregisterOutstandingRequest(req);
            }
        }
    }

    @Override
    public void handleWithReferrals(LdapSession session, DN reqTargetDn, InternalSearchRequest req) throws LdapException {
        InternalLdapResult result = req.getResultResponse().getLdapResult();
        ClonedServerEntry entry = null;
        boolean isReferral = false;
        boolean isparentReferral = false;
        ReferralManager referralManager = session.getCoreSession().getDirectoryService().getReferralManager();
        reqTargetDn.normalize(session.getCoreSession().getDirectoryService().getSchemaManager().getNormalizerMapping());
        referralManager.lockRead();
        isReferral = referralManager.isReferral(reqTargetDn);
        if (!isReferral) {
            isparentReferral = referralManager.hasParentReferral(reqTargetDn);
        }
        referralManager.unlock();
        if (!isReferral && !isparentReferral) {
            LOG.debug("Entry {} is NOT a referral.", (Object)reqTargetDn);
            this.handleIgnoringReferrals(session, req);
            return;
        }
        try {
            entry = session.getCoreSession().lookup(reqTargetDn);
            LOG.debug("Entry for {} was found: ", (Object)reqTargetDn, (Object)entry);
        }
        catch (LdapException e) {
            LOG.debug("Entry for {} not found.", (Object)reqTargetDn);
        }
        catch (Exception e) {
            this.handleException(session, req, e);
            return;
        }
        if (entry != null) {
            try {
                LOG.debug("Entry is a referral: {}", (Object)entry);
                this.handleReferralEntryForSearch(session, req, entry);
                return;
            }
            catch (Exception e) {
                this.handleException(session, req, e);
            }
        } else {
            ClonedServerEntry referralAncestor = null;
            try {
                referralAncestor = SearchHandler.getFarthestReferralAncestor(session, reqTargetDn);
            }
            catch (Exception e) {
                this.handleException(session, req, e);
                return;
            }
            if (referralAncestor == null) {
                result.setErrorMessage("Entry not found.");
                result.setResultCode(ResultCodeEnum.NO_SUCH_OBJECT);
                session.getIoSession().write((Object)req.getResultResponse());
                return;
            }
            try {
                InternalReferral referral = this.getReferralOnAncestorForSearch(session, req, referralAncestor);
                result.setResultCode(ResultCodeEnum.REFERRAL);
                result.setReferral(referral);
                session.getIoSession().write((Object)req.getResultResponse());
            }
            catch (Exception e) {
                this.handleException(session, req, e);
            }
        }
    }

    private void handleReferralEntryForSearch(LdapSession session, InternalSearchRequest req, ClonedServerEntry entry) throws Exception {
        InternalLdapResult result = req.getResultResponse().getLdapResult();
        ReferralImpl referral = new ReferralImpl();
        result.setReferral(referral);
        result.setResultCode(ResultCodeEnum.REFERRAL);
        result.setErrorMessage("Encountered referral attempting to handle request.");
        result.setMatchedDn(req.getBase());
        EntryAttribute refAttr = entry.getOriginalEntry().get("ref");
        for (Value refval : refAttr) {
            String refstr = refval.getString();
            if (!refstr.startsWith("ldap")) {
                referral.addLdapUrl(refstr);
                continue;
            }
            LdapURL ldapUrl = new LdapURL();
            try {
                ldapUrl.parse(refstr.toCharArray());
            }
            catch (LdapURLEncodingException e) {
                LOG.error(I18n.err(I18n.ERR_165, refstr, entry));
                continue;
            }
            ldapUrl.setForceScopeRendering(true);
            ldapUrl.setAttributes(req.getAttributes());
            ldapUrl.setScope(req.getScope().getScope());
            referral.addLdapUrl(ldapUrl.toString());
        }
        session.getIoSession().write((Object)req.getResultResponse());
    }

    private static boolean isRootDSESearch(InternalSearchRequest req) {
        boolean isBaseIsRoot = req.getBase().isEmpty();
        boolean isBaseScope = req.getScope() == SearchScope.OBJECT;
        boolean isRootDSEFilter = false;
        if (req.getFilter() instanceof PresenceNode) {
            String attribute = ((PresenceNode)req.getFilter()).getAttribute();
            isRootDSEFilter = attribute.equalsIgnoreCase("objectClass") || attribute.equals("2.5.4.0");
        }
        return isBaseIsRoot && isBaseScope && isRootDSEFilter;
    }

    private static boolean isSubSchemaSubEntrySearch(LdapSession session, InternalSearchRequest req) throws Exception {
        DN base = req.getBase();
        String baseNormForm = base.isNormalized() ? base.getNormName() : base.getNormName();
        DirectoryService ds = session.getCoreSession().getDirectoryService();
        PartitionNexus nexus = ds.getPartitionNexus();
        Value<?> subschemaSubentry = nexus.getRootDSE(null).get("subschemaSubentry").get();
        DN subschemaSubentryDn = new DN(subschemaSubentry.getString());
        subschemaSubentryDn.normalize(ds.getSchemaManager().getNormalizerMapping());
        String subschemaSubentryDnNorm = subschemaSubentryDn.getNormName();
        return subschemaSubentryDnNorm.equals(baseNormForm);
    }
}

