/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.registries.synchronizers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.OperationManager;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntryUtils;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.schema.registries.synchronizers.RegistrySynchronizer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.DefaultServerAttribute;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.ServerModification;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.schema.SchemaObjectType;
import org.apache.directory.shared.ldap.schema.SchemaObjectWrapper;
import org.apache.directory.shared.ldap.schema.loader.ldif.SchemaEntityFactory;
import org.apache.directory.shared.ldap.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.schema.registries.DefaultSchemaObjectRegistry;
import org.apache.directory.shared.ldap.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.registries.Schema;
import org.apache.directory.shared.ldap.util.DateUtils;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaSynchronizer
implements RegistrySynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaSynchronizer.class);
    private final SchemaEntityFactory factory;
    private final SchemaManager schemaManager;
    private final Registries registries;
    private final AttributeType disabledAT;
    private final AttributeType cnAT;
    private final AttributeType dependenciesAT;
    private final AttributeType modifiersNameAT;
    private final AttributeType modifyTimestampAT;
    private final DN ouSchemaDN;

    public SchemaSynchronizer(SchemaManager schemaManager) throws Exception {
        this.registries = schemaManager.getRegistries();
        this.schemaManager = schemaManager;
        this.disabledAT = (AttributeType)this.registries.getAttributeTypeRegistry().lookup("m-disabled");
        this.factory = new SchemaEntityFactory();
        this.cnAT = (AttributeType)this.registries.getAttributeTypeRegistry().lookup("cn");
        this.dependenciesAT = (AttributeType)this.registries.getAttributeTypeRegistry().lookup("m-dependencies");
        this.modifiersNameAT = (AttributeType)this.registries.getAttributeTypeRegistry().lookup("modifiersName");
        this.modifyTimestampAT = (AttributeType)this.registries.getAttributeTypeRegistry().lookup("modifyTimestamp");
        this.ouSchemaDN = new DN("ou=schema");
        this.ouSchemaDN.normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
    }

    @Override
    public boolean modify(ModifyOperationContext opContext, ServerEntry targetEntry, boolean cascade) throws Exception {
        ClonedServerEntry entry = opContext.getEntry();
        List mods = opContext.getModItems();
        boolean hasModification = false;
        EntryAttribute disabledInEntry = entry.get(this.disabledAT);
        Modification disabledModification = ServerEntryUtils.getModificationItem((List)mods, (AttributeType)this.disabledAT);
        if (disabledModification != null) {
            ModificationOperation modification = disabledModification.getOperation();
            EntryAttribute attribute = disabledModification.getAttribute();
            hasModification = this.modifyDisable(opContext, modification, attribute, disabledInEntry);
        } else if (disabledInEntry != null) {
            hasModification = this.modifyDisable(opContext, ModificationOperation.REMOVE_ATTRIBUTE, null, disabledInEntry);
        }
        return hasModification;
    }

    @Override
    public void moveAndRename(DN oriChildName, DN newParentName, RDN newRn, boolean deleteOldRn, ServerEntry entry, boolean cascaded) throws LdapException {
    }

    @Override
    public void add(ServerEntry entry) throws Exception {
        DN dn = entry.getDn();
        DN parentDn = (DN)dn.clone();
        parentDn.remove(parentDn.size() - 1);
        parentDn.normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
        if (!parentDn.equals(this.ouSchemaDN)) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_380, this.ouSchemaDN.getName(), parentDn.getNormName()));
        }
        boolean isEnabled = false;
        EntryAttribute disabled = entry.get(this.disabledAT);
        if (disabled == null) {
            isEnabled = true;
        } else if (!disabled.contains("TRUE")) {
            isEnabled = true;
        }
        this.checkForDependencies(isEnabled, entry);
        if (isEnabled) {
            Schema schema = this.factory.getSchema(entry);
            this.schemaManager.load(schema);
        }
    }

    @Override
    public void delete(ServerEntry entry, boolean cascade) throws Exception {
        EntryAttribute cn = entry.get(this.cnAT);
        String schemaName = cn.getString();
        Set<String> dependents = this.schemaManager.listDependentSchemaNames(schemaName);
        if (dependents != null && !dependents.isEmpty()) {
            String msg = I18n.err(I18n.ERR_381, dependents);
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        this.schemaManager.unload(schemaName);
    }

    @Override
    public void rename(ServerEntry entry, RDN newRdn, boolean cascade) throws Exception {
        String rdnAttribute = newRdn.getUpType();
        String rdnAttributeOid = this.registries.getAttributeTypeRegistry().getOidByName(rdnAttribute);
        if (!rdnAttributeOid.equals(this.cnAT.getOid())) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_382, rdnAttribute));
        }
    }

    public void moveAndRename(DN oriChildName, DN newParentName, String newRn, boolean deleteOldRn, ServerEntry entry, boolean cascade) throws LdapUnwillingToPerformException {
        throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_383, new Object[0]));
    }

    @Override
    public void move(DN oriChildName, DN newParentName, ServerEntry entry, boolean cascade) throws LdapUnwillingToPerformException {
        throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_383, new Object[0]));
    }

    private boolean modifyDisable(ModifyOperationContext opContext, ModificationOperation modOp, EntryAttribute disabledInMods, EntryAttribute disabledInEntry) throws Exception {
        DN name = opContext.getDn();
        switch (modOp) {
            case ADD_ATTRIBUTE: {
                if (disabledInEntry != null || !"TRUE".equalsIgnoreCase(disabledInMods.getString())) break;
                return this.disableSchema(opContext.getSession(), this.getSchemaName(name));
            }
            case REMOVE_ATTRIBUTE: {
                if (disabledInEntry == null || !"TRUE".equalsIgnoreCase(disabledInEntry.getString())) break;
                return this.enableSchema(this.getSchemaName(name));
            }
            case REPLACE_ATTRIBUTE: {
                boolean isCurrentlyDisabled = false;
                if (disabledInEntry != null) {
                    isCurrentlyDisabled = "TRUE".equalsIgnoreCase(disabledInEntry.getString());
                }
                boolean isNewStateDisabled = false;
                if (disabledInMods != null) {
                    Value<?> val = disabledInMods.get();
                    isNewStateDisabled = val == null ? false : "TRUE".equalsIgnoreCase(val.getString());
                }
                if (isCurrentlyDisabled && !isNewStateDisabled) {
                    return this.enableSchema(this.getSchemaName(name));
                }
                if (isCurrentlyDisabled || !isNewStateDisabled) break;
                return this.disableSchema(opContext.getSession(), this.getSchemaName(name));
            }
            default: {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_384, new Object[]{modOp}));
            }
        }
        return false;
    }

    private String getSchemaName(DN schema) {
        return schema.getRdn().getNormValue();
    }

    private DN buildDn(SchemaObjectType schemaObjectType, String schemaName) throws LdapInvalidDnException {
        DN path = new DN("ou=schema", "cn=" + schemaName, schemaObjectType.getRdn());
        return path;
    }

    private void disable(SchemaObject schemaObject, CoreSession session, Registries registries) throws Exception {
        Schema schema = registries.getLoadedSchema(schemaObject.getSchemaName());
        ArrayList<ServerModification> modifications = new ArrayList<ServerModification>();
        DefaultServerAttribute disabledAttr = new DefaultServerAttribute(this.disabledAT, "FALSE");
        ServerModification disabledMod = new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, disabledAttr);
        modifications.add(disabledMod);
        DefaultServerAttribute modifiersNameAttr = new DefaultServerAttribute(this.modifiersNameAT, session.getEffectivePrincipal().getName());
        ServerModification modifiersNameMod = new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, modifiersNameAttr);
        modifications.add(modifiersNameMod);
        DefaultServerAttribute modifyTimestampAttr = new DefaultServerAttribute(this.modifyTimestampAT, DateUtils.getGeneralizedTime());
        ServerModification modifyTimestampMod = new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, modifyTimestampAttr);
        modifications.add(modifyTimestampMod);
        DN dn = this.buildDn(schemaObject.getObjectType(), schemaObject.getName());
        ModifyOperationContext modifyContext = new ModifyOperationContext(session, dn, modifications);
        modifyContext.setByPassed(ByPassConstants.BYPASS_ALL_COLLECTION);
        OperationManager operationManager = session.getDirectoryService().getOperationManager();
        operationManager.modify(modifyContext);
        for (SchemaObjectWrapper schemaObjectWrapper : schema.getContent()) {
        }
    }

    private boolean disableSchema(CoreSession session, String schemaName) throws Exception {
        Schema schema = this.registries.getLoadedSchema(schemaName);
        if (schema == null) {
            String msg = I18n.err(I18n.ERR_85, schemaName);
            LOG.error(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        return this.schemaManager.disable(schemaName);
    }

    private void disableAT(CoreSession session, String schemaName) {
        AttributeTypeRegistry atRegistry = this.registries.getAttributeTypeRegistry();
        for (AttributeType attributeType : atRegistry) {
            if (!schemaName.equalsIgnoreCase(attributeType.getSchemaName()) || attributeType.isDisabled()) continue;
            DefaultServerAttribute disable = new DefaultServerAttribute(this.disabledAT, "TRUE");
            ServerModification modification = new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, disable);
        }
    }

    private boolean enableSchema(String schemaName) throws Exception {
        Schema schema = this.registries.getLoadedSchema(schemaName);
        if (schema == null) {
            this.schemaManager.loadDisabled(schemaName);
        }
        return this.schemaManager.enable(schemaName);
    }

    private void checkForDependencies(boolean isEnabled, ServerEntry entry) throws Exception {
        EntryAttribute dependencies = entry.get(this.dependenciesAT);
        if (dependencies == null) {
            return;
        }
        if (isEnabled) {
            Map<String, Schema> loaded = this.registries.getLoadedSchemas();
            for (Value value : dependencies) {
                String dependency = value.getString();
                if (loaded.containsKey(dependency)) continue;
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, "Unwilling to perform operation on enabled schema with disabled or missing dependencies: " + dependency);
            }
        } else {
            for (Value value : dependencies) {
                String dependency = value.getString();
                if (this.schemaManager.getLoadedSchema(StringTools.toLowerCase(dependency)) != null) continue;
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_385, dependency));
            }
        }
    }

    private void renameSchema(DefaultSchemaObjectRegistry<? extends SchemaObject> registry, String originalSchemaName, String newSchemaName) {
        for (SchemaObject schemaObject : registry) {
            if (!schemaObject.getSchemaName().equalsIgnoreCase(originalSchemaName)) continue;
            schemaObject.setSchemaName(newSchemaName);
        }
    }
}

