/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.schema.SchemaPartitionDao;
import org.apache.directory.server.core.schema.SchemaPartitionDaoImpl;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.parsers.LdapComparatorDescription;
import org.apache.directory.shared.ldap.schema.parsers.NormalizerDescription;
import org.apache.directory.shared.ldap.schema.parsers.SyntaxCheckerDescription;
import org.apache.directory.shared.ldap.schema.registries.AbstractSchemaLoader;
import org.apache.directory.shared.ldap.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.registries.Schema;
import org.apache.directory.shared.ldap.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionSchemaLoader
extends AbstractSchemaLoader {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionSchemaLoader.class);
    private final SchemaPartitionDao dao;
    private Partition partition;
    private SchemaManager schemaManager;
    private final AttributeType mOidAT;
    private final AttributeType mNameAT;
    private final AttributeType cnAT;
    private final AttributeType byteCodeAT;
    private final AttributeType descAT;
    private final AttributeType fqcnAT;
    private static Map<String, DN> staticAttributeTypeDNs = new HashMap<String, DN>();
    private static Map<String, DN> staticMatchingRulesDNs = new HashMap<String, DN>();
    private static Map<String, DN> staticObjectClassesDNs = new HashMap<String, DN>();
    private static Map<String, DN> staticComparatorsDNs = new HashMap<String, DN>();
    private static Map<String, DN> staticNormalizersDNs = new HashMap<String, DN>();
    private static Map<String, DN> staticSyntaxCheckersDNs = new HashMap<String, DN>();
    private static Map<String, DN> staticSyntaxesDNs = new HashMap<String, DN>();

    public PartitionSchemaLoader(Partition partition, SchemaManager schemaManager) throws Exception {
        this.partition = partition;
        this.schemaManager = schemaManager;
        this.dao = new SchemaPartitionDaoImpl(this.partition, schemaManager);
        this.mOidAT = schemaManager.lookupAttributeTypeRegistry("m-oid");
        this.mNameAT = schemaManager.lookupAttributeTypeRegistry("m-name");
        this.cnAT = schemaManager.lookupAttributeTypeRegistry("cn");
        this.byteCodeAT = schemaManager.lookupAttributeTypeRegistry("m-bytecode");
        this.descAT = schemaManager.lookupAttributeTypeRegistry("m-description");
        this.fqcnAT = schemaManager.lookupAttributeTypeRegistry("m-fqcn");
        this.initStaticDNs("system");
        this.initStaticDNs("core");
        this.initStaticDNs("apache");
        this.initStaticDNs("apachemeta");
        this.initStaticDNs("other");
        this.initStaticDNs("collective");
        this.initStaticDNs("java");
        this.initStaticDNs("cosine");
        this.initStaticDNs("inetorgperson");
    }

    private void initStaticDNs(String schemaName) throws Exception {
        DN dn = new DN("ou=attributetypes", "cn=" + schemaName, "ou=schema");
        dn.normalize(this.schemaManager.getNormalizerMapping());
        staticAttributeTypeDNs.put(schemaName, dn);
        dn = new DN("ou=objectclasses", "cn=" + schemaName, "ou=schema");
        dn.normalize(this.schemaManager.getNormalizerMapping());
        staticObjectClassesDNs.put(schemaName, dn);
        dn = new DN("ou=matchingrules", "cn=" + schemaName, "ou=schema");
        dn.normalize(this.schemaManager.getNormalizerMapping());
        staticMatchingRulesDNs.put(schemaName, dn);
        dn = new DN("ou=comparators", "cn=" + schemaName, "ou=schema");
        dn.normalize(this.schemaManager.getNormalizerMapping());
        staticComparatorsDNs.put(schemaName, dn);
        dn = new DN("ou=normalizers", "cn=" + schemaName, "ou=schema");
        dn.normalize(this.schemaManager.getNormalizerMapping());
        staticNormalizersDNs.put(schemaName, dn);
        dn = new DN("ou=syntaxcheckers", "cn=" + schemaName, "ou=schema");
        dn.normalize(this.schemaManager.getNormalizerMapping());
        staticSyntaxCheckersDNs.put(schemaName, dn);
        dn = new DN("ou=syntaxes", "cn=" + schemaName, "ou=schema");
        dn.normalize(this.schemaManager.getNormalizerMapping());
        staticSyntaxesDNs.put(schemaName, dn);
    }

    private DN updateDNs(Map<String, DN> staticDNs, String path, Schema schema) throws LdapInvalidDnException {
        DN dn = staticDNs.get(schema.getSchemaName());
        if (dn == null) {
            dn = new DN(path, "cn=" + schema.getSchemaName(), "ou=schema");
            dn.normalize(this.schemaManager.getNormalizerMapping());
            staticDNs.put(schema.getSchemaName(), dn);
        }
        return dn;
    }

    public Set<String> listDependentSchemaNames(String schemaName) throws Exception {
        HashSet<String> dependees = new HashSet<String>();
        Set<ServerEntry> results = this.dao.listSchemaDependents(schemaName);
        if (results.isEmpty()) {
            return dependees;
        }
        for (ServerEntry sr : results) {
            EntryAttribute cn = sr.get(this.cnAT);
            dependees.add(cn.getString());
        }
        return dependees;
    }

    public Set<String> listEnabledDependentSchemaNames(String schemaName) throws Exception {
        HashSet<String> dependees = new HashSet<String>();
        Set<ServerEntry> results = this.dao.listEnabledSchemaDependents(schemaName);
        if (results.isEmpty()) {
            return dependees;
        }
        for (ServerEntry sr : results) {
            EntryAttribute cn = sr.get(this.cnAT);
            dependees.add(cn.getString());
        }
        return dependees;
    }

    public Map<String, Schema> getSchemas() throws Exception {
        return this.dao.getSchemas();
    }

    public Set<String> getSchemaNames() throws Exception {
        return this.dao.getSchemaNames();
    }

    @Override
    public Schema getSchema(String schemaName) {
        try {
            return this.dao.getSchema(schemaName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public final void load(Schema schema, Registries targetRegistries, boolean isDepLoad) throws Exception {
        if (schema.isDisabled() && isDepLoad) {
            this.dao.enableSchema(schema.getSchemaName());
        }
        if (targetRegistries.isSchemaLoaded(schema.getSchemaName())) {
            LOG.debug("schema {} already seems to be loaded", (Object)schema.getSchemaName());
            return;
        }
        LOG.debug("loading {} schema ...", (Object)schema.getSchemaName());
        this.loadComparators(schema);
        this.loadNormalizers(schema);
        this.loadSyntaxCheckers(schema);
        this.loadSyntaxes(schema);
        this.loadMatchingRules(schema);
        this.loadAttributeTypes(schema);
        this.loadObjectClasses(schema);
        this.loadMatchingRuleUses(schema);
        this.loadDitContentRules(schema);
        this.loadNameForms(schema);
        this.loadDitStructureRules(schema);
        this.notifyListenerOrRegistries(schema, targetRegistries);
    }

    @Override
    public List<Entry> loadAttributeTypes(Schema ... schemas) throws Exception {
        ArrayList<Entry> attributeTypeList = new ArrayList<Entry>();
        for (Schema schema : schemas) {
            DN dn = this.updateDNs(staticAttributeTypeDNs, "ou=attributetypes", schema);
            if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
                return attributeTypeList;
            }
            LOG.debug("{} schema: loading attributeTypes", (Object)schema.getSchemaName());
            EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
            while (list.next()) {
                ServerEntry result = (ServerEntry)list.get();
                attributeTypeList.add(result);
            }
        }
        return attributeTypeList;
    }

    @Override
    public List<Entry> loadComparators(Schema ... schemas) throws Exception {
        ArrayList<Entry> comparatorList = new ArrayList<Entry>();
        if (schemas == null) {
            return comparatorList;
        }
        for (Schema schema : schemas) {
            DN dn = this.updateDNs(staticComparatorsDNs, "ou=comparators", schema);
            if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
                return comparatorList;
            }
            LOG.debug("{} schema: loading comparators", (Object)schema.getSchemaName());
            EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
            while (list.next()) {
                ClonedServerEntry entry = (ClonedServerEntry)list.get();
                comparatorList.add((Entry)entry);
            }
        }
        return comparatorList;
    }

    @Override
    public List<Entry> loadDitContentRules(Schema ... schemas) throws Exception {
        LOG.error(I18n.err(I18n.ERR_86, new Object[0]));
        return null;
    }

    @Override
    public List<Entry> loadDitStructureRules(Schema ... schemas) throws Exception {
        LOG.error(I18n.err(I18n.ERR_87, new Object[0]));
        return null;
    }

    @Override
    public List<Entry> loadMatchingRules(Schema ... schemas) throws Exception {
        ArrayList<Entry> matchingRuleList = new ArrayList<Entry>();
        if (schemas == null) {
            return matchingRuleList;
        }
        for (Schema schema : schemas) {
            DN dn = this.updateDNs(staticMatchingRulesDNs, "ou=matchingrules", schema);
            if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
                return matchingRuleList;
            }
            LOG.debug("{} schema: loading matchingRules", (Object)schema.getSchemaName());
            EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
            while (list.next()) {
                ServerEntry entry = (ServerEntry)list.get();
                matchingRuleList.add(entry);
            }
        }
        return matchingRuleList;
    }

    @Override
    public List<Entry> loadMatchingRuleUses(Schema ... schemas) throws Exception {
        LOG.error(I18n.err(I18n.ERR_88, new Object[0]));
        return null;
    }

    @Override
    public List<Entry> loadNameForms(Schema ... schemas) throws Exception {
        LOG.error(I18n.err(I18n.ERR_89, new Object[0]));
        return null;
    }

    @Override
    public List<Entry> loadNormalizers(Schema ... schemas) throws Exception {
        ArrayList<Entry> normalizerList = new ArrayList<Entry>();
        if (schemas == null) {
            return normalizerList;
        }
        for (Schema schema : schemas) {
            DN dn = this.updateDNs(staticNormalizersDNs, "ou=normalizers", schema);
            if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
                return normalizerList;
            }
            LOG.debug("{} schema: loading normalizers", (Object)schema.getSchemaName());
            EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
            while (list.next()) {
                ClonedServerEntry entry = (ClonedServerEntry)list.get();
                normalizerList.add((Entry)entry);
            }
        }
        return normalizerList;
    }

    @Override
    public List<Entry> loadObjectClasses(Schema ... schemas) throws Exception {
        ArrayList<Entry> objectClassList = new ArrayList<Entry>();
        if (schemas == null) {
            return objectClassList;
        }
        for (Schema schema : schemas) {
            DN dn = this.updateDNs(staticObjectClassesDNs, "ou=objectclasses", schema);
            if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
                return objectClassList;
            }
            LOG.debug("{} schema: loading objectClasses", (Object)schema.getSchemaName());
            EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
            while (list.next()) {
                ClonedServerEntry entry = (ClonedServerEntry)list.get();
                objectClassList.add((Entry)entry);
            }
        }
        return objectClassList;
    }

    @Override
    public List<Entry> loadSyntaxes(Schema ... schemas) throws Exception {
        ArrayList<Entry> syntaxList = new ArrayList<Entry>();
        if (schemas == null) {
            return syntaxList;
        }
        for (Schema schema : schemas) {
            DN dn = this.updateDNs(staticSyntaxesDNs, "ou=syntaxes", schema);
            if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
                return syntaxList;
            }
            LOG.debug("{} schema: loading syntaxes", (Object)schema.getSchemaName());
            EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
            while (list.next()) {
                ServerEntry entry = (ServerEntry)list.get();
                syntaxList.add(entry);
            }
        }
        return syntaxList;
    }

    @Override
    public List<Entry> loadSyntaxCheckers(Schema ... schemas) throws Exception {
        ArrayList<Entry> syntaxCheckerList = new ArrayList<Entry>();
        if (schemas == null) {
            return syntaxCheckerList;
        }
        for (Schema schema : schemas) {
            DN dn = this.updateDNs(staticSyntaxCheckersDNs, "ou=syntaxcheckers", schema);
            if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
                return syntaxCheckerList;
            }
            LOG.debug("{} schema: loading syntaxCsheckers", (Object)schema.getSchemaName());
            EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
            while (list.next()) {
                ServerEntry entry = (ServerEntry)list.get();
                syntaxCheckerList.add(entry);
            }
        }
        return syntaxCheckerList;
    }

    private String getOid(ServerEntry entry) throws Exception {
        EntryAttribute oid = entry.get(this.mOidAT);
        if (oid == null) {
            return null;
        }
        return oid.getString();
    }

    private NormalizerDescription getNormalizerDescription(String schemaName, ServerEntry entry) throws Exception {
        EntryAttribute bytecode;
        NormalizerDescription description = new NormalizerDescription(this.getOid(entry));
        ArrayList<String> values = new ArrayList<String>();
        values.add(schemaName);
        description.addExtension("X-SCHEMA", values);
        description.setFqcn(entry.get(this.fqcnAT).getString());
        EntryAttribute desc = entry.get(this.descAT);
        if (desc != null && desc.size() > 0) {
            description.setDescription(desc.getString());
        }
        if ((bytecode = entry.get(this.byteCodeAT)) != null && bytecode.size() > 0) {
            byte[] bytes = bytecode.getBytes();
            description.setBytecode(new String(Base64.encode(bytes)));
        }
        return description;
    }

    private ClonedServerEntry lookupPartition(DN dn) throws Exception {
        return this.partition.lookup(new LookupOperationContext(null, dn));
    }

    private LdapComparatorDescription getLdapComparatorDescription(String schemaName, ServerEntry entry) throws Exception {
        EntryAttribute bytecode;
        LdapComparatorDescription description = new LdapComparatorDescription(this.getOid(entry));
        ArrayList<String> values = new ArrayList<String>();
        values.add(schemaName);
        description.addExtension("X-SCHEMA", values);
        description.setFqcn(entry.get(this.fqcnAT).getString());
        EntryAttribute desc = entry.get(this.descAT);
        if (desc != null && desc.size() > 0) {
            description.setDescription(desc.getString());
        }
        if ((bytecode = entry.get(this.byteCodeAT)) != null && bytecode.size() > 0) {
            byte[] bytes = bytecode.getBytes();
            description.setBytecode(new String(Base64.encode(bytes)));
        }
        return description;
    }

    private SyntaxCheckerDescription getSyntaxCheckerDescription(String schemaName, ServerEntry entry) throws Exception {
        EntryAttribute bytecode;
        SyntaxCheckerDescription description = new SyntaxCheckerDescription(this.getOid(entry));
        ArrayList<String> values = new ArrayList<String>();
        values.add(schemaName);
        description.addExtension("X-SCHEMA", values);
        description.setFqcn(entry.get(this.fqcnAT).getString());
        EntryAttribute desc = entry.get(this.descAT);
        if (desc != null && desc.size() > 0) {
            description.setDescription(desc.getString());
        }
        if ((bytecode = entry.get(this.byteCodeAT)) != null && bytecode.size() > 0) {
            byte[] bytes = bytecode.getBytes();
            description.setBytecode(new String(Base64.encode(bytes)));
        }
        return description;
    }

    @Override
    public SchemaPartitionDao getDao() {
        return this.dao;
    }
}

