/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import jdbm.RecordManager;
import jdbm.helper.LongSerializer;
import jdbm.helper.Serializer;
import jdbm.helper.StringComparator;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.core.partition.impl.btree.jdbm.ServerEntrySerializer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.MasterTable;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.comparators.SerializableComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbmMasterTable<E>
extends JdbmTable<Long, E>
implements MasterTable<E> {
    private static final StringComparator STRCOMP = new StringComparator();
    private static final SerializableComparator<Long> LONG_COMPARATOR = new SerializableComparator<Long>("1.3.6.1.4.1.18060.0.4.1.1.2"){
        private static final long serialVersionUID = 4048791282048841016L;

        @Override
        public int compare(Long o1, Long o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_525, new Object[0]));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_526, new Object[0]));
            }
            if (o1.longValue() == o2.longValue()) {
                return 0;
            }
            if (o1.longValue() == o2.longValue()) {
                return 0;
            }
            if (o1 >= 0L) {
                if (o2 >= 0L) {
                    return o1 > o2 ? 1 : -1;
                }
                return -1;
            }
            if (o2 >= 0L) {
                return 1;
            }
            return o1 < o2 ? -1 : 1;
        }
    };
    private static final SerializableComparator<String> STRING_COMPARATOR = new SerializableComparator<String>("1.3.6.1.4.1.18060.0.4.1.1.3"){
        private static final long serialVersionUID = 3258689922792961845L;

        @Override
        public int compare(String o1, String o2) {
            return STRCOMP.compare((Object)o1, (Object)o2);
        }
    };
    protected final JdbmTable<String, String> adminTbl;

    public JdbmMasterTable(RecordManager recMan, SchemaManager schemaManager) throws Exception {
        super(schemaManager, "master", recMan, LONG_COMPARATOR, (Serializer)LongSerializer.INSTANCE, new ServerEntrySerializer(schemaManager));
        this.adminTbl = new JdbmTable(schemaManager, "admin", recMan, STRING_COMPARATOR, null, null);
        String seqValue = this.adminTbl.get("__sequence__");
        if (null == seqValue) {
            this.adminTbl.put("__sequence__", "0");
        }
        LONG_COMPARATOR.setSchemaManager(schemaManager);
        STRING_COMPARATOR.setSchemaManager(schemaManager);
    }

    protected JdbmMasterTable(RecordManager recMan, SchemaManager schemaManager, String dbName, Serializer serializer) throws Exception {
        super(schemaManager, "master", recMan, LONG_COMPARATOR, (Serializer)LongSerializer.INSTANCE, serializer);
        this.adminTbl = new JdbmTable(schemaManager, dbName, recMan, STRING_COMPARATOR, null, null);
        String seqValue = this.adminTbl.get("__sequence__");
        if (null == seqValue) {
            this.adminTbl.put("__sequence__", "0");
        }
    }

    @Override
    public E get(Long id) throws Exception {
        return (E)super.get(id);
    }

    @Override
    public void put(Long id, E entry) throws Exception {
        super.put(id, entry);
    }

    public void delete(Long id) throws Exception {
        super.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getCurrentId() throws Exception {
        Long id;
        JdbmTable<String, String> jdbmTable = this.adminTbl;
        synchronized (jdbmTable) {
            id = new Long(this.adminTbl.get("__sequence__"));
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextId() throws Exception {
        Long nextVal;
        JdbmTable<String, String> jdbmTable = this.adminTbl;
        synchronized (jdbmTable) {
            Long lastVal = new Long(this.adminTbl.get("__sequence__"));
            nextVal = lastVal + 1L;
            this.adminTbl.put("__sequence__", nextVal.toString());
        }
        return nextVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String property) throws Exception {
        JdbmTable<String, String> jdbmTable = this.adminTbl;
        synchronized (jdbmTable) {
            return this.adminTbl.get(property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String property, String value) throws Exception {
        JdbmTable<String, String> jdbmTable = this.adminTbl;
        synchronized (jdbmTable) {
            this.adminTbl.put(property, value);
        }
    }
}

