/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.File;
import java.io.IOException;
import jdbm.RecordManager;
import jdbm.helper.CachePolicy;
import jdbm.helper.MRU;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;
import org.apache.directory.server.core.partition.impl.btree.IndexCursorAdaptor;
import org.apache.directory.server.core.partition.impl.btree.LongComparator;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.core.partition.impl.btree.jdbm.LongSerializer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.Tuple;
import org.apache.directory.shared.ldap.cursor.Cursor;
import org.apache.directory.shared.ldap.entry.BinaryValue;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.comparators.SerializableComparator;
import org.apache.directory.shared.ldap.util.SynchronizedLRUMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbmIndex<K, O>
implements Index<K, O, Long> {
    private static final Logger LOG = LoggerFactory.getLogger((String)JdbmIndex.class.getSimpleName());
    public static final int DEFAULT_DUPLICATE_LIMIT = 512;
    public static final String FORWARD_BTREE = "_forward";
    public static final String REVERSE_BTREE = "_reverse";
    private AttributeType attribute;
    protected JdbmTable<K, Long> forward;
    protected JdbmTable<Long, K> reverse;
    protected RecordManager recMan;
    protected SynchronizedLRUMap keyCache;
    protected int cacheSize = 100;
    protected int numDupLimit = 512;
    private String attributeId;
    protected boolean initialized = false;
    protected File wkDirPath;

    public JdbmIndex() {
    }

    public JdbmIndex(String attributeId) {
        this.setAttributeId(attributeId);
    }

    public void init(SchemaManager schemaManager, AttributeType attributeType, File wkDirPath) throws IOException {
        LOG.debug("Initializing an Index for attribute '{}'", (Object)attributeType.getName());
        this.keyCache = new SynchronizedLRUMap(this.cacheSize);
        this.attribute = attributeType;
        if (this.attributeId == null) {
            this.setAttributeId(this.attribute.getName());
        }
        if (this.wkDirPath == null) {
            this.wkDirPath = wkDirPath;
        }
        File file = new File(this.wkDirPath.getPath() + File.separator + this.attribute.getName());
        String path = file.getAbsolutePath();
        BaseRecordManager base = new BaseRecordManager(path);
        base.disableTransactions();
        this.recMan = new CacheRecordManager((RecordManager)base, (CachePolicy)new MRU(this.cacheSize));
        try {
            this.initTables(schemaManager);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        this.initialized = true;
    }

    private void initTables(SchemaManager schemaManager) throws IOException {
        MatchingRule mr = this.attribute.getEquality();
        if (mr == null) {
            throw new IOException(I18n.err(I18n.ERR_574, this.attribute.getName()));
        }
        SerializableComparator comp = new SerializableComparator(mr.getOid());
        LongComparator.INSTANCE.setSchemaManager(schemaManager);
        comp.setSchemaManager(schemaManager);
        this.forward = new JdbmTable(schemaManager, this.attribute.getName() + FORWARD_BTREE, this.numDupLimit, this.recMan, comp, LongComparator.INSTANCE, null, LongSerializer.INSTANCE);
        this.reverse = this.attribute.isSingleValued() ? new JdbmTable(schemaManager, this.attribute.getName() + REVERSE_BTREE, this.recMan, LongComparator.INSTANCE, LongSerializer.INSTANCE, null) : new JdbmTable(schemaManager, this.attribute.getName() + REVERSE_BTREE, this.numDupLimit, this.recMan, LongComparator.INSTANCE, comp, LongSerializer.INSTANCE, null);
    }

    public AttributeType getAttribute() {
        return this.attribute;
    }

    private void protect(String property) {
        if (this.initialized) {
            throw new IllegalStateException(I18n.err(I18n.ERR_575, property));
        }
    }

    public boolean isCountExact() {
        return false;
    }

    public String getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(String attributeId) {
        this.protect("attributeId");
        this.attributeId = attributeId;
    }

    public int getNumDupLimit() {
        return this.numDupLimit;
    }

    public void setNumDupLimit(int numDupLimit) {
        this.protect("numDupLimit");
        this.numDupLimit = numDupLimit;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.protect("cacheSize");
        this.cacheSize = cacheSize;
    }

    public void setWkDirPath(File wkDirPath) {
        this.protect("wkDirPath");
        this.wkDirPath = wkDirPath;
    }

    public File getWkDirPath() {
        return this.wkDirPath;
    }

    public int count() throws IOException {
        return this.forward.count();
    }

    public int count(K attrVal) throws Exception {
        return this.forward.count(this.getNormalized(attrVal));
    }

    public int greaterThanCount(K attrVal) throws Exception {
        return this.forward.greaterThanCount(this.getNormalized(attrVal));
    }

    public int lessThanCount(K attrVal) throws Exception {
        return this.forward.lessThanCount(this.getNormalized(attrVal));
    }

    public Long forwardLookup(K attrVal) throws Exception {
        return this.forward.get(this.getNormalized(attrVal));
    }

    public K reverseLookup(Long id) throws Exception {
        return this.reverse.get(id);
    }

    public synchronized void add(K attrVal, Long id) throws Exception {
        this.forward.put(this.getNormalized(attrVal), id);
        this.reverse.put(id, (Long)this.getNormalized(attrVal));
    }

    public synchronized void drop(K attrVal, Long id) throws Exception {
        this.forward.remove(this.getNormalized(attrVal), id);
        this.reverse.remove(id, (Long)this.getNormalized(attrVal));
    }

    public void drop(Long entryId) throws Exception {
        Cursor<Tuple<Long, K>> values = this.reverse.cursor(entryId);
        while (values.next()) {
            this.forward.remove(((Tuple)values.get()).getValue(), entryId);
        }
        this.reverse.remove(entryId);
    }

    public IndexCursor<K, O, Long> reverseCursor() throws Exception {
        return new IndexCursorAdaptor(this.reverse.cursor(), false);
    }

    public IndexCursor<K, O, Long> forwardCursor() throws Exception {
        return new IndexCursorAdaptor(this.forward.cursor(), true);
    }

    public IndexCursor<K, O, Long> reverseCursor(Long id) throws Exception {
        return new IndexCursorAdaptor(this.reverse.cursor(id), false);
    }

    public IndexCursor<K, O, Long> forwardCursor(K key) throws Exception {
        return new IndexCursorAdaptor(this.forward.cursor(key), true);
    }

    public Cursor<K> reverseValueCursor(Long id) throws Exception {
        return this.reverse.valueCursor(id);
    }

    public Cursor<Long> forwardValueCursor(K key) throws Exception {
        return this.forward.valueCursor(key);
    }

    public boolean forward(K attrVal) throws Exception {
        return this.forward.has(this.getNormalized(attrVal));
    }

    public boolean forward(K attrVal, Long id) throws Exception {
        return this.forward.has(this.getNormalized(attrVal), id);
    }

    public boolean reverse(Long id) throws Exception {
        return this.reverse.has(id);
    }

    public boolean reverse(Long id, K attrVal) throws Exception {
        return this.forward.has(this.getNormalized(attrVal), id);
    }

    public boolean forwardGreaterOrEq(K attrVal) throws Exception {
        return this.forward.hasGreaterOrEqual(this.getNormalized(attrVal));
    }

    public boolean forwardGreaterOrEq(K attrVal, Long id) throws Exception {
        return this.forward.hasGreaterOrEqual(this.getNormalized(attrVal), id);
    }

    public boolean forwardLessOrEq(K attrVal) throws Exception {
        return this.forward.hasLessOrEqual(this.getNormalized(attrVal));
    }

    public boolean forwardLessOrEq(K attrVal, Long id) throws Exception {
        return this.forward.hasLessOrEqual(this.getNormalized(attrVal), id);
    }

    public boolean reverseGreaterOrEq(Long id) throws Exception {
        return this.reverse.hasGreaterOrEqual(id);
    }

    public boolean reverseGreaterOrEq(Long id, K attrVal) throws Exception {
        return this.reverse.hasGreaterOrEqual(id, (Long)this.getNormalized(attrVal));
    }

    public boolean reverseLessOrEq(Long id) throws Exception {
        return this.reverse.hasLessOrEqual(id);
    }

    public boolean reverseLessOrEq(Long id, K attrVal) throws Exception {
        return this.reverse.hasLessOrEqual(id, (Long)this.getNormalized(attrVal));
    }

    public synchronized void close() throws IOException {
        if (this.forward != null) {
            this.forward.close();
        }
        if (this.reverse != null) {
            this.reverse.close();
        }
        this.recMan.commit();
        this.recMan.close();
    }

    public synchronized void sync() throws IOException {
        this.recMan.commit();
    }

    public K getNormalized(K attrVal) throws Exception {
        if (attrVal instanceof Long) {
            return attrVal;
        }
        Object normalized = this.keyCache.get(attrVal);
        if (null == normalized) {
            normalized = attrVal instanceof String ? this.attribute.getEquality().getNormalizer().normalize((String)attrVal) : this.attribute.getEquality().getNormalizer().normalize(new BinaryValue((byte[])attrVal)).get();
            this.keyCache.put((Object)attrVal, normalized);
            this.keyCache.put(normalized, normalized);
        }
        return (K)normalized;
    }

    public String toString() {
        return "Index<" + this.attributeId + ">";
    }
}

