/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.avl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.partition.avl.AvlIndex;
import org.apache.directory.server.core.partition.avl.AvlMasterTable;
import org.apache.directory.server.core.partition.impl.btree.LongComparator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.exception.LdapNoSuchObjectException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.AVA;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.util.NamespaceTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvlStore<E>
implements Store<E, Long> {
    private static final Logger LOG = LoggerFactory.getLogger(AvlStore.class);
    private static AttributeType OBJECT_CLASS_AT;
    private static AttributeType ALIASED_OBJECT_NAME_AT;
    private AvlMasterTable<ServerEntry> master;
    private AvlIndex<String, E> ndnIdx;
    private AvlIndex<String, E> updnIdx;
    private AvlIndex<String, E> existenceIdx;
    private AvlIndex<String, E> aliasIdx;
    private AvlIndex<Long, E> subLevelIdx;
    private AvlIndex<Long, E> oneLevelIdx;
    private AvlIndex<Long, E> oneAliasIdx;
    private AvlIndex<Long, E> subAliasIdx;
    private AvlIndex<String, E> objectClassIdx;
    private AvlIndex<String, E> entryCsnIdx;
    private AvlIndex<String, E> entryUuidIdx;
    private Map<String, AvlIndex<? extends Object, E>> userIndices = new HashMap<String, AvlIndex<? extends Object, E>>();
    private Map<String, AvlIndex<? extends Object, E>> systemIndices = new HashMap<String, AvlIndex<? extends Object, E>>();
    private boolean initialized;
    private SchemaManager schemaManager;
    private DN suffixDn;
    private String name;

    public void add(ServerEntry entry) throws Exception {
        Long parentId;
        if (entry instanceof ClonedServerEntry) {
            throw new Exception(I18n.err(I18n.ERR_215, new Object[0]));
        }
        DN normName = entry.getDn();
        Long id = this.master.getNextId();
        DN parentDn = null;
        if (normName.getNormName().equals(this.suffixDn.getNormName())) {
            parentId = 0L;
        } else {
            parentDn = (DN)normName.clone();
            parentDn.remove(parentDn.size() - 1);
            parentId = this.getEntryId(parentDn.getNormName());
        }
        if (parentId == null) {
            throw new LdapNoSuchObjectException(I18n.err(I18n.ERR_216, parentDn));
        }
        EntryAttribute objectClass = entry.get(OBJECT_CLASS_AT);
        if (objectClass == null) {
            String msg = I18n.err(I18n.ERR_217, normName.getName(), entry);
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, msg);
        }
        for (Value value : objectClass) {
            this.objectClassIdx.add(value.getString(), id);
        }
        if (objectClass.contains("alias")) {
            EntryAttribute aliasAttr = entry.get(ALIASED_OBJECT_NAME_AT);
            this.addAliasIndices(id, normName, aliasAttr.getString());
        }
        if (!Character.isDigit(normName.getNormName().charAt(0))) {
            throw new IllegalStateException(I18n.err(I18n.ERR_218, normName.getNormName()));
        }
        this.ndnIdx.add(normName.getNormName(), id);
        this.updnIdx.add(normName.getName(), id);
        this.oneLevelIdx.add(parentId, id);
        EntryAttribute entryCsn = entry.get("entryCSN");
        if (entryCsn == null) {
            String msg = I18n.err(I18n.ERR_219, normName.getName(), entry);
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, msg);
        }
        this.entryCsnIdx.add(entryCsn.getString(), id);
        EntryAttribute entryUuid = entry.get("entryUUID");
        if (entryUuid == null) {
            String msg = I18n.err(I18n.ERR_220, normName.getName(), entry);
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, msg);
        }
        this.entryUuidIdx.add(entryUuid.getString(), id);
        Long tempId = parentId;
        while (tempId != null && tempId != 0L && tempId != 1L) {
            this.subLevelIdx.add(tempId, id);
            tempId = this.getParentId(tempId);
        }
        this.subLevelIdx.add(id, id);
        for (EntryAttribute attribute : entry) {
            String attributeOid = attribute.getAttributeType().getOid();
            if (!this.hasUserIndexOn(attributeOid)) continue;
            Index<Object, E, Long> idx = this.getUserIndex(attributeOid);
            for (Value value : attribute) {
                idx.add(value.get(), (Object)id);
            }
            this.existenceIdx.add(attributeOid, id);
        }
        this.master.put(id, entry);
    }

    public void addIndex(Index<? extends Object, E, Long> index) throws Exception {
        if (index instanceof AvlIndex) {
            this.userIndices.put(index.getAttributeId(), (AvlIndex)index);
        } else {
            this.userIndices.put(index.getAttributeId(), this.convert(index));
        }
    }

    public int count() throws Exception {
        return this.master.count();
    }

    public void delete(Long id) throws Exception {
        ServerEntry entry = this.lookup(id);
        Long parentId = this.getParentId(id);
        EntryAttribute objectClass = entry.get(OBJECT_CLASS_AT);
        if (objectClass.contains("alias")) {
            this.dropAliasIndices(id);
        }
        for (Value value : objectClass) {
            this.objectClassIdx.drop(value.getString(), id);
        }
        this.ndnIdx.drop(id);
        this.updnIdx.drop(id);
        this.oneLevelIdx.drop(id);
        this.entryCsnIdx.drop(id);
        this.entryUuidIdx.drop(id);
        if (id != 1L) {
            this.subLevelIdx.drop(id);
        }
        if (!parentId.equals(0L)) {
            this.oneLevelIdx.drop(parentId, id);
        }
        for (EntryAttribute attribute : entry) {
            String attributeOid = attribute.getAttributeType().getOid();
            if (!this.hasUserIndexOn(attributeOid)) continue;
            Index<Object, E, Long> index = this.getUserIndex(attributeOid);
            for (Value value : attribute) {
                ((AvlIndex)index).drop(value.get(), id);
            }
            this.existenceIdx.drop(attributeOid, id);
        }
        this.master.delete(id);
    }

    public void destroy() throws Exception {
    }

    public Index<String, E, Long> getAliasIndex() {
        return this.aliasIdx;
    }

    public int getChildCount(Long id) throws Exception {
        return this.oneLevelIdx.count(id);
    }

    public String getEntryDn(Long id) throws Exception {
        return this.ndnIdx.reverseLookup(id);
    }

    public Long getEntryId(String dn) throws Exception {
        return this.ndnIdx.forwardLookup((Object)dn);
    }

    public String getEntryUpdn(Long id) throws Exception {
        return this.updnIdx.reverseLookup(id);
    }

    public String getEntryUpdn(String dn) throws Exception {
        Object id = this.ndnIdx.forwardLookup((Object)dn);
        return this.updnIdx.reverseLookup((Long)id);
    }

    public String getName() {
        return this.name;
    }

    public Index<String, E, Long> getNdnIndex() {
        return this.ndnIdx;
    }

    public Index<Long, E, Long> getOneAliasIndex() {
        return this.oneAliasIdx;
    }

    public Index<Long, E, Long> getOneLevelIndex() {
        return this.oneLevelIdx;
    }

    public Long getParentId(String dn) throws Exception {
        Object childId = this.ndnIdx.forwardLookup((Object)dn);
        return this.oneLevelIdx.reverseLookup((Long)childId);
    }

    public Long getParentId(Long childId) throws Exception {
        return this.oneLevelIdx.reverseLookup(childId);
    }

    public Index<String, E, Long> getPresenceIndex() {
        return this.existenceIdx;
    }

    public String getProperty(String propertyName) throws Exception {
        return this.master.getProperty(propertyName);
    }

    public Index<Long, E, Long> getSubAliasIndex() {
        return this.subAliasIdx;
    }

    public Index<Long, E, Long> getSubLevelIndex() {
        return this.subLevelIdx;
    }

    public DN getSuffix() {
        if (this.suffixDn == null) {
            return null;
        }
        try {
            return new DN(this.suffixDn.getNormName());
        }
        catch (LdapInvalidDnException e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }

    public DN getUpSuffix() {
        if (this.suffixDn == null) {
            return null;
        }
        try {
            return new DN(this.suffixDn.getName());
        }
        catch (LdapInvalidDnException e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }

    public String getSuffixDn() {
        if (this.suffixDn == null) {
            return null;
        }
        return this.suffixDn.getName();
    }

    public Index<?, E, Long> getSystemIndex(String id) throws IndexNotFoundException {
        try {
            id = this.schemaManager.getAttributeTypeRegistry().getOidByName(id);
        }
        catch (LdapException e) {
            LOG.error(I18n.err(I18n.ERR_1, id), (Object)e.getLocalizedMessage());
            throw new IndexNotFoundException(I18n.err(I18n.ERR_1, id), id, (Throwable)e);
        }
        if (this.systemIndices.containsKey(id)) {
            return this.systemIndices.get(id);
        }
        throw new IndexNotFoundException(I18n.err(I18n.ERR_2, id, this.name));
    }

    public Index<?, E, Long> getIndex(String id) throws IndexNotFoundException {
        try {
            id = this.schemaManager.getAttributeTypeRegistry().getOidByName(id);
        }
        catch (LdapException e) {
            LOG.error(I18n.err(I18n.ERR_1, id), (Object)e.getLocalizedMessage());
            throw new IndexNotFoundException(I18n.err(I18n.ERR_1, id), id, (Throwable)e);
        }
        if (this.userIndices.containsKey(id)) {
            return this.userIndices.get(id);
        }
        if (this.systemIndices.containsKey(id)) {
            return this.systemIndices.get(id);
        }
        throw new IndexNotFoundException(I18n.err(I18n.ERR_2, id, this.name));
    }

    public Index<String, E, Long> getUpdnIndex() {
        return this.updnIdx;
    }

    public Index<? extends Object, E, Long> getUserIndex(String id) throws IndexNotFoundException {
        try {
            id = this.schemaManager.getAttributeTypeRegistry().getOidByName(id);
        }
        catch (LdapException e) {
            LOG.error(I18n.err(I18n.ERR_1, id), (Object)e.getLocalizedMessage());
            throw new IndexNotFoundException(I18n.err(I18n.ERR_1, id), id, (Throwable)e);
        }
        if (this.userIndices.containsKey(id)) {
            return this.userIndices.get(id);
        }
        throw new IndexNotFoundException(I18n.err(I18n.ERR_3, id, this.name));
    }

    public Set<Index<? extends Object, E, Long>> getUserIndices() {
        return new HashSet<Index<? extends Object, E, Long>>(this.userIndices.values());
    }

    public boolean hasIndexOn(String id) throws Exception {
        return this.hasUserIndexOn(id) || this.hasSystemIndexOn(id);
    }

    public boolean hasSystemIndexOn(String id) throws Exception {
        return this.systemIndices.containsKey(id);
    }

    public boolean hasUserIndexOn(String id) throws Exception {
        return this.userIndices.containsKey(id);
    }

    public void init(SchemaManager schemaManager) throws Exception {
        this.schemaManager = schemaManager;
        OBJECT_CLASS_AT = schemaManager.lookupAttributeTypeRegistry("objectClass");
        ALIASED_OBJECT_NAME_AT = schemaManager.lookupAttributeTypeRegistry("aliasedObjectName");
        this.master = new AvlMasterTable(this.name, new LongComparator(), null, false);
        this.suffixDn.normalize(schemaManager.getNormalizerMapping());
        this.setupSystemIndices();
        this.setupUserIndices();
        this.initialized = true;
    }

    private void setupSystemIndices() throws Exception {
        AttributeType attributeType;
        if (this.ndnIdx == null) {
            attributeType = this.schemaManager.lookupAttributeTypeRegistry("1.3.6.1.4.1.18060.0.4.1.2.1");
            this.ndnIdx = new AvlIndex();
            this.ndnIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.1");
            this.ndnIdx.initialize(attributeType);
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.1", this.ndnIdx);
        }
        if (this.updnIdx == null) {
            attributeType = this.schemaManager.lookupAttributeTypeRegistry("1.3.6.1.4.1.18060.0.4.1.2.2");
            this.updnIdx = new AvlIndex();
            this.updnIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.2");
            this.updnIdx.initialize(attributeType);
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.2", this.updnIdx);
        }
        if (this.existenceIdx == null) {
            attributeType = this.schemaManager.lookupAttributeTypeRegistry("1.3.6.1.4.1.18060.0.4.1.2.3");
            this.existenceIdx = new AvlIndex();
            this.existenceIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.3");
            this.existenceIdx.initialize(attributeType);
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.3", this.existenceIdx);
        }
        if (this.oneLevelIdx == null) {
            attributeType = this.schemaManager.lookupAttributeTypeRegistry("1.3.6.1.4.1.18060.0.4.1.2.4");
            this.oneLevelIdx = new AvlIndex();
            this.oneLevelIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.4");
            this.oneLevelIdx.initialize(attributeType);
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.4", this.oneLevelIdx);
        }
        if (this.oneAliasIdx == null) {
            attributeType = this.schemaManager.lookupAttributeTypeRegistry("1.3.6.1.4.1.18060.0.4.1.2.5");
            this.oneAliasIdx = new AvlIndex();
            this.oneAliasIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.5");
            this.oneAliasIdx.initialize(attributeType);
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.5", this.oneAliasIdx);
        }
        if (this.subAliasIdx == null) {
            attributeType = this.schemaManager.lookupAttributeTypeRegistry("1.3.6.1.4.1.18060.0.4.1.2.6");
            this.subAliasIdx = new AvlIndex();
            this.subAliasIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.6");
            this.subAliasIdx.initialize(attributeType);
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.6", this.subAliasIdx);
        }
        if (this.aliasIdx == null) {
            attributeType = this.schemaManager.lookupAttributeTypeRegistry("1.3.6.1.4.1.18060.0.4.1.2.7");
            this.aliasIdx = new AvlIndex();
            this.aliasIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.7");
            this.aliasIdx.initialize(attributeType);
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.7", this.aliasIdx);
        }
        if (this.subLevelIdx == null) {
            attributeType = this.schemaManager.lookupAttributeTypeRegistry("1.3.6.1.4.1.18060.0.4.1.2.43");
            this.subLevelIdx = new AvlIndex();
            this.subLevelIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.43");
            this.subLevelIdx.initialize(attributeType);
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.43", this.subLevelIdx);
        }
        if (this.entryCsnIdx == null) {
            attributeType = this.schemaManager.lookupAttributeTypeRegistry("1.3.6.1.4.1.4203.666.1.7");
            this.entryCsnIdx = new AvlIndex();
            this.entryCsnIdx.setAttributeId("1.3.6.1.4.1.4203.666.1.7");
            this.entryCsnIdx.initialize(attributeType);
            this.systemIndices.put("1.3.6.1.4.1.4203.666.1.7", this.entryCsnIdx);
        }
        if (this.entryUuidIdx == null) {
            attributeType = this.schemaManager.lookupAttributeTypeRegistry("1.3.6.1.1.16.4");
            this.entryUuidIdx = new AvlIndex();
            this.entryUuidIdx.setAttributeId("1.3.6.1.1.16.4");
            this.entryUuidIdx.initialize(attributeType);
            this.systemIndices.put("1.3.6.1.1.16.4", this.entryUuidIdx);
        }
        if (this.objectClassIdx == null) {
            attributeType = this.schemaManager.lookupAttributeTypeRegistry("2.5.4.0");
            this.objectClassIdx = new AvlIndex();
            this.objectClassIdx.setAttributeId("2.5.4.0");
            this.objectClassIdx.initialize(attributeType);
            this.systemIndices.put("2.5.4.0", this.objectClassIdx);
        }
    }

    private void setupUserIndices() throws Exception {
        if (this.userIndices != null && this.userIndices.size() > 0) {
            HashMap<String, AvlIndex<Object, E>> tmp = new HashMap<String, AvlIndex<Object, E>>();
            for (AvlIndex<Object, E> index : this.userIndices.values()) {
                String oid = this.schemaManager.getAttributeTypeRegistry().getOidByName(index.getAttributeId());
                AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(oid);
                MatchingRule mr = attributeType.getEquality();
                if (mr != null) {
                    index.initialize(this.schemaManager.lookupAttributeTypeRegistry(oid));
                    tmp.put(oid, index);
                    continue;
                }
                LOG.error(I18n.err(I18n.ERR_4, attributeType.getName()));
            }
            this.userIndices = tmp;
        } else {
            this.userIndices = new HashMap<String, AvlIndex<? extends Object, E>>();
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public IndexCursor<Long, E, Long> list(Long id) throws Exception {
        IndexCursor<Long, E, Long> cursor = this.oneLevelIdx.forwardCursor(id);
        cursor.beforeValue((Object)id, null);
        return cursor;
    }

    public ServerEntry lookup(Long id) throws Exception {
        return (ServerEntry)this.master.get(id);
    }

    private void modifyDn(Long id, DN updn, boolean isMove) throws Exception {
        String aliasTarget;
        this.ndnIdx.drop(id);
        if (!updn.isNormalized()) {
            updn.normalize(this.schemaManager.getNormalizerMapping());
        }
        this.ndnIdx.add(updn.getNormName(), id);
        this.updnIdx.drop(id);
        this.updnIdx.add(updn.getName(), id);
        if (isMove && null != (aliasTarget = this.aliasIdx.reverseLookup(id))) {
            this.addAliasIndices(id, new DN(this.getEntryDn(id)), aliasTarget);
        }
        IndexCursor<Long, E, Long> children = this.list(id);
        while (children.next()) {
            IndexEntry rec = (IndexEntry)children.get();
            Long childId = (Long)rec.getId();
            DN childUpdn = (DN)updn.clone();
            DN oldUpdn = new DN(this.getEntryUpdn(childId));
            String rdn = oldUpdn.get(oldUpdn.size() - 1);
            DN rdnDN = new DN(rdn);
            rdnDN.normalize(this.schemaManager.getNormalizerMapping());
            childUpdn.add(rdnDN.getRdn());
            ServerEntry entry = this.lookup(childId);
            entry.setDn(childUpdn);
            this.master.put(childId, entry);
            this.modifyDn(childId, childUpdn, isMove);
        }
        children.close();
    }

    private void add(Long id, ServerEntry entry, EntryAttribute mods) throws Exception {
        if (entry instanceof ClonedServerEntry) {
            throw new Exception(I18n.err(I18n.ERR_215, new Object[0]));
        }
        String modsOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mods.getId());
        if (modsOid.equals("2.5.4.0")) {
            for (Value value : mods) {
                this.objectClassIdx.drop(value.getString(), id);
            }
        } else if (this.hasUserIndexOn(modsOid)) {
            Index<Object, E, Long> index = this.getUserIndex(modsOid);
            for (Value value : mods) {
                ((AvlIndex)index).add(value.get(), id);
            }
            if (!this.existenceIdx.forward(modsOid, id)) {
                this.existenceIdx.add(modsOid, id);
            }
        }
        AttributeType type = this.schemaManager.lookupAttributeTypeRegistry(modsOid);
        for (Value value : mods) {
            entry.add(type, value);
        }
        if (modsOid.equals("2.5.4.1")) {
            String ndnStr = this.ndnIdx.reverseLookup(id);
            this.addAliasIndices(id, new DN(ndnStr), mods.getString());
        }
    }

    private void remove(Long id, ServerEntry entry, EntryAttribute mods) throws Exception {
        if (entry instanceof ClonedServerEntry) {
            throw new Exception(I18n.err(I18n.ERR_215, new Object[0]));
        }
        String modsOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mods.getId());
        if (modsOid.equals("2.5.4.0")) {
            for (Value value : mods) {
                this.objectClassIdx.drop(value.getString(), id);
            }
        } else if (this.hasUserIndexOn(modsOid)) {
            Index<Object, E, Long> index = this.getUserIndex(modsOid);
            for (Value value : mods) {
                ((AvlIndex)index).drop(value.get(), id);
            }
            if (null == index.reverseLookup((Object)id)) {
                this.existenceIdx.drop(modsOid, id);
            }
        }
        AttributeType attrType = this.schemaManager.lookupAttributeTypeRegistry(modsOid);
        if (mods.size() == 0) {
            entry.removeAttributes(attrType);
        } else {
            EntryAttribute entryAttr = entry.get(attrType);
            for (Value value : mods) {
                if (value instanceof StringValue) {
                    entryAttr.remove((String)value.get());
                    continue;
                }
                entryAttr.remove(new byte[][]{(byte[])value.get()});
            }
            if (entryAttr.size() == 0) {
                entry.removeAttributes(entryAttr.getId());
            }
        }
        if (modsOid.equals("2.5.4.1")) {
            this.dropAliasIndices(id);
        }
    }

    private void replace(Long id, ServerEntry entry, EntryAttribute mods) throws Exception {
        String aliasAttributeOid;
        if (entry instanceof ClonedServerEntry) {
            throw new Exception(I18n.err(I18n.ERR_215, new Object[0]));
        }
        String modsOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mods.getId());
        if (modsOid.equals("2.5.4.0")) {
            if (this.objectClassIdx.reverse(id)) {
                this.objectClassIdx.drop(id);
            }
            for (Value value : mods) {
                this.objectClassIdx.add(value.getString(), id);
            }
        } else if (this.hasUserIndexOn(modsOid)) {
            Index<Object, E, Long> index = this.getUserIndex(modsOid);
            if (index.reverse((Object)id)) {
                ((AvlIndex)index).drop(id);
            }
            for (Value value : mods) {
                ((AvlIndex)index).add(value.get(), id);
            }
            if (null == index.reverseLookup((Object)id)) {
                this.existenceIdx.drop(modsOid, id);
            }
        }
        if (modsOid.equals(aliasAttributeOid = "2.5.4.1")) {
            this.dropAliasIndices(id);
        }
        if (mods.size() > 0) {
            entry.put(mods);
        } else {
            entry.remove(mods);
        }
        if (modsOid.equals(aliasAttributeOid) && mods.size() > 0) {
            String ndnStr = this.ndnIdx.reverseLookup(id);
            this.addAliasIndices(id, new DN(ndnStr), mods.getString());
        }
    }

    public void modify(DN dn, ModificationOperation modOp, ServerEntry mods) throws Exception {
        if (mods instanceof ClonedServerEntry) {
            throw new Exception(I18n.err(I18n.ERR_215, new Object[0]));
        }
        Long id = this.getEntryId(dn.getNormName());
        ServerEntry entry = (ServerEntry)this.master.get(id);
        block5: for (AttributeType attributeType : mods.getAttributeTypes()) {
            EntryAttribute attr = mods.get(attributeType);
            switch (modOp) {
                case ADD_ATTRIBUTE: {
                    this.add(id, entry, attr);
                    continue block5;
                }
                case REMOVE_ATTRIBUTE: {
                    this.remove(id, entry, attr);
                    continue block5;
                }
                case REPLACE_ATTRIBUTE: {
                    this.replace(id, entry, attr);
                    continue block5;
                }
            }
            throw new Exception(I18n.err(I18n.ERR_221, new Object[0]));
        }
        this.master.put(id, entry);
    }

    public void modify(DN dn, List<Modification> mods) throws Exception {
        Long id = this.getEntryId(dn.getNormName());
        this.modify(id, mods);
    }

    public void modify(long entryId, List<Modification> mods) throws Exception {
        ServerEntry entry = (ServerEntry)this.master.get(entryId);
        block5: for (Modification mod : mods) {
            EntryAttribute attrMods = mod.getAttribute();
            switch (mod.getOperation()) {
                case ADD_ATTRIBUTE: {
                    this.add(entryId, entry, attrMods);
                    continue block5;
                }
                case REMOVE_ATTRIBUTE: {
                    this.remove(entryId, entry, attrMods);
                    continue block5;
                }
                case REPLACE_ATTRIBUTE: {
                    this.replace(entryId, entry, attrMods);
                    continue block5;
                }
            }
            throw new Exception(I18n.err(I18n.ERR_221, new Object[0]));
        }
        this.master.put(entryId, entry);
    }

    public void move(DN oldChildDn, DN newParentDn, RDN newRdn, boolean deleteOldRdn) throws Exception {
        Long childId = this.getEntryId(oldChildDn.getNormName());
        this.rename(oldChildDn, newRdn, deleteOldRdn);
        DN newUpdn = this.move(oldChildDn, childId, newParentDn);
        ServerEntry entry = this.lookup(childId);
        entry.setDn(newUpdn);
        this.master.put(childId, entry);
    }

    public void move(DN oldChildDn, DN newParentDn) throws Exception {
        Long childId = this.getEntryId(oldChildDn.getNormName());
        DN newUpdn = this.move(oldChildDn, childId, newParentDn);
        ServerEntry entry = this.lookup(childId);
        entry.setDn(newUpdn);
        this.master.put(childId, entry);
    }

    private DN move(DN oldChildDn, Long childId, DN newParentDn) throws Exception {
        Long newParentId = this.getEntryId(newParentDn.getNormName());
        Long oldParentId = this.getParentId(childId);
        this.dropMovedAliasIndices(oldChildDn);
        this.oneLevelIdx.drop(oldParentId, childId);
        this.oneLevelIdx.add(newParentId, childId);
        this.updateSubLevelIndex(childId, oldParentId, newParentId);
        DN childUpdn = new DN(this.getEntryUpdn(childId));
        String childRdn = childUpdn.get(childUpdn.size() - 1);
        DN newUpdn = new DN(this.getEntryUpdn(newParentId));
        newUpdn.add(newUpdn.size(), childRdn);
        this.modifyDn(childId, newUpdn, true);
        return newUpdn;
    }

    public void rename(DN dn, RDN newRdn, boolean deleteOldRdn) throws Exception {
        Long id = this.getEntryId(dn.getNormName());
        ServerEntry entry = this.lookup(id);
        DN updn = entry.getDn();
        for (AVA newAtav : newRdn) {
            String newNormType = newAtav.getNormType();
            Object newNormValue = newAtav.getNormValue().get();
            AttributeType newRdnAttrType = this.schemaManager.lookupAttributeTypeRegistry(newNormType);
            entry.add(newRdnAttrType, newAtav.getUpValue());
            if (!this.hasUserIndexOn(newNormType)) continue;
            Index<Object, E, Long> index = this.getUserIndex(newNormType);
            index.add(newNormValue, (Object)id);
            if (this.existenceIdx.forward(newNormType, id)) continue;
            this.existenceIdx.add(newNormType, id);
        }
        if (deleteOldRdn) {
            RDN oldRdn = updn.getRdn();
            for (AVA oldAtav : oldRdn) {
                boolean mustRemove = true;
                for (AVA newAtav : newRdn) {
                    if (!oldAtav.equals(newAtav)) continue;
                    mustRemove = false;
                    break;
                }
                if (!mustRemove) continue;
                String oldNormType = oldAtav.getNormType();
                String oldNormValue = oldAtav.getNormValue().getString();
                AttributeType oldRdnAttrType = this.schemaManager.lookupAttributeTypeRegistry(oldNormType);
                entry.remove(oldRdnAttrType, oldNormValue);
                if (!this.hasUserIndexOn(oldNormType)) continue;
                Index<Object, E, Long> index = this.getUserIndex(oldNormType);
                ((AvlIndex)index).drop(oldNormValue, id);
                if (null != index.reverseLookup((Object)id)) continue;
                this.existenceIdx.drop(oldNormType, id);
            }
        }
        DN newUpdn = (DN)updn.clone();
        newUpdn.remove(newUpdn.size() - 1);
        newUpdn.add(newRdn.getName());
        newUpdn.normalize(this.schemaManager.getNormalizerMapping());
        this.modifyDn(id, newUpdn, false);
        entry.setDn(newUpdn);
        this.master.put(id, entry);
    }

    public void setAliasIndex(Index<String, E, Long> index) throws Exception {
        this.protect("aliasIndex");
        this.aliasIdx = index instanceof AvlIndex ? (AvlIndex<Object, Object>)index : this.convert(index);
        this.systemIndices.put(index.getAttributeId(), this.aliasIdx);
    }

    public void setName(String name) {
        this.protect("name");
        this.name = name;
    }

    public void setNdnIndex(Index<String, E, Long> index) throws Exception {
        this.protect("ndnIndex");
        this.ndnIdx = index instanceof AvlIndex ? (AvlIndex<Object, Object>)index : this.convert(index);
        this.systemIndices.put(index.getAttributeId(), this.ndnIdx);
    }

    public void setOneAliasIndex(Index<Long, E, Long> index) throws Exception {
        this.protect("oneAliasIndex");
        this.oneAliasIdx = index instanceof AvlIndex ? (AvlIndex<Object, Object>)index : this.convert(index);
        this.systemIndices.put(index.getAttributeId(), this.oneAliasIdx);
    }

    public void setOneLevelIndex(Index<Long, E, Long> index) throws Exception {
        this.protect("oneLevelIndex");
        this.oneLevelIdx = index instanceof AvlIndex ? (AvlIndex<Object, Object>)index : this.convert(index);
        this.systemIndices.put(index.getAttributeId(), this.oneLevelIdx);
    }

    public void setPresenceIndex(Index<String, E, Long> index) throws Exception {
        this.protect("presenceIndex");
        this.existenceIdx = index instanceof AvlIndex ? (AvlIndex<Object, Object>)index : this.convert(index);
        this.systemIndices.put(index.getAttributeId(), this.existenceIdx);
    }

    public void setProperty(String propertyName, String propertyValue) throws Exception {
        this.master.setProperty(propertyName, propertyValue);
    }

    public void setSubAliasIndex(Index<Long, E, Long> index) throws Exception {
        this.protect("subAliasIndex");
        this.subAliasIdx = index instanceof AvlIndex ? (AvlIndex<Object, Object>)index : this.convert(index);
        this.systemIndices.put(index.getAttributeId(), this.subAliasIdx);
    }

    public void setSubLevelIndex(Index<Long, E, Long> index) throws Exception {
        this.protect("subLevelIndex");
        this.subLevelIdx = index instanceof AvlIndex ? (AvlIndex<Object, Object>)index : this.convert(index);
        this.systemIndices.put(index.getAttributeId(), this.subLevelIdx);
    }

    public void setSuffixDn(String suffixDn) {
        this.protect("suffixDn");
        try {
            this.suffixDn = new DN(suffixDn);
        }
        catch (LdapInvalidDnException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setUpdnIndex(Index<String, E, Long> index) throws Exception {
        this.protect("updnIndex");
        this.updnIdx = index instanceof AvlIndex ? (AvlIndex<Object, Object>)index : this.convert(index);
        this.systemIndices.put(index.getAttributeId(), this.updnIdx);
    }

    public void setUserIndices(Set<Index<? extends Object, E, Long>> userIndices) {
        this.protect("setUserIndices");
        for (Index<Object, E, Long> index : userIndices) {
            if (index instanceof AvlIndex) {
                this.userIndices.put(index.getAttributeId(), (AvlIndex)index);
                continue;
            }
            LOG.warn("Supplied index {} is not a AvlIndex.  Will create new AvlIndex using copied configuration parameters.", index);
            AvlIndex<Object, E> avlIndex = this.convert(index);
            this.userIndices.put(index.getAttributeId(), avlIndex);
        }
    }

    private <K> AvlIndex<K, E> convert(Index<K, E, Long> index) {
        AvlIndex avlIndex = new AvlIndex();
        avlIndex.setAttributeId(index.getAttributeId());
        return avlIndex;
    }

    private void protect(String method) {
        if (this.initialized) {
            throw new IllegalStateException(I18n.err(I18n.ERR_222, method));
        }
    }

    public Iterator<String> systemIndices() {
        return this.systemIndices.keySet().iterator();
    }

    public Iterator<String> userIndices() {
        return this.userIndices.keySet().iterator();
    }

    private void addAliasIndices(Long aliasId, DN aliasDn, String aliasTarget) throws Exception {
        DN normalizedAliasTargetDn = new DN(aliasTarget);
        normalizedAliasTargetDn.normalize(this.schemaManager.getNormalizerMapping());
        if (aliasDn.isChildOf(normalizedAliasTargetDn)) {
            if (aliasDn.equals(normalizedAliasTargetDn)) {
                throw new Exception(I18n.err(I18n.ERR_223, new Object[0]));
            }
            throw new Exception(I18n.err(I18n.ERR_224, aliasTarget, aliasDn));
        }
        if (!normalizedAliasTargetDn.isChildOf(this.suffixDn)) {
            throw new Exception(I18n.err(I18n.ERR_225, this.suffixDn.getName()));
        }
        Object targetId = this.ndnIdx.forwardLookup((Object)normalizedAliasTargetDn.getNormName());
        if (null == targetId) {
            throw new Exception(I18n.err(I18n.ERR_226, new Object[0]));
        }
        if (null != this.aliasIdx.reverseLookup((Long)targetId)) {
            throw new Exception(I18n.err(I18n.ERR_227, new Object[0]));
        }
        this.aliasIdx.add(normalizedAliasTargetDn.getNormName(), aliasId);
        DN ancestorDn = (DN)aliasDn.clone();
        ancestorDn.remove(aliasDn.size() - 1);
        Long ancestorId = this.getEntryId(ancestorDn.getNormName());
        DN normalizedAliasTargetParentDn = (DN)normalizedAliasTargetDn.clone();
        normalizedAliasTargetParentDn.remove(normalizedAliasTargetDn.size() - 1);
        if (!aliasDn.isChildOf(normalizedAliasTargetParentDn)) {
            this.oneAliasIdx.add(ancestorId, (Long)targetId);
        }
        while (!ancestorDn.equals(this.suffixDn) && null != ancestorId) {
            if (!NamespaceTools.isDescendant(ancestorDn, normalizedAliasTargetDn)) {
                this.subAliasIdx.add(ancestorId, (Long)targetId);
            }
            ancestorDn.remove(ancestorDn.size() - 1);
            ancestorId = this.getEntryId(ancestorDn.getNormName());
        }
    }

    private void dropAliasIndices(Long aliasId) throws Exception {
        String targetDn = this.aliasIdx.reverseLookup(aliasId);
        Long targetId = this.getEntryId(targetDn);
        String aliasDn = this.getEntryDn(aliasId);
        DN aliasDN = new DN(aliasDn);
        DN ancestorDn = (DN)aliasDN.clone();
        ancestorDn.remove(aliasDN.size() - 1);
        Long ancestorId = this.getEntryId(ancestorDn.getNormName());
        this.oneAliasIdx.drop(ancestorId, targetId);
        this.subAliasIdx.drop(ancestorId, targetId);
        while (!ancestorDn.equals(this.suffixDn) && ancestorDn.size() > this.suffixDn.size()) {
            ancestorDn = ancestorDn.getPrefix(ancestorDn.size() - 1);
            ancestorId = this.getEntryId(ancestorDn.getNormName());
            this.subAliasIdx.drop(ancestorId, targetId);
        }
        this.aliasIdx.drop(aliasId);
    }

    private void updateSubLevelIndex(Long childId, Long oldParentId, Long newParentId) throws Exception {
        Long tempId = oldParentId;
        ArrayList<Long> parentIds = new ArrayList<Long>();
        while (tempId != 0L && tempId != 1L && tempId != null) {
            parentIds.add(tempId);
            tempId = this.getParentId(tempId);
        }
        IndexCursor<Long, E, Long> cursor = this.subLevelIdx.forwardCursor(childId);
        ArrayList<Object> childIds = new ArrayList<Object>();
        childIds.add(childId);
        while (cursor.next()) {
            childIds.add(((IndexEntry)cursor.get()).getId());
        }
        for (Long pid : parentIds) {
            for (Long l : childIds) {
                this.subLevelIdx.drop(pid, l);
            }
        }
        parentIds.clear();
        tempId = newParentId;
        while (tempId != 0L && tempId != 1L && tempId != null) {
            parentIds.add(tempId);
            tempId = this.getParentId(tempId);
        }
        for (Long id : parentIds) {
            for (Long l : childIds) {
                this.subLevelIdx.add(id, l);
            }
        }
    }

    private void dropMovedAliasIndices(DN movedBase) throws Exception {
        Long movedBaseId = this.getEntryId(movedBase.getNormName());
        if (this.aliasIdx.reverseLookup(movedBaseId) != null) {
            this.dropAliasIndices(movedBaseId, movedBase);
        }
    }

    private void dropAliasIndices(Long aliasId, DN movedBase) throws Exception {
        String targetDn = this.aliasIdx.reverseLookup(aliasId);
        Long targetId = this.getEntryId(targetDn);
        String aliasDn = this.getEntryDn(aliasId);
        DN ancestorDn = movedBase.getPrefix(1);
        Long ancestorId = this.getEntryId(ancestorDn.getNormName());
        if (aliasDn.equals(movedBase.toString())) {
            this.oneAliasIdx.drop(ancestorId, targetId);
        }
        this.subAliasIdx.drop(ancestorId, targetId);
        while (!ancestorDn.equals(this.suffixDn)) {
            ancestorDn = ancestorDn.getPrefix(1);
            ancestorId = this.getEntryId(ancestorDn.getNormName());
            this.subAliasIdx.drop(ancestorId, targetId);
        }
    }

    public int getCacheSize() {
        return 0;
    }

    public Index<String, E, Long> getEntryCsnIndex() {
        return this.entryCsnIdx;
    }

    public Index<String, E, Long> getEntryUuidIndex() {
        return this.entryUuidIdx;
    }

    public Index<String, E, Long> getObjectClassIndex() {
        return this.objectClassIdx;
    }

    public void setEntryCsnIndex(Index<String, E, Long> index) throws Exception {
        this.protect("entryCsnIndex");
        this.entryCsnIdx = index instanceof AvlIndex ? (AvlIndex<Object, Object>)index : this.convert(index);
        this.systemIndices.put(index.getAttributeId(), this.entryCsnIdx);
    }

    public void setSyncOnWrite(boolean sync) {
    }

    public void setWorkingDirectory(File wkDir) {
    }

    public File getWorkingDirectory() {
        return null;
    }

    public boolean isSyncOnWrite() {
        return false;
    }

    public void setCacheSize(int size) {
    }

    public void setObjectClassIndex(Index<String, E, Long> index) {
        this.protect("objectClassIndex");
        this.objectClassIdx = index instanceof AvlIndex ? (AvlIndex<Object, Object>)index : this.convert(index);
        this.systemIndices.put(index.getAttributeId(), this.objectClassIdx);
    }

    public void setEntryUuidIndex(Index<String, E, Long> index) {
        this.protect("entryUuidIndex");
        this.entryUuidIdx = index instanceof AvlIndex ? (AvlIndex<Object, Object>)index : this.convert(index);
        this.systemIndices.put(index.getAttributeId(), this.entryUuidIdx);
    }

    public void sync() throws Exception {
    }

    public Long getDefaultId() {
        return 1L;
    }
}

