/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DefaultOperationManager;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.OperationManager;
import org.apache.directory.server.core.ReferralManager;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.authz.AciAuthorizationInterceptor;
import org.apache.directory.server.core.authz.DefaultAuthorizationInterceptor;
import org.apache.directory.server.core.changelog.ChangeLog;
import org.apache.directory.server.core.changelog.ChangeLogEvent;
import org.apache.directory.server.core.changelog.ChangeLogInterceptor;
import org.apache.directory.server.core.changelog.DefaultChangeLog;
import org.apache.directory.server.core.changelog.Tag;
import org.apache.directory.server.core.changelog.TaggableSearchableChangeLogStore;
import org.apache.directory.server.core.collective.CollectiveAttributeInterceptor;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.event.EventInterceptor;
import org.apache.directory.server.core.event.EventService;
import org.apache.directory.server.core.exception.ExceptionInterceptor;
import org.apache.directory.server.core.interceptor.Interceptor;
import org.apache.directory.server.core.interceptor.InterceptorChain;
import org.apache.directory.server.core.interceptor.context.AddContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.RemoveContextPartitionOperationContext;
import org.apache.directory.server.core.journal.DefaultJournal;
import org.apache.directory.server.core.journal.Journal;
import org.apache.directory.server.core.journal.JournalInterceptor;
import org.apache.directory.server.core.normalization.NormalizationInterceptor;
import org.apache.directory.server.core.operational.OperationalAttributeInterceptor;
import org.apache.directory.server.core.partition.DefaultPartitionNexus;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.referral.ReferralInterceptor;
import org.apache.directory.server.core.replication.ReplicationConfiguration;
import org.apache.directory.server.core.schema.DefaultSchemaService;
import org.apache.directory.server.core.schema.SchemaInterceptor;
import org.apache.directory.server.core.schema.SchemaService;
import org.apache.directory.server.core.security.TlsKeyGenerator;
import org.apache.directory.server.core.subtree.SubentryInterceptor;
import org.apache.directory.server.core.trigger.TriggerInterceptor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.csn.Csn;
import org.apache.directory.shared.ldap.csn.CsnFactory;
import org.apache.directory.shared.ldap.cursor.Cursor;
import org.apache.directory.shared.ldap.entry.DefaultServerEntry;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.DefaultClientEntry;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.normalizers.OidNormalizer;
import org.apache.directory.shared.ldap.util.DateUtils;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDirectoryService
implements DirectoryService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDirectoryService.class);
    private SchemaService schemaService;
    private SchemaManager schemaManager;
    private DefaultPartitionNexus partitionNexus;
    private boolean firstStart;
    private InterceptorChain interceptorChain;
    private boolean started;
    private ChangeLog changeLog;
    private Journal journal;
    private OperationManager operationManager = new DefaultOperationManager(this);
    private DN adminDn;
    private CoreSession adminSession;
    private ReferralManager referralManager;
    private boolean passwordHidden = false;
    private CsnFactory csnFactory;
    private int replicaId;
    private ReplicationConfiguration replicationConfig;
    private static final String PARTIAL_IMPL_WARNING = "WARNING: the changelog is only partially operational and will revert\nstate without consideration of who made the original change.  All reverting changes are made by the admin user.\n Furthermore the used controls are not at all taken into account";
    private long syncPeriodMillis;
    private static final long DEFAULT_SYNC_PERIOD = 15000L;
    private Thread workerThread;
    private SynchWorker worker = new SynchWorker();
    public static final int MAX_SIZE_LIMIT_DEFAULT = 100;
    public static final int MAX_TIME_LIMIT_DEFAULT = 10000;
    private String instanceId;
    private File workingDirectory = new File("server-work");
    private boolean exitVmOnShutdown = true;
    private boolean shutdownHookEnabled = true;
    private boolean allowAnonymousAccess = true;
    private boolean accessControlEnabled;
    private boolean denormalizeOpAttrsEnabled;
    private List<Interceptor> interceptors;
    private Partition systemPartition;
    private Set<Partition> partitions = new HashSet<Partition>();
    private List<? extends LdifEntry> testEntries = new ArrayList<LdifEntry>();
    private EventService eventService;
    private int maxPDUSize = Integer.MAX_VALUE;

    public DefaultDirectoryService() throws Exception {
        this.setDefaultInterceptorConfigurations();
        this.changeLog = new DefaultChangeLog();
        this.journal = new DefaultJournal();
        this.syncPeriodMillis = 15000L;
        this.csnFactory = new CsnFactory(this.replicaId);
        this.schemaService = new DefaultSchemaService();
    }

    @Override
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public Set<? extends Partition> getPartitions() {
        HashSet<Partition> cloned = new HashSet<Partition>();
        cloned.addAll(this.partitions);
        return cloned;
    }

    @Override
    public void setPartitions(Set<? extends Partition> partitions) {
        HashSet<Partition> cloned = new HashSet<Partition>();
        cloned.addAll(partitions);
        HashSet<String> names = new HashSet<String>();
        for (Partition partition : cloned) {
            String id = partition.getId();
            if (names.contains(id)) {
                LOG.warn("Encountered duplicate partition {} identifier.", (Object)id);
            }
            names.add(id);
        }
        this.partitions = cloned;
    }

    @Override
    public boolean isAccessControlEnabled() {
        return this.accessControlEnabled;
    }

    @Override
    public void setAccessControlEnabled(boolean accessControlEnabled) {
        this.accessControlEnabled = accessControlEnabled;
    }

    @Override
    public boolean isAllowAnonymousAccess() {
        return this.allowAnonymousAccess;
    }

    @Override
    public void setAllowAnonymousAccess(boolean enableAnonymousAccess) {
        this.allowAnonymousAccess = enableAnonymousAccess;
    }

    @Override
    public List<Interceptor> getInterceptors() {
        ArrayList<Interceptor> cloned = new ArrayList<Interceptor>();
        cloned.addAll(this.interceptors);
        return cloned;
    }

    @Override
    public void setInterceptors(List<Interceptor> interceptors) {
        HashSet<String> names = new HashSet<String>();
        for (Interceptor interceptor : interceptors) {
            String name = interceptor.getName();
            if (names.contains(name)) {
                LOG.warn("Encountered duplicate definitions for {} interceptor", (Object)interceptor.getName());
            }
            names.add(name);
        }
        this.interceptors = interceptors;
    }

    @Override
    public List<LdifEntry> getTestEntries() {
        ArrayList<LdifEntry> cloned = new ArrayList<LdifEntry>();
        cloned.addAll(this.testEntries);
        return cloned;
    }

    @Override
    public void setTestEntries(List<? extends LdifEntry> testEntries) {
        ArrayList<? extends LdifEntry> cloned = new ArrayList<LdifEntry>();
        cloned.addAll(testEntries);
        this.testEntries = testEntries;
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    public void setShutdownHookEnabled(boolean shutdownHookEnabled) {
        this.shutdownHookEnabled = shutdownHookEnabled;
    }

    @Override
    public boolean isShutdownHookEnabled() {
        return this.shutdownHookEnabled;
    }

    @Override
    public void setExitVmOnShutdown(boolean exitVmOnShutdown) {
        this.exitVmOnShutdown = exitVmOnShutdown;
    }

    @Override
    public boolean isExitVmOnShutdown() {
        return this.exitVmOnShutdown;
    }

    @Override
    public void setSystemPartition(Partition systemPartition) {
        this.systemPartition = systemPartition;
    }

    @Override
    public Partition getSystemPartition() {
        return this.systemPartition;
    }

    @Override
    public boolean isDenormalizeOpAttrsEnabled() {
        return this.denormalizeOpAttrsEnabled;
    }

    @Override
    public void setDenormalizeOpAttrsEnabled(boolean denormalizeOpAttrsEnabled) {
        this.denormalizeOpAttrsEnabled = denormalizeOpAttrsEnabled;
    }

    @Override
    public ChangeLog getChangeLog() {
        return this.changeLog;
    }

    @Override
    public Journal getJournal() {
        return this.journal;
    }

    @Override
    public void setChangeLog(ChangeLog changeLog) {
        this.changeLog = changeLog;
    }

    @Override
    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    @Override
    public void addPartition(Partition partition) throws Exception {
        partition.setSchemaManager(this.schemaManager);
        this.partitions.add(partition);
        if (!this.started) {
            return;
        }
        AddContextPartitionOperationContext addPartitionCtx = new AddContextPartitionOperationContext(this.adminSession, partition);
        this.partitionNexus.addContextPartition(addPartitionCtx);
    }

    @Override
    public void removePartition(Partition partition) throws Exception {
        this.partitions.remove(partition);
        if (!this.started) {
            return;
        }
        RemoveContextPartitionOperationContext removePartitionCtx = new RemoveContextPartitionOperationContext(this.adminSession, partition.getSuffixDn());
        this.partitionNexus.removeContextPartition(removePartitionCtx);
    }

    private void setDefaultInterceptorConfigurations() {
        ArrayList<Interceptor> list = new ArrayList<Interceptor>();
        list.add((Interceptor)new NormalizationInterceptor());
        list.add((Interceptor)new AuthenticationInterceptor());
        list.add((Interceptor)new ReferralInterceptor());
        list.add((Interceptor)new AciAuthorizationInterceptor());
        list.add((Interceptor)new DefaultAuthorizationInterceptor());
        list.add(new ExceptionInterceptor());
        list.add(new ChangeLogInterceptor());
        list.add((Interceptor)new OperationalAttributeInterceptor());
        list.add(new SchemaInterceptor());
        list.add((Interceptor)new SubentryInterceptor());
        list.add((Interceptor)new CollectiveAttributeInterceptor());
        list.add((Interceptor)new EventInterceptor());
        list.add((Interceptor)new TriggerInterceptor());
        list.add((Interceptor)new JournalInterceptor());
        this.setInterceptors(list);
    }

    @Override
    public CoreSession getAdminSession() {
        return this.adminSession;
    }

    @Override
    public CoreSession getSession() {
        return new DefaultCoreSession(new LdapPrincipal(), this);
    }

    @Override
    public CoreSession getSession(LdapPrincipal principal) {
        return new DefaultCoreSession(principal, this);
    }

    @Override
    public CoreSession getSession(DN principalDn, byte[] credentials) throws Exception {
        if (!this.started) {
            throw new IllegalStateException("Service has not started.");
        }
        BindOperationContext bindContext = new BindOperationContext(null);
        bindContext.setCredentials(credentials);
        bindContext.setDn(principalDn);
        this.operationManager.bind(bindContext);
        return bindContext.getSession();
    }

    @Override
    public CoreSession getSession(DN principalDn, byte[] credentials, String saslMechanism, String saslAuthId) throws Exception {
        if (!this.started) {
            throw new IllegalStateException("Service has not started.");
        }
        BindOperationContext bindContext = new BindOperationContext(null);
        bindContext.setCredentials(credentials);
        bindContext.setDn(principalDn);
        bindContext.setSaslMechanism(saslMechanism);
        this.operationManager.bind(bindContext);
        return bindContext.getSession();
    }

    @Override
    public long revert() throws Exception {
        if (this.changeLog == null || !this.changeLog.isEnabled()) {
            throw new IllegalStateException(I18n.err(I18n.ERR_310, new Object[0]));
        }
        Tag latest = this.changeLog.getLatest();
        if (null != latest) {
            if (latest.getRevision() < this.changeLog.getCurrentRevision()) {
                return this.revert(latest.getRevision());
            }
            LOG.info("Ignoring request to revert without changes since the latest tag.");
            return this.changeLog.getCurrentRevision();
        }
        throw new IllegalStateException(I18n.err(I18n.ERR_311, new Object[0]));
    }

    private void moddn(DN oldDn, DN newDn, boolean delOldRdn) throws Exception {
        if (oldDn.size() == 0) {
            throw new LdapNoPermissionException(I18n.err(I18n.ERR_312, new Object[0]));
        }
        DN oldBase = (DN)oldDn.clone();
        oldBase.remove(oldDn.size() - 1);
        DN newBase = (DN)newDn.clone();
        newBase.remove(newDn.size() - 1);
        RDN newRdn = newDn.getRdn(newDn.size() - 1);
        RDN oldRdn = oldDn.getRdn(oldDn.size() - 1);
        if (oldDn.size() == newDn.size() && oldBase.equals(newBase)) {
            this.adminSession.rename(oldDn, newRdn, delOldRdn);
        } else {
            DN target = (DN)newDn.clone();
            target.remove(newDn.size() - 1);
            if (newRdn.equals(oldRdn)) {
                this.adminSession.move(oldDn, target);
            } else {
                this.adminSession.moveAndRename(oldDn, target, new RDN(newRdn), delOldRdn);
            }
        }
    }

    @Override
    public long revert(long revision) throws Exception {
        if (this.changeLog == null || !this.changeLog.isEnabled()) {
            throw new IllegalStateException(I18n.err(I18n.ERR_310, new Object[0]));
        }
        if (revision < 0L) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_239, new Object[0]));
        }
        if (revision >= this.changeLog.getChangeLogStore().getCurrentRevision()) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_314, new Object[0]));
        }
        Cursor<ChangeLogEvent> cursor = this.changeLog.getChangeLogStore().findAfter(revision);
        try {
            LOG.warn(PARTIAL_IMPL_WARNING);
            cursor.afterLast();
            while (cursor.previous()) {
                ChangeLogEvent event = (ChangeLogEvent)cursor.get();
                List<LdifEntry> reverses = event.getReverseLdifs();
                block9: for (LdifEntry reverse : reverses) {
                    switch (reverse.getChangeType().getChangeType()) {
                        case 0: {
                            this.adminSession.add((ServerEntry)new DefaultServerEntry(this.schemaManager, reverse.getEntry()), true);
                            continue block9;
                        }
                        case 4: {
                            this.adminSession.delete(reverse.getDn(), true);
                            continue block9;
                        }
                        case 1: {
                            List mods = reverse.getModificationItems();
                            this.adminSession.modify(reverse.getDn(), (List<Modification>)mods, true);
                            continue block9;
                        }
                        case 2: 
                        case 3: {
                            DN forwardDn = event.getForwardLdif().getDn();
                            DN reverseDn = reverse.getDn();
                            this.moddn(reverseDn, forwardDn, reverse.isDeleteOldRdn());
                            continue block9;
                        }
                    }
                    LOG.error(I18n.err(I18n.ERR_75, new Object[0]));
                    throw new NotImplementedException(I18n.err(I18n.ERR_76, reverse.getChangeType()));
                }
            }
        }
        catch (IOException e) {
            String message = I18n.err(I18n.ERR_77, revision);
            LOG.error(message);
            throw new LdapException(message);
        }
        return this.changeLog.getCurrentRevision();
    }

    @Override
    public OperationManager getOperationManager() {
        return this.operationManager;
    }

    @Override
    public synchronized void startup() throws Exception {
        if (this.started) {
            return;
        }
        if (this.shutdownHookEnabled) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                public void run() {
                    try {
                        DefaultDirectoryService.this.shutdown();
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to shut down the directory service: " + DefaultDirectoryService.this.instanceId, (Throwable)e);
                    }
                }
            }, "ApacheDS Shutdown Hook (" + this.instanceId + ')'));
            LOG.info("ApacheDS shutdown hook has been registered with the runtime.");
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("ApacheDS shutdown hook has NOT been registered with the runtime.  This default setting for standalone operation has been overriden.");
        }
        this.initialize();
        this.showSecurityWarnings();
        if (this.syncPeriodMillis > 0L) {
            this.workerThread = new Thread((Runnable)this.worker, "SynchWorkerThread");
            this.workerThread.start();
        }
        this.started = true;
        if (!this.testEntries.isEmpty()) {
            this.createTestEntries();
        }
    }

    @Override
    public synchronized void sync() throws Exception {
        if (!this.started) {
            return;
        }
        this.changeLog.sync();
        this.partitionNexus.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() throws Exception {
        if (!this.started) {
            return;
        }
        this.changeLog.sync();
        this.changeLog.destroy();
        if (this.journal.isEnabled()) {
            this.journal.destroy();
        }
        this.partitionNexus.sync();
        this.partitionNexus.destroy();
        if (this.workerThread != null) {
            this.worker.stop = true;
            Object object = this.worker.lock;
            synchronized (object) {
                this.worker.lock.notify();
            }
            while (this.workerThread.isAlive()) {
                LOG.info("Waiting for SynchWorkerThread to die.");
                this.workerThread.join(500L);
            }
        }
        this.interceptorChain.destroy();
        this.started = false;
        this.setDefaultInterceptorConfigurations();
    }

    @Override
    public ReferralManager getReferralManager() {
        return this.referralManager;
    }

    @Override
    public void setReferralManager(ReferralManager referralManager) {
        this.referralManager = referralManager;
    }

    @Override
    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    @Override
    public SchemaService getSchemaService() {
        return this.schemaService;
    }

    @Override
    public void setSchemaService(SchemaService schemaService) {
        this.schemaService = schemaService;
    }

    @Override
    public DefaultPartitionNexus getPartitionNexus() {
        return this.partitionNexus;
    }

    @Override
    public InterceptorChain getInterceptorChain() {
        return this.interceptorChain;
    }

    public boolean isFirstStart() {
        return this.firstStart;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public ServerEntry newEntry(DN dn) {
        return new DefaultServerEntry(this.schemaManager, dn);
    }

    private boolean createBootstrapEntries() throws Exception {
        boolean firstStart = false;
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(this.adminSession, this.adminDn))) {
            firstStart = true;
            DefaultServerEntry serverEntry = new DefaultServerEntry(this.schemaManager, this.adminDn);
            serverEntry.put("objectClass", "top", "person", "organizationalPerson", "inetOrgPerson");
            serverEntry.put("uid", "admin");
            serverEntry.put("userPassword", (byte[][])new byte[][]{PartitionNexus.ADMIN_PASSWORD_BYTES});
            serverEntry.put("displayName", "Directory Superuser");
            serverEntry.put("cn", "system administrator");
            serverEntry.put("sn", "administrator");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.put("displayName", "Directory Superuser");
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", UUID.randomUUID().toString());
            TlsKeyGenerator.addKeyPair((ServerEntry)serverEntry);
            this.partitionNexus.add(new AddOperationContext(this.adminSession, (ServerEntry)serverEntry));
        }
        Map<String, OidNormalizer> oidsMap = this.schemaManager.getNormalizerMapping();
        DN userDn = new DN("ou=users,ou=system");
        userDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(this.adminSession, userDn))) {
            firstStart = true;
            DefaultServerEntry serverEntry = new DefaultServerEntry(this.schemaManager, userDn);
            serverEntry.put("objectClass", "top", "organizationalUnit");
            serverEntry.put("ou", "users");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", UUID.randomUUID().toString());
            this.partitionNexus.add(new AddOperationContext(this.adminSession, (ServerEntry)serverEntry));
        }
        DN groupDn = new DN("ou=groups,ou=system");
        groupDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(this.adminSession, groupDn))) {
            firstStart = true;
            DefaultServerEntry serverEntry = new DefaultServerEntry(this.schemaManager, groupDn);
            serverEntry.put("objectClass", "top", "organizationalUnit");
            serverEntry.put("ou", "groups");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", UUID.randomUUID().toString());
            this.partitionNexus.add(new AddOperationContext(this.adminSession, (ServerEntry)serverEntry));
        }
        DN name = new DN("cn=Administrators,ou=groups,ou=system");
        name.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(this.adminSession, name))) {
            firstStart = true;
            DefaultServerEntry serverEntry = new DefaultServerEntry(this.schemaManager, name);
            serverEntry.put("objectClass", "top", "groupOfUniqueNames");
            serverEntry.put("cn", "Administrators");
            serverEntry.put("uniqueMember", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", UUID.randomUUID().toString());
            this.partitionNexus.add(new AddOperationContext(this.adminSession, (ServerEntry)serverEntry));
        }
        DN configurationDn = new DN("ou=configuration,ou=system");
        configurationDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(this.adminSession, configurationDn))) {
            firstStart = true;
            DefaultServerEntry serverEntry = new DefaultServerEntry(this.schemaManager, configurationDn);
            serverEntry.put("objectClass", "top", "organizationalUnit");
            serverEntry.put("ou", "configuration");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", UUID.randomUUID().toString());
            this.partitionNexus.add(new AddOperationContext(this.adminSession, (ServerEntry)serverEntry));
        }
        DN partitionsDn = new DN("ou=partitions,ou=configuration,ou=system");
        partitionsDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(this.adminSession, partitionsDn))) {
            firstStart = true;
            DefaultServerEntry serverEntry = new DefaultServerEntry(this.schemaManager, partitionsDn);
            serverEntry.put("objectClass", "top", "organizationalUnit");
            serverEntry.put("ou", "partitions");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", UUID.randomUUID().toString());
            this.partitionNexus.add(new AddOperationContext(this.adminSession, (ServerEntry)serverEntry));
        }
        DN servicesDn = new DN("ou=services,ou=configuration,ou=system");
        servicesDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(this.adminSession, servicesDn))) {
            firstStart = true;
            DefaultServerEntry serverEntry = new DefaultServerEntry(this.schemaManager, servicesDn);
            serverEntry.put("objectClass", "top", "organizationalUnit");
            serverEntry.put("ou", "services");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", UUID.randomUUID().toString());
            this.partitionNexus.add(new AddOperationContext(this.adminSession, (ServerEntry)serverEntry));
        }
        DN interceptorsDn = new DN("ou=interceptors,ou=configuration,ou=system");
        interceptorsDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(this.adminSession, interceptorsDn))) {
            firstStart = true;
            DefaultServerEntry serverEntry = new DefaultServerEntry(this.schemaManager, interceptorsDn);
            serverEntry.put("objectClass", "top", "organizationalUnit");
            serverEntry.put("ou", "interceptors");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", UUID.randomUUID().toString());
            this.partitionNexus.add(new AddOperationContext(this.adminSession, (ServerEntry)serverEntry));
        }
        DN sysPrefRootDn = new DN("prefNodeName=sysPrefRoot,ou=system");
        sysPrefRootDn.normalize(oidsMap);
        if (!this.partitionNexus.hasEntry(new EntryOperationContext(this.adminSession, sysPrefRootDn))) {
            firstStart = true;
            DefaultServerEntry serverEntry = new DefaultServerEntry(this.schemaManager, sysPrefRootDn);
            serverEntry.put("objectClass", "top", "organizationalUnit", "extensibleObject");
            serverEntry.put("prefNodeName", "sysPrefRoot");
            serverEntry.put("creatorsName", "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            serverEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            serverEntry.add("entryCSN", this.getCSN().toString());
            serverEntry.add("entryUUID", UUID.randomUUID().toString());
            this.partitionNexus.add(new AddOperationContext(this.adminSession, (ServerEntry)serverEntry));
        }
        return firstStart;
    }

    private void showSecurityWarnings() throws Exception {
        boolean needToChangeAdminPassword = false;
        DN adminDn = new DN("uid=admin,ou=system");
        adminDn.normalize(this.schemaManager.getNormalizerMapping());
        ClonedServerEntry adminEntry = this.partitionNexus.lookup(new LookupOperationContext(this.adminSession, adminDn));
        Value<?> userPassword = adminEntry.get("userPassword").get();
        if (userPassword instanceof byte[]) {
            needToChangeAdminPassword = Arrays.equals(PartitionNexus.ADMIN_PASSWORD_BYTES, (byte[])userPassword);
        } else if (userPassword.toString().equals("secret")) {
            needToChangeAdminPassword = "secret".equals(userPassword.toString());
        }
        if (needToChangeAdminPassword) {
            LOG.warn("You didn't change the admin password of directory service instance '" + this.instanceId + "'.  " + "Please update the admin password as soon as possible " + "to prevent a possible security breach.");
        }
    }

    private void createTestEntries() throws Exception {
        for (LdifEntry ldifEntry : this.testEntries) {
            try {
                LdifEntry ldifEntry2 = ldifEntry.clone();
                Entry entry = ldifEntry2.getEntry();
                String dn = ldifEntry2.getDn().getName();
                try {
                    this.getAdminSession().add(new DefaultServerEntry(this.schemaManager, entry));
                }
                catch (Exception e) {
                    LOG.warn(dn + " test entry already exists.", (Throwable)e);
                }
            }
            catch (CloneNotSupportedException cnse) {
                LOG.warn("Cannot clone the entry ", (Throwable)cnse);
            }
        }
    }

    private void initialize() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("---> Initializing the DefaultDirectoryService ");
        }
        this.schemaService.initialize();
        this.schemaService.getSchemaPartition().initialize();
        this.partitions.add(this.schemaService.getSchemaPartition());
        this.systemPartition.getSuffixDn().normalize(this.schemaManager.getNormalizerMapping());
        this.adminDn = new DN("uid=admin,ou=system").normalize(this.schemaManager.getNormalizerMapping());
        this.adminDn.normalize(this.schemaManager.getNormalizerMapping());
        this.adminSession = new DefaultCoreSession(new LdapPrincipal(this.adminDn, AuthenticationLevel.STRONG), this);
        this.partitionNexus = new DefaultPartitionNexus(new DefaultServerEntry(this.schemaManager, DN.EMPTY_DN));
        this.partitionNexus.setDirectoryService(this);
        this.partitionNexus.initialize();
        this.firstStart = this.createBootstrapEntries();
        this.interceptorChain = new InterceptorChain();
        this.interceptorChain.init(this);
        if (this.changeLog.isEnabled()) {
            this.changeLog.init(this);
            if (this.changeLog.isExposed() && this.changeLog.isTagSearchSupported()) {
                String clSuffix = ((TaggableSearchableChangeLogStore)this.changeLog.getChangeLogStore()).getPartition().getSuffixDn().getName();
                this.partitionNexus.getRootDSE(null).getOriginalEntry().add("changeLogContext", clSuffix);
            }
        }
        if (this.journal.isEnabled()) {
            this.journal.init((DirectoryService)this);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<--- DefaultDirectoryService initialized");
        }
    }

    private Entry readEntry(String text) {
        StringReader strIn = new StringReader(text);
        BufferedReader in = new BufferedReader(strIn);
        String line = null;
        DefaultClientEntry entry = new DefaultClientEntry();
        block6: while (true) {
            try {
                while ((line = in.readLine()) != null) {
                    String addedLine;
                    if (line.length() == 0 || StringTools.isEmpty(addedLine = line.trim())) continue;
                    EntryAttribute attribute = LdifReader.parseAttributeValue((String)addedLine);
                    EntryAttribute oldAttribute = entry.get(attribute.getId());
                    if (oldAttribute != null) {
                        try {
                            oldAttribute.add(attribute.get());
                            entry.put(oldAttribute);
                            continue block6;
                        }
                        catch (LdapException ne) {
                            continue;
                        }
                    }
                    try {
                        entry.put(attribute);
                        continue block6;
                    }
                    catch (LdapException ne) {
                    }
                }
                break;
            }
            catch (IOException ioe) {
                // empty catch block
                break;
            }
        }
        return entry;
    }

    @Override
    public ServerEntry newEntry(String ldif, String dn) {
        try {
            Entry entry = this.readEntry(ldif);
            DN newDn = new DN(dn);
            entry.setDn(newDn);
            DefaultServerEntry serverEntry = new DefaultServerEntry(this.schemaManager, entry);
            return serverEntry;
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_78, ldif, dn));
            return null;
        }
    }

    @Override
    public EventService getEventService() {
        return this.eventService;
    }

    @Override
    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    @Override
    public boolean isPasswordHidden() {
        return this.passwordHidden;
    }

    @Override
    public void setPasswordHidden(boolean passwordHidden) {
        this.passwordHidden = passwordHidden;
    }

    @Override
    public int getMaxPDUSize() {
        return this.maxPDUSize;
    }

    @Override
    public void setMaxPDUSize(int maxPDUSize) {
        if (maxPDUSize <= 0) {
            maxPDUSize = Integer.MAX_VALUE;
        }
        this.maxPDUSize = maxPDUSize;
    }

    @Override
    public Interceptor getInterceptor(String interceptorName) {
        for (Interceptor interceptor : this.interceptors) {
            if (!interceptor.getName().equalsIgnoreCase(interceptorName)) continue;
            return interceptor;
        }
        return null;
    }

    @Override
    public Csn getCSN() {
        return this.csnFactory.newInstance();
    }

    @Override
    public int getReplicaId() {
        return this.replicaId;
    }

    @Override
    public void setReplicaId(int replicaId) {
        if (replicaId < 0 || replicaId > 999) {
            LOG.error(I18n.err(I18n.ERR_79, new Object[0]));
            this.replicaId = 0;
        } else {
            this.replicaId = replicaId;
        }
    }

    @Override
    public void setReplicationConfiguration(ReplicationConfiguration replicationConfig) {
        this.replicationConfig = replicationConfig;
    }

    @Override
    public ReplicationConfiguration getReplicationConfiguration() {
        return this.replicationConfig;
    }

    public long getSyncPeriodMillis() {
        return this.syncPeriodMillis;
    }

    public void setSyncPeriodMillis(long syncPeriodMillis) {
        this.syncPeriodMillis = syncPeriodMillis;
    }

    class SynchWorker
    implements Runnable {
        final Object lock = new Object();
        boolean stop;

        SynchWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stop) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(DefaultDirectoryService.this.syncPeriodMillis);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("SynchWorker failed to wait on lock.", (Throwable)e);
                    }
                }
                try {
                    DefaultDirectoryService.this.partitionNexus.sync();
                }
                catch (Exception e) {
                    LOG.error(I18n.err(I18n.ERR_74, new Object[0]), (Throwable)e);
                }
            }
        }
    }
}

