/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.extended;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.SerializationUtils;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.sp.StoredProcEngine;
import org.apache.directory.server.core.sp.StoredProcExecutionManager;
import org.apache.directory.server.core.sp.java.JavaStoredProcEngineConfig;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.ldap.codec.extended.operations.storedProcedure.StoredProcedure;
import org.apache.directory.shared.ldap.codec.extended.operations.storedProcedure.StoredProcedureContainer;
import org.apache.directory.shared.ldap.codec.extended.operations.storedProcedure.StoredProcedureDecoder;
import org.apache.directory.shared.ldap.message.internal.InternalExtendedRequest;
import org.apache.directory.shared.ldap.message.internal.InternalExtendedResponse;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.sp.LdapContextParameter;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcedureExtendedOperationHandler
implements ExtendedOperationHandler {
    private StoredProcExecutionManager manager;
    private static final Object[] EMPTY_CLASS_ARRAY = new Object[0];
    private static final Set<String> EXTENSION_OIDS;

    public StoredProcedureExtendedOperationHandler() {
        JavaStoredProcEngineConfig javaSPEngineConfig = new JavaStoredProcEngineConfig();
        ArrayList<JavaStoredProcEngineConfig> spEngineConfigs = new ArrayList<JavaStoredProcEngineConfig>();
        spEngineConfigs.add(javaSPEngineConfig);
        String spContainer = "ou=Stored Procedures,ou=system";
        this.manager = new StoredProcExecutionManager(spContainer, spEngineConfigs);
    }

    @Override
    public void handleExtendedOperation(LdapSession session, InternalExtendedRequest req) throws Exception {
        StoredProcedure spBean = this.decodeBean(req.getPayload());
        String procedure = StringTools.utf8ToString(spBean.getProcedure());
        ClonedServerEntry spUnit = this.manager.findStoredProcUnit(session.getCoreSession(), procedure);
        StoredProcEngine engine = this.manager.getStoredProcEngineInstance(spUnit);
        ArrayList<Object> valueList = new ArrayList<Object>(spBean.getParameters().size());
        for (StoredProcedure.StoredProcedureParameter pPojo : spBean.getParameters()) {
            byte[] serializedValue = pPojo.getValue();
            Object value = SerializationUtils.deserialize((byte[])serializedValue);
            if (value.getClass().equals(LdapContextParameter.class)) {
                String paramCtx = ((LdapContextParameter)value).getValue();
                value = session.getCoreSession().lookup(new DN(paramCtx));
            }
            valueList.add(value);
        }
        Object[] values = valueList.toArray(EMPTY_CLASS_ARRAY);
        Object response = engine.invokeProcedure(session.getCoreSession(), procedure, values);
        byte[] serializedResponse = SerializationUtils.serialize((Serializable)((Serializable)response));
        ((InternalExtendedResponse)req.getResultResponse()).setResponse(serializedResponse);
        session.getIoSession().write((Object)req.getResultResponse());
    }

    private StoredProcedure decodeBean(byte[] payload) {
        StoredProcedureDecoder storedProcedureDecoder = new StoredProcedureDecoder();
        ByteBuffer stream = ByteBuffer.wrap(payload);
        StoredProcedureContainer storedProcedureContainer = new StoredProcedureContainer();
        try {
            storedProcedureDecoder.decode(stream, (IAsn1Container)storedProcedureContainer);
        }
        catch (Exception de) {
            de.printStackTrace();
        }
        StoredProcedure spBean = storedProcedureContainer.getStoredProcedure();
        return spBean;
    }

    @Override
    public String getOid() {
        return "1.3.6.1.4.1.18060.0.1.6";
    }

    @Override
    public Set<String> getExtensionOids() {
        return EXTENSION_OIDS;
    }

    @Override
    public void setLdapServer(LdapServer ldapServer) {
    }

    static {
        HashSet<String> s = new HashSet<String>();
        s.add("1.3.6.1.4.1.18060.0.1.6");
        s.add("1.3.6.1.4.1.18060.0.1.7");
        EXTENSION_OIDS = Collections.unmodifiableSet(s);
    }
}

