/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.messages.value.types.AuthorizationType;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationDataEntry
extends AbstractAsn1Object {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationDataEntry.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private AuthorizationType adType;
    private byte[] adData;
    private transient int adTypeLength;
    private transient int adDataLength;
    private transient int authorizationDataEntryLength;

    public AuthorizationDataEntry() {
    }

    public AuthorizationDataEntry(AuthorizationType adType, byte[] adData) {
        this.adType = adType;
        this.adData = adData;
    }

    public byte[] getAdData() {
        return this.adData;
    }

    public void setAdData(byte[] adData) {
        this.adData = adData;
    }

    public AuthorizationType getAdType() {
        return this.adType;
    }

    public void setAdType(int adType) {
        this.adType = AuthorizationType.getTypeByOrdinal(adType);
    }

    public void setAdType(AuthorizationType adType) {
        this.adType = adType;
    }

    public int computeLength() {
        this.adTypeLength = 2 + Value.getNbBytes((int)this.adType.getOrdinal());
        this.authorizationDataEntryLength = 1 + TLV.getNbBytes((int)this.adTypeLength) + this.adTypeLength;
        this.adDataLength = this.adData == null ? 2 : 1 + TLV.getNbBytes((int)this.adData.length) + this.adData.length;
        this.authorizationDataEntryLength += 1 + TLV.getNbBytes((int)this.adDataLength) + this.adDataLength;
        int authorizationDataEntrySeqLength = 1 + Value.getNbBytes((int)this.authorizationDataEntryLength) + this.authorizationDataEntryLength;
        return authorizationDataEntrySeqLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_148, new Object[0]));
        }
        try {
            buffer.put((byte)48);
            buffer.put(TLV.getBytes((int)this.authorizationDataEntryLength));
            buffer.put((byte)-96);
            buffer.put(TLV.getBytes((int)this.adTypeLength));
            Value.encode((ByteBuffer)buffer, (int)this.adType.getOrdinal());
            buffer.put((byte)-95);
            buffer.put(TLV.getBytes((int)this.adDataLength));
            Value.encode((ByteBuffer)buffer, (byte[])this.adData);
        }
        catch (BufferOverflowException boe) {
            log.error(I18n.err(I18n.ERR_622, 1 + TLV.getNbBytes((int)this.authorizationDataEntryLength) + this.authorizationDataEntryLength, buffer.capacity()));
            throw new EncoderException(I18n.err(I18n.ERR_138, new Object[0]));
        }
        if (IS_DEBUG) {
            log.debug("AuthorizationDataEntry encoding : {}", (Object)StringTools.dumpBytes(buffer.array()));
            log.debug("AuthorizationDataEntry initial value : {}", (Object)this.toString());
        }
        return buffer;
    }

    public String toString() {
        return this.toString("    ");
    }

    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("AuthorizationDataEntry : {\n");
        sb.append(tabs).append("    ad-type: ").append((Object)this.adType).append('\n');
        sb.append(tabs).append("    ad-data: ").append(StringTools.dumpBytes(this.adData)).append("\n" + tabs + "}");
        return sb.toString();
    }
}

