/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.protocol;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.kerberos.kdc.authentication.AuthenticationContext;
import org.apache.directory.server.kerberos.kdc.authentication.AuthenticationService;
import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingContext;
import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingService;
import org.apache.directory.server.kerberos.shared.KerberosMessageType;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.ErrorMessage;
import org.apache.directory.server.kerberos.shared.messages.ErrorMessageModifier;
import org.apache.directory.server.kerberos.shared.messages.KdcRequest;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosProtocolHandler
implements IoHandler {
    private static final Logger log = LoggerFactory.getLogger(KerberosProtocolHandler.class);
    private KdcServer config;
    private PrincipalStore store;
    private static final String CONTEXT_KEY = "context";

    public KerberosProtocolHandler(KdcServer config, PrincipalStore store) {
        this.config = config;
        this.store = store;
    }

    public void sessionCreated(IoSession session) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("{} CREATED:  {}", (Object)session.getRemoteAddress(), (Object)session.getTransportMetadata());
        }
    }

    public void sessionOpened(IoSession session) {
        if (log.isDebugEnabled()) {
            log.debug("{} OPENED", (Object)session.getRemoteAddress());
        }
    }

    public void sessionClosed(IoSession session) {
        if (log.isDebugEnabled()) {
            log.debug("{} CLOSED", (Object)session.getRemoteAddress());
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        if (log.isDebugEnabled()) {
            log.debug("{} IDLE ({})", (Object)session.getRemoteAddress(), (Object)status);
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        log.error(session.getRemoteAddress() + " EXCEPTION", cause);
        session.close(true);
    }

    public void messageReceived(IoSession session, Object message) {
        if (log.isDebugEnabled()) {
            log.debug("{} RCVD:  {}", (Object)session.getRemoteAddress(), message);
        }
        InetAddress clientAddress = ((InetSocketAddress)session.getRemoteAddress()).getAddress();
        KdcRequest request = (KdcRequest)message;
        KerberosMessageType messageType = request.getMessageType();
        try {
            switch (messageType) {
                case AS_REQ: {
                    AuthenticationContext authContext = new AuthenticationContext();
                    authContext.setConfig(this.config);
                    authContext.setStore(this.store);
                    authContext.setClientAddress(clientAddress);
                    authContext.setRequest(request);
                    session.setAttribute((Object)CONTEXT_KEY, (Object)authContext);
                    AuthenticationService.execute(authContext);
                    session.write((Object)authContext.getReply());
                    break;
                }
                case TGS_REQ: {
                    TicketGrantingContext tgsContext = new TicketGrantingContext();
                    tgsContext.setConfig(this.config);
                    tgsContext.setStore(this.store);
                    tgsContext.setClientAddress(clientAddress);
                    tgsContext.setRequest(request);
                    session.setAttribute((Object)CONTEXT_KEY, (Object)tgsContext);
                    TicketGrantingService.execute(tgsContext);
                    session.write((Object)tgsContext.getReply());
                    break;
                }
                case AS_REP: 
                case TGS_REP: {
                    throw new KerberosException(ErrorType.KRB_AP_ERR_BADDIRECTION);
                }
                default: {
                    throw new KerberosException(ErrorType.KRB_AP_ERR_MSG_TYPE);
                }
            }
        }
        catch (KerberosException ke) {
            String messageText = ke.getLocalizedMessage() + " (" + ke.getErrorCode() + ")";
            if (log.isDebugEnabled()) {
                log.warn(messageText, (Throwable)ke);
            } else {
                log.warn(messageText);
            }
            ErrorMessage error = this.getErrorMessage(this.config.getServicePrincipal(), ke);
            if (log.isDebugEnabled()) {
                this.logErrorMessage(error);
            }
            session.write((Object)error);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(I18n.err(I18n.ERR_152, e.getLocalizedMessage()), (Throwable)e);
            session.write((Object)this.getErrorMessage(this.config.getServicePrincipal(), new KerberosException(ErrorType.KDC_ERR_SVC_UNAVAILABLE)));
        }
    }

    public void messageSent(IoSession session, Object message) {
        if (log.isDebugEnabled()) {
            log.debug("{} SENT:  {}", (Object)session.getRemoteAddress(), message);
        }
    }

    protected ErrorMessage getErrorMessage(KerberosPrincipal principal, KerberosException exception) {
        ErrorMessageModifier modifier = new ErrorMessageModifier();
        KerberosTime now = new KerberosTime();
        modifier.setErrorCode(exception.getErrorCode());
        modifier.setExplanatoryText(exception.getLocalizedMessage());
        modifier.setServerPrincipal(principal);
        modifier.setServerTime(now);
        modifier.setServerMicroSecond(0);
        modifier.setExplanatoryData(exception.getExplanatoryData());
        return modifier.getErrorMessage();
    }

    protected void logErrorMessage(ErrorMessage error) {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("Responding to request with error:");
            sb.append("\n\texplanatory text:      " + error.getExplanatoryText());
            sb.append("\n\terror code:            " + error.getErrorCode());
            sb.append("\n\tclientPrincipal:       " + error.getClientPrincipal());
            sb.append("\n\tclient time:           " + error.getClientTime());
            sb.append("\n\tserverPrincipal:       " + error.getServerPrincipal());
            sb.append("\n\tserver time:           " + error.getServerTime());
            log.debug(sb.toString());
        }
        catch (Exception e) {
            log.error(I18n.err(I18n.ERR_155, new Object[0]), (Throwable)e);
        }
    }
}

