/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.OperationManager;
import org.apache.directory.server.core.changelog.LogChange;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.AbstractOperationContext;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.BinaryValue;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.ServerModification;
import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterParser;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.message.control.Control;
import org.apache.directory.shared.ldap.message.internal.InternalAddRequest;
import org.apache.directory.shared.ldap.message.internal.InternalCompareRequest;
import org.apache.directory.shared.ldap.message.internal.InternalDeleteRequest;
import org.apache.directory.shared.ldap.message.internal.InternalModifyDnRequest;
import org.apache.directory.shared.ldap.message.internal.InternalModifyRequest;
import org.apache.directory.shared.ldap.message.internal.InternalSearchRequest;
import org.apache.directory.shared.ldap.message.internal.InternalUnbindRequest;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.AttributeTypeOptions;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockCoreSession
implements CoreSession {
    private DirectoryService directoryService;
    private final LdapPrincipal authenticatedPrincipal;
    private LdapPrincipal authorizedPrincipal;

    public MockCoreSession(LdapPrincipal principal, DirectoryService directoryService) {
        this.directoryService = directoryService;
        this.authenticatedPrincipal = principal;
    }

    private void setReferralHandling(AbstractOperationContext opContext, boolean ignoreReferral) {
        if (ignoreReferral) {
            opContext.ignoreReferral();
        } else {
            opContext.throwReferral();
        }
    }

    @Override
    public void add(ServerEntry entry) throws Exception {
        this.add(entry, LogChange.TRUE);
    }

    @Override
    public void add(ServerEntry entry, boolean ignoreReferral) throws Exception {
        this.add(entry, ignoreReferral, LogChange.TRUE);
    }

    @Override
    public void add(ServerEntry entry, LogChange log) throws Exception {
        AddOperationContext opContext = new AddOperationContext((CoreSession)this, entry);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.add(opContext);
    }

    @Override
    public void add(ServerEntry entry, boolean ignoreReferral, LogChange log) throws Exception {
        AddOperationContext opContext = new AddOperationContext((CoreSession)this, entry);
        opContext.setLogChange(log);
        this.setReferralHandling((AbstractOperationContext)opContext, ignoreReferral);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.add(opContext);
    }

    @Override
    public void add(InternalAddRequest addRequest) throws Exception {
        this.add(addRequest, LogChange.TRUE);
    }

    @Override
    public void add(InternalAddRequest addRequest, LogChange log) throws Exception {
        AddOperationContext opContext = new AddOperationContext((CoreSession)this, addRequest);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.add(opContext);
        addRequest.getResultResponse().addAll(opContext.getResponseControls());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Value<?> convertToValue(String oid, Object value) throws LdapException {
        void var3_8;
        Object var3_3 = null;
        AttributeType attributeType = this.directoryService.getSchemaManager().lookupAttributeTypeRegistry(oid);
        if (attributeType.getSyntax().isHumanReadable()) {
            if (value instanceof String) {
                StringValue stringValue = new StringValue(attributeType, (String)value);
                return var3_8;
            } else {
                if (!(value instanceof byte[])) throw new LdapException(I18n.err(I18n.ERR_309, oid));
                StringValue stringValue = new StringValue(attributeType, StringTools.utf8ToString((byte[])value));
            }
            return var3_8;
        } else if (value instanceof String) {
            BinaryValue binaryValue = new BinaryValue(attributeType, StringTools.getBytesUtf8((String)value));
            return var3_8;
        } else {
            if (!(value instanceof byte[])) throw new LdapException(I18n.err(I18n.ERR_309, oid));
            BinaryValue binaryValue = new BinaryValue(attributeType, (byte[])value);
        }
        return var3_8;
    }

    @Override
    public boolean compare(DN dn, String oid, Object value) throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.compare(new CompareOperationContext((CoreSession)this, dn, oid, this.convertToValue(oid, value)));
    }

    @Override
    public boolean compare(DN dn, String oid, Object value, boolean ignoreReferral) throws Exception {
        CompareOperationContext opContext = new CompareOperationContext((CoreSession)this, dn, oid, this.convertToValue(oid, value));
        this.setReferralHandling((AbstractOperationContext)opContext, ignoreReferral);
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.compare(opContext);
    }

    @Override
    public void delete(DN dn) throws Exception {
        this.delete(dn, LogChange.TRUE);
    }

    @Override
    public void delete(DN dn, LogChange log) throws Exception {
        DeleteOperationContext opContext = new DeleteOperationContext((CoreSession)this, dn);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.delete(opContext);
    }

    @Override
    public void delete(DN dn, boolean ignoreReferral) throws Exception {
        this.delete(dn, ignoreReferral, LogChange.TRUE);
    }

    @Override
    public void delete(DN dn, boolean ignoreReferral, LogChange log) throws Exception {
        DeleteOperationContext opContext = new DeleteOperationContext((CoreSession)this, dn);
        opContext.setLogChange(log);
        this.setReferralHandling((AbstractOperationContext)opContext, ignoreReferral);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.delete(opContext);
    }

    @Override
    public LdapPrincipal getAuthenticatedPrincipal() {
        return this.authenticatedPrincipal;
    }

    @Override
    public AuthenticationLevel getAuthenticationLevel() {
        return this.getEffectivePrincipal().getAuthenticationLevel();
    }

    @Override
    public SocketAddress getClientAddress() {
        return null;
    }

    @Override
    public Set<Control> getControls() {
        return null;
    }

    @Override
    public DirectoryService getDirectoryService() {
        return this.directoryService;
    }

    @Override
    public LdapPrincipal getEffectivePrincipal() {
        if (this.authorizedPrincipal == null) {
            return this.authenticatedPrincipal;
        }
        return this.authorizedPrincipal;
    }

    @Override
    public Set<OperationContext> getOutstandingOperations() {
        return null;
    }

    @Override
    public SocketAddress getServiceAddress() {
        return null;
    }

    @Override
    public boolean isConfidential() {
        return false;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public boolean isAdministrator() {
        String normName = this.getEffectivePrincipal().getName();
        return normName.equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
    }

    @Override
    public boolean isAnAdministrator() {
        return this.isAdministrator();
    }

    @Override
    public EntryFilteringCursor list(DN dn, AliasDerefMode aliasDerefMode, Set<AttributeTypeOptions> returningAttributes) throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        ListOperationContext listOperationContext = new ListOperationContext((CoreSession)this, dn, returningAttributes);
        listOperationContext.setAliasDerefMode(aliasDerefMode);
        return operationManager.list(listOperationContext);
    }

    @Override
    public EntryFilteringCursor list(DN dn, AliasDerefMode aliasDerefMode, Set<AttributeTypeOptions> returningAttributes, long sizeLimit, int timeLimit) throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        ListOperationContext listOperationContext = new ListOperationContext((CoreSession)this, dn, returningAttributes);
        listOperationContext.setSizeLimit(sizeLimit);
        listOperationContext.setTimeLimit(timeLimit);
        listOperationContext.setAliasDerefMode(aliasDerefMode);
        return operationManager.list(listOperationContext);
    }

    @Override
    public ClonedServerEntry lookup(DN dn) throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.lookup(new LookupOperationContext((CoreSession)this, dn));
    }

    @Override
    public ClonedServerEntry lookup(DN dn, String[] attrId) throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.lookup(new LookupOperationContext((CoreSession)this, dn, attrId));
    }

    @Override
    public void modify(DN dn, List<Modification> mods) throws Exception {
        this.modify(dn, mods, LogChange.TRUE);
    }

    @Override
    public void modify(DN dn, List<Modification> mods, LogChange log) throws Exception {
        if (mods == null) {
            return;
        }
        ArrayList<ServerModification> serverModifications = new ArrayList<ServerModification>(mods.size());
        for (Modification mod : mods) {
            serverModifications.add(new ServerModification(this.directoryService.getSchemaManager(), mod));
        }
        ModifyOperationContext opContext = new ModifyOperationContext((CoreSession)this, dn, serverModifications);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.modify(opContext);
    }

    @Override
    public void modify(DN dn, List<Modification> mods, boolean ignoreReferral) throws Exception {
        this.modify(dn, mods, ignoreReferral, LogChange.TRUE);
    }

    @Override
    public void modify(DN dn, List<Modification> mods, boolean ignoreReferral, LogChange log) throws Exception {
        if (mods == null) {
            return;
        }
        ArrayList<ServerModification> serverModifications = new ArrayList<ServerModification>(mods.size());
        for (Modification mod : mods) {
            serverModifications.add(new ServerModification(this.directoryService.getSchemaManager(), mod));
        }
        ModifyOperationContext opContext = new ModifyOperationContext((CoreSession)this, dn, serverModifications);
        this.setReferralHandling((AbstractOperationContext)opContext, ignoreReferral);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.modify(opContext);
    }

    @Override
    public void move(DN dn, DN newParent) throws Exception {
        this.move(dn, newParent, LogChange.TRUE);
    }

    @Override
    public void move(DN dn, DN newParent, LogChange log) throws Exception {
        MoveOperationContext opContext = new MoveOperationContext((CoreSession)this, dn, newParent);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.move(opContext);
    }

    @Override
    public void move(DN dn, DN newParent, boolean ignoreReferral) throws Exception {
        this.move(dn, newParent, ignoreReferral, LogChange.TRUE);
    }

    @Override
    public void move(DN dn, DN newParent, boolean ignoreReferral, LogChange log) throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        MoveOperationContext opContext = new MoveOperationContext((CoreSession)this, dn, newParent);
        this.setReferralHandling((AbstractOperationContext)opContext, ignoreReferral);
        opContext.setLogChange(log);
        operationManager.move(opContext);
    }

    @Override
    public void moveAndRename(DN dn, DN newParent, RDN newRdn, boolean deleteOldRdn) throws Exception {
        this.moveAndRename(dn, newParent, newRdn, deleteOldRdn, LogChange.TRUE);
    }

    @Override
    public void moveAndRename(DN dn, DN newParent, RDN newRdn, boolean deleteOldRdn, LogChange log) throws Exception {
        MoveAndRenameOperationContext opContext = new MoveAndRenameOperationContext((CoreSession)this, dn, newParent, newRdn, deleteOldRdn);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.moveAndRename(opContext);
    }

    @Override
    public void moveAndRename(DN dn, DN newParent, RDN newRdn, boolean deleteOldRdn, boolean ignoreReferral) throws Exception {
        this.moveAndRename(dn, newParent, newRdn, deleteOldRdn, ignoreReferral, LogChange.TRUE);
    }

    @Override
    public void moveAndRename(DN dn, DN newParent, RDN newRdn, boolean deleteOldRdn, boolean ignoreReferral, LogChange log) throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        MoveAndRenameOperationContext opContext = new MoveAndRenameOperationContext((CoreSession)this, dn, newParent, newRdn, deleteOldRdn);
        opContext.setLogChange(log);
        this.setReferralHandling((AbstractOperationContext)opContext, ignoreReferral);
        operationManager.moveAndRename(opContext);
    }

    @Override
    public void rename(DN dn, RDN newRdn, boolean deleteOldRdn) throws Exception {
        this.rename(dn, newRdn, deleteOldRdn, LogChange.TRUE);
    }

    @Override
    public void rename(DN dn, RDN newRdn, boolean deleteOldRdn, LogChange log) throws Exception {
        RenameOperationContext opContext = new RenameOperationContext((CoreSession)this, dn, newRdn, deleteOldRdn);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.rename(opContext);
    }

    @Override
    public void rename(DN dn, RDN newRdn, boolean deleteOldRdn, boolean ignoreReferral) throws Exception {
        this.rename(dn, newRdn, deleteOldRdn, ignoreReferral, LogChange.TRUE);
    }

    @Override
    public void rename(DN dn, RDN newRdn, boolean deleteOldRdn, boolean ignoreReferral, LogChange log) throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        RenameOperationContext opContext = new RenameOperationContext((CoreSession)this, dn, newRdn, deleteOldRdn);
        opContext.setLogChange(log);
        this.setReferralHandling((AbstractOperationContext)opContext, ignoreReferral);
        operationManager.rename(opContext);
    }

    @Override
    public EntryFilteringCursor search(DN dn, String filter) throws Exception {
        return this.search(dn, filter, true);
    }

    @Override
    public EntryFilteringCursor search(DN dn, String filter, boolean ignoreReferrals) throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        ExprNode filterNode = FilterParser.parse((String)filter);
        SearchOperationContext searchOperationContext = new SearchOperationContext((CoreSession)this, dn, SearchScope.OBJECT, filterNode, null);
        searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
        this.setReferralHandling((AbstractOperationContext)searchOperationContext, ignoreReferrals);
        return operationManager.search(searchOperationContext);
    }

    @Override
    public EntryFilteringCursor search(DN dn, SearchScope scope, ExprNode filter, AliasDerefMode aliasDerefMode, Set<AttributeTypeOptions> returningAttributes) throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        SearchOperationContext searchOperationContext = new SearchOperationContext((CoreSession)this, dn, scope, filter, returningAttributes);
        searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
        return operationManager.search(searchOperationContext);
    }

    @Override
    public EntryFilteringCursor search(DN dn, SearchScope scope, ExprNode filter, AliasDerefMode aliasDerefMode, Set<AttributeTypeOptions> returningAttributes, long sizeLimit, int timeLimit) throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        SearchOperationContext searchOperationContext = new SearchOperationContext((CoreSession)this, dn, scope, filter, returningAttributes);
        searchOperationContext.setSizeLimit(sizeLimit);
        searchOperationContext.setTimeLimit(timeLimit);
        searchOperationContext.setAliasDerefMode(aliasDerefMode);
        return operationManager.search(searchOperationContext);
    }

    @Override
    public boolean isAnonymous() {
        return StringTools.isEmpty(this.getEffectivePrincipal().getName());
    }

    @Override
    public boolean compare(InternalCompareRequest compareRequest) throws Exception {
        CompareOperationContext opContext = new CompareOperationContext((CoreSession)this, compareRequest);
        OperationManager operationManager = this.directoryService.getOperationManager();
        boolean result = operationManager.compare(opContext);
        compareRequest.getResultResponse().addAll(opContext.getResponseControls());
        return result;
    }

    @Override
    public void delete(InternalDeleteRequest deleteRequest) throws Exception {
        this.delete(deleteRequest, LogChange.TRUE);
    }

    @Override
    public void delete(InternalDeleteRequest deleteRequest, LogChange log) throws Exception {
        DeleteOperationContext opContext = new DeleteOperationContext((CoreSession)this, deleteRequest);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.delete(opContext);
        deleteRequest.getResultResponse().addAll(opContext.getResponseControls());
    }

    @Override
    public boolean exists(DN dn) throws Exception {
        EntryOperationContext opContext = new EntryOperationContext((CoreSession)this, dn);
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.hasEntry(opContext);
    }

    @Override
    public void modify(InternalModifyRequest modifyRequest) throws Exception {
        this.modify(modifyRequest, LogChange.TRUE);
    }

    @Override
    public void modify(InternalModifyRequest modifyRequest, LogChange log) throws Exception {
        ModifyOperationContext opContext = new ModifyOperationContext((CoreSession)this, modifyRequest);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.modify(opContext);
        modifyRequest.getResultResponse().addAll(opContext.getResponseControls());
    }

    @Override
    public void move(InternalModifyDnRequest modifyDnRequest) throws Exception {
        this.move(modifyDnRequest, LogChange.TRUE);
    }

    @Override
    public void move(InternalModifyDnRequest modifyDnRequest, LogChange log) throws Exception {
        MoveOperationContext opContext = new MoveOperationContext((CoreSession)this, modifyDnRequest);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.move(opContext);
        modifyDnRequest.getResultResponse().addAll(opContext.getResponseControls());
    }

    @Override
    public void moveAndRename(InternalModifyDnRequest modifyDnRequest) throws Exception {
        this.moveAndRename(modifyDnRequest, LogChange.TRUE);
    }

    @Override
    public void moveAndRename(InternalModifyDnRequest modifyDnRequest, LogChange log) throws Exception {
        MoveAndRenameOperationContext opContext = new MoveAndRenameOperationContext((CoreSession)this, modifyDnRequest);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.moveAndRename(opContext);
        modifyDnRequest.getResultResponse().addAll(opContext.getResponseControls());
    }

    @Override
    public void rename(InternalModifyDnRequest modifyDnRequest) throws Exception {
        this.rename(modifyDnRequest, LogChange.TRUE);
    }

    @Override
    public void rename(InternalModifyDnRequest modifyDnRequest, LogChange log) throws Exception {
        RenameOperationContext opContext = new RenameOperationContext((CoreSession)this, modifyDnRequest);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.rename(opContext);
        modifyDnRequest.getResultResponse().addAll(opContext.getResponseControls());
    }

    @Override
    public EntryFilteringCursor search(InternalSearchRequest searchRequest) throws Exception {
        SearchOperationContext opContext = new SearchOperationContext((CoreSession)this, searchRequest);
        OperationManager operationManager = this.directoryService.getOperationManager();
        EntryFilteringCursor cursor = operationManager.search(opContext);
        searchRequest.getResultResponse().addAll(opContext.getResponseControls());
        return cursor;
    }

    @Override
    public void unbind() throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.unbind(new UnbindOperationContext((CoreSession)this));
    }

    @Override
    public void unbind(InternalUnbindRequest unbindRequest) {
    }

    public void setDirectoryService(DirectoryService directoryService) {
        this.directoryService = directoryService;
    }
}

