/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apacheds.impl;

import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.axiom.om.util.Base64;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.factory.JdbmPartitionFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.core.interceptor.Interceptor;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.name.DN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.apacheds.AdminGroupInfo;
import org.wso2.carbon.apacheds.AdminInfo;
import org.wso2.carbon.apacheds.PartitionInfo;
import org.wso2.carbon.apacheds.PartitionManager;
import org.wso2.carbon.apacheds.PasswordAlgorithm;
import org.wso2.carbon.ldap.server.exception.DirectoryServerException;

class ApacheDirectoryPartitionManager
implements PartitionManager {
    private DirectoryService directoryService = null;
    private String workingDirectory;
    private PartitionFactory partitionFactory = null;
    private static final int PARTITION_CACHE_SIZE = 500;
    private static final Logger logger = LoggerFactory.getLogger(ApacheDirectoryPartitionManager.class);

    public ApacheDirectoryPartitionManager(DirectoryService directoryService, String wd) {
        this.directoryService = directoryService;
        this.workingDirectory = wd;
        this.partitionFactory = new JdbmPartitionFactory();
    }

    @Override
    public void addPartition(PartitionInfo partitionInformation) throws DirectoryServerException {
        try {
            JdbmPartition partition = this.createNewPartition(partitionInformation.getPartitionId(), partitionInformation.getRootDN());
            this.directoryService.addPartition((Partition)partition);
            CoreSession adminSession = this.directoryService.getAdminSession();
            if (!adminSession.exists(partition.getSuffixDn())) {
                this.addPartitionAttributes(partitionInformation.getRootDN(), partitionInformation.getObjectClasses(), partitionInformation.getRealm(), partitionInformation.getPreferredDomainComponent());
                this.addUserStoreToPartition(partition.getSuffix());
                this.addGroupStoreToPartition(partition.getSuffix());
                this.addAdmin(partitionInformation.getPartitionAdministrator(), partition.getSuffix(), partitionInformation.getRealm(), partitionInformation.isKdcEnabled());
                this.addAdminGroup(partitionInformation.getPartitionAdministrator(), partition.getSuffix());
                this.addAdminACLEntry(partitionInformation.getPartitionAdministrator().getAdminUID(), partition.getSuffix());
                this.directoryService.sync();
            }
        }
        catch (Exception e) {
            String errorMessage = "Could not add the partition";
            logger.error(errorMessage, (Throwable)e);
            throw new DirectoryServerException(errorMessage, e);
        }
    }

    @Override
    public boolean partitionDirectoryExists(String partitionID) throws DirectoryServerException {
        boolean partitionDirectoryExists = false;
        String partitionDirectoryName = this.workingDirectory + File.separator + partitionID;
        File partitionDirectory = new File(partitionDirectoryName);
        if (partitionDirectory.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Partition directory - " + partitionDirectoryName + " already exists.");
            }
            partitionDirectoryExists = true;
        }
        return partitionDirectoryExists;
    }

    @Override
    public boolean partitionInitialized(String partitionId) {
        Set partitions = this.directoryService.getPartitions();
        for (Partition partition : partitions) {
            if (!partition.getId().equals(partitionId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getNumberOfPartitions() {
        int numOfPartitions = 0;
        Set partitions = this.directoryService.getPartitions();
        numOfPartitions = partitions.size();
        return numOfPartitions;
    }

    @Override
    public void initializeExistingPartition(PartitionInfo partitionInfo) throws DirectoryServerException {
        Partition existingPartition = null;
        try {
            existingPartition = this.partitionFactory.createPartition(partitionInfo.getPartitionId(), partitionInfo.getRootDN(), 500, new File(this.workingDirectory, partitionInfo.getPartitionId()));
            existingPartition.setSchemaManager(this.directoryService.getSchemaManager());
            if (logger.isDebugEnabled()) {
                logger.debug("Partition" + partitionInfo.getPartitionId() + " created from existing partition directory.");
            }
        }
        catch (Exception e) {
            logger.error("Error in creating partition from existing partition directory.", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            this.directoryService.addPartition(existingPartition);
            this.directoryService.sync();
            if (logger.isDebugEnabled()) {
                logger.debug("Partition" + partitionInfo.getPartitionId() + " added to directory service.");
            }
        }
        catch (Exception e) {
            logger.error("Error in initializing partition in directory service", (Throwable)e);
            throw new DirectoryServerException(e);
        }
    }

    @Override
    public void removePartition(String partitionSuffix) throws DirectoryServerException {
        Partition partition = this.getPartition(partitionSuffix);
        if (partition == null) {
            String msg = "Error deleting partition. Could not find a partition with suffix " + partitionSuffix;
            logger.error(msg);
            throw new DirectoryServerException(msg);
        }
        try {
            this.directoryService.removePartition(partition);
        }
        catch (Exception e) {
            String msg = "Unable to delete partition with suffix " + partitionSuffix;
            logger.error(msg, (Throwable)e);
            throw new DirectoryServerException("Unable to delete partition with suffix " + partitionSuffix, e);
        }
    }

    @Override
    public void removeAllPartitions() throws DirectoryServerException {
        Set partitions = this.directoryService.getPartitions();
        for (Partition partition : partitions) {
            if (partition.getId().equalsIgnoreCase("schema")) continue;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Removing partition with id - " + partition.getId() + " suffix - " + partition.getSuffix());
                }
                this.directoryService.removePartition(partition);
            }
            catch (Exception e) {
                String msg = "Unable to remove partition with id " + partition.getId() + " with suffix " + partition.getSuffix();
                logger.error(msg, (Throwable)e);
                throw new DirectoryServerException(msg, e);
            }
        }
    }

    @Override
    public void synchronizePartitions() throws DirectoryServerException {
        try {
            this.directoryService.sync();
            List interceptors = this.directoryService.getInterceptors();
            for (Interceptor interceptor : interceptors) {
                interceptor.init(this.directoryService);
            }
        }
        catch (Exception e) {
            throw new DirectoryServerException("Unable to sync partitions. ", e);
        }
    }

    private static void throwDirectoryServerException(String message, Throwable e) throws DirectoryServerException {
        logger.error(message, e);
        throw new DirectoryServerException(message, e);
    }

    private static void addObjectClasses(ServerEntry serverEntry, List<String> objectClasses) throws DirectoryServerException {
        for (String objectClass : objectClasses) {
            try {
                serverEntry.add("objectClass", new String[]{objectClass});
            }
            catch (LdapException e) {
                ApacheDirectoryPartitionManager.throwDirectoryServerException("Could not add class to partition " + serverEntry.getDn().getName(), e);
            }
        }
    }

    private void addAccessControlAttributes(ServerEntry serverEntry) throws LdapException {
        serverEntry.add("administrativeRole", new String[]{"accessControlSpecificArea"});
    }

    private void addPartitionAttributes(String partitionDN, List<String> objectClasses, String realm, String dc) throws DirectoryServerException {
        try {
            DN adminDN = new DN(partitionDN);
            ServerEntry serverEntry = this.directoryService.newEntry(adminDN);
            ApacheDirectoryPartitionManager.addObjectClasses(serverEntry, objectClasses);
            serverEntry.add("o", new String[]{realm});
            if (dc == null) {
                logger.warn("Domain component not found for partition with DN - " + partitionDN + ". Not setting domain component.");
            } else {
                serverEntry.add("dc", new String[]{dc});
            }
            this.addAccessControlAttributes(serverEntry);
            this.directoryService.getAdminSession().add(serverEntry);
        }
        catch (Exception e) {
            String msg = "Could not add partition attributes for partition - " + partitionDN;
            ApacheDirectoryPartitionManager.throwDirectoryServerException(msg, e);
        }
    }

    private void addUserStoreToPartition(String partitionSuffixDn) throws DirectoryServerException {
        try {
            DN usersDN = new DN("ou=Users," + partitionSuffixDn);
            ServerEntry usersEntry = this.directoryService.newEntry(usersDN);
            usersEntry.add("objectClass", new String[]{"organizationalUnit", "top"});
            usersEntry.add("ou", new String[]{"Users"});
            this.directoryService.getAdminSession().add(usersEntry);
        }
        catch (LdapInvalidDnException e) {
            String msg = "Could not add user store to partition - " + partitionSuffixDn + ". Cause - partition domain name is not valid.";
            ApacheDirectoryPartitionManager.throwDirectoryServerException(msg, e);
        }
        catch (LdapException e) {
            String msg = "Could not add user store to partition - " + partitionSuffixDn;
            ApacheDirectoryPartitionManager.throwDirectoryServerException(msg, e);
        }
        catch (NamingException e) {
            String msg = "Could not add user store to partition - " + partitionSuffixDn + ". Cause - partition domain name is not valid.";
            ApacheDirectoryPartitionManager.throwDirectoryServerException(msg, e);
        }
        catch (Exception e) {
            String msg = "Could not add user store to partition admin session. - " + partitionSuffixDn;
            ApacheDirectoryPartitionManager.throwDirectoryServerException(msg, e);
        }
    }

    private void addGroupStoreToPartition(String partitionSuffixDn) throws DirectoryServerException {
        try {
            DN groupsDN = new DN("ou=Groups," + partitionSuffixDn);
            ServerEntry groupsEntry = this.directoryService.newEntry(groupsDN);
            groupsEntry.add("objectClass", new String[]{"organizationalUnit", "top"});
            groupsEntry.add("ou", new String[]{"Groups"});
            this.directoryService.getAdminSession().add(groupsEntry);
        }
        catch (NamingException e) {
            String msg = "Could not add group store to partition - " + partitionSuffixDn + ". Cause - partition domain name is not valid.";
            ApacheDirectoryPartitionManager.throwDirectoryServerException(msg, e);
        }
        catch (LdapException e) {
            String msg = "Could not add group store to partition - " + partitionSuffixDn;
            ApacheDirectoryPartitionManager.throwDirectoryServerException(msg, e);
        }
        catch (Exception e) {
            String msg = "Could not add group store to partition admin session. - " + partitionSuffixDn;
            ApacheDirectoryPartitionManager.throwDirectoryServerException(msg, e);
        }
    }

    private Partition getPartition(String partitionSuffix) {
        Set availablePartitions = this.directoryService.getPartitions();
        for (Object object : availablePartitions) {
            Partition partition = (Partition)object;
            if (!partition.getSuffix().equals(partitionSuffix)) continue;
            return partition;
        }
        return null;
    }

    private JdbmPartition createNewPartition(String partitionId, String partitionSuffix) throws DirectoryServerException {
        try {
            JdbmPartition partition = new JdbmPartition();
            String partitionDirectoryName = this.workingDirectory + File.separator + partitionId;
            File partitionDirectory = new File(partitionDirectoryName);
            partition.setId(partitionId);
            partition.setSuffix(partitionSuffix);
            partition.setPartitionDir(partitionDirectory);
            HashSet<JdbmIndex> indexedAttrs = new HashSet<JdbmIndex>();
            indexedAttrs.add(new JdbmIndex("1.3.6.1.4.1.18060.0.4.1.2.1"));
            indexedAttrs.add(new JdbmIndex("1.3.6.1.4.1.18060.0.4.1.2.2"));
            indexedAttrs.add(new JdbmIndex("1.3.6.1.4.1.18060.0.4.1.2.3"));
            indexedAttrs.add(new JdbmIndex("1.3.6.1.4.1.18060.0.4.1.2.4"));
            indexedAttrs.add(new JdbmIndex("1.3.6.1.4.1.18060.0.4.1.2.5"));
            indexedAttrs.add(new JdbmIndex("1.3.6.1.4.1.18060.0.4.1.2.6"));
            indexedAttrs.add(new JdbmIndex("1.3.6.1.4.1.18060.0.4.1.2.7"));
            indexedAttrs.add(new JdbmIndex("ou"));
            indexedAttrs.add(new JdbmIndex("dc"));
            indexedAttrs.add(new JdbmIndex("objectClass"));
            indexedAttrs.add(new JdbmIndex("cn"));
            indexedAttrs.add(new JdbmIndex("uid"));
            partition.setIndexedAttributes(indexedAttrs);
            String message = MessageFormat.format("Partition created with following attributes, partition id - {0}, Partition domain - {1}, Partition working directory {2}", partitionId, partitionSuffix, partitionDirectoryName);
            if (logger.isDebugEnabled()) {
                logger.debug(message);
            }
            return partition;
        }
        catch (LdapInvalidDnException e) {
            String msg = "Could not add a new partition with partition id " + partitionId + " and suffix " + partitionSuffix;
            logger.error(msg, (Throwable)e);
            throw new DirectoryServerException(msg, e);
        }
    }

    private void addAdminACLEntry(String adminUid, String tenantSuffix) throws DirectoryServerException {
        try {
            DN adminACLEntrydn = new DN("cn=adminACLEntry," + tenantSuffix);
            ServerEntry adminACLEntry = this.directoryService.newEntry(adminACLEntrydn);
            adminACLEntry.add("objectClass", new String[]{"accessControlSubentry", "subentry", "top"});
            adminACLEntry.add("cn", new String[]{"adminACLEntry"});
            String aclScript = "{ identificationTag \"adminACLEntryTag\", precedence 1, authenticationLevel simple, itemOrUserFirst userFirst: { userClasses { name { \"uid=" + adminUid + ",ou=Users," + tenantSuffix + "\" " + "}  " + "}, " + "userPermissions " + "{ " + "{ " + "protectedItems { entry, allUserAttributeTypesAndValues }, " + "grantsAndDenials { " + "grantBrowse, " + "grantFilterMatch, " + "grantModify, " + "grantAdd, " + "grantCompare, " + "grantRename, " + "grantRead, " + "grantReturnDN, " + "grantImport, " + "grantInvoke, " + "grantRemove, " + "grantExport, " + "grantDiscloseOnError " + "} " + "} " + "} " + "} " + "}";
            adminACLEntry.add("prescriptiveACI", new String[]{aclScript});
            adminACLEntry.add("subtreeSpecification", new String[]{"{ }"});
            this.directoryService.getAdminSession().add(adminACLEntry);
        }
        catch (LdapInvalidDnException e) {
            ApacheDirectoryPartitionManager.throwDirectoryServerException("Domain name invalid - cn=adminACLEntry," + tenantSuffix, e);
        }
        catch (LdapException e) {
            ApacheDirectoryPartitionManager.throwDirectoryServerException("Unable to create ACL entry for user " + adminUid, e);
        }
        catch (NamingException e) {
            ApacheDirectoryPartitionManager.throwDirectoryServerException("Invalid domain name entry - cn=adminACLEntry," + tenantSuffix, e);
        }
        catch (Exception e) {
            ApacheDirectoryPartitionManager.throwDirectoryServerException("Unable to add ACL entry for user - " + adminUid + " with DN - cn=adminACLEntry," + tenantSuffix, e);
        }
    }

    private void addAdminPassword(ServerEntry adminEntry, String password, PasswordAlgorithm algorithm, boolean kdcEnabled) throws DirectoryServerException {
        try {
            String passwordToStore = "{" + algorithm.getAlgorithmName() + "}";
            if (algorithm != PasswordAlgorithm.PLAIN_TEXT && !kdcEnabled) {
                MessageDigest md = MessageDigest.getInstance(algorithm.getAlgorithmName());
                md.update(password.getBytes());
                byte[] bytes = md.digest();
                String hash = Base64.encode((byte[])bytes);
                passwordToStore = passwordToStore + hash;
            } else {
                if (kdcEnabled) {
                    logger.warn("KDC enabled. Enforcing passwords to be plain text. Cause - KDC cannot operate with hashed passwords.");
                }
                passwordToStore = password;
            }
            adminEntry.put("userPassword", (byte[][])new byte[][]{passwordToStore.getBytes()});
        }
        catch (NoSuchAlgorithmException e) {
            ApacheDirectoryPartitionManager.throwDirectoryServerException("Could not find matching hash algorithm - " + algorithm.getAlgorithmName(), e);
        }
    }

    private void addAdminGroup(AdminInfo adminInfo, String partitionSuffix) throws DirectoryServerException {
        AdminGroupInfo groupInfo = adminInfo.getGroupInformation();
        String domainName = "";
        try {
            if (groupInfo != null) {
                domainName = groupInfo.getGroupNameAttribute() + "=" + groupInfo.getAdminRoleName() + "," + "ou=Groups," + partitionSuffix;
                DN adminGroup = new DN(domainName);
                ServerEntry adminGroupEntry = this.directoryService.newEntry(adminGroup);
                ApacheDirectoryPartitionManager.addObjectClasses(adminGroupEntry, groupInfo.getObjectClasses());
                adminGroupEntry.add(groupInfo.getGroupNameAttribute(), new String[]{groupInfo.getAdminRoleName()});
                adminGroupEntry.add(groupInfo.getMemberNameAttribute(), new String[]{"uid=" + adminInfo.getAdminUID() + "," + "ou=Users," + partitionSuffix});
                this.directoryService.getAdminSession().add(adminGroupEntry);
            }
        }
        catch (LdapInvalidDnException e) {
            String msg = "Domain name invalid " + domainName;
            ApacheDirectoryPartitionManager.throwDirectoryServerException(msg, e);
        }
        catch (LdapException e) {
            ApacheDirectoryPartitionManager.throwDirectoryServerException("Could not add group entry - " + domainName, e);
        }
        catch (NamingException e) {
            ApacheDirectoryPartitionManager.throwDirectoryServerException("Domain name invalid - " + domainName, e);
        }
        catch (Exception e) {
            ApacheDirectoryPartitionManager.throwDirectoryServerException("Could not add group entry to admin session. DN - " + domainName, e);
        }
    }

    private void addAdmin(AdminInfo adminInfo, String partitionSuffix, String realm, boolean kdcEnabled) throws DirectoryServerException {
        String domainName = "uid=" + adminInfo.getAdminUID() + "," + "ou=Users," + partitionSuffix;
        try {
            DN adminDn = new DN(domainName);
            ServerEntry adminEntry = this.directoryService.newEntry(adminDn);
            List<String> objectClasses = adminInfo.getObjectClasses();
            if (kdcEnabled) {
                objectClasses = new ArrayList<String>(adminInfo.getObjectClasses());
                objectClasses.add("krb5principal");
                objectClasses.add("krb5kdcentry");
            }
            ApacheDirectoryPartitionManager.addObjectClasses(adminEntry, objectClasses);
            adminEntry.add("uid", new String[]{adminInfo.getAdminUID()});
            adminEntry.add("sn", new String[]{adminInfo.getAdminLastName()});
            adminEntry.add("givenName", new String[]{adminInfo.getAdminCommonName()});
            adminEntry.add("cn", new String[]{adminInfo.getAdminUID()});
            adminEntry.add("mail", new String[]{adminInfo.getAdminEmail()});
            if (kdcEnabled) {
                String principal = adminInfo.getAdminUID() + "@" + realm;
                adminEntry.put("krb5PrincipalName", new String[]{principal});
                adminEntry.put("krb5KeyVersionNumber", new String[]{"0"});
            }
            this.addAdminPassword(adminEntry, adminInfo.getAdminPassword(), adminInfo.getPasswordAlgorithm(), kdcEnabled);
            this.directoryService.getAdminSession().add(adminEntry);
        }
        catch (LdapInvalidDnException e) {
            ApacheDirectoryPartitionManager.throwDirectoryServerException("Domain name invalid " + domainName, e);
        }
        catch (LdapException e) {
            ApacheDirectoryPartitionManager.throwDirectoryServerException("Could not add entry to partition. DN - " + domainName, e);
        }
        catch (NamingException e) {
            ApacheDirectoryPartitionManager.throwDirectoryServerException("Domain name invalid - " + domainName, e);
        }
        catch (Exception e) {
            ApacheDirectoryPartitionManager.throwDirectoryServerException("Could not add group entry to admin session. DN - " + domainName, e);
        }
    }
}

