/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.io.InputStream;
import java.util.Properties;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.codec.stateful.DecoderCallback;
import org.apache.directory.shared.asn1.codec.stateful.DecoderMonitor;
import org.apache.directory.shared.asn1.codec.stateful.StatefulDecoder;
import org.apache.directory.shared.ldap.codec.LdapTransformer;
import org.apache.directory.shared.ldap.codec.ResponseCarryingException;
import org.apache.directory.shared.ldap.message.MessageException;
import org.apache.directory.shared.ldap.message.ResponseCarryingMessageException;
import org.apache.directory.shared.ldap.message.spi.BinaryAttributeDetector;
import org.apache.directory.shared.ldap.message.spi.Provider;
import org.apache.directory.shared.ldap.message.spi.ProviderDecoder;

public final class MessageDecoder
implements ProviderDecoder {
    private final Provider provider;
    private final ProviderDecoder decoder;
    private DecoderCallback cb;

    public MessageDecoder(BinaryAttributeDetector binaryAttributeDetector) throws MessageException {
        this(binaryAttributeDetector, Integer.MAX_VALUE);
    }

    public MessageDecoder(BinaryAttributeDetector binaryAttributeDetector, int maxPDUSize) throws MessageException {
        Properties providerEnv = Provider.getEnvironment();
        this.provider = Provider.getProvider(providerEnv);
        this.decoder = this.provider.getDecoder(binaryAttributeDetector, maxPDUSize);
        this.decoder.setCallback(new DecoderCallback(){

            public void decodeOccurred(StatefulDecoder decoder, Object decoded) {
                if (decoded instanceof Asn1Object) {
                    MessageDecoder.this.cb.decodeOccurred(decoder, (Object)LdapTransformer.transform((Object)decoded));
                } else {
                    MessageDecoder.this.cb.decodeOccurred(decoder, decoded);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(Object lock, InputStream in) throws MessageException {
        Object providerEnvelope;
        block6: {
            try {
                if (lock == null) {
                    providerEnvelope = this.decoder.decode(lock, in);
                    break block6;
                }
                Object object = lock;
                synchronized (object) {
                    providerEnvelope = this.decoder.decode(lock, in);
                    lock.notifyAll();
                }
            }
            catch (Exception e) {
                throw (MessageException)((Object)e);
            }
        }
        return LdapTransformer.transform((Object)providerEnvelope);
    }

    public void decode(Object chunk) throws MessageException {
        try {
            this.decoder.decode(chunk);
        }
        catch (DecoderException e) {
            if (e instanceof ResponseCarryingException) {
                ResponseCarryingMessageException rcme = new ResponseCarryingMessageException(e.getMessage());
                rcme.setResponse(((ResponseCarryingException)e).getResponse());
                throw rcme;
            }
            throw new ResponseCarryingMessageException(e.getMessage());
        }
    }

    public void setCallback(DecoderCallback cb) {
        this.cb = cb;
    }

    public void setDecoderMonitor(DecoderMonitor monitor) {
        this.decoder.setDecoderMonitor(monitor);
    }

    public Provider getProvider() {
        return this.provider;
    }
}

