/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.extended;

import java.security.KeyStore;
import java.security.KeyStoreSpi;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.directory.server.core.security.CoreKeyStoreSpi;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.shared.ldap.message.ExtendedResponseImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.internal.InternalExtendedRequest;
import org.apache.directory.shared.ldap.message.internal.InternalLdapResult;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.filter.ssl.SslFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartTlsHandler
implements ExtendedOperationHandler {
    public static final String EXTENSION_OID = "1.3.6.1.4.1.1466.20037";
    private static final Set<String> EXTENSION_OIDS;
    private static final Logger LOG;
    private SSLContext sslContext;

    @Override
    public void handleExtendedOperation(LdapSession session, InternalExtendedRequest req) throws Exception {
        LOG.info("Handling StartTLS request.");
        IoFilterChain chain = session.getIoSession().getFilterChain();
        SslFilter sslFilter = (SslFilter)chain.get("sslFilter");
        if (sslFilter == null) {
            sslFilter = new SslFilter(this.sslContext);
            chain.addFirst("sslFilter", (IoFilter)sslFilter);
        } else {
            sslFilter.startSsl(session.getIoSession());
        }
        ExtendedResponseImpl res = new ExtendedResponseImpl(req.getMessageId());
        InternalLdapResult result = res.getLdapResult();
        result.setResultCode(ResultCodeEnum.SUCCESS);
        res.setResponseName(EXTENSION_OID);
        res.setResponse(new byte[0]);
        session.getIoSession().setAttribute((Object)SslFilter.DISABLE_ENCRYPTION_ONCE);
        session.getIoSession().write((Object)res);
    }

    @Override
    public final Set<String> getExtensionOids() {
        return EXTENSION_OIDS;
    }

    @Override
    public final String getOid() {
        return EXTENSION_OID;
    }

    @Override
    public void setLdapServer(LdapServer ldapServer) {
        LOG.debug("Setting LDAP Service");
        Provider provider = Security.getProvider("SUN");
        LOG.debug("provider = {}", (Object)provider);
        CoreKeyStoreSpi coreKeyStoreSpi = new CoreKeyStoreSpi(ldapServer.getDirectoryService());
        KeyStore keyStore = new KeyStore((KeyStoreSpi)coreKeyStoreSpi, provider, "JKS"){};
        try {
            keyStore.load(null, null);
        }
        catch (Exception e1) {
            throw new RuntimeException(I18n.err(I18n.ERR_678, new Object[0]));
        }
        KeyManagerFactory keyManagerFactory = null;
        try {
            keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        }
        catch (Exception e) {
            throw new RuntimeException(I18n.err(I18n.ERR_679, new Object[0]), e);
        }
        try {
            keyManagerFactory.init(keyStore, null);
        }
        catch (Exception e) {
            throw new RuntimeException(I18n.err(I18n.ERR_680, new Object[0]), e);
        }
        try {
            this.sslContext = SSLContext.getInstance("TLS");
        }
        catch (Exception e) {
            throw new RuntimeException(I18n.err(I18n.ERR_681, new Object[0]), e);
        }
        try {
            this.sslContext.init(keyManagerFactory.getKeyManagers(), new TrustManager[]{new ServerX509TrustManager()}, new SecureRandom());
        }
        catch (Exception e) {
            throw new RuntimeException(I18n.err(I18n.ERR_682, new Object[0]), e);
        }
    }

    static {
        LOG = LoggerFactory.getLogger(StartTlsHandler.class);
        HashSet<String> set = new HashSet<String>(3);
        set.add(EXTENSION_OID);
        EXTENSION_OIDS = Collections.unmodifiableSet(set);
    }

    class ServerX509TrustManager
    implements X509TrustManager {
        ServerX509TrustManager() {
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            LOG.debug("checkClientTrusted() called");
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            LOG.debug("checkServerTrusted() called");
        }

        public X509Certificate[] getAcceptedIssuers() {
            LOG.debug("getAcceptedIssuers() called");
            return new X509Certificate[0];
        }
    }
}

