/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.KerberosUtils;
import org.apache.directory.server.kerberos.shared.messages.value.types.PrincipalNameType;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrincipalName
extends AbstractAsn1Object {
    private static final Logger LOG = LoggerFactory.getLogger(PrincipalName.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private PrincipalNameType nameType;
    private List<String> nameString;
    private transient List<byte[]> nameBytes;
    private transient int principalNameSeqLength;
    private transient int principalTypeTagLength;
    private transient int principalTypeLength;
    private transient int principalStringsTagLength;
    private transient int principalStringsSeqLength;

    public PrincipalName() {
    }

    public PrincipalName(KerberosPrincipal principal) {
        try {
            this.nameString = KerberosUtils.getNames(principal);
        }
        catch (ParseException pe) {
            this.nameString = KerberosUtils.EMPTY_PRINCIPAL_NAME;
        }
        this.nameType = PrincipalNameType.getTypeByOrdinal(principal.getNameType());
    }

    public PrincipalName(String nameString, PrincipalNameType nameType) throws ParseException {
        this.nameString = KerberosUtils.getNames(nameString);
        this.nameType = nameType;
    }

    public PrincipalName(String nameString, int nameType) throws ParseException {
        this.nameString = KerberosUtils.getNames(nameString);
        this.nameType = PrincipalNameType.getTypeByOrdinal(nameType);
    }

    public PrincipalNameType getNameType() {
        return this.nameType;
    }

    public void setNameType(PrincipalNameType nameType) {
        this.nameType = nameType;
    }

    public void setNameType(int nameType) {
        this.nameType = PrincipalNameType.getTypeByOrdinal(nameType);
    }

    public List<String> getNames() {
        return this.nameString;
    }

    public String getNameString() {
        if (this.nameString == null || this.nameString.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String name : this.nameString) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append('/');
            }
            sb.append(name);
        }
        return sb.toString();
    }

    public void addName(String name) {
        if (this.nameString == null) {
            this.nameString = new ArrayList<String>();
        }
        this.nameString.add(name);
    }

    public int computeLength() {
        this.principalTypeLength = Value.getNbBytes((int)this.nameType.getOrdinal());
        this.principalTypeTagLength = 1 + TLV.getNbBytes((int)this.principalTypeLength) + this.principalTypeLength;
        this.principalNameSeqLength = 1 + TLV.getNbBytes((int)this.principalTypeTagLength) + this.principalTypeTagLength;
        if (this.nameString == null || this.nameString.size() == 0) {
            this.principalStringsSeqLength = 0;
        } else {
            this.principalStringsSeqLength = 0;
            this.nameBytes = new ArrayList<byte[]>(this.nameString.size());
            for (String name : this.nameString) {
                if (name != null) {
                    byte[] bytes = StringTools.getBytesUtf8(name);
                    this.nameBytes.add(bytes);
                    this.principalStringsSeqLength += 1 + TLV.getNbBytes((int)bytes.length) + bytes.length;
                    continue;
                }
                this.nameBytes.add(StringTools.EMPTY_BYTES);
                this.principalStringsSeqLength += 2;
            }
        }
        this.principalStringsTagLength = 1 + TLV.getNbBytes((int)this.principalStringsSeqLength) + this.principalStringsSeqLength;
        this.principalNameSeqLength += 1 + TLV.getNbBytes((int)this.principalStringsTagLength) + this.principalStringsTagLength;
        return 1 + TLV.getNbBytes((int)this.principalNameSeqLength) + this.principalNameSeqLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_148, new Object[0]));
        }
        try {
            buffer.put((byte)48);
            buffer.put(TLV.getBytes((int)this.principalNameSeqLength));
            buffer.put((byte)-96);
            buffer.put(TLV.getBytes((int)this.principalTypeTagLength));
            Value.encode((ByteBuffer)buffer, (int)this.nameType.getOrdinal());
            buffer.put((byte)-95);
            buffer.put(TLV.getBytes((int)this.principalStringsTagLength));
            buffer.put((byte)48);
            if (this.nameString == null || this.nameString.size() == 0) {
                buffer.put((byte)0);
            } else {
                buffer.put(TLV.getBytes((int)this.principalStringsSeqLength));
                for (byte[] name : this.nameBytes) {
                    buffer.put((byte)27);
                    if (name == null || name.length == 0) {
                        buffer.put((byte)0);
                        continue;
                    }
                    buffer.put(TLV.getBytes((int)name.length));
                    buffer.put(name);
                }
            }
        }
        catch (BufferOverflowException boe) {
            LOG.error(I18n.err(I18n.ERR_146, 1 + TLV.getNbBytes((int)this.principalNameSeqLength) + this.principalNameSeqLength, buffer.capacity()));
            throw new EncoderException(I18n.err(I18n.ERR_138, new Object[0]));
        }
        if (IS_DEBUG) {
            LOG.debug("PrinipalName encoding : {}", (Object)StringTools.dumpBytes(buffer.array()));
            LOG.debug("PrinipalName initial value : {}", (Object)this.toString());
        }
        return buffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PincipalName : {\n");
        sb.append("    name-type: ").append((Object)this.nameType).append('\n');
        if (this.nameString != null && this.nameString.size() != 0) {
            sb.append("    name-string : <");
            boolean isFirst = true;
            for (String name : this.nameString) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append('\'').append(name).append('\'');
            }
            sb.append(">\n}");
        } else {
            sb.append("    no name-string\n}");
        }
        return sb.toString();
    }
}

