/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.util.Hashtable;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.jndi.ServerContext;
import org.apache.directory.server.core.jndi.ServerDirContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.entry.BinaryValue;
import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.jndi.JndiUtils;
import org.apache.directory.shared.ldap.message.control.Control;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerLdapContext
extends ServerDirContext
implements LdapContext {
    public ServerLdapContext(DirectoryService service, Hashtable<String, Object> env) throws Exception {
        super(service, env);
    }

    public ServerLdapContext(DirectoryService service, LdapPrincipal principal, Name dn) throws Exception {
        super(service, principal, dn);
    }

    public ServerLdapContext(DirectoryService service, CoreSession session, Name bindDn) throws Exception {
        super(service, session, bindDn);
    }

    @Override
    public ExtendedResponse extendedOperation(ExtendedRequest request) {
        throw new NotImplementedException();
    }

    @Override
    public LdapContext newInstance(javax.naming.ldap.Control[] requestControls) throws NamingException {
        ServerLdapContext ctx = null;
        try {
            ctx = new ServerLdapContext(this.getService(), this.getSession().getEffectivePrincipal(), DN.toName(this.getDn()));
        }
        catch (Exception e) {
            JndiUtils.wrap((Throwable)e);
        }
        ctx.setRequestControls(requestControls);
        return ctx;
    }

    @Override
    public void reconnect(javax.naming.ldap.Control[] connCtls) throws NamingException {
        this.connectControls = connCtls;
    }

    @Override
    public javax.naming.ldap.Control[] getConnectControls() throws NamingException {
        return this.connectControls;
    }

    @Override
    public void setRequestControls(javax.naming.ldap.Control[] requestControls) throws NamingException {
        this.requestControls = requestControls;
    }

    @Override
    public javax.naming.ldap.Control[] getRequestControls() throws NamingException {
        return this.requestControls;
    }

    @Override
    public javax.naming.ldap.Control[] getResponseControls() throws NamingException {
        return this.responseControls;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean compare(DN name, String oid, Object value) throws NamingException {
        void var4_9;
        Object var4_4 = null;
        AttributeType attributeType = null;
        try {
            attributeType = this.getService().getSchemaManager().lookupAttributeTypeRegistry(oid);
        }
        catch (LdapException le) {
            throw new InvalidAttributeIdentifierException(le.getMessage());
        }
        if (attributeType.getSyntax().isHumanReadable()) {
            if (value instanceof String) {
                StringValue stringValue = new StringValue(attributeType, (String)value);
            } else {
                if (!(value instanceof byte[])) throw new NamingException(I18n.err(I18n.ERR_309, oid));
                StringValue stringValue = new StringValue(attributeType, StringTools.utf8ToString((byte[])value));
            }
        } else if (value instanceof String) {
            BinaryValue binaryValue = new BinaryValue(attributeType, StringTools.getBytesUtf8((String)value));
        } else {
            if (!(value instanceof byte[])) throw new NamingException(I18n.err(I18n.ERR_309, oid));
            BinaryValue binaryValue = new BinaryValue(attributeType, (byte[])value);
        }
        CompareOperationContext opCtx = new CompareOperationContext(this.getSession(), name, oid, (Value)var4_9);
        opCtx.addRequestControls(JndiUtils.fromJndiControls((javax.naming.ldap.Control[])this.requestControls));
        this.injectReferralControl((OperationContext)opCtx);
        boolean result = false;
        try {
            result = super.getDirectoryService().getOperationManager().compare(opCtx);
        }
        catch (Exception e) {
            JndiUtils.wrap((Throwable)e);
        }
        this.responseControls = this.getResponseControls();
        this.requestControls = EMPTY_CONTROLS;
        return result;
    }

    public void ldapUnbind() throws NamingException {
        UnbindOperationContext opCtx = new UnbindOperationContext(this.getSession());
        opCtx.addRequestControls(JndiUtils.fromJndiControls((javax.naming.ldap.Control[])this.requestControls));
        try {
            super.getDirectoryService().getOperationManager().unbind(opCtx);
        }
        catch (Exception e) {
            JndiUtils.wrap((Throwable)e);
        }
        this.responseControls = JndiUtils.toJndiControls((Control[])opCtx.getResponseControls());
        this.requestControls = EMPTY_CONTROLS;
    }

    @Override
    public ServerContext getRootContext() throws NamingException {
        ServerLdapContext ctx = null;
        try {
            ctx = new ServerLdapContext(this.getService(), this.getSession().getEffectivePrincipal(), (Name)new LdapName(""));
        }
        catch (Exception e) {
            JndiUtils.wrap((Throwable)e);
        }
        return ctx;
    }
}

