/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.changelog;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.changelog.ChangeLogEvent;
import org.apache.directory.server.core.changelog.Tag;
import org.apache.directory.server.core.changelog.TaggableChangeLogStore;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.cursor.Cursor;
import org.apache.directory.shared.ldap.cursor.ListCursor;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.util.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryChangeLogStore
implements TaggableChangeLogStore {
    private static final String REV_FILE = "revision";
    private static final String TAG_FILE = "tags";
    private static final String CHANGELOG_FILE = "changelog.dat";
    private long currentRevision;
    private Tag latest;
    private final Map<Long, Tag> tags = new HashMap<Long, Tag>(100);
    private final List<ChangeLogEvent> events = new ArrayList<ChangeLogEvent>();
    private File workingDirectory;

    @Override
    public Tag tag(long revision) throws Exception {
        if (this.tags.containsKey(revision)) {
            return this.tags.get(revision);
        }
        this.latest = new Tag(revision, null);
        this.tags.put(revision, this.latest);
        return this.latest;
    }

    @Override
    public Tag tag() throws Exception {
        if (this.latest != null && this.latest.getRevision() == this.currentRevision) {
            return this.latest;
        }
        this.latest = new Tag(this.currentRevision, null);
        this.tags.put(this.currentRevision, this.latest);
        return this.latest;
    }

    @Override
    public Tag tag(String description) throws Exception {
        if (this.latest != null && this.latest.getRevision() == this.currentRevision) {
            return this.latest;
        }
        this.latest = new Tag(this.currentRevision, description);
        this.tags.put(this.currentRevision, this.latest);
        return this.latest;
    }

    @Override
    public void init(DirectoryService service) throws Exception {
        this.workingDirectory = service.getWorkingDirectory();
        this.loadRevision();
        this.loadTags();
        this.loadChangeLog();
    }

    private void loadRevision() throws Exception {
        File revFile = new File(this.workingDirectory, REV_FILE);
        if (revFile.exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(revFile));
                String line = reader.readLine();
                this.currentRevision = Long.valueOf(line);
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private void saveRevision() throws Exception {
        File revFile = new File(this.workingDirectory, REV_FILE);
        if (revFile.exists()) {
            revFile.delete();
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(revFile));
            out.println(this.currentRevision);
            out.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void saveTags() throws Exception {
        File tagFile = new File(this.workingDirectory, TAG_FILE);
        if (tagFile.exists()) {
            tagFile.delete();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(tagFile);
            Properties props = new Properties();
            for (Tag tag : this.tags.values()) {
                String key = String.valueOf(tag.getRevision());
                if (tag.getDescription() == null) {
                    props.setProperty(key, "null");
                    continue;
                }
                props.setProperty(key, tag.getDescription());
            }
            props.store(out, null);
            out.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void loadTags() throws Exception {
        File revFile = new File(this.workingDirectory, REV_FILE);
        if (revFile.exists()) {
            Properties props = new Properties();
            FileInputStream in = null;
            try {
                in = new FileInputStream(revFile);
                props.load(in);
                ArrayList<Long> revList = new ArrayList<Long>();
                for (Object key : props.keySet()) {
                    revList.add(Long.valueOf((String)key));
                }
                Collections.sort(revList);
                Tag tag = null;
                this.tags.clear();
                for (Long lkey : revList) {
                    String rev = String.valueOf(lkey);
                    String desc = props.getProperty(rev);
                    tag = desc != null && desc.equals("null") ? new Tag(lkey, null) : new Tag(lkey, desc);
                    this.tags.put(lkey, tag);
                }
                this.latest = tag;
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private void loadChangeLog() throws Exception {
        File file = new File(this.workingDirectory, CHANGELOG_FILE);
        if (file.exists()) {
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(new FileInputStream(file));
                int size = in.readInt();
                ArrayList<ChangeLogEvent> changeLogEvents = new ArrayList<ChangeLogEvent>(size);
                for (int i = 0; i < size; ++i) {
                    ChangeLogEvent event = (ChangeLogEvent)in.readObject();
                    changeLogEvents.add(event);
                }
                this.events.clear();
                this.events.addAll(changeLogEvents);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private void saveChangeLog() throws Exception {
        File file = new File(this.workingDirectory, CHANGELOG_FILE);
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(file));
            out.writeInt(this.events.size());
            for (ChangeLogEvent event : this.events) {
                out.writeObject(event);
            }
            out.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public void sync() throws Exception {
        this.saveRevision();
        this.saveTags();
        this.saveChangeLog();
    }

    @Override
    public void destroy() throws Exception {
        this.saveRevision();
        this.saveTags();
        this.saveChangeLog();
    }

    @Override
    public long getCurrentRevision() {
        return this.currentRevision;
    }

    @Override
    public ChangeLogEvent log(LdapPrincipal principal, LdifEntry forward, LdifEntry reverse) throws Exception {
        ++this.currentRevision;
        ChangeLogEvent event = new ChangeLogEvent(this.currentRevision, DateUtils.getGeneralizedTime(), principal, forward, reverse);
        this.events.add(event);
        return event;
    }

    @Override
    public ChangeLogEvent log(LdapPrincipal principal, LdifEntry forward, List<LdifEntry> reverses) throws Exception {
        ++this.currentRevision;
        ChangeLogEvent event = new ChangeLogEvent(this.currentRevision, DateUtils.getGeneralizedTime(), principal, forward, reverses);
        this.events.add(event);
        return event;
    }

    @Override
    public ChangeLogEvent lookup(long revision) throws Exception {
        if (revision < 0L) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_239, new Object[0]));
        }
        if (revision > this.getCurrentRevision()) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_240, new Object[0]));
        }
        return this.events.get((int)revision);
    }

    @Override
    public Cursor<ChangeLogEvent> find() throws Exception {
        return new ListCursor(this.events);
    }

    @Override
    public Cursor<ChangeLogEvent> findBefore(long revision) throws Exception {
        return new ListCursor(this.events, (int)revision);
    }

    @Override
    public Cursor<ChangeLogEvent> findAfter(long revision) throws Exception {
        return new ListCursor((int)revision, this.events);
    }

    @Override
    public Cursor<ChangeLogEvent> find(long startRevision, long endRevision) throws Exception {
        return new ListCursor((int)startRevision, this.events, (int)(endRevision + 1L));
    }

    @Override
    public Tag getLatest() throws Exception {
        return this.latest;
    }

    @Override
    public Tag removeTag(long revision) throws Exception {
        return this.tags.remove(revision);
    }

    @Override
    public Tag tag(long revision, String descrition) throws Exception {
        if (this.tags.containsKey(revision)) {
            return this.tags.get(revision);
        }
        this.latest = new Tag(revision, descrition);
        this.tags.put(revision, this.latest);
        return this.latest;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MemoryChangeLog\n");
        sb.append("latest tag : ").append(this.latest).append('\n');
        if (this.events != null) {
            sb.append("Nb of events : ").append(this.events.size()).append('\n');
            int i = 0;
            for (ChangeLogEvent event : this.events) {
                sb.append("event[").append(i++).append("] : ");
                sb.append("\n---------------------------------------\n");
                sb.append(event);
                sb.append("\n---------------------------------------\n");
            }
        }
        return sb.toString();
    }
}

