/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.lb.endpoint.endpoint;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.clustering.management.DefaultGroupManagementAgent;
import org.apache.axis2.clustering.management.GroupManagementAgent;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.endpoints.utils.LoadbalanceAlgorithmFactory;
import org.apache.synapse.core.LoadBalanceMembershipHandler;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.endpoints.DynamicLoadbalanceEndpoint;
import org.apache.synapse.endpoints.DynamicLoadbalanceFaultHandler;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;
import org.apache.synapse.endpoints.dispatch.Dispatcher;
import org.apache.synapse.endpoints.dispatch.HttpSessionDispatcher;
import org.apache.synapse.endpoints.dispatch.SALSessions;
import org.apache.synapse.endpoints.dispatch.SessionInformation;
import org.wso2.carbon.lb.common.conf.LoadBalancerConfiguration;
import org.wso2.carbon.lb.common.conf.util.TenantDomainRangeContext;
import org.wso2.carbon.lb.endpoint.TenantLoadBalanceMembershipHandler;
import org.wso2.carbon.lb.endpoint.util.ConfigHolder;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;

public class TenantAwareLoadBalanceEndpoint
extends DynamicLoadbalanceEndpoint
implements Serializable {
    private static final long serialVersionUID = 1577351815951789938L;
    private static final Log log = LogFactory.getLog(TenantAwareLoadBalanceEndpoint.class);
    private String algorithm;
    private String configuration;
    private String failOver;
    private TenantLoadBalanceMembershipHandler tlbMembershipHandler;
    private Map<String, TenantDomainRangeContext> hostDomainMap;
    private LoadBalancerConfiguration lbConfig;

    public void init(SynapseEnvironment synapseEnvironment) {
        try {
            String configURL = System.getProperty("loadbalancer.conf");
            this.lbConfig = new LoadBalancerConfiguration();
            this.lbConfig.init(configURL);
            this.hostDomainMap = this.lbConfig.getHostDomainMap();
        }
        catch (Exception e) {
            log.error((Object)("Error While reading Load Balancer configuration file" + e.toString()));
        }
        LoadbalanceAlgorithm algorithm = null;
        try {
            OMElement payload = AXIOMUtil.stringToOM((String)this.generatePayLoad());
            algorithm = LoadbalanceAlgorithmFactory.createLoadbalanceAlgorithm((OMElement)payload, null);
        }
        catch (Exception e) {
            log.error((Object)("Error While creating Load balance algorithm" + e.toString()));
        }
        if (!this.initialized) {
            SALSessions salSessions;
            super.init(synapseEnvironment);
            ConfigurationContext cfgCtx = ((Axis2SynapseEnvironment)synapseEnvironment).getAxis2ConfigurationContext();
            ClusteringAgent clusteringAgent = cfgCtx.getAxisConfiguration().getClusteringAgent();
            if (clusteringAgent == null) {
                throw new SynapseException("Axis2 ClusteringAgent not defined in axis2.xml");
            }
            if (this.hostDomainMap != null) {
                for (TenantDomainRangeContext tenantDomainRangeContext : this.hostDomainMap.values()) {
                    for (String domain : tenantDomainRangeContext.getTenantDomainRangeContextMap().keySet()) {
                        if (clusteringAgent.getGroupManagementAgent(domain) != null) continue;
                        clusteringAgent.addGroupManagementAgent((GroupManagementAgent)new DefaultGroupManagementAgent(), domain);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Group management agent added to cluster domain " + domain));
                    }
                }
                this.tlbMembershipHandler = new TenantLoadBalanceMembershipHandler(this.hostDomainMap, algorithm, cfgCtx, this.isClusteringEnabled, this.getName());
            }
            if (!(salSessions = SALSessions.getInstance()).isInitialized()) {
                salSessions.initialize(this.isClusteringEnabled.booleanValue(), cfgCtx);
            }
            this.setSessionAffinity(true);
            this.setDispatcher((Dispatcher)new HttpSessionDispatcher());
            this.initialized = true;
            log.info((Object)"===== Tenant Aware Load Balance Endpoint initialized =====");
        }
    }

    public void setConfiguration(String paramEle) {
        this.configuration = paramEle;
        System.out.print(paramEle.toString());
        CarbonUtils.getCarbonHome();
    }

    public void setAlgorithm(String paramEle) {
        this.algorithm = paramEle;
        System.out.print(paramEle.toString());
    }

    public void setFailOver(String paramEle) {
        this.failOver = paramEle;
        System.out.print(paramEle.toString());
    }

    private String generatePayLoad() {
        return " <serviceDynamicLoadbalance failover=\"true\"\n                                           algorithm=\"org.apache.synapse.endpoints.algorithms.RoundRobin\"/>";
    }

    public LoadBalanceMembershipHandler getLbMembershipHandler() {
        return this.tlbMembershipHandler;
    }

    public void send(org.apache.synapse.MessageContext synCtx) {
        int tenantId = this.getTenantId(synCtx.getTo().toString());
        Member currentMember = null;
        SessionInformation sessionInformation = null;
        if (this.isSessionAffinityBasedLB()) {
            sessionInformation = (SessionInformation)synCtx.getProperty("synapse.sal.endpoint.current.sessioninformation");
            currentMember = (Member)synCtx.getProperty("synapse.sal.current.member");
            if (sessionInformation == null && currentMember == null && (sessionInformation = this.dispatcher.getSession(synCtx)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Current session id : " + sessionInformation.getId()));
                }
                currentMember = sessionInformation.getMember();
                synCtx.setProperty("synapse.sal.current.member", (Object)currentMember);
                synCtx.setProperty("synapse.sal.endpoint.current.sessioninformation", (Object)sessionInformation);
            }
        }
        String targetHost = this.getTargetHost(synCtx);
        ConfigurationContext configCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getConfigurationContext();
        if (this.tlbMembershipHandler.getConfigurationContext() == null) {
            this.tlbMembershipHandler.setConfigurationContext(configCtx);
        }
        TenantDynamicLoadBalanceFaultHandlerImpl faultHandler = new TenantDynamicLoadBalanceFaultHandlerImpl();
        faultHandler.setHost(targetHost);
        if (sessionInformation != null && currentMember != null) {
            sessionInformation.updateExpiryTime();
            this.sendToApplicationMember(synCtx, currentMember, faultHandler, false);
        } else {
            currentMember = this.tlbMembershipHandler.getNextApplicationMember(targetHost, tenantId);
            if (currentMember == null) {
                String msg = "No application members available";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            this.sendToApplicationMember(synCtx, currentMember, faultHandler, true);
        }
    }

    public Map<String, TenantDomainRangeContext> getHostDomainMap() {
        return Collections.unmodifiableMap(this.hostDomainMap);
    }

    private int getTenantId(String url) {
        int domainNameEndIndex;
        int domainNameStartIndex;
        String domainName;
        String servicesPrefix = "/t/";
        if (url != null && url.contains(servicesPrefix) && (domainName = url.substring(domainNameStartIndex, (domainNameEndIndex = url.indexOf(47, domainNameStartIndex = url.indexOf(servicesPrefix) + servicesPrefix.length())) == -1 ? url.length() : domainNameEndIndex)) != null) {
            try {
                return ConfigHolder.getInstance().getRealmService().getTenantManager().getTenantId(domainName);
            }
            catch (UserStoreException e) {
                log.error((Object)"An error occurred while obtaining the tenant id.", (Throwable)e);
            }
        }
        return 0;
    }

    private String getTargetHost(org.apache.synapse.MessageContext synCtx) {
        MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Map headers = (Map)axis2MessageContext.getProperty("TRANSPORT_HEADERS");
        String address = (String)headers.get("Host");
        synCtx.setProperty("LB_REQUEST_HOST", (Object)address);
        if (address.contains(":")) {
            address = address.substring(0, address.indexOf(":"));
        }
        return address;
    }

    private class TenantDynamicLoadBalanceFaultHandlerImpl
    extends DynamicLoadbalanceFaultHandler {
        private EndpointReference to;
        private Member currentMember;
        private Endpoint currentEp;
        private String host;
        private static final int MAX_RETRY_COUNT = 5;
        private ThreadLocal<Integer> callCount = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };

        public void setHost(String host) {
            this.host = host;
        }

        public void setCurrentMember(Member currentMember) {
            this.currentMember = currentMember;
        }

        public void setTo(EndpointReference to) {
            this.to = to;
        }

        private TenantDynamicLoadBalanceFaultHandlerImpl() {
        }

        public void onFault(org.apache.synapse.MessageContext synCtx) {
            Integer errorCode;
            if (this.currentMember == null) {
                return;
            }
            this.currentMember.suspend(10000L);
            log.info((Object)("Suspended member " + this.currentMember + " for 10s"));
            this.callCount.set(this.callCount.get() + 1);
            if (this.callCount.get() >= 5) {
                return;
            }
            if (this.currentEp != null) {
                this.currentEp.destroy();
            }
            if ((errorCode = (Integer)synCtx.getProperty("ERROR_CODE")) != null) {
                if (errorCode.equals(101503) || errorCode.equals(101507) || errorCode.equals(101508)) {
                    Set pros;
                    Member newMember = TenantAwareLoadBalanceEndpoint.this.tlbMembershipHandler.getNextApplicationMember(this.host, TenantAwareLoadBalanceEndpoint.this.getTenantId(synCtx.toString()));
                    if (newMember == null) {
                        String msg = "No application members available";
                        log.error((Object)msg);
                        throw new SynapseException(msg);
                    }
                    log.info((Object)("Failed over to " + newMember));
                    synCtx.setTo(this.to);
                    if (TenantAwareLoadBalanceEndpoint.this.isSessionAffinityBasedLB() && (pros = synCtx.getPropertyKeySet()) != null) {
                        pros.remove("synapse.sal.endpoint.current.sessioninformation");
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                    TenantAwareLoadBalanceEndpoint.this.sendToApplicationMember(synCtx, newMember, this, true);
                } else if (errorCode.equals(101500) || errorCode.equals(101505)) {
                    // empty if block
                }
            }
        }

        public void setCurrentEp(Endpoint currentEp) {
            this.currentEp = currentEp;
        }
    }
}

