/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.lb.endpoint;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.clustering.management.GroupManagementAgent;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.LoadBalanceMembershipHandler;
import org.apache.synapse.endpoints.algorithms.AlgorithmContext;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;
import org.wso2.carbon.lb.common.conf.util.TenantDomainRangeContext;

public class TenantLoadBalanceMembershipHandler
implements LoadBalanceMembershipHandler {
    private static final Log log = LogFactory.getLog(TenantLoadBalanceMembershipHandler.class);
    private ConfigurationContext configCtx;
    private LoadbalanceAlgorithm lbAlgo;
    private static Map<String, DomainAlgorithmContext> hostDomainAlgorithmContextMap = new HashMap<String, DomainAlgorithmContext>();
    private ClusteringAgent clusteringAgent;

    public TenantLoadBalanceMembershipHandler(Map<String, TenantDomainRangeContext> hostDomainMap, LoadbalanceAlgorithm algorithm, ConfigurationContext configCtx, boolean isClusteringEnabled, String endpointName) {
        this.lbAlgo = algorithm;
        for (Map.Entry<String, TenantDomainRangeContext> entry : hostDomainMap.entrySet()) {
            AlgorithmContext algorithmContext = new AlgorithmContext(isClusteringEnabled, configCtx, endpointName + "." + entry.getKey());
            hostDomainAlgorithmContextMap.put(entry.getKey(), new DomainAlgorithmContext(entry.getValue(), algorithm.clone(), algorithmContext));
        }
    }

    public void init(Properties props, LoadbalanceAlgorithm algorithm) {
    }

    public void setConfigurationContext(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
        this.clusteringAgent = configCtx.getAxisConfiguration().getClusteringAgent();
        if (this.clusteringAgent == null) {
            String msg = "In order to enable load balancing across an Axis2 cluster, the cluster entry should be enabled in the axis2.xml file";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configCtx;
    }

    public Member getNextApplicationMember(AlgorithmContext context) {
        throw new UnsupportedOperationException("This operation is invalid. Call getNextApplicationMember(String host)");
    }

    public Member getNextApplicationMember(String host, int tenantId) {
        DomainAlgorithmContext domainAlgorithmContext = this.getDomainAlgorithmContext(host);
        String lbDomain = domainAlgorithmContext.getDomain(tenantId);
        LoadbalanceAlgorithm algorithm = domainAlgorithmContext.getAlgorithm();
        GroupManagementAgent groupMgtAgent = this.clusteringAgent.getGroupManagementAgent(lbDomain);
        if (groupMgtAgent == null) {
            String msg = "A LoadBalanceEventHandler has not been specified in the axis2.xml file for the domain " + lbDomain + " for host " + host;
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        algorithm.setApplicationMembers(groupMgtAgent.getMembers());
        AlgorithmContext context = domainAlgorithmContext.getAlgorithmContext();
        return algorithm.getNextApplicationMember(context);
    }

    private DomainAlgorithmContext getDomainAlgorithmContext(String host) {
        DomainAlgorithmContext domainAlgorithmContext = hostDomainAlgorithmContextMap.get(host);
        if (domainAlgorithmContext == null) {
            int indexOfDot = host.indexOf(".");
            if (indexOfDot != -1) {
                domainAlgorithmContext = this.getDomainAlgorithmContext(host.substring(indexOfDot + 1));
            } else {
                throw new SynapseException("Domain not found for host" + host);
            }
        }
        return domainAlgorithmContext;
    }

    public LoadbalanceAlgorithm getLoadbalanceAlgorithm() {
        return this.lbAlgo;
    }

    public Properties getProperties() {
        return null;
    }

    public static String getDomainFormHostTenant(String targetHost, int tenantId) {
        return hostDomainAlgorithmContextMap.get(targetHost).getDomain(tenantId);
    }

    private static class DomainAlgorithmContext {
        private AlgorithmContext algorithmContext;
        private LoadbalanceAlgorithm algorithm;
        private TenantDomainRangeContext tenantDomainRangeContext;

        private DomainAlgorithmContext(TenantDomainRangeContext tenantDomainRangeContext, LoadbalanceAlgorithm algorithm, AlgorithmContext algorithmContext) {
            this.tenantDomainRangeContext = tenantDomainRangeContext;
            this.algorithm = algorithm;
            this.algorithmContext = algorithmContext;
        }

        public LoadbalanceAlgorithm getAlgorithm() {
            return this.algorithm;
        }

        public String getDomain(int tenantId) {
            return this.tenantDomainRangeContext.getClusterDomainFormTenantId(tenantId);
        }

        public AlgorithmContext getAlgorithmContext() {
            return this.algorithmContext;
        }
    }
}

