/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mashup.javascript.stubgenerator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.WSDL11ToAllAxisServicesBuilder;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.mashup.utils.MashupUtils;
import org.wso2.carbon.wsdl2form.Util;

public class JSStubGenerator {
    private static Log log = LogFactory.getLog(JSStubGenerator.class);

    public String genarateStub(String type, DataHandler wsdl) throws CarbonException {
        InputStream inputStream;
        try {
            inputStream = wsdl.getDataSource().getInputStream();
        }
        catch (IOException e) {
            throw new CarbonException((Throwable)e);
        }
        return this.getStub(type, inputStream, null);
    }

    public String genarateStubFromURL(String type, String url) throws CarbonException {
        GetMethod httpMethod = new GetMethod(url);
        try {
            URL wsdlURL = new URL(url);
            int statusCode = MashupUtils.executeHTTPMethod((HttpMethod)httpMethod, (URL)wsdlURL, null, null);
            if (statusCode != 200) {
                throw new CarbonException("An error occured while getting the WSDL at " + wsdlURL + ". Reason :" + httpMethod.getStatusLine());
            }
            InputStream inputStream = httpMethod.getResponseBodyAsStream();
            String string = this.getStub(type, inputStream, url);
            return string;
        }
        catch (IOException e) {
            throw new CarbonException((Throwable)e);
        }
        finally {
            httpMethod.releaseConnection();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getStub(String type, InputStream inputStream, String uri) throws CarbonException {
        AxisService service = null;
        ByteArrayOutputStream stubOutStream = new ByteArrayOutputStream();
        try {
            OMElement documentElement = (OMElement)XMLUtils.toOM((InputStream)inputStream);
            OMNamespace documentElementNS = documentElement.getNamespace();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            if (documentElementNS == null) throw new CarbonException("Invalid WSDL");
            if ("http://schemas.xmlsoap.org/wsdl/".equals(documentElementNS.getNamespaceURI())) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                documentElement.serialize((OutputStream)outputStream);
                ByteArrayInputStream inStream = new ByteArrayInputStream(outputStream.toByteArray());
                WSDL11ToAllAxisServicesBuilder wsdl11ToAxisServiceBuilder = new WSDL11ToAllAxisServicesBuilder((InputStream)inStream);
                wsdl11ToAxisServiceBuilder.setBaseUri(uri);
                wsdl11ToAxisServiceBuilder.setAllPorts(true);
                service = wsdl11ToAxisServiceBuilder.populateService();
                Map endpointsMap = service.getEndpoints();
                Iterator iterator = endpointsMap.values().iterator();
                String[] eprs = new String[endpointsMap.size()];
                int i = 0;
                while (iterator.hasNext()) {
                    AxisEndpoint axisEndpoint = (AxisEndpoint)iterator.next();
                    eprs[i] = axisEndpoint.getEndpointURL();
                    ++i;
                }
                service.setEPRs(eprs);
                MessageContext messageContext = MessageContext.getCurrentMessageContext();
                AxisServiceGroup axisServiceGroup = new AxisServiceGroup();
                axisServiceGroup.setParent((AxisDescription)messageContext.getConfigurationContext().getAxisConfiguration());
                service.setParent(axisServiceGroup);
                service.printWSDL2((OutputStream)outStream);
            } else {
                if (!"http://www.w3.org/ns/wsdl".equals(documentElementNS.getNamespaceURI())) throw new CarbonException("Invalid WSDL");
                documentElement.serialize((OutputStream)outStream);
                if (uri != null) {
                    try {
                        String serviceName = null;
                        String wsdlURL = new URL(uri).getPath().split("/services")[1];
                        String[] serviceURLParts = wsdlURL.split("/");
                        int serviceNameVal = serviceURLParts.length;
                        if (serviceNameVal == 5) {
                            serviceName = "/" + serviceURLParts[2] + "/" + serviceURLParts[3];
                        } else if (serviceNameVal == 3) {
                            serviceName = "/" + serviceURLParts[1] + "/" + serviceURLParts[2];
                        }
                        service = new AxisService(serviceName);
                    }
                    catch (IOException e) {
                        throw new CarbonException((Throwable)e);
                    }
                }
            }
            DOMSource sigStream = Util.getSigStream(service, (ByteArrayOutputStream)outStream, null);
            StreamResult result = new StreamResult(stubOutStream);
            HashMap<String, String> paramMap = null;
            if ("e4x".equals(type)) {
                paramMap = new HashMap<String, String>();
                paramMap.put("e4x", "true");
            }
            Util.generateStub((Source)sigStream, (Result)result, paramMap);
            return stubOutStream.toString();
        }
        catch (XMLStreamException e) {
            throw new CarbonException((Throwable)e);
        }
        catch (AxisFault axisFault) {
            throw new CarbonException((Throwable)axisFault);
        }
        catch (TransformerException e) {
            throw new CarbonException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new CarbonException((Throwable)e);
        }
    }
}

