/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mashup.jsservices.ui.fileupload;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.mashup.jsservices.stub.client.types.JSServiceUploadData;
import org.wso2.carbon.mashup.jsservices.ui.MashupServiceAdminClient;
import org.wso2.carbon.mashup.jsservices.ui.fileupload.JSServiceUploadClient;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.ArchiveManipulator;
import org.wso2.carbon.utils.FileItemData;

public class JSServiceUploadExecutor
extends AbstractFileUploadExecutor {
    private static final String[] ALLOWED_FILE_EXTENSIONS = new String[]{".zip"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        String webContext = (String)request.getAttribute("WebContext");
        String serverURL = (String)request.getAttribute("ServerURL");
        String cookie = (String)request.getAttribute("wso2carbon.admin.service.cookie");
        String username = (String)request.getSession().getAttribute("logged-user");
        List tempDataList = null;
        String message = null;
        Map fileItemsMap = this.getFileItemsMap();
        if (fileItemsMap == null || fileItemsMap.isEmpty()) {
            message = "File uploading failed. No files are specified";
            log.error((Object)message);
            CarbonUIMessage.sendCarbonUIMessage((String)message, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/js_service/upload.jsp"));
            return false;
        }
        tempDataList = (List)fileItemsMap.get("jsFilename");
        JSServiceUploadClient serviceUploaderClient = new JSServiceUploadClient(this.configurationContext, serverURL, cookie);
        MashupServiceAdminClient client = new MashupServiceAdminClient(cookie, serverURL, this.configurationContext);
        ArrayList<JSServiceUploadData> jsServiceDataList = new ArrayList<JSServiceUploadData>();
        ArchiveManipulator archiveManipulator = new ArchiveManipulator();
        String[] serviceNames = new String[tempDataList.size()];
        ArrayList<File> tempFiles = new ArrayList<File>();
        try {
            for (int i = 0; i < tempDataList.size(); ++i) {
                FileItemData fileData = (FileItemData)tempDataList.get(i);
                String fileName = this.getFileName(fileData.getFileItem().getName());
                this.checkServiceFileExtensionValidity(fileName, ALLOWED_FILE_EXTENSIONS);
                JSServiceUploadData tempData = new JSServiceUploadData();
                tempData.setFileName(fileName);
                tempData.setDataHandler(fileData.getDataHandler());
                if (fileName.endsWith(".zip")) {
                    File zipFile = ((DeferredFileOutputStream)fileData.getFileItem().getOutputStream()).getFile();
                    fileData.getFileItem().write(zipFile);
                    tempFiles.add(zipFile);
                    String[] files = archiveManipulator.check(zipFile.getAbsolutePath());
                    boolean jsFile = false;
                    boolean resourceFolder = false;
                    for (String file : files) {
                        if (file.indexOf("/") != -1) continue;
                        String extension = file.substring(file.indexOf(".") + 1);
                        String jsName = file.substring(0, file.indexOf("."));
                        if ("js".equals(extension)) {
                            if (jsFile) {
                                message = this.getFileName(fileData.getFileItem().getName()) + " file should contain only " + "one '.js' file in the root folder";
                                log.error((Object)message);
                                CarbonUIMessage.sendCarbonUIMessage((String)message, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/js_service/upload.jsp"));
                                boolean bl = false;
                                return bl;
                            }
                            serviceNames[i] = username + "/" + jsName;
                            jsFile = true;
                            continue;
                        }
                        if ("resources".equals(extension)) {
                            if (resourceFolder) {
                                message = this.getFileName(fileData.getFileItem().getName()) + " file contains an invalid file in the root folder : " + file;
                                log.error((Object)message);
                                CarbonUIMessage.sendCarbonUIMessage((String)message, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/js_service/upload.jsp"));
                                boolean bl = false;
                                return bl;
                            }
                            resourceFolder = true;
                            continue;
                        }
                        message = this.getFileName(fileData.getFileItem().getName()) + " file contains an invalid file in the root folder : " + file;
                        log.error((Object)message);
                        CarbonUIMessage.sendCarbonUIMessage((String)message, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/js_service/upload.jsp"));
                        boolean bl = false;
                        return bl;
                    }
                    if (!jsFile) {
                        message = this.getFileName(fileData.getFileItem().getName()) + " file doesn't contain a '.js'" + " file in the root folder";
                        log.error((Object)message);
                        CarbonUIMessage.sendCarbonUIMessage((String)message, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/js_service/upload.jsp"));
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    message = "File with extension " + fileName + " is not supported!";
                    CarbonUIMessage.sendCarbonUIMessage((String)message, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/js_service/upload.jsp"));
                    log.error((Object)message);
                    boolean zipFile = false;
                    return zipFile;
                }
                jsServiceDataList.add(tempData);
            }
            String[] existingServices = client.doesServicesExists(serviceNames);
            String zipCode = null;
            if (existingServices != null && existingServices.length != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < existingServices.length; ++i) {
                    String existingService = existingServices[i].substring(existingServices[i].indexOf("/") + 1);
                    for (int j = 0; j < jsServiceDataList.size(); ++j) {
                        String fileName = ((JSServiceUploadData)jsServiceDataList.get(j)).getFileName();
                        if (!fileName.replaceAll(zipCode, "").equals(existingService)) continue;
                        jsServiceDataList.remove(j);
                    }
                    if (i == 0) {
                        stringBuilder.append(existingService);
                        continue;
                    }
                    stringBuilder.append(", " + existingService);
                }
                if (jsServiceDataList.size() > 0) {
                    StringBuilder serviceList = new StringBuilder();
                    for (int j = 0; j < jsServiceDataList.size(); ++j) {
                        if (j == 0) {
                            serviceList.append(((JSServiceUploadData)jsServiceDataList.get(j)).getFileName().replaceAll(zipCode, ""));
                            continue;
                        }
                        serviceList.append("," + ((JSServiceUploadData)jsServiceDataList.get(j)).getFileName().replaceAll(zipCode, ""));
                    }
                    JSServiceUploadData[] services = jsServiceDataList.toArray(new JSServiceUploadData[jsServiceDataList.size()]);
                    serviceUploaderClient.uploadService(username, services);
                    message = "Javascript services with the names-" + serviceList.toString() + " uploaded successfully,except services with the names- " + stringBuilder.toString() + " since they are already exist.";
                    CarbonUIMessage.sendCarbonUIMessage((String)message, (String)"info", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/service-mgt/index.jsp"));
                    log.error((Object)message);
                    boolean j = false;
                    return j;
                }
                message = "Services with the names " + stringBuilder.toString() + " already exist";
                CarbonUIMessage.sendCarbonUIMessage((String)message, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/js_service/upload.jsp"));
                log.error((Object)message);
                boolean bl = false;
                return bl;
            }
            JSServiceUploadData[] services = jsServiceDataList.toArray(new JSServiceUploadData[jsServiceDataList.size()]);
            serviceUploaderClient.uploadService(username, services);
            message = "Javascript Services uploaded successfully.";
            log.info((Object)message);
            CarbonUIMessage.sendCarbonUIMessage((String)message, (String)"info", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/service-mgt/index.jsp"));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            message = "File upload failed. " + e.getMessage();
            log.error((Object)message, (Throwable)e);
            CarbonUIMessage.sendCarbonUIMessage((String)message, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/js_service/upload.jsp"));
        }
        finally {
            for (File file : tempFiles) {
                if (file.delete()) continue;
                log.warn((Object)("Error deleting temp file " + file.getName()));
            }
        }
        return false;
    }
}

