/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mashup.jsservices.ui;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.mashup.jsservices.stub.CarbonExceptionException;
import org.wso2.carbon.mashup.jsservices.stub.MashupServiceAdminStub;

public class MashupServiceAdminClient {
    private MashupServiceAdminStub stub = null;
    private static Log log = LogFactory.getLog(MashupServiceAdminClient.class);

    public MashupServiceAdminClient(String cookie, String url, ConfigurationContext configContext) throws AxisFault {
        String serviceEndPoint = null;
        try {
            serviceEndPoint = url + "MashupServiceAdmin";
            this.stub = new MashupServiceAdminStub(configContext, serviceEndPoint);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault e) {
            log.error((Object)("Error occurred while connecting via stub to :" + serviceEndPoint), (Throwable)e);
            throw e;
        }
    }

    public String[] getMashupServiceContentAsString(String serviceName) throws CarbonException {
        try {
            return this.stub.getMashupServiceContentAsString(serviceName);
        }
        catch (RemoteException e) {
            log.error((Object)("Error occured while trying to retrieve the contents of the JS Service " + serviceName), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
    }

    public boolean saveMashupServiceSource(String serviceName, String contents, String type) throws CarbonException {
        try {
            return this.stub.saveMashupServiceSource(serviceName, type, contents);
        }
        catch (RemoteException e) {
            log.error((Object)("Error occured while trying to save the the JS Service " + serviceName), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
        catch (CarbonExceptionException e) {
            log.error((Object)("Error occured while trying to save the the JS Service " + serviceName), (Throwable)e);
            throw new CarbonException((Throwable)e);
        }
    }

    public boolean doesServiceExists(String serviceName) throws CarbonException {
        try {
            return this.stub.doesServiceExists(serviceName);
        }
        catch (RemoteException e) {
            throw new CarbonException((Throwable)e);
        }
        catch (CarbonExceptionException e) {
            throw new CarbonException((Throwable)e);
        }
    }

    public String[] doesServicesExists(String[] serviceNames) throws CarbonException {
        try {
            return this.stub.doesServicesExists(serviceNames);
        }
        catch (RemoteException e) {
            throw new CarbonException((Throwable)e);
        }
        catch (CarbonExceptionException e) {
            throw new CarbonException((Throwable)e);
        }
    }

    public String getBackendHttpPort() throws CarbonException {
        try {
            return this.stub.getBackendHttpPort();
        }
        catch (RemoteException e) {
            throw new CarbonException((Throwable)e);
        }
        catch (CarbonExceptionException e) {
            throw new CarbonException((Throwable)e);
        }
    }
}

