/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.jaxwsservices.ui.fileupload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.jaxwsservices.stub.types.JAXServiceData;
import org.wso2.carbon.jaxwsservices.ui.fileupload.JAXWSServiceUploaderClient;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class JAXWSFileUploadExecutor
extends AbstractFileUploadExecutor {
    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        return this.uploadArtifacts(request, response, "servicejars", new String[]{"jar"}, "Axis2");
    }

    protected boolean uploadArtifacts(HttpServletRequest request, HttpServletResponse response, String uploadDirName, String[] extensions, String utilityString) throws IOException {
        String msg;
        response.setContentType("text/html; charset=utf-8");
        String webContext = (String)request.getAttribute("WebContext");
        String serverURL = (String)request.getAttribute("ServerURL");
        String cookie = (String)request.getAttribute("wso2carbon.admin.service.cookie");
        Map fileItemsMap = this.getFileItemsMap();
        if (fileItemsMap == null || fileItemsMap.isEmpty()) {
            msg = "File uploading failed. No files are specified";
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/jaxws/index.jsp"));
        }
        JAXWSServiceUploaderClient uploaderClient = new JAXWSServiceUploaderClient(this.configurationContext, serverURL + "JAXWSServiceUploader", cookie);
        List serviceHierarchyList = null;
        Map formFieldsMap = this.getFormFieldsMap();
        if (formFieldsMap != null && formFieldsMap.size() > 0) {
            serviceHierarchyList = (List)formFieldsMap.get("serviceHierarchy");
        }
        List fileItemDataList = null;
        if (fileItemsMap != null && fileItemsMap.size() > 0) {
            fileItemDataList = (List)fileItemsMap.get("jarfilename");
        }
        ArrayList<JAXServiceData> serviceDataList = new ArrayList<JAXServiceData>();
        try {
            if (serviceHierarchyList != null) {
                for (int i = 0; i < serviceHierarchyList.size(); ++i) {
                    JAXServiceData tempServiceData = new JAXServiceData();
                    tempServiceData.setFileName(this.getFileName(((FileItemData)fileItemDataList.get(i)).getFileItem().getName()));
                    tempServiceData.setDataHandler(((FileItemData)fileItemDataList.get(i)).getDataHandler());
                    tempServiceData.setServiceHierarchy((String)serviceHierarchyList.get(i));
                    serviceDataList.add(tempServiceData);
                }
            }
            uploaderClient.uploadFileItems(serviceDataList.toArray(new JAXServiceData[serviceDataList.size()]));
            msg = "Files have been uploaded successfully. Please refresh this page in a while to see the status of the created JAXWS service";
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"info", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/service-mgt/index.jsp"));
            return true;
        }
        catch (Exception e) {
            msg = "File upload failed.";
            log.error((Object)msg, (Throwable)e);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/jaxws/index.jsp"));
            return false;
        }
    }
}

