/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.integration.tests;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.wso2.carbon.integration.framework.ClientConnectionUtil;
import org.wso2.carbon.integration.framework.LoginLogoutUtil;
import org.wso2.carbon.integration.tests.CarbonTestServerManager;
import org.wso2.carbon.integration.tests.ServerShutdownTestCase;
import org.wso2.carbon.server.admin.ui.ServerAdminClient;

public class ServerRestartTestCase {
    private static final Log log = LogFactory.getLog(ServerShutdownTestCase.class);
    private static final long TIMEOUT = 300000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"carbon.core.graceful.restart.test"})
    public void testGracefulServerRestart() throws Exception {
        log.info((Object)"Testing server graceful restart...");
        int portOffset = 121;
        CarbonTestServerManager serverManager = this.startServerForRestartTest(portOffset);
        try {
            int httpsPort = 9443 + portOffset;
            ClientConnectionUtil.waitForPort((int)httpsPort);
            ServerAdminClient serverAdmin = LoginLogoutUtil.getServerAdminClient((int)portOffset);
            AssertJUnit.assertTrue((boolean)serverAdmin.restartGracefully());
            Thread.sleep(5000L);
            ClientConnectionUtil.waitForPort((int)httpsPort, (long)300000L, (boolean)true);
            Thread.sleep(5000L);
        }
        finally {
            if (serverManager != null) {
                serverManager.stopServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"carbon.core.restart.test"})
    public void testServerRestart() throws Exception {
        log.info((Object)"Testing server restart...");
        int portOffset = 122;
        CarbonTestServerManager serverManager = this.startServerForRestartTest(portOffset);
        try {
            int httpsPort = 9443 + portOffset;
            ClientConnectionUtil.waitForPort((int)httpsPort);
            ServerAdminClient serverAdmin = LoginLogoutUtil.getServerAdminClient((int)portOffset);
            AssertJUnit.assertTrue((boolean)serverAdmin.restart());
            Thread.sleep(5000L);
            ClientConnectionUtil.waitForPort((int)httpsPort, (long)300000L, (boolean)true);
            Thread.sleep(5000L);
        }
        finally {
            if (serverManager != null) {
                serverManager.stopServer();
            }
        }
    }

    private CarbonTestServerManager startServerForRestartTest(int portOffset) throws IOException {
        CarbonTestServerManager server = new CarbonTestServerManager(portOffset);
        server.startServer();
        return server;
    }
}

