/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.integration.tests;

import java.util.HashMap;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.wso2.carbon.integration.framework.ClientConnectionUtil;
import org.wso2.carbon.server.admin.service.ServerAdminMBean;

public class MaintenanceModeTestCase {
    private ServerAdminMBean serverAdmin;

    @BeforeMethod(groups={"carbon.core"}, description="Initializes the JMX connection & obtains the ServerAdmin MBean")
    public void init() throws Exception {
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://localhost:11111/jndi/rmi://localhost:9999/jmxrmi");
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        String[] creds = new String[]{"admin", "admin"};
        env.put("jmx.remote.credentials", creds);
        JMXConnector cc = JMXConnectorFactory.connect(url, env);
        MBeanServerConnection mbsc = cc.getMBeanServerConnection();
        ObjectName mxbeanName = new ObjectName("org.wso2.carbon:type=ServerAdmin");
        this.serverAdmin = JMX.newMXBeanProxy(mbsc, mxbeanName, ServerAdminMBean.class);
    }

    @Test(groups={"carbon.core"}, description="Puts the Carbon core server into maintenance mode")
    public void startMaintenance() throws Exception {
        this.serverAdmin.startMaintenance();
        Assert.assertFalse((boolean)ClientConnectionUtil.isPortOpen((int)9443), (String)"Port 9443 should be closed in maintenance mode, but is open");
        Assert.assertFalse((boolean)ClientConnectionUtil.isPortOpen((int)9763), (String)"Port 9763 should be closed in maintenance mode, but is open");
    }

    @Test(groups={"carbon.core"}, dependsOnMethods={"startMaintenance"}, description="Puts a server which was in maintenance mode back to normal mode")
    public void endMaintenance() throws Exception {
        this.serverAdmin.endMaintenance();
        Assert.assertTrue((boolean)ClientConnectionUtil.isPortOpen((int)9443), (String)"Port 9443 should be open in normal mode, but is closed");
        Assert.assertTrue((boolean)ClientConnectionUtil.isPortOpen((int)9763), (String)"Port 9763 should be open in maintenance mode, but is closed");
    }
}

