/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.integration.tests;

import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.wso2.carbon.core.commons.stub.loggeduserinfo.LoggedUserInfoAdminStub;
import org.wso2.carbon.integration.framework.ClientConnectionUtil;
import org.wso2.carbon.integration.framework.LoginLogoutUtil;
import org.wso2.carbon.integration.framework.utils.FrameworkSettings;
import org.wso2.carbon.utils.CarbonUtils;

public class LoginLogoutTestCase {
    private static final Log log = LogFactory.getLog(LoginLogoutTestCase.class);
    private LoginLogoutUtil util = new LoginLogoutUtil();

    @Deprecated
    @Test(groups={"carbon.core"}, description="Tests the server login functionality", dependsOnMethods={"loginWithBasicAuth"})
    public void login() throws Exception {
        this.util.login();
    }

    @Test(groups={"carbon.core"}, description="Tests the server login functionality")
    public void loginWithBasicAuth() throws Exception {
        boolean b = this.util.loginWithBasicAuth();
        Assert.assertTrue((boolean)b, (String)"Authentication failed !!");
    }

    @Test(groups={"carbon.core"}, dependsOnMethods={"loginWithBasicAuth"}, description="Tests the server logout functionality")
    public void logout() throws Exception {
        this.util.logout();
    }

    @Test(groups={"carbon.core"}, description="Checks whether remember me data is correctly processed.")
    public void loginWithRememberMe() throws Exception {
        int portOffset = 0;
        ClientConnectionUtil.waitForPort((int)(Integer.parseInt(FrameworkSettings.HTTPS_PORT) + portOffset));
        String authenticationServiceURL = "https://localhost:" + (Integer.parseInt(FrameworkSettings.HTTPS_PORT) + portOffset) + "/services/";
        LoggedUserInfoAdminStub stub = null;
        try {
            stub = new LoggedUserInfoAdminStub(authenticationServiceURL + "LoggedUserInfoAdmin");
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Unable to create LoggedUserInfoAdmin stub", (Throwable)axisFault);
            Assert.fail((String)"Unable to create LoggedUserInfoAdmin stub, with remember me login");
        }
        ServiceClient client = stub._getServiceClient();
        CarbonUtils.setBasicAccessSecurityHeaders((String)FrameworkSettings.USER_NAME, (String)FrameworkSettings.PASSWORD, (boolean)true, (ServiceClient)client);
        try {
            stub.getUserInfo();
        }
        catch (Exception e) {
            log.error((Object)"Unable to retrieve data from LoggedUserInfoAdmin", (Throwable)e);
            Assert.fail((String)"Unable to create LoggedUserInfoAdmin stub, with remember me login");
        }
        this.checkRememberMeData(client);
        client.cleanup();
        this.util.logout();
    }

    private void checkRememberMeData(ServiceClient serviceClient) {
        OperationContext operationContext = serviceClient.getLastOperationContext();
        MessageContext inMessageContext = null;
        try {
            inMessageContext = operationContext.getMessageContext("In");
        }
        catch (AxisFault axisFault) {
            String msg = "Unable to retrieve IN message context from operation context of service client";
            log.error((Object)msg, (Throwable)axisFault);
            Assert.fail((String)msg);
        }
        Map transportHeaders = (Map)inMessageContext.getProperty("TRANSPORT_HEADERS");
        String cookieValue = (String)transportHeaders.get("RememberMeCookieValue");
        String cookieAge = (String)transportHeaders.get("RememberMeCookieAge");
        Assert.assertNotNull((Object)cookieValue, (String)"Cookie value cannot be null for a remember me request");
        Assert.assertNotNull((Object)cookieAge, (String)"Cookie age cannot be null for a remember me request");
    }
}

