/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.integration.tests;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.wso2.carbon.integration.framework.ClientConnectionUtil;
import org.wso2.carbon.integration.framework.LoginLogoutUtil;
import org.wso2.carbon.integration.tests.CarbonTestServerManager;
import org.wso2.carbon.server.admin.ui.ServerAdminClient;

public class ServerShutdownTestCase {
    private static final Log log = LogFactory.getLog(ServerShutdownTestCase.class);

    @Test(groups={"carbon.core.graceful.shutdown.test"})
    public void testGracefulServerShutdown() throws Exception {
        log.info((Object)"Testing graceful server shutdown...");
        int portOffset = 35;
        this.startServerForShutdownTest(portOffset);
        int httpsPort = 9443 + portOffset;
        ClientConnectionUtil.waitForPort((int)httpsPort);
        ServerAdminClient serverAdmin = LoginLogoutUtil.getServerAdminClient((int)portOffset);
        serverAdmin.shutdownGracefully();
        Thread.sleep(5000L);
        Assert.assertFalse((boolean)ClientConnectionUtil.isPortOpen((int)httpsPort), (String)("Port " + httpsPort + " shouldn't be open when the server is gracefully shutting down"));
        int httpPort = 9763 + portOffset;
        Assert.assertFalse((boolean)ClientConnectionUtil.isPortOpen((int)httpPort), (String)("Port " + httpPort + " shouldn't be open when the server is gracefully shutting down"));
    }

    @Test(groups={"carbon.core.shutdown.test"})
    public void testServerShutdown() throws Exception {
        log.info((Object)"Testing server shutdown...");
        int portOffset = 37;
        this.startServerForShutdownTest(portOffset);
        int httpsPort = 9443 + portOffset;
        ClientConnectionUtil.waitForPort((int)httpsPort);
        ServerAdminClient serverAdmin = LoginLogoutUtil.getServerAdminClient((int)portOffset);
        AssertJUnit.assertTrue((boolean)serverAdmin.shutdown());
        Thread.sleep(5000L);
        Assert.assertFalse((boolean)ClientConnectionUtil.isPortOpen((int)httpsPort), (String)("Port " + httpsPort + " shouldn't be open when the server is shutting down"));
        int httpPort = 9763 + portOffset;
        Assert.assertFalse((boolean)ClientConnectionUtil.isPortOpen((int)httpPort), (String)("Port " + httpPort + " shouldn't be open when the server is shutting down"));
    }

    private void startServerForShutdownTest(int portOffset) throws IOException {
        CarbonTestServerManager server = new CarbonTestServerManager(portOffset);
        server.startServer();
    }
}

