/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.integration.framework.utils;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.integration.framework.ClientConnectionUtil;
import org.wso2.carbon.integration.framework.LoginLogoutUtil;
import org.wso2.carbon.integration.framework.utils.CodeCoverageUtils;
import org.wso2.carbon.integration.framework.utils.FrameworkSettings;
import org.wso2.carbon.integration.framework.utils.InputStreamHandler;
import org.wso2.carbon.server.admin.ui.ServerAdminClient;
import org.wso2.carbon.utils.ArchiveManipulator;
import org.wso2.carbon.utils.FileManipulator;
import org.wso2.carbon.utils.NetworkUtils;

public class ServerUtils {
    private static final Log log = LogFactory.getLog(ServerUtils.class);
    private Process process;
    private String carbonHome;
    private String originalUserDir = null;
    private InputStreamHandler inputStreamHandler;
    private static final String DEFAULT_SCRIPT_NAME = "wso2server";
    private static final String SERVER_SHUTDOWN_MESSAGE = "Halting JVM";
    private static final long DEFAULT_START_STOP_WAIT_MS = 300000L;
    private int defaultHttpsPort = 9443;

    public synchronized void startServerUsingCarbonHome(String carbonHome, int portOffset) {
        this.startServerUsingCarbonHome(carbonHome, carbonHome, DEFAULT_SCRIPT_NAME, portOffset, null);
    }

    public synchronized void startServerUsingCarbonHome(String carbonHome, String carbonFolder, String scriptName, final int portOffset, final String carbonManagementContext) {
        Process tempProcess;
        if (this.process != null) {
            return;
        }
        try {
            CodeCoverageUtils.instrument(carbonFolder);
            FrameworkSettings.init();
            this.defaultHttpsPort = Integer.parseInt(FrameworkSettings.HTTPS_PORT);
            int defaultHttpPort = Integer.parseInt(FrameworkSettings.HTTP_PORT);
            System.setProperty("carbon.home", carbonFolder);
            this.originalUserDir = System.getProperty("user.dir");
            System.setProperty("user.dir", carbonFolder);
            File commandDir = new File(carbonHome);
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                commandDir = new File(carbonHome + File.separator + "bin");
                tempProcess = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", scriptName + ".bat", "-DportOffset=" + String.valueOf(portOffset), "-Demma.properties=" + System.getProperty("emma.properties"), "-Demma.rt.control.port=" + (47653 + portOffset)}, null, commandDir);
            } else {
                tempProcess = Runtime.getRuntime().exec(new String[]{"sh", "bin/" + scriptName + ".sh", "-DportOffset=" + String.valueOf(portOffset), "-Demma.properties=" + System.getProperty("emma.properties"), "-Demma.rt.control.port=" + (47653 + portOffset)}, null, commandDir);
            }
            InputStreamHandler errorStreamHandler = new InputStreamHandler("errorStream", tempProcess.getErrorStream());
            this.inputStreamHandler = new InputStreamHandler("inputStream", tempProcess.getInputStream());
            this.inputStreamHandler.start();
            errorStreamHandler.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        log.info((Object)"Shutting down server...");
                        if (carbonManagementContext == null || carbonManagementContext.trim().equals("")) {
                            ServerUtils.this.shutdown(portOffset);
                        } else {
                            ServerUtils.this.shutdown(portOffset, carbonManagementContext);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Cannot shutdown server", (Throwable)e);
                    }
                }
            });
            ClientConnectionUtil.waitForPort(this.defaultHttpsPort + portOffset, 300000L, false);
            ClientConnectionUtil.waitForPort(defaultHttpPort + portOffset, 300000L, false);
            if (carbonManagementContext == null || carbonManagementContext.trim().equals("")) {
                ClientConnectionUtil.waitForLogin(portOffset);
            } else {
                ClientConnectionUtil.waitForLogin(portOffset, carbonManagementContext);
            }
            log.info((Object)"Server started successfully.");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to start server", e);
        }
        this.process = tempProcess;
    }

    public synchronized String setUpCarbonHome(String carbonServerZipFile) throws IOException {
        String fileSeparator;
        if (this.process != null) {
            return this.carbonHome;
        }
        CodeCoverageUtils.init();
        int indexOfZip = carbonServerZipFile.lastIndexOf(".zip");
        if (indexOfZip == -1) {
            throw new IllegalArgumentException(carbonServerZipFile + " is not a zip file");
        }
        String string = fileSeparator = File.separator.equals("\\") ? "\\" : "/";
        if (fileSeparator.equals("\\")) {
            carbonServerZipFile = carbonServerZipFile.replace("/", "\\");
        }
        String extractedCarbonDir = carbonServerZipFile.substring(carbonServerZipFile.lastIndexOf(fileSeparator) + 1, indexOfZip);
        FileManipulator.deleteDir((String)extractedCarbonDir);
        String extractDir = "carbontmp" + System.currentTimeMillis();
        new ArchiveManipulator().extract(carbonServerZipFile, extractDir);
        String baseDir = System.getProperty("basedir", ".") + File.separator + "target";
        this.carbonHome = new File(baseDir).getAbsolutePath() + File.separator + extractDir + File.separator + extractedCarbonDir;
        return this.carbonHome;
    }

    public synchronized void shutdown(int portOffset, String carbonManagementContext) throws Exception {
        if (this.process != null) {
            if (ClientConnectionUtil.isPortOpen(this.defaultHttpsPort + portOffset)) {
                if (carbonManagementContext == null || carbonManagementContext.trim().equals("")) {
                    this.shutdownServer(portOffset);
                } else {
                    this.shutdownServer(portOffset, carbonManagementContext);
                }
                long time = System.currentTimeMillis() + 300000L;
                while (!this.inputStreamHandler.getOutput().contains(SERVER_SHUTDOWN_MESSAGE) && System.currentTimeMillis() < time) {
                }
                log.info((Object)"Server stopped successfully...");
            }
            this.process.destroy();
            this.process = null;
            System.clearProperty("carbon.home");
            System.setProperty("user.dir", this.originalUserDir);
        }
    }

    public synchronized void shutdown(int portOffset) throws Exception {
        if (this.process != null) {
            if (ClientConnectionUtil.isPortOpen(this.defaultHttpsPort + portOffset)) {
                this.shutdownServer(portOffset);
                long time = System.currentTimeMillis() + 300000L;
                while (!this.inputStreamHandler.getOutput().contains(SERVER_SHUTDOWN_MESSAGE) && System.currentTimeMillis() < time) {
                }
                log.info((Object)"Server stopped successfully...");
            }
            this.process.destroy();
            this.process = null;
            System.clearProperty("carbon.home");
            System.setProperty("user.dir", this.originalUserDir);
        }
    }

    private void shutdownServer(int portOffset) throws Exception {
        this.shutdownServer(portOffset, null);
    }

    private void shutdownServer(int portOffset, String carbonManagementContext) throws Exception {
        int httpsPort = this.defaultHttpsPort + portOffset;
        try {
            String sessionCookie;
            String serviceBaseURL;
            if (carbonManagementContext == null || carbonManagementContext.trim().equals("")) {
                serviceBaseURL = "https://localhost:" + httpsPort + "/services/";
                sessionCookie = new LoginLogoutUtil(portOffset).login();
            } else {
                serviceBaseURL = "https://localhost:" + httpsPort + "/" + carbonManagementContext + "/services/";
                sessionCookie = new LoginLogoutUtil(portOffset).login(NetworkUtils.getLocalHostname(), carbonManagementContext);
            }
            ServerAdminClient serverAdminClient = new ServerAdminClient(null, serviceBaseURL, sessionCookie, null);
            serverAdminClient.shutdownGracefully();
        }
        catch (Exception e) {
            log.error((Object)"Error when shutting down the server.", (Throwable)e);
            throw e;
        }
    }
}

