/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.integration.framework;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.integration.framework.LoginLogoutUtil;
import org.wso2.carbon.integration.framework.utils.FrameworkSettings;
import org.wso2.carbon.utils.NetworkUtils;

public final class ClientConnectionUtil {
    private static final Log log = LogFactory.getLog(ClientConnectionUtil.class);
    private static final long TIMEOUT = 60000L;

    private ClientConnectionUtil() {
    }

    public static void waitForLogin(int portOffset) {
        ClientConnectionUtil.waitForLogin(portOffset, null);
    }

    public static void waitForLogin(int portOffset, String carbonManagementContext) {
        long startTime = System.currentTimeMillis();
        boolean loginFailed = true;
        while (loginFailed && System.currentTimeMillis() - startTime < 60000L) {
            log.info((Object)"Waiting to login to Carbon server...");
            try {
                FrameworkSettings.init();
                if (carbonManagementContext == null || carbonManagementContext.trim().equals("")) {
                    new LoginLogoutUtil(portOffset).login();
                } else {
                    new LoginLogoutUtil(portOffset).login(NetworkUtils.getLocalHostname(), carbonManagementContext);
                }
                loginFailed = false;
                return;
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Login failed after server startup", (Throwable)e);
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ignored) {}
            }
        }
        throw new RuntimeException("Could not login to Carbon server within 60000ms. portOffset=" + portOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForPort(int port, long timeout, boolean verbose) {
        long startTime = System.currentTimeMillis();
        boolean isPortOpen = false;
        while (!isPortOpen && System.currentTimeMillis() - startTime < timeout) {
            Socket socket = null;
            try {
                InetAddress address = InetAddress.getByName("localhost");
                socket = new Socket(address, port);
                isPortOpen = socket.isConnected();
                if (!isPortOpen) continue;
                if (verbose) {
                    log.info((Object)("Successfully connected to the server on port " + port));
                }
                return;
            }
            catch (IOException e) {
                if (verbose) {
                    log.info((Object)("Waiting until server starts on port " + port));
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
            finally {
                try {
                    if (socket == null || !socket.isConnected()) continue;
                    socket.close();
                }
                catch (IOException e) {
                    log.error((Object)"Can not close the socket with is used to check the server status ", (Throwable)e);
                }
            }
        }
        throw new RuntimeException("Port " + port + " is not open");
    }

    public static void waitForPort(int port) {
        ClientConnectionUtil.waitForPort(port, 60000L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortOpen(int port) {
        Socket socket = null;
        boolean isPortOpen = false;
        try {
            InetAddress address = InetAddress.getByName("localhost");
            socket = new Socket(address, port);
            isPortOpen = socket.isConnected();
            if (isPortOpen) {
                log.info((Object)("Successfully connected to the server on port " + port));
            }
        }
        catch (IOException e) {
            log.info((Object)("Waiting until server starts on port " + port));
            isPortOpen = false;
        }
        finally {
            try {
                if (socket != null && socket.isConnected()) {
                    socket.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Can not close the socket with is used to check the server status ", (Throwable)e);
            }
        }
        return isPortOpen;
    }
}

