/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.integration.framework.utils;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.utils.FileManipulator;

public class TestUtil {
    private static final Log log = LogFactory.getLog(TestUtil.class);

    public static void copySecurityVerificationService(String carbonHome) throws IOException {
        String secVerifierDir = System.getProperty("sec.verifier.dir");
        if (secVerifierDir == null) {
            log.warn((Object)"Security verification test not enabled");
            return;
        }
        assert (carbonHome != null) : "carbonHome cannot be null";
        File srcFile = new File(secVerifierDir + "SecVerifier.aar");
        assert (srcFile.exists()) : srcFile.getAbsolutePath() + " does not exist";
        String deploymentPath = carbonHome + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "axis2services";
        File depFile = new File(deploymentPath);
        if (!depFile.exists() && !depFile.mkdir()) {
            throw new IOException("Error while creating the deployment folder : " + deploymentPath);
        }
        File dstFile = new File(depFile.getAbsolutePath() + File.separator + "SecVerifier.aar");
        log.info((Object)("Copying " + srcFile.getAbsolutePath() + " => " + dstFile.getAbsolutePath()));
        FileManipulator.copyFile((File)srcFile, (File)dstFile);
    }
}

