/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.integration.framework.utils;

import com.vladium.emma.Command;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.utils.ArchiveManipulator;
import org.wso2.carbon.utils.FileManipulator;

public final class CodeCoverageUtils {
    private static final Log log = LogFactory.getLog(CodeCoverageUtils.class);

    private CodeCoverageUtils() {
    }

    public static void init() {
        String emmaHome = System.getProperty("emma.home");
        if (emmaHome == null) {
            return;
        }
        if (!emmaHome.endsWith(File.separator)) {
            emmaHome = emmaHome + File.separator;
        }
        try {
            if (System.getProperty("emma.properties") == null) {
                for (File file : new File(emmaHome).listFiles()) {
                    if (!file.getName().startsWith("org.wso2.carbon.integration.framework")) continue;
                    ArchiveManipulator archiveManipulator = new ArchiveManipulator();
                    archiveManipulator.extract(file.getAbsolutePath(), emmaHome);
                }
                System.setProperty("emma.properties", new File(emmaHome).getAbsolutePath() + File.separator + "emma.properties");
            }
            if (System.getProperty("emma.report.html.out.file") == null) {
                System.setProperty("emma.report.html.out.file", new File(emmaHome).getAbsolutePath() + File.separator + "coverage" + File.separator + "index.html");
            }
            if (System.getProperty("emma.rt.control.port") == null) {
                System.setProperty("emma.rt.control.port", "44444");
            }
        }
        catch (IOException e) {
            log.error((Object)"Cannot initialize Emma", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void instrument(String carbonHome) {
        String workingDir = System.getProperty("user.dir");
        try {
            System.setProperty("user.dir", carbonHome);
            String emmaHome = System.getProperty("emma.home");
            if (emmaHome == null) {
                return;
            }
            if (!emmaHome.endsWith(File.separator)) {
                emmaHome = emmaHome + File.separator;
            }
            String emmaJarName = null;
            for (File file : new File(emmaHome).listFiles()) {
                String fileName = file.getName();
                if (!fileName.startsWith("emma") || !fileName.endsWith(".jar")) continue;
                emmaJarName = fileName;
            }
            if (emmaJarName == null) {
                return;
            }
            FileUtils.copyFileToDirectory((File)new File(emmaHome + emmaJarName), (File)new File(carbonHome + File.separator + "repository" + File.separator + "components" + File.separator + "lib" + File.separator));
            CodeCoverageUtils.instrumentSelectedFiles(carbonHome);
        }
        catch (IOException e) {
            log.error((Object)"Cannot instrument jars", (Throwable)e);
        }
        finally {
            System.setProperty("user.dir", workingDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void instrumentSelectedFiles(String carbonHome) throws IOException {
        File instrumentationTxt = System.getProperty("instr.file") != null ? new File(System.getProperty("instr.file")) : new File(System.getProperty("basedir") + File.separator + "src" + File.separator + "test" + File.separator + "resources" + File.separator + "instrumentation.txt");
        ArrayList<String> filePatterns = new ArrayList<String>();
        if (instrumentationTxt.exists()) {
            RandomAccessFile rf = new RandomAccessFile(instrumentationTxt, "r");
            try {
                String line;
                while ((line = rf.readLine()) != null) {
                    filePatterns.add(line);
                }
            }
            finally {
                rf.close();
            }
        }
        File plugins = new File(carbonHome + File.separator + "repository" + File.separator + "components" + File.separator + "plugins");
        int instrumentedFileCount = 0;
        for (File file : plugins.listFiles()) {
            if (!file.isFile()) continue;
            if (filePatterns.isEmpty()) {
                CodeCoverageUtils.instrument(file);
                ++instrumentedFileCount;
                continue;
            }
            for (String filePattern : filePatterns) {
                if (!file.getName().startsWith(filePattern)) continue;
                CodeCoverageUtils.instrument(file);
                ++instrumentedFileCount;
            }
        }
        log.info((Object)("Instrumented " + instrumentedFileCount + " files."));
    }

    private static void instrument(File file) throws IOException {
        CodeCoverageUtils.addEmmaDynamicImportPackage(file.getAbsolutePath());
        CodeCoverageUtils.doEmmaInstrumentation(file);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Instrumented " + file.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void addEmmaDynamicImportPackage(String jarFilePath) throws IOException {
        String tempExtractedDir;
        ArchiveManipulator archiveManipulator;
        if (!jarFilePath.endsWith(".jar")) {
            throw new IllegalArgumentException("Jar file should have the extension .jar. " + jarFilePath + " is invalid");
        }
        JarFile jarFile = new JarFile(jarFilePath);
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            throw new IllegalArgumentException(jarFilePath + " does not contain a MANIFEST.MF file");
        }
        String fileSeparator = File.separatorChar == '\\' ? "\\" : File.separator;
        String jarFileName = jarFilePath;
        if (jarFilePath.lastIndexOf(fileSeparator) != -1) {
            jarFileName = jarFilePath.substring(jarFilePath.lastIndexOf(fileSeparator) + 1);
        }
        try {
            archiveManipulator = new ArchiveManipulator();
            tempExtractedDir = System.getProperty("basedir") + File.separator + "target" + File.separator + jarFileName.substring(0, jarFileName.lastIndexOf(46));
            archiveManipulator.extract(jarFilePath, tempExtractedDir);
        }
        finally {
            jarFile.close();
        }
        String dynamicImports = manifest.getMainAttributes().getValue("DynamicImport-Package");
        if (dynamicImports != null) {
            manifest.getMainAttributes().putValue("DynamicImport-Package", dynamicImports + ",com.vladium.*");
        } else {
            manifest.getMainAttributes().putValue("DynamicImport-Package", "com.vladium.*");
        }
        File newManifest = new File(tempExtractedDir + File.separator + "META-INF" + File.separator + "MANIFEST.MF");
        FileOutputStream manifestOut = null;
        try {
            manifestOut = new FileOutputStream(newManifest);
            manifest.write(manifestOut);
        }
        catch (IOException e) {
            log.error((Object)"Could not write content to new MANIFEST.MF file", (Throwable)e);
        }
        finally {
            if (manifestOut != null) {
                manifestOut.close();
            }
        }
        archiveManipulator.archiveDir(jarFilePath, tempExtractedDir);
        FileManipulator.deleteDir((String)tempExtractedDir);
    }

    private static void doEmmaInstrumentation(File file) {
        String emmaFilters = System.getProperty("filters.file");
        if (emmaFilters == null) {
            emmaFilters = System.getProperty("basedir") + File.separator + "src" + File.separator + "test" + File.separator + "resources" + File.separator + "filters.txt";
        } else if (!new File(emmaFilters).exists()) {
            log.warn((Object)("Emma filters file " + emmaFilters + " does not exist"));
        }
        File emmaFiltersFile = new File(emmaFilters);
        Command cmd = emmaFiltersFile.exists() ? Command.create((String)"instr", (String)"emmarun", (String[])new String[]{"-m", "overwrite", "-ip", file.getAbsolutePath(), "-ix", "@" + emmaFiltersFile.getAbsolutePath()}) : Command.create((String)"instr", (String)"emmarun", (String[])new String[]{"-m", "overwrite", "-ip", file.getAbsolutePath()});
        cmd.run();
    }

    public static void generateReports() {
        String emmaHome = System.getProperty("emma.home");
        if (emmaHome == null) {
            return;
        }
        String basedir = System.getProperty("basedir");
        String coverageEm = new File(basedir + File.separator + "" + "target" + File.separator + "coverage.em").getAbsolutePath();
        Collection ecFiles = FileUtils.listFiles((File)new File(basedir), (String[])new String[]{"ec"}, (boolean)true);
        StringBuilder ecFilesString = new StringBuilder();
        for (File ecFile : ecFiles) {
            ecFilesString.append(ecFile.getAbsolutePath()).append(",");
        }
        Command cmd = Command.create((String)"report", (String)"emmarun", (String[])new String[]{"-r", "html", "-in", coverageEm + "," + ecFilesString});
        cmd.run();
        log.info((Object)"Generated Emma reports");
    }
}

