/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.integration.framework;

import java.io.File;
import java.io.IOException;
import org.wso2.carbon.integration.framework.utils.CodeCoverageUtils;
import org.wso2.carbon.integration.framework.utils.FrameworkSettings;
import org.wso2.carbon.integration.framework.utils.ServerUtils;
import org.wso2.carbon.integration.framework.utils.TestUtil;

public abstract class TestServerManager {
    private ServerUtils serverUtils = new ServerUtils();
    private String carbonZip;
    private int portOffset;

    protected TestServerManager() {
    }

    protected TestServerManager(String carbonZip) {
        this.carbonZip = carbonZip;
    }

    protected TestServerManager(int portOffset) {
        this.portOffset = portOffset;
    }

    protected TestServerManager(String carbonZip, int portOffset) {
        this.carbonZip = carbonZip;
        this.portOffset = portOffset;
    }

    public String getCarbonZip() {
        return this.carbonZip;
    }

    protected String startServer() throws IOException {
        if (this.carbonZip == null) {
            this.carbonZip = System.getProperty("carbon.zip");
        }
        if (this.carbonZip == null) {
            throw new IllegalArgumentException("carbon zip file is null");
        }
        String carbonHome = this.serverUtils.setUpCarbonHome(this.carbonZip);
        TestUtil.copySecurityVerificationService(carbonHome);
        this.copyArtifacts(carbonHome);
        this.serverUtils.startServerUsingCarbonHome(carbonHome, this.portOffset);
        FrameworkSettings.init();
        return carbonHome;
    }

    protected String startServerInCarbonFolder(String carbonManagementContext, String scriptName) throws IOException {
        if (this.carbonZip == null) {
            this.carbonZip = System.getProperty("carbon.zip");
        }
        if (this.carbonZip == null) {
            throw new IllegalArgumentException("carbon zip file is null");
        }
        String carbonHome = this.serverUtils.setUpCarbonHome(this.carbonZip);
        String carbonFolder = "";
        if (carbonHome != null) {
            carbonFolder = carbonHome + File.separator + "carbon";
        }
        TestUtil.copySecurityVerificationService(carbonFolder);
        this.copyArtifacts(carbonHome);
        this.serverUtils.startServerUsingCarbonHome(carbonHome, carbonFolder, scriptName, this.portOffset, carbonManagementContext);
        FrameworkSettings.init();
        return carbonHome;
    }

    protected void stopServer() throws Exception {
        this.serverUtils.shutdown(this.portOffset);
        CodeCoverageUtils.generateReports();
    }

    protected void stopServer(String carbonManagementContext) throws Exception {
        this.serverUtils.shutdown(this.portOffset, carbonManagementContext);
        CodeCoverageUtils.generateReports();
    }

    protected abstract void copyArtifacts(String var1) throws IOException;
}

