/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.integration.framework;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ServiceContext;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;
import org.wso2.carbon.core.commons.stub.loggeduserinfo.LoggedUserInfoAdminStub;
import org.wso2.carbon.integration.framework.ClientConnectionUtil;
import org.wso2.carbon.integration.framework.utils.FrameworkSettings;
import org.wso2.carbon.server.admin.ui.ServerAdminClient;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.NetworkUtils;

public final class LoginLogoutUtil {
    private static final Log log = LogFactory.getLog(LoginLogoutUtil.class);
    private String sessionCookie;
    private int portOffset;

    public LoginLogoutUtil(int portOffset) {
        this.portOffset = portOffset;
    }

    public LoginLogoutUtil() {
    }

    @Deprecated
    public String login() throws Exception {
        return this.login(NetworkUtils.getLocalHostname());
    }

    @Deprecated
    public String login(String hostName) throws Exception {
        return this.login(hostName, null);
    }

    @Deprecated
    public String login(String hostName, String carbonManagementContext) throws Exception {
        ClientConnectionUtil.waitForPort(Integer.parseInt(FrameworkSettings.HTTPS_PORT) + this.portOffset);
        AuthenticationAdminStub authAdminStub = carbonManagementContext == null || carbonManagementContext.trim().equals("") ? this.getAuthAdminStub() : this.getAuthAdminStub(carbonManagementContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("UserName : " + FrameworkSettings.USER_NAME + " Password : " + FrameworkSettings.PASSWORD + " HostName : " + hostName));
        }
        boolean isLoggedIn = authAdminStub.login(FrameworkSettings.USER_NAME, FrameworkSettings.PASSWORD, hostName);
        assert (isLoggedIn) : "Login failed!";
        log.debug((Object)"getting sessionCookie");
        ServiceContext serviceContext = authAdminStub._getServiceClient().getLastOperationContext().getServiceContext();
        this.sessionCookie = (String)serviceContext.getProperty("Cookie");
        assert (this.sessionCookie != null) : "Logged in session cookie is null";
        if (log.isDebugEnabled()) {
            log.debug((Object)("sessionCookie : " + this.sessionCookie));
        }
        log.info((Object)("Successfully logged in : " + this.sessionCookie));
        return this.sessionCookie;
    }

    public boolean loginWithBasicAuth() {
        ClientConnectionUtil.waitForPort(Integer.parseInt(FrameworkSettings.HTTPS_PORT) + this.portOffset);
        String authenticationServiceURL = "https://localhost:" + (Integer.parseInt(FrameworkSettings.HTTPS_PORT) + this.portOffset) + "/services/";
        LoggedUserInfoAdminStub stub = null;
        try {
            stub = this.getLoggedUserInfoAdminStub(authenticationServiceURL);
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Unable to create LoggedUserInfoAdmin stub", (Throwable)axisFault);
            return false;
        }
        ServiceClient client = stub._getServiceClient();
        CarbonUtils.setBasicAccessSecurityHeaders((String)FrameworkSettings.USER_NAME, (String)FrameworkSettings.PASSWORD, (ServiceClient)client);
        try {
            stub.getUserInfo();
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Unable to retrieve data from LoggedUserInfoAdmin", (Throwable)e);
            return false;
        }
    }

    public void logout() throws Exception {
        this.logout(null);
    }

    public void logout(String carbonManagementContext) throws Exception {
        AuthenticationAdminStub authenticationAdminStub = carbonManagementContext == null || carbonManagementContext.trim().equals("") ? this.getAuthAdminStub() : this.getAuthAdminStub(carbonManagementContext);
        try {
            Options options = authenticationAdminStub._getServiceClient().getOptions();
            options.setProperty("Cookie", (Object)this.sessionCookie);
            authenticationAdminStub.logout();
        }
        catch (Exception e) {
            String msg = "Error occurred while logging out";
            log.error((Object)msg, (Throwable)e);
            throw new AuthenticationException(msg, (Throwable)e);
        }
    }

    private AuthenticationAdminStub getAuthAdminStub(String carbonManagementContext) throws AxisFault {
        String authenticationServiceURL = carbonManagementContext == null || carbonManagementContext.trim().equals("") ? "https://localhost:" + (Integer.parseInt(FrameworkSettings.HTTPS_PORT) + this.portOffset) + "/services/AuthenticationAdmin" : "https://localhost:" + (Integer.parseInt(FrameworkSettings.HTTPS_PORT) + this.portOffset) + "/" + carbonManagementContext + "/services/AuthenticationAdmin";
        if (log.isDebugEnabled()) {
            log.debug((Object)("AuthenticationAdminService URL = " + authenticationServiceURL));
        }
        AuthenticationAdminStub authenticationAdminStub = new AuthenticationAdminStub(authenticationServiceURL);
        ServiceClient client = authenticationAdminStub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        return authenticationAdminStub;
    }

    private AuthenticationAdminStub getAuthAdminStub() throws AxisFault {
        return this.getAuthAdminStub(null);
    }

    private LoggedUserInfoAdminStub getLoggedUserInfoAdminStub(String backendServerURL) throws AxisFault {
        return new LoggedUserInfoAdminStub(backendServerURL + "LoggedUserInfoAdmin");
    }

    public static ServerAdminClient getServerAdminClient(int portOffset) throws AxisFault {
        return new ServerAdminClient("https://localhost:" + (Integer.parseInt(FrameworkSettings.HTTPS_PORT) + portOffset) + "/services/ServerAdmin/", FrameworkSettings.USER_NAME, FrameworkSettings.PASSWORD);
    }
}

