/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.integration.framework;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import org.wso2.carbon.integration.framework.HttpResponse;

public class HttpRequestUtil {
    private HttpRequestUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse sendGetRequest(String endpoint, String requestParameters) throws IOException {
        if (endpoint.startsWith("http://")) {
            String urlStr = endpoint;
            if (requestParameters != null && requestParameters.length() > 0) {
                urlStr = urlStr + "?" + requestParameters;
            }
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            conn.setReadTimeout(10000);
            conn.connect();
            StringBuilder sb = new StringBuilder();
            BufferedReader rd = null;
            try {
                String line;
                rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (FileNotFoundException ignored) {
            }
            finally {
                if (rd != null) {
                    rd.close();
                }
            }
            return new HttpResponse(sb.toString(), conn.getResponseCode());
        }
        return null;
    }

    public static void sendPostRequest(Reader data, URL endpoint, Writer output) throws Exception {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)endpoint.openConnection();
            try {
                urlConnection.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new Exception("Shouldn't happen: HttpURLConnection doesn't support POST??", e);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setAllowUserInteraction(false);
            urlConnection.setRequestProperty("Content-type", "text/xml; charset=UTF-8");
            OutputStream out = urlConnection.getOutputStream();
            try {
                OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
                HttpRequestUtil.pipe(data, writer);
                ((Writer)writer).close();
            }
            catch (IOException e) {
                throw new Exception("IOException while posting data: " + e.getMessage(), e);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            InputStream in = urlConnection.getInputStream();
            try {
                InputStreamReader reader = new InputStreamReader(in);
                HttpRequestUtil.pipe(reader, output);
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new Exception("IOException while reading response: " + e.getMessage(), e);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            throw new Exception("Connection error (is server running at " + endpoint + " ?): " + e.getMessage(), e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    private static void pipe(Reader reader, Writer writer) throws IOException {
        int read;
        char[] buf = new char[1024];
        while ((read = reader.read(buf)) >= 0) {
            writer.write(buf, 0, read);
        }
        writer.flush();
    }
}

