/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.ui.util;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.carbon.identity.entitlement.ui.EntitlementPolicyCreationException;
import org.wso2.carbon.identity.entitlement.ui.dto.ApplyElementDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.AttributeDesignatorDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.AttributeElementDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.AttributeSelectorDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.AttributeValueElementDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.BasicRequestDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.BasicRuleElementDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.BasicTargetElementDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.ConditionElementDT0;
import org.wso2.carbon.identity.entitlement.ui.dto.FunctionDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.MatchElementDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.NewTargetElementDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.PolicyElementDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.PolicySetDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.RuleElementDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.SubElementDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.TargetElementDTO;
import org.wso2.carbon.identity.entitlement.ui.util.PolicyEditorUtil;

public class PolicyCreatorUtil {
    public static Element createPolicyElement(PolicyElementDTO policyElementDTO, Document doc) {
        Element policyElement = doc.createElement("Policy");
        policyElement.setAttribute("xmlns", "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17");
        if (policyElementDTO.getPolicyName() == null || policyElementDTO.getPolicyName().trim().length() <= 0) {
            return null;
        }
        policyElement.setAttribute("PolicyId", policyElementDTO.getPolicyName());
        if (policyElementDTO.getRuleCombiningAlgorithms() != null && policyElementDTO.getRuleCombiningAlgorithms().trim().length() > 0) {
            if ("first-applicable".equals(policyElementDTO.getRuleCombiningAlgorithms().trim())) {
                policyElement.setAttribute("RuleCombiningAlgId", "urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:" + policyElementDTO.getRuleCombiningAlgorithms());
            } else {
                policyElement.setAttribute("RuleCombiningAlgId", "urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:" + policyElementDTO.getRuleCombiningAlgorithms());
            }
        } else {
            return null;
        }
        if (policyElementDTO.getVersion() != null && policyElementDTO.getVersion().trim().length() > 0) {
            policyElement.setAttribute("Version", policyElementDTO.getVersion());
        } else {
            policyElement.setAttribute("Version", "1.0");
        }
        if (policyElementDTO.getPolicyDescription() != null && policyElementDTO.getPolicyDescription().trim().length() > 0) {
            Element descriptionElement = doc.createElement("Description");
            descriptionElement.setTextContent(policyElementDTO.getPolicyDescription());
            policyElement.appendChild(descriptionElement);
        }
        return policyElement;
    }

    public static Element createMatchElement(MatchElementDTO matchElementDTO, Document doc) {
        Element matchElement = null;
        if (matchElementDTO.getMatchId() != null && matchElementDTO.getMatchId().trim().length() > 0) {
            matchElement = doc.createElement("Match");
            matchElement.setAttribute("MatchId", matchElementDTO.getMatchId());
            if (matchElementDTO.getAttributeValueElementDTO() != null) {
                Element attributeValueElement = PolicyCreatorUtil.createAttributeValueElement(matchElementDTO.getAttributeValueElementDTO(), doc);
                matchElement.appendChild(attributeValueElement);
            }
            if (matchElementDTO.getAttributeDesignatorDTO() != null) {
                Element attributeDesignatorElement = PolicyCreatorUtil.createAttributeDesignatorElement(matchElementDTO.getAttributeDesignatorDTO(), doc);
                matchElement.appendChild(attributeDesignatorElement);
            }
            if (matchElementDTO.getAttributeSelectorDTO() != null) {
                Element attributeSelectorElement = PolicyCreatorUtil.createAttributeSelectorElement(matchElementDTO.getAttributeSelectorDTO(), doc);
                matchElement.appendChild(attributeSelectorElement);
            }
        }
        return matchElement;
    }

    public static Element createAttributeValueElement(AttributeValueElementDTO attributeValueElementDTO, Document doc) {
        Element attributeValueElement = doc.createElement("AttributeValue");
        if (attributeValueElementDTO.getAttributeValue() != null && attributeValueElementDTO.getAttributeValue().trim().length() > 0) {
            attributeValueElement.setTextContent(attributeValueElementDTO.getAttributeValue().trim());
            if (attributeValueElementDTO.getAttributeDataType() != null && attributeValueElementDTO.getAttributeDataType().trim().length() > 0) {
                attributeValueElement.setAttribute("DataType", attributeValueElementDTO.getAttributeDataType());
            } else {
                attributeValueElement.setAttribute("DataType", "http://www.w3.org/2001/XMLSchema#string");
            }
        }
        return attributeValueElement;
    }

    public static Element createAttributeElement(AttributeElementDTO attributeElementDTO, Document doc) {
        Element attributeElement = doc.createElement("Attribute");
        if (attributeElementDTO.getAttributeId() != null && attributeElementDTO.getAttributeId().trim().length() > 0 && attributeElementDTO.getDataType() != null && attributeElementDTO.getDataType().trim().length() > 0 && attributeElementDTO.getAttributeValue() != null) {
            attributeElement.setAttribute("AttributeId", attributeElementDTO.getAttributeId());
            attributeElement.setAttribute("DataType", attributeElementDTO.getDataType());
            if (attributeElementDTO.getIssuer() != null && attributeElementDTO.getIssuer().trim().length() > 0) {
                attributeElement.setAttribute("Issuer", attributeElementDTO.getIssuer());
            }
            for (String attributeValue : attributeElementDTO.getAttributeValue()) {
                Element attributeValueElement = doc.createElement("AttributeValue");
                attributeValueElement.setTextContent(attributeValue);
                attributeElement.appendChild(attributeValueElement);
            }
        }
        return attributeElement;
    }

    public static Element createRequestSubElement(AttributeElementDTO attributeElementDTO, String subElementName, Document doc) {
        boolean useDefaultResourceAttributeId = false;
        Element subElement = doc.createElement(subElementName);
        for (String attributeValue : attributeElementDTO.getAttributeValue()) {
            Element attributeElement = doc.createElement("Attribute");
            if (attributeElementDTO.getAttributeId() != null && attributeElementDTO.getAttributeId().trim().length() > 0 && attributeElementDTO.getDataType() != null && attributeElementDTO.getDataType().trim().length() > 0 && attributeElementDTO.getAttributeValue() != null) {
                if ("Resource".equals(subElementName)) {
                    if (useDefaultResourceAttributeId) {
                        attributeElement.setAttribute("AttributeId", attributeElementDTO.getAttributeId());
                    } else {
                        useDefaultResourceAttributeId = true;
                        attributeElement.setAttribute("AttributeId", "urn:oasis:names:tc:xacml:1.0:resource:resource-id");
                    }
                } else {
                    attributeElement.setAttribute("AttributeId", attributeElementDTO.getAttributeId());
                }
                attributeElement.setAttribute("DataType", attributeElementDTO.getDataType());
                if (attributeElementDTO.getIssuer() != null && attributeElementDTO.getIssuer().trim().length() > 0) {
                    attributeElement.setAttribute("Issuer", attributeElementDTO.getIssuer());
                }
                Element attributeValueElement = doc.createElement("AttributeValue");
                attributeValueElement.setTextContent(attributeValue.trim());
                attributeElement.appendChild(attributeValueElement);
            }
            subElement.appendChild(attributeElement);
        }
        return subElement;
    }

    public static Element createFunctionElement(FunctionDTO functionDTO, Document doc) {
        Element functionElement = doc.createElement("Function");
        if (functionDTO.getFunctionId() != null && functionDTO.getFunctionId().trim().length() > 0) {
            functionElement.setAttribute("FunctionId", functionDTO.getFunctionId());
        }
        return functionElement;
    }

    public static Element createAttributeDesignatorElement(AttributeDesignatorDTO attributeDesignatorDTO, Document doc) {
        String attributeDesignatorElementName = "AttributeDesignator";
        Element attributeDesignatorElement = doc.createElement(attributeDesignatorElementName);
        String attributeId = attributeDesignatorDTO.getAttributeId();
        String category = attributeDesignatorDTO.getCategory();
        if (attributeId != null && attributeId.trim().length() > 0 && category != null && category.trim().length() > 0) {
            attributeDesignatorElement.setAttribute("AttributeId", attributeDesignatorDTO.getAttributeId());
            attributeDesignatorElement.setAttribute("Category", attributeDesignatorDTO.getCategory());
            if (attributeDesignatorDTO.getDataType() != null && attributeDesignatorDTO.getDataType().trim().length() > 0) {
                attributeDesignatorElement.setAttribute("DataType", attributeDesignatorDTO.getDataType());
            } else {
                attributeDesignatorElement.setAttribute("DataType", "http://www.w3.org/2001/XMLSchema#string");
            }
            if (attributeDesignatorDTO.getIssuer() != null && attributeDesignatorDTO.getIssuer().trim().length() > 0) {
                attributeDesignatorElement.setAttribute("Issuer", attributeDesignatorDTO.getIssuer());
            }
            if (attributeDesignatorDTO.getMustBePresent() != null && attributeDesignatorDTO.getMustBePresent().trim().length() > 0) {
                attributeDesignatorElement.setAttribute("MustBePresent", attributeDesignatorDTO.getMustBePresent());
            } else {
                attributeDesignatorElement.setAttribute("MustBePresent", "true");
            }
        }
        return attributeDesignatorElement;
    }

    public static Element createAttributeSelectorElement(AttributeSelectorDTO attributeSelectorDTO, Document doc) {
        Element attributeSelectorElement = doc.createElement("AttributeSelector");
        if (attributeSelectorDTO.getAttributeSelectorRequestContextPath() != null && attributeSelectorDTO.getAttributeSelectorRequestContextPath().trim().length() > 0) {
            attributeSelectorElement.setAttribute("RequestContextPath", "urn:oasis:names:tc:xacml:2.0:example:attribute:" + attributeSelectorDTO.getAttributeSelectorRequestContextPath());
            if (attributeSelectorDTO.getAttributeSelectorDataType() != null && attributeSelectorDTO.getAttributeSelectorDataType().trim().length() > 0) {
                attributeSelectorElement.setAttribute("DataType", attributeSelectorDTO.getAttributeSelectorDataType());
            } else {
                attributeSelectorElement.setAttribute("DataType", "http://www.w3.org/2001/XMLSchema#string");
            }
            if (attributeSelectorDTO.getAttributeSelectorMustBePresent() != null && attributeSelectorDTO.getAttributeSelectorMustBePresent().trim().length() > 0) {
                attributeSelectorElement.setAttribute("MustBePresent", attributeSelectorDTO.getAttributeSelectorMustBePresent());
            }
        }
        return attributeSelectorElement;
    }

    public static Element createSubElement(SubElementDTO subElementDTO, Document doc) {
        String subElementName = subElementDTO.getElementName();
        Element subElement = doc.createElement(subElementName);
        for (MatchElementDTO matchElementDTO : subElementDTO.getMatchElementDTOs()) {
            Element matchElement = PolicyCreatorUtil.createMatchElement(matchElementDTO, doc);
            if (matchElement == null) continue;
            subElement.appendChild(matchElement);
        }
        return subElement;
    }

    public static Element createTargetElement(List<SubElementDTO> subElementDTOs, Document doc) {
        Element targetElement = doc.createElement("Target");
        String subjectElementName = "Subjects";
        String actionElementName = "Actions";
        String resourceElementName = "Resources";
        String enviornementElementName = "Environments";
        Element subjectElement = doc.createElement(subjectElementName);
        Element actionElement = doc.createElement(actionElementName);
        Element resourceElement = doc.createElement(resourceElementName);
        Element enviornementElement = doc.createElement(enviornementElementName);
        for (SubElementDTO subElementDTO : subElementDTOs) {
            Element subParentElement;
            if (subElementDTO.getElementName().equals("Subject")) {
                subParentElement = PolicyCreatorUtil.createSubElement(subElementDTO, doc);
                subjectElement.appendChild(subParentElement);
            }
            if (subElementDTO.getElementName().equals("Action")) {
                subParentElement = PolicyCreatorUtil.createSubElement(subElementDTO, doc);
                actionElement.appendChild(subParentElement);
            }
            if (subElementDTO.getElementName().equals("Resource")) {
                subParentElement = PolicyCreatorUtil.createSubElement(subElementDTO, doc);
                resourceElement.appendChild(subParentElement);
            }
            if (!subElementDTO.getElementName().equals("Environment")) continue;
            subParentElement = PolicyCreatorUtil.createSubElement(subElementDTO, doc);
            enviornementElement.appendChild(subParentElement);
        }
        targetElement.appendChild(subjectElement);
        targetElement.appendChild(actionElement);
        targetElement.appendChild(resourceElement);
        targetElement.appendChild(enviornementElement);
        return targetElement;
    }

    public static Element createRuleElement(RuleElementDTO ruleElementDTO, Document doc) {
        NewTargetElementDTO targetElementDTO = ruleElementDTO.getNewTargetElementDTO();
        ConditionElementDT0 conditionElementDT0 = ruleElementDTO.getConditionElementDT0();
        Element ruleElement = doc.createElement("Rule");
        if (ruleElementDTO.getRuleId() != null && ruleElementDTO.getRuleId().trim().length() > 0) {
            ruleElement.setAttribute("RuleId", ruleElementDTO.getRuleId());
        }
        if (ruleElementDTO.getRuleEffect() != null && ruleElementDTO.getRuleEffect().trim().length() > 0) {
            ruleElement.setAttribute("Effect", ruleElementDTO.getRuleEffect());
        }
        if (ruleElementDTO.getRuleDescription() != null && ruleElementDTO.getRuleDescription().trim().length() > 0) {
            Element descriptionElement = doc.createElement("Description");
            descriptionElement.setTextContent(ruleElementDTO.getRuleDescription());
            ruleElement.appendChild(descriptionElement);
        }
        if (targetElementDTO != null) {
            Element targetElement = PolicyEditorUtil.createTargetElement(targetElementDTO, doc);
            ruleElement.appendChild(targetElement);
        }
        if (conditionElementDT0 != null) {
            ruleElement.appendChild(PolicyCreatorUtil.createConditionElement(conditionElementDT0, doc));
        }
        return ruleElement;
    }

    public static Element createConditionElement(ConditionElementDT0 conditionElementDT0, Document doc) {
        Element conditionElement = doc.createElement("Condition");
        if (conditionElementDT0.getApplyElement() != null) {
            conditionElement.appendChild(PolicyCreatorUtil.createApplyElement(conditionElementDT0.getApplyElement(), doc));
        } else if (conditionElementDT0.getAttributeValueElementDTO() != null) {
            Element attributeValueElement = PolicyCreatorUtil.createAttributeValueElement(conditionElementDT0.getAttributeValueElementDTO(), doc);
            conditionElement.appendChild(attributeValueElement);
        } else if (conditionElementDT0.getAttributeDesignator() != null) {
            AttributeDesignatorDTO attributeDesignatorDTO = conditionElementDT0.getAttributeDesignator();
            conditionElement.appendChild(PolicyCreatorUtil.createAttributeDesignatorElement(attributeDesignatorDTO, doc));
        } else if (conditionElementDT0.getFunctionFunctionId() != null) {
            Element functionElement = doc.createElement("Function");
            functionElement.setAttribute("FunctionId", conditionElementDT0.getFunctionFunctionId());
            conditionElement.appendChild(functionElement);
        } else if (conditionElementDT0.getVariableId() != null) {
            Element variableReferenceElement = doc.createElement("VariableReference");
            variableReferenceElement.setAttribute("VariableId", conditionElementDT0.getVariableId());
            conditionElement.appendChild(variableReferenceElement);
        }
        return conditionElement;
    }

    public static Element createApplyElement(ApplyElementDTO applyElementDTO, Document doc) {
        List<AttributeSelectorDTO> attributeSelectorDTOs;
        List<AttributeDesignatorDTO> attributeDesignatorDTOs;
        List<AttributeValueElementDTO> attributeValueElementDTOs;
        List<ApplyElementDTO> applyElementDTOs;
        Element applyElement = doc.createElement("Apply");
        if (applyElementDTO.getFunctionId() != null && applyElementDTO.getFunctionId().trim().length() > 0) {
            applyElement.setAttribute("FunctionId", applyElementDTO.getFunctionId());
        }
        if (applyElementDTO.getFunctionFunctionId() != null && applyElementDTO.getFunctionFunctionId().trim().length() > 0) {
            FunctionDTO functionDTO = new FunctionDTO();
            functionDTO.setFunctionId(applyElementDTO.getFunctionFunctionId());
            Element functionElement = PolicyCreatorUtil.createFunctionElement(functionDTO, doc);
            applyElement.appendChild(functionElement);
        }
        if ((applyElementDTOs = applyElementDTO.getApplyElements()) != null && applyElementDTOs.size() > 0) {
            for (ApplyElementDTO elementDTO : applyElementDTOs) {
                Element subApplyElement = PolicyCreatorUtil.createApplyElement(elementDTO, doc);
                applyElement.appendChild(subApplyElement);
            }
        }
        if ((attributeValueElementDTOs = applyElementDTO.getAttributeValueElementDTOs()) != null && attributeValueElementDTOs.size() > 0) {
            for (AttributeValueElementDTO attributeValueElementDTO : attributeValueElementDTOs) {
                Element attributeValueElement = PolicyCreatorUtil.createAttributeValueElement(attributeValueElementDTO, doc);
                applyElement.appendChild(attributeValueElement);
            }
        }
        if ((attributeDesignatorDTOs = applyElementDTO.getAttributeDesignators()) != null && attributeDesignatorDTOs.size() > 0) {
            for (AttributeDesignatorDTO attributeDesignatorDTO : attributeDesignatorDTOs) {
                Element attributeDesignatorElement = PolicyCreatorUtil.createAttributeDesignatorElement(attributeDesignatorDTO, doc);
                applyElement.appendChild(attributeDesignatorElement);
            }
        }
        if ((attributeSelectorDTOs = applyElementDTO.getAttributeSelectors()) != null && attributeSelectorDTOs.size() > 0) {
            for (AttributeSelectorDTO attributeSelectorDTO : attributeSelectorDTOs) {
                Element attributeSelectorElement = PolicyCreatorUtil.createAttributeSelectorElement(attributeSelectorDTO, doc);
                applyElement.appendChild(attributeSelectorElement);
            }
        }
        return applyElement;
    }

    public static ApplyElementDTO createApplyElementForBagFunctions(String functionId, String attributeDesignatorType, String attributeDesignatorId, String[] attributeValues) {
        ApplyElementDTO applyElementDTO = new ApplyElementDTO();
        if (attributeValues != null && functionId != null && functionId.trim().length() > 0 && attributeDesignatorType != null && attributeDesignatorType.trim().length() > 0 && attributeDesignatorId != null && attributeDesignatorId.trim().length() > 0) {
            ApplyElementDTO applyElementDTOBag = new ApplyElementDTO();
            for (String attributeValue : attributeValues) {
                AttributeValueElementDTO attributeValueElementDTO = new AttributeValueElementDTO();
                attributeValueElementDTO.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
                attributeValueElementDTO.setAttributeValue(attributeValue.trim());
                applyElementDTOBag.setAttributeValueElementDTO(attributeValueElementDTO);
            }
            applyElementDTOBag.setFunctionId("urn:oasis:names:tc:xacml:1.0:function:string-bag");
            AttributeDesignatorDTO attributeDesignatorDTO = new AttributeDesignatorDTO();
            attributeDesignatorDTO.setDataType("http://www.w3.org/2001/XMLSchema#string");
            attributeDesignatorDTO.setAttributeId(attributeDesignatorId);
            attributeDesignatorDTO.setElementName(attributeDesignatorType);
            applyElementDTO.setApplyElement(applyElementDTOBag);
            applyElementDTO.setAttributeDesignators(attributeDesignatorDTO);
            applyElementDTO.setFunctionId(functionId);
        }
        return applyElementDTO;
    }

    public static ApplyElementDTO createApplyElementForNonBagFunctions(String functionId, String attributeDesignatorType, String attributeDesignatorId, String attributeValue) {
        ApplyElementDTO applyElementDTO = new ApplyElementDTO();
        if (attributeValue != null && attributeValue.trim().length() > 0 && functionId != null && functionId.trim().length() > 0 && attributeDesignatorType != null && attributeDesignatorType.trim().length() > 0 && attributeDesignatorId != null && attributeDesignatorId.trim().length() > 0) {
            AttributeValueElementDTO attributeValueElementDTO = new AttributeValueElementDTO();
            attributeValueElementDTO.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
            attributeValueElementDTO.setAttributeValue(attributeValue.trim());
            AttributeDesignatorDTO attributeDesignatorDTO = new AttributeDesignatorDTO();
            attributeDesignatorDTO.setDataType("http://www.w3.org/2001/XMLSchema#string");
            attributeDesignatorDTO.setAttributeId(attributeDesignatorId);
            attributeDesignatorDTO.setElementName(attributeDesignatorType);
            applyElementDTO.setAttributeValueElementDTO(attributeValueElementDTO);
            applyElementDTO.setAttributeDesignators(attributeDesignatorDTO);
            applyElementDTO.setFunctionId(functionId);
        }
        return applyElementDTO;
    }

    public static ApplyElementDTO createApplyElementForNonBagFunctionsWithAnyOf(String functionId, String attributeDesignatorType, String attributeDesignatorId, String attributeValue) {
        ApplyElementDTO applyElementDTO = new ApplyElementDTO();
        if (attributeValue != null && attributeValue.trim().length() > 0 && functionId != null && functionId.trim().length() > 0 && attributeDesignatorType != null && attributeDesignatorType.trim().length() > 0 && attributeDesignatorId != null && attributeDesignatorId.trim().length() > 0) {
            AttributeValueElementDTO attributeValueElementDTO = new AttributeValueElementDTO();
            attributeValueElementDTO.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
            attributeValueElementDTO.setAttributeValue(attributeValue.trim());
            AttributeDesignatorDTO attributeDesignatorDTO = new AttributeDesignatorDTO();
            attributeDesignatorDTO.setDataType("http://www.w3.org/2001/XMLSchema#string");
            attributeDesignatorDTO.setAttributeId(attributeDesignatorId);
            attributeDesignatorDTO.setElementName(attributeDesignatorType);
            applyElementDTO.setFunctionFunctionId(functionId);
            applyElementDTO.setAttributeValueElementDTO(attributeValueElementDTO);
            applyElementDTO.setAttributeDesignators(attributeDesignatorDTO);
            applyElementDTO.setFunctionId("urn:oasis:names:tc:xacml:1.0:function:any-of");
        }
        return applyElementDTO;
    }

    public static MatchElementDTO createMatchElementForNonBagFunctions(String functionId, String attributeValue, String attributeDesignatorType, String attributeDesignatorId) {
        MatchElementDTO matchElementDTO = new MatchElementDTO();
        if (functionId != null && functionId.trim().length() > 0 && attributeValue != null && attributeValue.trim().length() > 0 && attributeDesignatorType != null && attributeDesignatorType.trim().length() > 0 && attributeDesignatorId != null && attributeDesignatorId.trim().length() > 0) {
            AttributeValueElementDTO attributeValueElementDTO = new AttributeValueElementDTO();
            attributeValueElementDTO.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
            attributeValueElementDTO.setAttributeValue(attributeValue.trim());
            AttributeDesignatorDTO attributeDesignatorDTO = new AttributeDesignatorDTO();
            attributeDesignatorDTO.setDataType("http://www.w3.org/2001/XMLSchema#string");
            attributeDesignatorDTO.setAttributeId(attributeDesignatorId);
            attributeDesignatorDTO.setElementName(attributeDesignatorType);
            matchElementDTO.setMatchElementName(attributeDesignatorType);
            matchElementDTO.setMatchId(functionId);
            matchElementDTO.setAttributeValueElementDTO(attributeValueElementDTO);
            matchElementDTO.setAttributeDesignatorDTO(attributeDesignatorDTO);
        }
        return matchElementDTO;
    }

    public static Element createBasicRuleElementDTO(BasicRuleElementDTO basicRuleElementDTO, Document doc) {
        ApplyElementDTO elementDTO;
        Element matchElement;
        MatchElementDTO matchElementDTO;
        String functionOnResources = basicRuleElementDTO.getFunctionOnResources();
        String functionOnSubjects = basicRuleElementDTO.getFunctionOnSubjects();
        String functionOnActions = basicRuleElementDTO.getFunctionOnActions();
        String functionOnEnvironment = basicRuleElementDTO.getFunctionOnEnvironment();
        String functionOnUserAttributes = basicRuleElementDTO.getFunctionOnAttributes();
        String resourceNames = basicRuleElementDTO.getResourceList();
        String actionNames = basicRuleElementDTO.getActionList();
        String subjectNames = basicRuleElementDTO.getSubjectList();
        String environmentNames = basicRuleElementDTO.getEnvironmentList();
        String userAttributeValue = basicRuleElementDTO.getUserAttributeValue();
        String resourceId = basicRuleElementDTO.getResourceId();
        String subjectId = basicRuleElementDTO.getSubjectId();
        String actionId = basicRuleElementDTO.getActionId();
        String environmentId = basicRuleElementDTO.getEnvironmentId();
        String attributeId = basicRuleElementDTO.getAttributeId();
        String subjectType = basicRuleElementDTO.getSubjectType();
        String resourceDataType = basicRuleElementDTO.getResourceDataType();
        String subjectDataType = basicRuleElementDTO.getSubjectDataType();
        String actionDataType = basicRuleElementDTO.getActionDataType();
        String environmentDataType = basicRuleElementDTO.getResourceDataType();
        Element resourcesElement = null;
        Element actionsElement = null;
        Element subjectsElement = null;
        Element environmentsElement = null;
        Element targetElement = null;
        Element applyElement = null;
        Element conditionElement = null;
        Element ruleElement = null;
        ApplyElementDTO applyElementDTO = new ApplyElementDTO();
        if (resourceNames != null && resourceNames.trim().length() > 0) {
            String[] resources = resourceNames.split(",");
            if (resourceId == null || resourceId.trim().length() < 1) {
                resourceId = "urn:oasis:names:tc:xacml:1.0:resource:resource-id";
            }
            if (functionOnResources.equals("equals to") || functionOnResources.equals("matching reg-ex to")) {
                resourcesElement = doc.createElement("Resources");
                Element resourceElement = doc.createElement("Resource");
                matchElementDTO = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId(functionOnResources), resources[0], "Resource", resourceId);
                matchElement = PolicyCreatorUtil.createMatchElement(matchElementDTO, doc);
                if (matchElement != null) {
                    resourceElement.appendChild(matchElement);
                }
                resourcesElement.appendChild(resourceElement);
            } else if (functionOnResources.equals("in")) {
                elementDTO = PolicyCreatorUtil.createApplyElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId(functionOnResources), "Resource", resourceId, resources[0]);
                applyElementDTO.setApplyElement(elementDTO);
            } else {
                elementDTO = PolicyCreatorUtil.createApplyElementForBagFunctions(PolicyCreatorUtil.getFunctionId(functionOnResources), "Resource", resourceId, resources);
                applyElementDTO.setApplyElement(elementDTO);
            }
        }
        if (actionNames != null && actionNames.trim().length() > 0) {
            String[] actions = actionNames.split(",");
            if (actionId == null || actionId.trim().length() < 1) {
                actionId = "urn:oasis:names:tc:xacml:1.0:action:action-id";
            }
            if (functionOnActions.equals("equals to") || functionOnActions.equals("matching reg-ex to")) {
                actionsElement = doc.createElement("Actions");
                Element actionElement = doc.createElement("Action");
                matchElementDTO = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId(functionOnActions), actions[0], "Action", actionId);
                matchElement = PolicyCreatorUtil.createMatchElement(matchElementDTO, doc);
                if (matchElement != null) {
                    actionElement.appendChild(matchElement);
                }
                actionsElement.appendChild(actionElement);
            } else if (functionOnActions.equals("in")) {
                elementDTO = PolicyCreatorUtil.createApplyElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId(functionOnActions), "Action", actionId, actions[0]);
                applyElementDTO.setApplyElement(elementDTO);
            } else {
                elementDTO = PolicyCreatorUtil.createApplyElementForBagFunctions(PolicyCreatorUtil.getFunctionId(functionOnActions), "Action", actionId, actions);
                applyElementDTO.setApplyElement(elementDTO);
            }
        }
        if (environmentNames != null && environmentNames.trim().length() > 0) {
            String[] environments = environmentNames.split(",");
            if (environmentId == null || environmentId.trim().length() < 1) {
                environmentId = "urn:oasis:names:tc:xacml:1.0:environment:environment-id";
            }
            if (functionOnEnvironment.equals("equals to") || functionOnEnvironment.equals("matching reg-ex to")) {
                environmentsElement = doc.createElement("Environments");
                Element environmentElement = doc.createElement("Environment");
                matchElementDTO = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId(functionOnEnvironment), environments[0], "Environment", environmentId);
                matchElement = PolicyCreatorUtil.createMatchElement(matchElementDTO, doc);
                if (matchElement != null) {
                    environmentElement.appendChild(matchElement);
                }
                environmentsElement.appendChild(environmentElement);
            } else if (functionOnEnvironment.equals("in")) {
                elementDTO = PolicyCreatorUtil.createApplyElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId(functionOnEnvironment), "Environment", environmentId, environments[0]);
                applyElementDTO.setApplyElement(elementDTO);
            } else {
                elementDTO = PolicyCreatorUtil.createApplyElementForBagFunctions(PolicyCreatorUtil.getFunctionId(functionOnEnvironment), "Environment", environmentId, environments);
                applyElementDTO.setApplyElement(elementDTO);
            }
        }
        if (subjectNames != null && subjectNames.trim().length() > 0) {
            String[] subjects = subjectNames.split(",");
            if (subjectId == null || subjectId.trim().length() < 1) {
                subjectId = "Roles".equals(subjectType) ? "http://wso2.org/claims/role" : "urn:oasis:names:tc:xacml:1.0:subject:subject-id";
            }
            if ((elementDTO = functionOnSubjects.equals("equals to") || functionOnSubjects.equals("matching reg-ex to") ? PolicyCreatorUtil.createApplyElementForNonBagFunctionsWithAnyOf(PolicyCreatorUtil.getFunctionId(functionOnSubjects), "Subject", subjectId, subjects[0]) : (functionOnSubjects.equals("in") ? PolicyCreatorUtil.createApplyElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId(functionOnSubjects), "Subject", subjectId, subjects[0]) : PolicyCreatorUtil.createApplyElementForBagFunctions(PolicyCreatorUtil.getFunctionId(functionOnSubjects), "Subject", subjectId, subjects))) != null) {
                applyElementDTO.setApplyElement(elementDTO);
            }
            if (userAttributeValue != null && userAttributeValue.trim().length() > 0) {
                subjectsElement = doc.createElement("Subjects");
                Element subjectElement = doc.createElement("Subject");
                if (functionOnUserAttributes.equals("equals to") || functionOnUserAttributes.equals("matching reg-ex to")) {
                    MatchElementDTO matchElementDTO2 = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId(functionOnUserAttributes), userAttributeValue, "Subject", attributeId);
                    Element matchElement2 = PolicyCreatorUtil.createMatchElement(matchElementDTO2, doc);
                    if (matchElement2 != null) {
                        subjectElement.appendChild(matchElement2);
                    }
                    subjectsElement.appendChild(subjectElement);
                }
                subjectsElement.appendChild(subjectElement);
            }
        } else if (userAttributeValue != null && userAttributeValue.trim().length() > 0 && (functionOnUserAttributes.equals("equals to") || functionOnUserAttributes.equals("matching reg-ex to"))) {
            subjectsElement = doc.createElement("Subjects");
            Element subjectElement = doc.createElement("Subject");
            MatchElementDTO matchElementDTO3 = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId(functionOnUserAttributes), userAttributeValue, "Subject", attributeId);
            Element matchElement3 = PolicyCreatorUtil.createMatchElement(matchElementDTO3, doc);
            if (matchElement3 != null) {
                subjectElement.appendChild(matchElement3);
            }
            subjectsElement.appendChild(subjectElement);
            subjectsElement.appendChild(subjectElement);
        }
        List<ApplyElementDTO> applyElementDTOs = applyElementDTO.getApplyElements();
        if (applyElementDTOs.size() > 1) {
            applyElementDTO.setFunctionId("urn:oasis:names:tc:xacml:1.0:function:and");
            applyElement = PolicyCreatorUtil.createApplyElement(applyElementDTO, doc);
        } else if (applyElementDTOs.size() == 1) {
            applyElement = PolicyCreatorUtil.createApplyElement(applyElementDTOs.get(0), doc);
        }
        if (resourcesElement != null || actionsElement != null || subjectsElement != null || environmentsElement != null) {
            targetElement = doc.createElement("Target");
            if (resourcesElement != null) {
                targetElement.appendChild(resourcesElement);
            }
            if (actionsElement != null) {
                targetElement.appendChild(actionsElement);
            }
            if (subjectsElement != null) {
                targetElement.appendChild(subjectsElement);
            }
            if (environmentsElement != null) {
                targetElement.appendChild(environmentsElement);
            }
        }
        if (applyElement != null) {
            conditionElement = doc.createElement("Condition");
            conditionElement.appendChild(applyElement);
        }
        if (basicRuleElementDTO.getRuleId() != null && basicRuleElementDTO.getRuleId().trim().length() > 0 && basicRuleElementDTO.getRuleEffect() != null && basicRuleElementDTO.getRuleEffect().trim().length() > 0) {
            ruleElement = doc.createElement("Rule");
            ruleElement.setAttribute("RuleId", basicRuleElementDTO.getRuleId());
            ruleElement.setAttribute("Effect", basicRuleElementDTO.getRuleEffect());
            if (basicRuleElementDTO.getRuleDescription() != null && basicRuleElementDTO.getRuleDescription().trim().length() > 0) {
                ruleElement.setAttribute("Description", basicRuleElementDTO.getRuleDescription());
            }
            if (targetElement != null) {
                ruleElement.appendChild(targetElement);
            }
            if (conditionElement != null) {
                ruleElement.appendChild(conditionElement);
            }
        }
        return ruleElement;
    }

    public static Element createBasicTargetElementDTO(BasicTargetElementDTO basicTargetElementDTO, Document doc) {
        Element subjectElement;
        Element matchElement;
        MatchElementDTO matchElementDTO;
        Element matchElement2;
        MatchElementDTO matchElementDTO2;
        Element matchElement3;
        MatchElementDTO matchElementDTO3;
        String functionOnResources = basicTargetElementDTO.getFunctionOnResources();
        String functionOnSubjects = basicTargetElementDTO.getFunctionOnSubjects();
        String functionOnActions = basicTargetElementDTO.getFunctionOnActions();
        String functionOnEnvironment = basicTargetElementDTO.getFunctionOnEnvironment();
        String functionOnUserAttributes = basicTargetElementDTO.getFunctionOnAttributes();
        String resourceNames = basicTargetElementDTO.getResourceList();
        String actionNames = basicTargetElementDTO.getActionList();
        String subjectNames = basicTargetElementDTO.getSubjectList();
        String environmentNames = basicTargetElementDTO.getEnvironmentList();
        String resourceId = basicTargetElementDTO.getResourceId();
        String subjectId = basicTargetElementDTO.getSubjectId();
        String actionId = basicTargetElementDTO.getActionId();
        String environmentId = basicTargetElementDTO.getEnvironmentId();
        String userAttributeValue = basicTargetElementDTO.getUserAttributeValue();
        String attributeId = basicTargetElementDTO.getAttributeId();
        String subjectType = basicTargetElementDTO.getSubjectType();
        Element resourcesElement = null;
        Element actionsElement = null;
        Element subjectsElement = null;
        Element environmentsElement = null;
        Element targetElement = doc.createElement("Target");
        if (resourceNames != null && resourceNames.trim().length() > 0) {
            Element resourceEle;
            resourcesElement = doc.createElement("Resources");
            Element resourceElement = doc.createElement("Resource");
            String[] resources = resourceNames.split(",");
            if (resourceId == null || resourceId.trim().length() < 1) {
                resourceId = "urn:oasis:names:tc:xacml:1.0:resource:resource-id";
            }
            if (functionOnResources.equals("equals to") || functionOnResources.equals("matching reg-ex to")) {
                matchElementDTO3 = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId(functionOnResources), resources[0], "Resource", resourceId);
                matchElement3 = PolicyCreatorUtil.createMatchElement(matchElementDTO3, doc);
                if (matchElement3 != null) {
                    resourceElement.appendChild(matchElement3);
                }
                resourcesElement.appendChild(resourceElement);
            } else if (functionOnResources.equals("at-least-one-matching-member-of")) {
                for (String resource : resources) {
                    resourceEle = doc.createElement("Resource");
                    matchElementDTO2 = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId("equals to"), resource, "Resource", resourceId);
                    matchElement2 = PolicyCreatorUtil.createMatchElement(matchElementDTO2, doc);
                    if (matchElement2 != null) {
                        resourceEle.appendChild(matchElement2);
                    }
                    resourcesElement.appendChild(resourceEle);
                }
            } else if (functionOnResources.equals("at-least-one-matching-reg-ex-member-of")) {
                for (String resource : resources) {
                    resourceEle = doc.createElement("Resource");
                    matchElementDTO2 = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId("matching reg-ex to"), resource, "Resource", resourceId);
                    matchElement2 = PolicyCreatorUtil.createMatchElement(matchElementDTO2, doc);
                    if (matchElement2 != null) {
                        resourceEle.appendChild(matchElement2);
                    }
                    resourcesElement.appendChild(resourceEle);
                }
            } else if (functionOnResources.equals("a matching reg-ex set of")) {
                for (String resource : resources) {
                    matchElementDTO = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId("matching reg-ex to"), resource, "Resource", resourceId);
                    matchElement = PolicyCreatorUtil.createMatchElement(matchElementDTO, doc);
                    if (matchElement == null) continue;
                    resourceElement.appendChild(matchElement);
                }
                resourcesElement.appendChild(resourceElement);
            } else if (functionOnResources.equals("a matching set of")) {
                for (String resource : resources) {
                    matchElementDTO = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId("equals to"), resource, "Resource", resourceId);
                    matchElement = PolicyCreatorUtil.createMatchElement(matchElementDTO, doc);
                    if (matchElement == null) continue;
                    resourceElement.appendChild(matchElement);
                }
                resourcesElement.appendChild(resourceElement);
            }
        }
        if (actionNames != null && actionNames.trim().length() > 0) {
            Element actionEle;
            actionsElement = doc.createElement("Actions");
            Element actionElement = doc.createElement("Action");
            String[] actions = actionNames.split(",");
            if (actionId == null || actionId.trim().length() < 1) {
                actionId = "urn:oasis:names:tc:xacml:1.0:action:action-id";
            }
            if (functionOnActions.equals("equals to") || functionOnActions.equals("matching reg-ex to")) {
                matchElementDTO3 = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId(functionOnActions), actions[0], "Action", actionId);
                matchElement3 = PolicyCreatorUtil.createMatchElement(matchElementDTO3, doc);
                if (matchElement3 != null) {
                    actionElement.appendChild(matchElement3);
                }
                actionsElement.appendChild(actionElement);
            } else if (functionOnActions.equals("at-least-one-matching-member-of")) {
                for (String action : actions) {
                    actionEle = doc.createElement("Action");
                    matchElementDTO2 = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId("equals to"), action, "Action", actionId);
                    matchElement2 = PolicyCreatorUtil.createMatchElement(matchElementDTO2, doc);
                    if (matchElement2 != null) {
                        actionEle.appendChild(matchElement2);
                    }
                    actionsElement.appendChild(actionEle);
                }
            } else if (functionOnActions.equals("at-least-one-matching-reg-ex-member-of")) {
                for (String action : actions) {
                    actionEle = doc.createElement("Action");
                    matchElementDTO2 = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId("matching reg-ex to"), action, "Action", actionId);
                    matchElement2 = PolicyCreatorUtil.createMatchElement(matchElementDTO2, doc);
                    if (matchElement2 != null) {
                        actionEle.appendChild(matchElement2);
                    }
                    actionsElement.appendChild(actionEle);
                }
            } else if (functionOnActions.equals("a matching reg-ex set of")) {
                for (String action : actions) {
                    matchElementDTO = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId("matching reg-ex to"), action, "Action", actionId);
                    matchElement = PolicyCreatorUtil.createMatchElement(matchElementDTO, doc);
                    if (matchElement == null) continue;
                    actionElement.appendChild(matchElement);
                }
                actionsElement.appendChild(actionElement);
            } else if (functionOnActions.equals("a matching set of")) {
                for (String action : actions) {
                    matchElementDTO = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId("equals to"), action, "Action", actionId);
                    matchElement = PolicyCreatorUtil.createMatchElement(matchElementDTO, doc);
                    if (matchElement == null) continue;
                    actionElement.appendChild(matchElement);
                }
                actionsElement.appendChild(actionElement);
            }
        }
        if (environmentNames != null && environmentNames.trim().length() > 0) {
            Element environmentEle;
            environmentsElement = doc.createElement("Environments");
            Element environmentElement = doc.createElement("Environment");
            String[] environments = environmentNames.split(",");
            if (environmentId == null || environmentId.trim().length() < 1) {
                environmentId = "urn:oasis:names:tc:xacml:1.0:environment:environment-id";
            }
            if (functionOnEnvironment.equals("equals to") || functionOnEnvironment.equals("matching reg-ex to")) {
                matchElementDTO3 = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId(functionOnEnvironment), environments[0], "Environment", environmentId);
                Element matchElement4 = PolicyCreatorUtil.createMatchElement(matchElementDTO3, doc);
                if (matchElement4 != null) {
                    environmentElement.appendChild(matchElement4);
                }
                environmentsElement.appendChild(environmentElement);
            } else if (functionOnEnvironment.equals("at-least-one-matching-member-of")) {
                for (String environment : environments) {
                    environmentEle = doc.createElement("Environment");
                    matchElementDTO2 = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId("equals to"), environment, "Environment", environmentId);
                    matchElement2 = PolicyCreatorUtil.createMatchElement(matchElementDTO2, doc);
                    if (matchElement2 != null) {
                        environmentEle.appendChild(matchElement2);
                    }
                    environmentsElement.appendChild(environmentEle);
                }
            } else if (functionOnEnvironment.equals("at-least-one-matching-reg-ex-member-of")) {
                for (String environment : environments) {
                    environmentEle = doc.createElement("Environment");
                    matchElementDTO2 = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId("matching reg-ex to"), environment, "Environment", environmentId);
                    matchElement2 = PolicyCreatorUtil.createMatchElement(matchElementDTO2, doc);
                    if (matchElement2 != null) {
                        environmentEle.appendChild(matchElement2);
                    }
                    environmentsElement.appendChild(environmentEle);
                }
            } else if (functionOnEnvironment.equals("a matching reg-ex set of")) {
                for (String environment : environments) {
                    matchElementDTO = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId("matching reg-ex to"), environment, "Environment", environmentId);
                    matchElement = PolicyCreatorUtil.createMatchElement(matchElementDTO, doc);
                    if (matchElement == null) continue;
                    environmentElement.appendChild(matchElement);
                }
                environmentsElement.appendChild(environmentElement);
            } else if (functionOnEnvironment.equals("a matching set of")) {
                for (String environment : environments) {
                    matchElementDTO = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId("equals to"), environment, "Environment", environmentId);
                    matchElement = PolicyCreatorUtil.createMatchElement(matchElementDTO, doc);
                    if (matchElement == null) continue;
                    environmentElement.appendChild(matchElement);
                }
                environmentsElement.appendChild(environmentElement);
            }
        }
        if (subjectNames != null && subjectNames.trim().length() > 0) {
            Element subjectEle;
            subjectsElement = doc.createElement("Subjects");
            subjectElement = doc.createElement("Subject");
            String[] subjects = subjectNames.split(",");
            if (subjectId == null || subjectId.trim().length() < 1) {
                subjectId = "Roles".equals(subjectType) ? "http://wso2.org/claims/role" : "urn:oasis:names:tc:xacml:1.0:subject:subject-id";
            }
            if (functionOnSubjects.equals("equals to") || functionOnSubjects.equals("matching reg-ex to")) {
                matchElementDTO3 = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId(functionOnSubjects), subjects[0], "Subject", subjectId);
                Element matchElement5 = PolicyCreatorUtil.createMatchElement(matchElementDTO3, doc);
                if (matchElement5 != null) {
                    subjectElement.appendChild(matchElement5);
                }
                subjectsElement.appendChild(subjectElement);
            } else if (functionOnSubjects.equals("at-least-one-matching-member-of")) {
                for (String subject : subjects) {
                    subjectEle = doc.createElement("Subject");
                    matchElementDTO2 = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId("equals to"), subject, "Subject", subjectId);
                    matchElement2 = PolicyCreatorUtil.createMatchElement(matchElementDTO2, doc);
                    if (matchElement2 != null) {
                        subjectEle.appendChild(matchElement2);
                    }
                    subjectsElement.appendChild(subjectEle);
                }
            } else if (functionOnSubjects.equals("at-least-one-matching-reg-ex-member-of")) {
                for (String subject : subjects) {
                    subjectEle = doc.createElement("Subject");
                    matchElementDTO2 = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId("matching reg-ex to"), subject, "Subject", subjectId);
                    matchElement2 = PolicyCreatorUtil.createMatchElement(matchElementDTO2, doc);
                    if (matchElement2 != null) {
                        subjectEle.appendChild(matchElement2);
                    }
                    subjectsElement.appendChild(subjectEle);
                }
            } else if (functionOnSubjects.equals("a matching set of")) {
                for (String subject : subjects) {
                    matchElementDTO = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId("equals to"), subject, "Subject", subjectId);
                    matchElement = PolicyCreatorUtil.createMatchElement(matchElementDTO, doc);
                    if (matchElement == null) continue;
                    subjectElement.appendChild(matchElement);
                }
                subjectsElement.appendChild(subjectElement);
            } else if (functionOnSubjects.equals("a matching reg-ex set of")) {
                for (String subject : subjects) {
                    matchElementDTO = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId("matching reg-ex to"), subject, "Subject", subjectId);
                    matchElement = PolicyCreatorUtil.createMatchElement(matchElementDTO, doc);
                    if (matchElement == null) continue;
                    subjectElement.appendChild(matchElement);
                }
                subjectsElement.appendChild(subjectElement);
            }
            if (userAttributeValue != null && userAttributeValue.trim().length() > 0 && (functionOnUserAttributes.equals("equals to") || functionOnUserAttributes.equals("matching reg-ex to"))) {
                matchElementDTO3 = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId(functionOnUserAttributes), userAttributeValue, "Subject", attributeId);
                Element matchElement6 = PolicyCreatorUtil.createMatchElement(matchElementDTO3, doc);
                if (matchElement6 != null) {
                    subjectElement.appendChild(matchElement6);
                }
                subjectsElement.appendChild(subjectElement);
            }
        } else if (userAttributeValue != null && userAttributeValue.trim().length() > 0) {
            subjectsElement = doc.createElement("Subjects");
            subjectElement = doc.createElement("Subject");
            if (functionOnUserAttributes.equals("equals to") || functionOnUserAttributes.equals("matching reg-ex to")) {
                MatchElementDTO matchElementDTO4 = PolicyCreatorUtil.createMatchElementForNonBagFunctions(PolicyCreatorUtil.getFunctionId(functionOnUserAttributes), userAttributeValue, "Subject", attributeId);
                Element matchElement7 = PolicyCreatorUtil.createMatchElement(matchElementDTO4, doc);
                if (matchElement7 != null) {
                    subjectElement.appendChild(matchElement7);
                }
                subjectsElement.appendChild(subjectElement);
            }
        }
        if (resourcesElement != null) {
            targetElement.appendChild(resourcesElement);
        }
        if (actionsElement != null) {
            targetElement.appendChild(actionsElement);
        }
        if (subjectsElement != null) {
            targetElement.appendChild(subjectsElement);
        }
        if (environmentsElement != null) {
            targetElement.appendChild(environmentsElement);
        }
        return targetElement;
    }

    public static Element createBasicRequestElement(BasicRequestDTO basicRequestDTO, Document doc) {
        String[] subjects;
        AttributeElementDTO attributeElementDTO = new AttributeElementDTO();
        Element requestElement = doc.createElement("Request");
        requestElement.setAttribute("xmlns", "urn:oasis:names:tc:xacml:2.0:context:schema:os");
        requestElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        Element resourceElement = null;
        Element subjectElement = null;
        Element actionElement = null;
        Element enviornementElement = null;
        Element userAttributeElement = null;
        if (basicRequestDTO.getResources() != null && basicRequestDTO.getResources().trim().length() > 0) {
            String[] resources = basicRequestDTO.getResources().split(",");
            attributeElementDTO.setAttributeValue(Arrays.asList(resources));
            attributeElementDTO.setDataType("http://www.w3.org/2001/XMLSchema#string");
            attributeElementDTO.setAttributeId("urn:oasis:names:tc:xacml:1.0:resource:resource");
            resourceElement = PolicyCreatorUtil.createRequestSubElement(attributeElementDTO, "Resource", doc);
        }
        if (basicRequestDTO.getSubjects() != null && basicRequestDTO.getSubjects().trim().length() > 0) {
            subjects = basicRequestDTO.getSubjects().split(",");
            attributeElementDTO.setAttributeValue(Arrays.asList(subjects));
            attributeElementDTO.setDataType("http://www.w3.org/2001/XMLSchema#string");
            attributeElementDTO.setAttributeId("urn:oasis:names:tc:xacml:1.0:subject:subject-id");
            subjectElement = PolicyCreatorUtil.createRequestSubElement(attributeElementDTO, "Subject", doc);
            if (basicRequestDTO.getUserAttributeId() != null && basicRequestDTO.getUserAttributeId().trim().length() > 0 && basicRequestDTO.getUserAttributeValue() != null && basicRequestDTO.getUserAttributeValue().trim().length() > 0) {
                String[] userAttributeValue = basicRequestDTO.getUserAttributeValue().split(",");
                attributeElementDTO.setAttributeValue(Arrays.asList(userAttributeValue[0]));
                attributeElementDTO.setDataType("http://www.w3.org/2001/XMLSchema#string");
                attributeElementDTO.setAttributeId(basicRequestDTO.getUserAttributeId());
                Element userAttributeElementLocal = PolicyCreatorUtil.createRequestSubElement(attributeElementDTO, "Subject", doc);
                if (userAttributeElementLocal != null) {
                    NodeList list = userAttributeElementLocal.getChildNodes();
                    for (int i = 0; i < list.getLength(); ++i) {
                        subjectElement.appendChild(list.item(i));
                    }
                }
            }
        } else if (basicRequestDTO.getUserAttributeId() != null && basicRequestDTO.getUserAttributeId().trim().length() > 0 && basicRequestDTO.getUserAttributeValue() != null && basicRequestDTO.getUserAttributeValue().trim().length() > 0) {
            subjects = basicRequestDTO.getUserAttributeValue().split(",");
            attributeElementDTO.setAttributeValue(Arrays.asList(subjects[0]));
            attributeElementDTO.setDataType("http://www.w3.org/2001/XMLSchema#string");
            attributeElementDTO.setAttributeId(basicRequestDTO.getUserAttributeId());
            userAttributeElement = PolicyCreatorUtil.createRequestSubElement(attributeElementDTO, "Subject", doc);
        }
        if (basicRequestDTO.getActions() != null && basicRequestDTO.getActions().trim().length() > 0) {
            String[] actions = basicRequestDTO.getActions().split(",");
            attributeElementDTO.setAttributeValue(Arrays.asList(actions));
            attributeElementDTO.setDataType("http://www.w3.org/2001/XMLSchema#string");
            attributeElementDTO.setAttributeId("urn:oasis:names:tc:xacml:1.0:action:action-id");
            actionElement = PolicyCreatorUtil.createRequestSubElement(attributeElementDTO, "Action", doc);
        }
        if (basicRequestDTO.getEnviornement() != null && basicRequestDTO.getEnviornement().trim().length() > 0) {
            String[] enviornement = basicRequestDTO.getEnviornement().split(",");
            attributeElementDTO.setAttributeValue(Arrays.asList(enviornement));
            attributeElementDTO.setDataType("http://www.w3.org/2001/XMLSchema#string");
            attributeElementDTO.setAttributeId("urn:oasis:names:tc:xacml:1.0:environment:environment-id");
            enviornementElement = PolicyCreatorUtil.createRequestSubElement(attributeElementDTO, "Environment", doc);
        }
        if (resourceElement != null) {
            requestElement.appendChild(resourceElement);
        } else {
            requestElement.appendChild(doc.createElement("Resource"));
        }
        if (subjectElement != null) {
            requestElement.appendChild(subjectElement);
        } else {
            requestElement.appendChild(doc.createElement("Subject"));
        }
        if (actionElement != null) {
            requestElement.appendChild(actionElement);
        } else {
            requestElement.appendChild(doc.createElement("Action"));
        }
        if (enviornementElement != null) {
            requestElement.appendChild(enviornementElement);
        } else {
            requestElement.appendChild(doc.createElement("Environment"));
        }
        if (userAttributeElement != null) {
            requestElement.appendChild(userAttributeElement);
        }
        return requestElement;
    }

    public static PolicyElementDTO createPolicyElementDTO(String policy) throws EntitlementPolicyCreationException {
        OMElement omElement;
        PolicyElementDTO policyElementDTO = new PolicyElementDTO();
        try {
            omElement = AXIOMUtil.stringToOM((String)policy);
        }
        catch (XMLStreamException e) {
            throw new EntitlementPolicyCreationException("Policy can not be converted to OMElement");
        }
        if (omElement != null) {
            OMElement descriptionElement;
            policyElementDTO.setPolicyName(omElement.getAttributeValue(new QName("PolicyId")));
            String ruleCombiningAlgorithm = omElement.getAttributeValue(new QName("RuleCombiningAlgId"));
            policyElementDTO.setRuleCombiningAlgorithms(ruleCombiningAlgorithm.split("urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:")[1]);
            Iterator iterator = omElement.getChildrenWithLocalName("Description");
            if (iterator.hasNext() && (descriptionElement = (OMElement)iterator.next()) != null && descriptionElement.getText() != null) {
                policyElementDTO.setPolicyDescription(descriptionElement.getText().trim());
            }
        }
        return policyElementDTO;
    }

    public static List<RuleElementDTO> createRuleElementDTOs(String policy) throws EntitlementPolicyCreationException {
        OMElement omElement;
        ArrayList<RuleElementDTO> ruleElementDTOs = new ArrayList<RuleElementDTO>();
        try {
            omElement = AXIOMUtil.stringToOM((String)policy);
        }
        catch (XMLStreamException e) {
            throw new EntitlementPolicyCreationException("Policy can not be converted to OMElement");
        }
        if (omElement != null) {
            Iterator iterator2 = omElement.getChildrenWithLocalName("Rule");
            while (iterator2.hasNext()) {
                OMElement ruleElement = (OMElement)iterator2.next();
                ruleElementDTOs.add(PolicyCreatorUtil.createRuleDTO(ruleElement));
            }
        }
        return ruleElementDTOs;
    }

    public static TargetElementDTO createTargetElementDTOs(String policy) throws EntitlementPolicyCreationException {
        OMElement omElement;
        TargetElementDTO targetElementDTO = null;
        try {
            omElement = AXIOMUtil.stringToOM((String)policy);
        }
        catch (XMLStreamException e) {
            throw new EntitlementPolicyCreationException("Policy can not be converted to OMElement");
        }
        if (omElement != null) {
            Iterator iterator = omElement.getChildrenWithLocalName("Target");
            while (iterator.hasNext()) {
                OMElement targetElement = (OMElement)iterator.next();
                targetElementDTO = PolicyCreatorUtil.createTargetElementDTO(targetElement, null);
            }
        }
        return targetElementDTO;
    }

    public static BasicTargetElementDTO createBasicTargetElementDTO(String[] policyMetaData) {
        BasicTargetElementDTO basicTargetElementDTO = new BasicTargetElementDTO();
        int i = 0;
        if (policyMetaData[i] != null) {
            basicTargetElementDTO.setFunctionOnResources(policyMetaData[i]);
        }
        if (policyMetaData[++i] != null) {
            basicTargetElementDTO.setResourceList(policyMetaData[i]);
        }
        if (policyMetaData[++i] != null) {
            basicTargetElementDTO.setResourceId(policyMetaData[i]);
        }
        if (policyMetaData[++i] != null) {
            basicTargetElementDTO.setResourceDataType(policyMetaData[i]);
        }
        if (policyMetaData[++i] != null) {
            basicTargetElementDTO.setFunctionOnSubjects(policyMetaData[i]);
        }
        if (policyMetaData[++i] != null) {
            basicTargetElementDTO.setSubjectList(policyMetaData[i]);
        }
        if (policyMetaData[++i] != null) {
            basicTargetElementDTO.setSubjectId(policyMetaData[i]);
        }
        if (policyMetaData[++i] != null) {
            basicTargetElementDTO.setSubjectDataType(policyMetaData[i]);
        }
        if (policyMetaData[++i] != null) {
            basicTargetElementDTO.setAttributeId(policyMetaData[i]);
        }
        if (policyMetaData[++i] != null) {
            basicTargetElementDTO.setFunctionOnAttributes(policyMetaData[i]);
        }
        if (policyMetaData[++i] != null) {
            basicTargetElementDTO.setUserAttributeValue(policyMetaData[i]);
        }
        if (policyMetaData[++i] != null) {
            basicTargetElementDTO.setFunctionOnActions(policyMetaData[i]);
        }
        if (policyMetaData[++i] != null) {
            basicTargetElementDTO.setActionList(policyMetaData[i]);
        }
        if (policyMetaData[++i] != null) {
            basicTargetElementDTO.setActionId(policyMetaData[i]);
        }
        if (policyMetaData[++i] != null) {
            basicTargetElementDTO.setActionDataType(policyMetaData[i]);
        }
        if (policyMetaData[++i] != null) {
            basicTargetElementDTO.setFunctionOnEnvironment(policyMetaData[i]);
        }
        if (policyMetaData[++i] != null) {
            basicTargetElementDTO.setEnvironmentList(policyMetaData[i]);
        }
        if (policyMetaData[++i] != null) {
            basicTargetElementDTO.setEnvironmentId(policyMetaData[i]);
        }
        if (policyMetaData[++i] != null) {
            basicTargetElementDTO.setEnvironmentDataType(policyMetaData[i]);
        }
        if (policyMetaData[++i] != null) {
            basicTargetElementDTO.setSubjectType(policyMetaData[i]);
        }
        return basicTargetElementDTO;
    }

    public static BasicRuleElementDTO createBasicRuleElementDTO(BasicRuleElementDTO basicRuleElementDTO, String[] policyMetaDataForRule) {
        int i = 0;
        if (policyMetaDataForRule[i] != null) {
            basicRuleElementDTO.setFunctionOnResources(policyMetaDataForRule[i]);
        }
        if (policyMetaDataForRule[++i] != null) {
            basicRuleElementDTO.setResourceList(policyMetaDataForRule[i]);
        }
        if (policyMetaDataForRule[++i] != null) {
            basicRuleElementDTO.setResourceId(policyMetaDataForRule[i]);
        }
        if (policyMetaDataForRule[++i] != null) {
            basicRuleElementDTO.setResourceDataType(policyMetaDataForRule[i]);
        }
        if (policyMetaDataForRule[++i] != null) {
            basicRuleElementDTO.setFunctionOnSubjects(policyMetaDataForRule[i]);
        }
        if (policyMetaDataForRule[++i] != null) {
            basicRuleElementDTO.setSubjectList(policyMetaDataForRule[i]);
        }
        if (policyMetaDataForRule[++i] != null) {
            basicRuleElementDTO.setSubjectId(policyMetaDataForRule[i]);
        }
        if (policyMetaDataForRule[++i] != null) {
            basicRuleElementDTO.setSubjectDataType(policyMetaDataForRule[i]);
        }
        if (policyMetaDataForRule[++i] != null) {
            basicRuleElementDTO.setAttributeId(policyMetaDataForRule[i]);
        }
        if (policyMetaDataForRule[++i] != null) {
            basicRuleElementDTO.setFunctionOnAttributes(policyMetaDataForRule[i]);
        }
        if (policyMetaDataForRule[++i] != null) {
            basicRuleElementDTO.setUserAttributeValue(policyMetaDataForRule[i]);
        }
        if (policyMetaDataForRule[++i] != null) {
            basicRuleElementDTO.setFunctionOnActions(policyMetaDataForRule[i]);
        }
        if (policyMetaDataForRule[++i] != null) {
            basicRuleElementDTO.setActionList(policyMetaDataForRule[i]);
        }
        if (policyMetaDataForRule[++i] != null) {
            basicRuleElementDTO.setActionId(policyMetaDataForRule[i]);
        }
        if (policyMetaDataForRule[++i] != null) {
            basicRuleElementDTO.setActionDataType(policyMetaDataForRule[i]);
        }
        if (policyMetaDataForRule[++i] != null) {
            basicRuleElementDTO.setFunctionOnEnvironment(policyMetaDataForRule[i]);
        }
        if (policyMetaDataForRule[++i] != null) {
            basicRuleElementDTO.setEnvironmentList(policyMetaDataForRule[i]);
        }
        if (policyMetaDataForRule[++i] != null) {
            basicRuleElementDTO.setEnvironmentId(policyMetaDataForRule[i]);
        }
        if (policyMetaDataForRule[++i] != null) {
            basicRuleElementDTO.setEnvironmentDataType(policyMetaDataForRule[i]);
        }
        if (policyMetaDataForRule[++i] != null) {
            basicRuleElementDTO.setSubjectType(policyMetaDataForRule[i]);
        }
        return basicRuleElementDTO;
    }

    public static List<BasicRuleElementDTO> createBasicRuleElementDTOs(List<RuleElementDTO> ruleElementDTOs, String[] policyMetaData) {
        int metaDataConstant = 20;
        ArrayList<BasicRuleElementDTO> basicRuleElementDTOs = new ArrayList<BasicRuleElementDTO>();
        int i = metaDataConstant;
        if (ruleElementDTOs != null && ruleElementDTOs.size() > 0) {
            for (RuleElementDTO ruleElementDTO : ruleElementDTOs) {
                if (ruleElementDTO == null) continue;
                BasicRuleElementDTO basicRuleElementDTO = new BasicRuleElementDTO();
                basicRuleElementDTO.setRuleId(ruleElementDTO.getRuleId());
                basicRuleElementDTO.setRuleEffect(ruleElementDTO.getRuleEffect());
                basicRuleElementDTO.setRuleDescription(ruleElementDTO.getRuleDescription());
                String[] policyMetaDataForRule = new String[metaDataConstant];
                int j = 0;
                if (policyMetaData != null) {
                    do {
                        policyMetaDataForRule[j++] = policyMetaData[i++];
                    } while (j != metaDataConstant);
                }
                basicRuleElementDTO = PolicyCreatorUtil.createBasicRuleElementDTO(basicRuleElementDTO, policyMetaDataForRule);
                basicRuleElementDTO.setCompletedRule(true);
                basicRuleElementDTOs.add(basicRuleElementDTO);
            }
        }
        return basicRuleElementDTOs;
    }

    public static String[] createPolicyMetaData(BasicTargetElementDTO basicTargetElementDTO, List<BasicRuleElementDTO> basicRuleElementDTOs, String ruleElementOrder) {
        String[] policyMetaData;
        block5: {
            int metaDataConstant = 20;
            int i = 0;
            policyMetaData = basicRuleElementDTOs != null ? new String[metaDataConstant + basicRuleElementDTOs.size() * metaDataConstant] : new String[metaDataConstant];
            policyMetaData[i++] = basicTargetElementDTO.getFunctionOnResources() != null ? basicTargetElementDTO.getFunctionOnResources() : "equals to";
            policyMetaData[i++] = basicTargetElementDTO.getResourceList();
            policyMetaData[i++] = basicTargetElementDTO.getResourceId();
            policyMetaData[i++] = basicTargetElementDTO.getResourceDataType();
            policyMetaData[i++] = basicTargetElementDTO.getFunctionOnSubjects();
            policyMetaData[i++] = basicTargetElementDTO.getSubjectList();
            policyMetaData[i++] = basicTargetElementDTO.getSubjectId();
            policyMetaData[i++] = basicTargetElementDTO.getSubjectDataType();
            policyMetaData[i++] = basicTargetElementDTO.getAttributeId();
            policyMetaData[i++] = basicTargetElementDTO.getFunctionOnAttributes();
            policyMetaData[i++] = basicTargetElementDTO.getUserAttributeValue();
            policyMetaData[i++] = basicTargetElementDTO.getFunctionOnActions();
            policyMetaData[i++] = basicTargetElementDTO.getActionList();
            policyMetaData[i++] = basicTargetElementDTO.getActionId();
            policyMetaData[i++] = basicTargetElementDTO.getActionDataType();
            policyMetaData[i++] = basicTargetElementDTO.getFunctionOnEnvironment();
            policyMetaData[i++] = basicTargetElementDTO.getEnvironmentList();
            policyMetaData[i++] = basicTargetElementDTO.getEnvironmentId();
            policyMetaData[i++] = basicTargetElementDTO.getEnvironmentDataType();
            policyMetaData[i++] = basicTargetElementDTO.getSubjectType();
            if (basicRuleElementDTOs == null || basicRuleElementDTOs.size() <= 0) break block5;
            if (ruleElementOrder != null && ruleElementOrder.trim().length() > 0) {
                String[] ruleIds;
                for (String ruleId : ruleIds = ruleElementOrder.split(",")) {
                    for (BasicRuleElementDTO basicRuleElementDTO : basicRuleElementDTOs) {
                        if (!ruleId.trim().equals(basicRuleElementDTO.getRuleId())) continue;
                        PolicyCreatorUtil.createPolicyMetaDataForRule(basicRuleElementDTO, policyMetaData, i);
                        i += 20;
                    }
                }
            } else {
                for (BasicRuleElementDTO basicRuleElementDTO : basicRuleElementDTOs) {
                    PolicyCreatorUtil.createPolicyMetaDataForRule(basicRuleElementDTO, policyMetaData, i);
                    i += 20;
                }
            }
        }
        return policyMetaData;
    }

    public static String[] createPolicyMetaDataForRule(BasicRuleElementDTO basicRuleElementDTO, String[] policyMetaData, int currentArrayIndex) {
        int i = currentArrayIndex;
        policyMetaData[i++] = basicRuleElementDTO.getFunctionOnResources();
        policyMetaData[i++] = basicRuleElementDTO.getResourceList();
        policyMetaData[i++] = basicRuleElementDTO.getResourceId();
        policyMetaData[i++] = basicRuleElementDTO.getResourceDataType();
        policyMetaData[i++] = basicRuleElementDTO.getFunctionOnSubjects();
        policyMetaData[i++] = basicRuleElementDTO.getSubjectList();
        policyMetaData[i++] = basicRuleElementDTO.getSubjectId();
        policyMetaData[i++] = basicRuleElementDTO.getSubjectDataType();
        policyMetaData[i++] = basicRuleElementDTO.getAttributeId();
        policyMetaData[i++] = basicRuleElementDTO.getFunctionOnAttributes();
        policyMetaData[i++] = basicRuleElementDTO.getUserAttributeValue();
        policyMetaData[i++] = basicRuleElementDTO.getFunctionOnActions();
        policyMetaData[i++] = basicRuleElementDTO.getActionList();
        policyMetaData[i++] = basicRuleElementDTO.getActionId();
        policyMetaData[i++] = basicRuleElementDTO.getActionDataType();
        policyMetaData[i++] = basicRuleElementDTO.getFunctionOnEnvironment();
        policyMetaData[i++] = basicRuleElementDTO.getEnvironmentList();
        policyMetaData[i++] = basicRuleElementDTO.getEnvironmentId();
        policyMetaData[i++] = basicRuleElementDTO.getEnvironmentDataType();
        policyMetaData[i++] = basicRuleElementDTO.getSubjectType();
        return policyMetaData;
    }

    public static PolicySetDTO createPolicySetDTO(String policySet) throws EntitlementPolicyCreationException {
        OMElement omElement;
        PolicySetDTO policySetDTO = new PolicySetDTO();
        try {
            omElement = AXIOMUtil.stringToOM((String)policySet);
        }
        catch (XMLStreamException e) {
            throw new EntitlementPolicyCreationException("Policy can not be converted to OMElement");
        }
        if (omElement != null) {
            OMElement descriptionElement;
            policySetDTO.setPolicySetId(omElement.getAttributeValue(new QName("PolicySetId")));
            String policyCombiningAlgorithm = omElement.getAttributeValue(new QName("PolicyCombiningAlgId"));
            policySetDTO.setPolicyCombiningAlgId(policyCombiningAlgorithm.split("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:")[1]);
            Iterator iterator1 = omElement.getChildrenWithLocalName("Description");
            if (iterator1.hasNext() && (descriptionElement = (OMElement)iterator1.next()) != null && descriptionElement.getText() != null) {
                policySetDTO.setDescription(descriptionElement.getText().trim());
            }
            Iterator iterator2 = omElement.getChildrenWithLocalName("Policy");
            while (iterator2.hasNext()) {
                OMElement policyElement = (OMElement)iterator2.next();
                if (policyElement == null) continue;
                policySetDTO.setPolicyIds(policyElement.getAttributeValue(new QName("PolicyId")));
            }
            Iterator iterator3 = omElement.getChildrenWithLocalName("PolicySet");
            while (iterator3.hasNext()) {
                OMElement policySetElement = (OMElement)iterator3.next();
                if (policySetElement == null) continue;
                policySetDTO.setPolicyIds(policySetElement.getAttributeValue(new QName("PolicySetId")));
            }
            Iterator iterator4 = omElement.getChildrenWithLocalName("PolicySetIdReference");
            while (iterator4.hasNext()) {
                OMElement policySetReferenceElement = (OMElement)iterator4.next();
                if (policySetReferenceElement == null) continue;
                policySetDTO.setPolicyIds(policySetReferenceElement.getText().trim());
            }
            Iterator iterator5 = omElement.getChildrenWithLocalName("PolicyIdReference");
            while (iterator5.hasNext()) {
                OMElement policyReferenceElement = (OMElement)iterator5.next();
                if (policyReferenceElement == null) continue;
                policySetDTO.setPolicyIds(policyReferenceElement.getText().trim());
            }
        }
        return policySetDTO;
    }

    public static RuleElementDTO createRuleDTO(OMElement omElement) {
        RuleElementDTO ruleElementDTO = new RuleElementDTO();
        if (omElement != null) {
            ruleElementDTO.setRuleId(omElement.getAttributeValue(new QName("RuleId")).trim());
            ruleElementDTO.setRuleEffect(omElement.getAttributeValue(new QName("Effect")).trim());
            Iterator iterator1 = omElement.getChildrenWithLocalName("Description");
            while (iterator1.hasNext()) {
                OMElement descriptionElement = (OMElement)iterator1.next();
                if (descriptionElement == null || descriptionElement.getText() == null) continue;
                ruleElementDTO.setRuleDescription(descriptionElement.getText().trim());
            }
            Iterator iterator2 = omElement.getChildrenWithLocalName("Target");
            while (iterator2.hasNext()) {
                OMElement targetElement = (OMElement)iterator2.next();
                ruleElementDTO.setTargetElementDTO(PolicyCreatorUtil.createTargetElementDTO(targetElement, ruleElementDTO.getRuleId()));
            }
            Iterator iterator3 = omElement.getChildrenWithLocalName("Condition");
            while (iterator3.hasNext()) {
                OMElement conditionElement = (OMElement)iterator3.next();
                ruleElementDTO.setConditionElementDT0(PolicyCreatorUtil.createConditionElementDT0(conditionElement));
            }
        }
        return ruleElementDTO;
    }

    public static ConditionElementDT0 createConditionElementDT0(OMElement omElement) {
        ConditionElementDT0 conditionElementDT0 = new ConditionElementDT0();
        if (omElement != null) {
            Iterator iterator = omElement.getChildrenWithLocalName("Apply");
            while (iterator.hasNext()) {
                OMElement applyElement = (OMElement)iterator.next();
                ApplyElementDTO applyElementDTO = new ApplyElementDTO();
                conditionElementDT0.setApplyElement(PolicyCreatorUtil.createApplyElementDTO(applyElementDTO, applyElement, 0, 0, ""));
            }
        }
        return conditionElementDT0;
    }

    public static ApplyElementDTO createApplyElementDTO(ApplyElementDTO applyElementDTO, OMElement omElement, int applyElementNo, int addApplyElementNo, String applyElementId) {
        if (applyElementDTO == null) {
            applyElementDTO = new ApplyElementDTO();
        }
        if (omElement != null) {
            applyElementId = applyElementId + "/" + ++applyElementNo;
            applyElementDTO.setApplyElementNumber(applyElementNo);
            applyElementDTO.setApplyElementId(applyElementId);
            applyElementDTO.setFunctionId(omElement.getAttributeValue(new QName("FunctionId")));
            Iterator iterator1 = omElement.getChildrenWithLocalName("Apply");
            while (iterator1.hasNext()) {
                OMElement applyElement = (OMElement)iterator1.next();
                ApplyElementDTO elementDTO = PolicyCreatorUtil.createApplyElementDTO(null, applyElement, applyElementNo, addApplyElementNo, applyElementId);
                applyElementNo = elementDTO.getApplyElementNumber() + 1;
                applyElementDTO.setApplyElement(elementDTO);
            }
            Iterator iterator2 = omElement.getChildrenWithLocalName("SubjectAttributeDesignator");
            int attributeDesignatorElementNo = 0;
            while (iterator2.hasNext()) {
                OMElement attributeDesignatorElement = (OMElement)iterator2.next();
                applyElementDTO.setAttributeDesignators(PolicyCreatorUtil.createAttributeDesignatorDTO(attributeDesignatorElement, addApplyElementNo, "Subject", attributeDesignatorElementNo, applyElementId));
                ++attributeDesignatorElementNo;
            }
            Iterator iterator3 = omElement.getChildrenWithLocalName("ResourceAttributeDesignator");
            while (iterator3.hasNext()) {
                OMElement attributeDesignatorElement = (OMElement)iterator3.next();
                applyElementDTO.setAttributeDesignators(PolicyCreatorUtil.createAttributeDesignatorDTO(attributeDesignatorElement, addApplyElementNo, "Resource", 0, applyElementId));
                ++attributeDesignatorElementNo;
            }
            Iterator iterator4 = omElement.getChildrenWithLocalName("ActionAttributeDesignator");
            while (iterator4.hasNext()) {
                OMElement attributeDesignatorElement = (OMElement)iterator4.next();
                applyElementDTO.setAttributeDesignators(PolicyCreatorUtil.createAttributeDesignatorDTO(attributeDesignatorElement, addApplyElementNo, "Action", 0, applyElementId));
                ++attributeDesignatorElementNo;
            }
            Iterator iterator5 = omElement.getChildrenWithLocalName("EnvironmentAttributeDesignator");
            while (iterator5.hasNext()) {
                OMElement attributeDesignatorElement = (OMElement)iterator5.next();
                applyElementDTO.setAttributeDesignators(PolicyCreatorUtil.createAttributeDesignatorDTO(attributeDesignatorElement, addApplyElementNo, "Environment", 0, applyElementId));
                ++attributeDesignatorElementNo;
            }
            Iterator iterator6 = omElement.getChildrenWithLocalName("AttributeValue");
            int attributeValueElementNo = 0;
            while (iterator6.hasNext()) {
                AttributeValueElementDTO attributeValueElementDTO = new AttributeValueElementDTO();
                OMElement attributeValueElement = (OMElement)iterator6.next();
                attributeValueElementDTO.setAttributeDataType(attributeValueElement.getAttributeValue(new QName("DataType")));
                attributeValueElementDTO.setAttributeValue(attributeValueElement.getText());
                attributeValueElementDTO.setApplyElementNumber(addApplyElementNo);
                attributeValueElementDTO.setApplyElementId(applyElementId);
                attributeValueElementDTO.setElementId(attributeValueElementNo);
                applyElementDTO.setAttributeValueElementDTO(attributeValueElementDTO);
                ++attributeValueElementNo;
            }
            Iterator iterator7 = omElement.getChildrenWithLocalName("Function");
            while (iterator7.hasNext()) {
                OMElement functionElement = (OMElement)iterator7.next();
                applyElementDTO.setFunctionFunctionId(functionElement.getAttributeValue(new QName("FunctionId")));
            }
            Iterator iterator8 = omElement.getChildrenWithLocalName("EnvironmentAttributeSelector");
            int attributeSelectorElementNo = 0;
            while (iterator8.hasNext()) {
                OMElement attributeSelectorElement = (OMElement)iterator8.next();
                applyElementDTO.setAttributeSelectors(PolicyCreatorUtil.createAttributeSelectorDTO(attributeSelectorElement, addApplyElementNo, attributeSelectorElementNo, applyElementId));
                ++attributeSelectorElementNo;
            }
            applyElementDTO.setAttributeValueElementCount(attributeValueElementNo);
            applyElementDTO.setAttributeDesignatorsElementCount(attributeDesignatorElementNo);
            applyElementDTO.setAttributeSelectorElementCount(attributeSelectorElementNo);
        }
        return applyElementDTO;
    }

    public static TargetElementDTO createTargetElementDTO(OMElement omElement, String ruleId) {
        TargetElementDTO targetElementDTO = new TargetElementDTO();
        ArrayList<SubElementDTO> subElementDTOs = new ArrayList<SubElementDTO>();
        int subElementId = 0;
        if (omElement != null) {
            OMElement resourceElement;
            OMElement element;
            if (omElement.getChildrenWithLocalName("Resources").hasNext()) {
                element = (OMElement)omElement.getChildrenWithLocalName("Resources").next();
                Iterator iterator1 = element.getChildrenWithLocalName("Resource");
                while (iterator1.hasNext()) {
                    resourceElement = (OMElement)iterator1.next();
                    subElementDTOs.add(PolicyCreatorUtil.createSubElementDTO(resourceElement, ruleId, "Resource", subElementId));
                    ++subElementId;
                }
            }
            if (omElement.getChildrenWithLocalName("Subjects").hasNext()) {
                element = (OMElement)omElement.getChildrenWithLocalName("Subjects").next();
                Iterator iterator2 = element.getChildrenWithLocalName("Subject");
                while (iterator2.hasNext()) {
                    resourceElement = (OMElement)iterator2.next();
                    subElementDTOs.add(PolicyCreatorUtil.createSubElementDTO(resourceElement, ruleId, "Subject", subElementId));
                    ++subElementId;
                }
            }
            if (omElement.getChildrenWithLocalName("Actions").hasNext()) {
                element = (OMElement)omElement.getChildrenWithLocalName("Actions").next();
                Iterator iterator3 = element.getChildrenWithLocalName("Action");
                while (iterator3.hasNext()) {
                    resourceElement = (OMElement)iterator3.next();
                    subElementDTOs.add(PolicyCreatorUtil.createSubElementDTO(resourceElement, ruleId, "Action", subElementId));
                    ++subElementId;
                }
            }
            if (omElement.getChildrenWithLocalName("Subjects").hasNext()) {
                element = (OMElement)omElement.getChildrenWithLocalName("Subjects").next();
                Iterator iterator4 = element.getChildrenWithLocalName("Environment");
                while (iterator4.hasNext()) {
                    resourceElement = (OMElement)iterator4.next();
                    subElementDTOs.add(PolicyCreatorUtil.createSubElementDTO(resourceElement, ruleId, "Environment", subElementId));
                    ++subElementId;
                }
            }
        }
        targetElementDTO.setSubElementDTOs(subElementDTOs);
        targetElementDTO.setSubElementCount(subElementId);
        return targetElementDTO;
    }

    public static SubElementDTO createSubElementDTO(OMElement omElement, String ruleId, String subElementName, int subElementId) {
        SubElementDTO subElementDTO = new SubElementDTO();
        subElementDTO.setElementName(subElementName);
        subElementDTO.setElementId(subElementId);
        subElementDTO.setRuleId(ruleId);
        int matchElementId = 0;
        if (omElement != null) {
            Iterator iterator1 = omElement.getChildrenWithLocalName(subElementName + "Match");
            while (iterator1.hasNext()) {
                MatchElementDTO matchElementDTO = new MatchElementDTO();
                OMElement matchElement = (OMElement)iterator1.next();
                matchElementDTO.setMatchElementName(subElementName);
                matchElementDTO.setElementId(matchElementId);
                matchElementDTO.setRuleElementName(ruleId);
                matchElementDTO.setMatchId(matchElement.getAttributeValue(new QName("MatchId")));
                Iterator iterator2 = matchElement.getChildrenWithLocalName(subElementName + "AttributeDesignator");
                while (iterator2.hasNext()) {
                    OMElement attributeDesignatorElement = (OMElement)iterator2.next();
                    matchElementDTO.setAttributeDesignatorDTO(PolicyCreatorUtil.createAttributeDesignatorDTO(attributeDesignatorElement, 0, subElementName, 0, ""));
                }
                Iterator iterator3 = matchElement.getChildrenWithLocalName("AttributeValue");
                while (iterator3.hasNext()) {
                    AttributeValueElementDTO attributeValueElementDTO = new AttributeValueElementDTO();
                    OMElement attributeValueElement = (OMElement)iterator3.next();
                    attributeValueElementDTO.setAttributeDataType(attributeValueElement.getAttributeValue(new QName("DataType")));
                    attributeValueElementDTO.setAttributeValue(attributeValueElement.getText());
                    matchElementDTO.setAttributeValueElementDTO(attributeValueElementDTO);
                }
                Iterator iterator4 = matchElement.getChildrenWithLocalName(subElementName + "AttributeSelector");
                while (iterator4.hasNext()) {
                    OMElement attributeSelectorElement = (OMElement)iterator4.next();
                    matchElementDTO.setAttributeSelectorDTO(PolicyCreatorUtil.createAttributeSelectorDTO(attributeSelectorElement, 0, 0, ""));
                }
                ++matchElementId;
                subElementDTO.setMatchElementDTOs(matchElementDTO);
            }
        }
        subElementDTO.setMatchElementCount(matchElementId);
        return subElementDTO;
    }

    public static AttributeDesignatorDTO createAttributeDesignatorDTO(OMElement omElement, int applyElementNo, String elementName, int matchElementId, String applyElementId) {
        AttributeDesignatorDTO attributeDesignatorDTO = new AttributeDesignatorDTO();
        if (omElement != null) {
            attributeDesignatorDTO.setAttributeId(omElement.getAttributeValue(new QName("AttributeId")));
            attributeDesignatorDTO.setDataType(omElement.getAttributeValue(new QName("DataType")));
            attributeDesignatorDTO.setIssuer(omElement.getAttributeValue(new QName("Issuer")));
            attributeDesignatorDTO.setMustBePresent(omElement.getAttributeValue(new QName("MustBePresent")));
            attributeDesignatorDTO.setApplyElementNumber(applyElementNo);
            attributeDesignatorDTO.setElementName(elementName);
            attributeDesignatorDTO.setElementId(matchElementId);
            attributeDesignatorDTO.setApplyElementId(applyElementId);
        }
        return attributeDesignatorDTO;
    }

    public static AttributeSelectorDTO createAttributeSelectorDTO(OMElement omElement, int applyElementNo, int attributeSelectorElementNo, String applyElementId) {
        AttributeSelectorDTO attributeSelectorDTO = new AttributeSelectorDTO();
        if (omElement != null) {
            attributeSelectorDTO.setAttributeSelectorDataType(omElement.getAttributeValue(new QName("DataType")));
            attributeSelectorDTO.setAttributeSelectorRequestContextPath(omElement.getAttributeValue(new QName("RequestContextPath")));
            attributeSelectorDTO.setAttributeSelectorMustBePresent(omElement.getAttributeValue(new QName("MustBePresent")));
            attributeSelectorDTO.setApplyElementNumber(applyElementNo);
            attributeSelectorDTO.setElementNumber(attributeSelectorElementNo);
            attributeSelectorDTO.setApplyElementId(applyElementId);
        }
        return attributeSelectorDTO;
    }

    public static int getAttributeValueElementCount(ApplyElementDTO applyElementDTO, int attributeValueElementNumber) {
        attributeValueElementNumber = applyElementDTO.getAttributeValueElementCount();
        List<ApplyElementDTO> applyElementDTOs = applyElementDTO.getApplyElements();
        for (ApplyElementDTO elementDTO : applyElementDTOs) {
            attributeValueElementNumber += PolicyCreatorUtil.getAttributeValueElementCount(elementDTO, attributeValueElementNumber);
        }
        return attributeValueElementNumber;
    }

    public static int getAttributeDesignatorElementCount(ApplyElementDTO applyElementDTO, int attributeDesignatorElementNumber) {
        attributeDesignatorElementNumber += applyElementDTO.getAttributeDesignatorsElementCount();
        List<ApplyElementDTO> applyElementDTOs = applyElementDTO.getApplyElements();
        for (ApplyElementDTO elementDTO : applyElementDTOs) {
            attributeDesignatorElementNumber += PolicyCreatorUtil.getAttributeDesignatorElementCount(elementDTO, attributeDesignatorElementNumber);
        }
        return attributeDesignatorElementNumber;
    }

    public static int getAttributeSelectorElementCount(ApplyElementDTO applyElementDTO, int attributeSelectorElementNumber) {
        attributeSelectorElementNumber += applyElementDTO.getAttributeSelectorElementCount();
        List<ApplyElementDTO> applyElementDTOs = applyElementDTO.getApplyElements();
        for (ApplyElementDTO elementDTO : applyElementDTOs) {
            attributeSelectorElementNumber += PolicyCreatorUtil.getAttributeSelectorElementCount(elementDTO, attributeSelectorElementNumber);
        }
        return attributeSelectorElementNumber;
    }

    public static Element createPolicySetElement(PolicySetDTO policySetDTO, Document doc) throws EntitlementPolicyCreationException {
        Element policySetElement = doc.createElement("PolicySet");
        Element targetElement = null;
        policySetElement.setAttribute("xmlns", "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17");
        if (policySetDTO.getPolicySetId() != null && policySetDTO.getPolicySetId().trim().length() > 0) {
            policySetElement.setAttribute("PolicySetId", policySetDTO.getPolicySetId());
        }
        if (policySetDTO.getPolicyCombiningAlgId() != null && policySetDTO.getPolicyCombiningAlgId().trim().length() > 0) {
            policySetElement.setAttribute("PolicyCombiningAlgId", "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:" + policySetDTO.getPolicyCombiningAlgId());
        }
        Element descriptionElement = doc.createElement("Description");
        if (policySetDTO.getDescription() != null && policySetDTO.getDescription().trim().length() > 0) {
            descriptionElement.setTextContent(policySetDTO.getDescription());
            policySetElement.appendChild(descriptionElement);
        } else {
            String description = "This is " + policySetDTO.getPolicySetId() + " policy set";
            descriptionElement.setTextContent(description);
            policySetElement.appendChild(descriptionElement);
        }
        if (policySetDTO.getTargetElementDTO() != null && policySetDTO.getTargetElementDTO().getSubElementDTOs() != null) {
            if (policySetDTO.getTargetElementDTO().getSubElementDTOs().size() > 0) {
                targetElement = PolicyCreatorUtil.createTargetElement(policySetDTO.getTargetElementDTO().getSubElementDTOs(), doc);
            }
        } else if (policySetDTO.getBasicTargetElementDTO() != null) {
            targetElement = PolicyCreatorUtil.createBasicTargetElementDTO(policySetDTO.getBasicTargetElementDTO(), doc);
        }
        if (targetElement != null) {
            policySetElement.appendChild(targetElement);
        } else {
            targetElement = doc.createElement("Target");
            policySetElement.appendChild(targetElement);
        }
        if (policySetDTO.getPolicyIdReferences() != null && policySetDTO.getPolicyIdReferences().size() > 0) {
            for (String policeReferences : policySetDTO.getPolicyIdReferences()) {
                Element policeReferencesElement = doc.createElement("PolicyIdReference");
                policeReferencesElement.setTextContent(policeReferences);
                policySetElement.appendChild(policeReferencesElement);
            }
        }
        if (policySetDTO.getPolicySetIdReferences() != null && policySetDTO.getPolicySetIdReferences().size() > 0) {
            for (String policeSetReferences : policySetDTO.getPolicySetIdReferences()) {
                Element policeSetReferencesElement = doc.createElement("PolicySetIdReference");
                policeSetReferencesElement.setTextContent(policeSetReferences);
                policySetElement.appendChild(policeSetReferencesElement);
            }
        }
        return policySetElement;
    }

    public static String getStringFromDocument(Document doc) throws EntitlementPolicyCreationException {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString().substring(writer.toString().indexOf(62) + 1);
        }
        catch (TransformerException e) {
            throw new EntitlementPolicyCreationException("While transforming policy element to String", e);
        }
    }

    private static String getFunctionId(String functionName) {
        String functionId = functionName.equals("matching reg-ex to") ? "urn:oasis:names:tc:xacml:1.0:function:string-regexp-match" : (functionName.equals("in") ? "urn:oasis:names:tc:xacml:1.0:function:string-is-in" : (functionName.equals("a matching set of") ? "urn:oasis:names:tc:xacml:1.0:function:string-set-equals" : (functionName.equals("a sub set of") ? "urn:oasis:names:tc:xacml:1.0:function:string-subset" : (functionName.equals("at-least-one-member-of") ? "urn:oasis:names:tc:xacml:1.0:function:string-at-least-one-member-of" : "urn:oasis:names:tc:xacml:1.0:function:string-equal"))));
        return functionId;
    }
}

