/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.ui.client;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.llom.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.entitlement.stub.EntitlementServiceStub;

public class EntitlementServiceClient {
    private EntitlementServiceStub stub;
    private static final Log log = LogFactory.getLog(EntitlementServiceClient.class);

    public EntitlementServiceClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "EntitlementService";
        this.stub = new EntitlementServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public String getDecision(String request) throws AxisFault {
        try {
            if (request != null) {
                request = request.trim().replaceAll("&lt;", "<");
                request = request.trim().replaceAll("&gt;", ">");
            }
            return this.getStatus(this.stub.getDecision(request));
        }
        catch (Exception e) {
            this.handleException("Error occurred while policy evaluation", e);
            return null;
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    private String getStatus(String xmlstring) throws Exception {
        OMElement response = null;
        OMElement result = null;
        OMElement decision = null;
        response = AXIOMUtil.stringToOM((String)xmlstring);
        result = response.getFirstChildWithName(new QName("Result"));
        if (result != null && (decision = result.getFirstChildWithName(new QName("Decision"))) != null) {
            return decision.getText();
        }
        return "Invalid Status";
    }
}

