/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.ui;

import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.carbon.identity.entitlement.ui.EntitlementPolicyCreationException;
import org.wso2.carbon.identity.entitlement.ui.PolicyEditorException;
import org.wso2.carbon.identity.entitlement.ui.dto.BasicRequestDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.BasicTargetDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.PolicyElementDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.PolicySetDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.RuleDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.RuleElementDTO;
import org.wso2.carbon.identity.entitlement.ui.dto.SubElementDTO;
import org.wso2.carbon.identity.entitlement.ui.util.PolicyCreatorUtil;
import org.wso2.carbon.identity.entitlement.ui.util.PolicyEditorUtil;

public class EntitlementPolicyCreator {
    public String createPolicy(PolicyElementDTO policyElementDTO, List<SubElementDTO> subElementDTOs, List<RuleElementDTO> ruleElementDTOs) throws EntitlementPolicyCreationException {
        block13: {
            Element policyElement = null;
            String ruleElementOrder = null;
            try {
                Document doc = this.createNewDocument();
                if (doc == null) break block13;
                if (policyElementDTO != null) {
                    policyElement = PolicyCreatorUtil.createPolicyElement(policyElementDTO, doc);
                    doc.appendChild(policyElement);
                    ruleElementOrder = policyElementDTO.getRuleElementOrder();
                }
                if (policyElementDTO != null) {
                    if (subElementDTOs != null && subElementDTOs.size() > 0) {
                        policyElement.appendChild(PolicyCreatorUtil.createTargetElement(subElementDTOs, doc));
                    } else if (ruleElementDTOs != null && ruleElementDTOs.size() > 0) {
                        policyElement.appendChild(doc.createElement("Target"));
                    }
                    if (ruleElementDTOs != null && ruleElementDTOs.size() > 0) {
                        if (ruleElementOrder != null && ruleElementOrder.trim().length() > 0) {
                            String[] ruleIds;
                            for (String ruleId : ruleIds = ruleElementOrder.split(",")) {
                                for (RuleElementDTO ruleElementDTO : ruleElementDTOs) {
                                    if (!ruleId.trim().equals(ruleElementDTO.getRuleId())) continue;
                                    policyElement.appendChild(PolicyCreatorUtil.createRuleElement(ruleElementDTO, doc));
                                }
                            }
                        } else {
                            for (RuleElementDTO ruleElementDTO : ruleElementDTOs) {
                                policyElement.appendChild(PolicyCreatorUtil.createRuleElement(ruleElementDTO, doc));
                            }
                        }
                    }
                }
                return PolicyCreatorUtil.getStringFromDocument(doc);
            }
            catch (EntitlementPolicyCreationException e) {
                throw new EntitlementPolicyCreationException("Error While Creating XACML Policy", e);
            }
        }
        return null;
    }

    public String createBasicPolicy(PolicyElementDTO policyElementDTO, List<RuleDTO> ruleDTOs, BasicTargetDTO targetDTO) throws EntitlementPolicyCreationException {
        block14: {
            Element policyElement = null;
            String ruleElementOrder = null;
            try {
                Document doc = this.createNewDocument();
                if (doc == null) break block14;
                if (policyElementDTO != null) {
                    policyElement = PolicyCreatorUtil.createPolicyElement(policyElementDTO, doc);
                    doc.appendChild(policyElement);
                    ruleElementOrder = policyElementDTO.getRuleElementOrder();
                }
                if (policyElement != null) {
                    if (targetDTO != null) {
                        policyElement.appendChild(PolicyEditorUtil.createTarget(targetDTO, doc));
                    } else if (ruleDTOs != null && ruleDTOs.size() > 0) {
                        policyElement.appendChild(doc.createElement("Target"));
                    }
                    if (ruleDTOs != null && ruleDTOs.size() > 0) {
                        if (ruleElementOrder != null && ruleElementOrder.trim().length() > 0) {
                            String[] ruleIds;
                            for (String ruleId : ruleIds = ruleElementOrder.split(",")) {
                                for (RuleDTO ruleDTO : ruleDTOs) {
                                    if (!ruleId.trim().equals(ruleDTO.getRuleId())) continue;
                                    policyElement.appendChild(PolicyEditorUtil.createRule(ruleDTO, doc));
                                }
                            }
                        } else {
                            for (RuleDTO ruleDTO : ruleDTOs) {
                                policyElement.appendChild(PolicyEditorUtil.createRule(ruleDTO, doc));
                            }
                        }
                    }
                }
                return PolicyCreatorUtil.getStringFromDocument(doc);
            }
            catch (EntitlementPolicyCreationException e) {
                throw new EntitlementPolicyCreationException("Error While Creating XACML Policy", e);
            }
            catch (PolicyEditorException e) {
                throw new EntitlementPolicyCreationException("Error While Creating XACML Policy", e);
            }
        }
        return null;
    }

    public String createPolicySet(PolicySetDTO policySetDTO) throws EntitlementPolicyCreationException {
        try {
            Document doc = this.createNewDocument();
            if (doc != null) {
                doc.appendChild(PolicyCreatorUtil.createPolicySetElement(policySetDTO, doc));
                StringBuilder policySet = new StringBuilder(PolicyCreatorUtil.getStringFromDocument(doc));
                if (policySetDTO.getPolicies() != null) {
                    for (String policy : policySetDTO.getPolicies()) {
                        policySet.insert(policySet.indexOf(">") + 1, policy);
                    }
                }
                return policySet.toString();
            }
        }
        catch (EntitlementPolicyCreationException e) {
            throw new EntitlementPolicyCreationException("Error While Creating Policy Set", e);
        }
        return null;
    }

    public String createBasicRequest(BasicRequestDTO basicRequestDTO) throws EntitlementPolicyCreationException {
        try {
            Document doc = this.createNewDocument();
            if (doc != null) {
                doc.appendChild(PolicyCreatorUtil.createBasicRequestElement(basicRequestDTO, doc));
                return PolicyCreatorUtil.getStringFromDocument(doc);
            }
        }
        catch (EntitlementPolicyCreationException e) {
            throw new EntitlementPolicyCreationException("Error While Creating XACML Request", e);
        }
        return null;
    }

    private Document createNewDocument() throws EntitlementPolicyCreationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilder = docFactory.newDocumentBuilder();
            doc = docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new EntitlementPolicyCreationException("While creating Document Object", e);
        }
        return doc;
    }
}

