/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.ui.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationEngine;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.entitlement.ui.EntitlementPolicyCreationException;

public class PolicyAttributeFinderUtil {
    private static final Log log = LogFactory.getLog(PolicyAttributeFinderUtil.class);

    public static List<String> getOperationListFromServiceUri(String serviceUri) throws AxisFault, EntitlementPolicyCreationException {
        ArrayList<String> operationList = new ArrayList<String>();
        CodeGenConfiguration codeGenConfiguration = null;
        AxisService axisService = null;
        try {
            CodeGenerationEngine codeGenerationEngine = new CodeGenerationEngine(codeGenConfiguration);
            Definition wsdl4jDef = codeGenerationEngine.readInTheWSDLFile(serviceUri + "?wsdl");
            WSDL11ToAxisServiceBuilder wsdl11ToAxisServiceBuilder = new WSDL11ToAxisServiceBuilder(wsdl4jDef, null, null, false);
            axisService = wsdl11ToAxisServiceBuilder.populateService();
        }
        catch (WSDLException e) {
            log.warn((Object)("Operation List can not be created for given wsdl uri  " + serviceUri + "?wsdl"));
        }
        catch (CodeGenerationException e) {
            log.warn((Object)("Operation List can not be created for given wsdl uri  " + serviceUri + "?wsdl"));
        }
        if (axisService != null) {
            Iterator iterator = axisService.getOperations();
            while (iterator.hasNext()) {
                AxisOperation operation = (AxisOperation)iterator.next();
                operationList.add(operation.getName().getLocalPart());
            }
        }
        return operationList;
    }
}

