/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.ui.client;

import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.entitlement.stub.EntitlementPolicyAdminServiceStub;
import org.wso2.carbon.identity.entitlement.stub.dto.EntitledResultSetDTO;
import org.wso2.carbon.identity.entitlement.stub.dto.PaginatedPolicySetDTO;
import org.wso2.carbon.identity.entitlement.stub.dto.PolicyAttributeDTO;
import org.wso2.carbon.identity.entitlement.stub.dto.PolicyDTO;

public class EntitlementPolicyAdminServiceClient {
    private EntitlementPolicyAdminServiceStub stub;
    private static final Log log = LogFactory.getLog(EntitlementPolicyAdminServiceClient.class);

    public EntitlementPolicyAdminServiceClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "EntitlementPolicyAdminService";
        this.stub = new EntitlementPolicyAdminServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public PaginatedPolicySetDTO getAllPolicies(String policyTypeFilter, String policySearchString, int pageNumber) throws AxisFault {
        try {
            return this.stub.getAllPolicies(policyTypeFilter, policySearchString, pageNumber);
        }
        catch (Exception e) {
            String message = "Error while loading all policies from backend service";
            this.handleException(message, e);
            PaginatedPolicySetDTO paginatedPolicySetDTO = new PaginatedPolicySetDTO();
            paginatedPolicySetDTO.setPolicySet(new PolicyDTO[0]);
            return paginatedPolicySetDTO;
        }
    }

    public PolicyDTO getPolicy(String policyId) throws AxisFault {
        PolicyDTO dto = null;
        try {
            dto = this.stub.getPolicy(policyId);
            dto.setPolicy(dto.getPolicy().trim().replaceAll("><", ">\n<"));
        }
        catch (Exception e) {
            String message = "Error while loading the policy from backend service";
            this.handleException(message, e);
        }
        return dto;
    }

    public PolicyDTO getLightPolicy(String policyId) throws AxisFault {
        PolicyDTO dto = null;
        try {
            dto = this.stub.getLightPolicy(policyId);
        }
        catch (Exception e) {
            String message = "Error while loading the policy from backend service";
            this.handleException(message, e);
        }
        return dto;
    }

    public PolicyDTO getMetaDataPolicy(String policyId) throws AxisFault {
        PolicyDTO dto = null;
        try {
            dto = this.stub.getMetaDataPolicy(policyId);
        }
        catch (Exception e) {
            String message = "Error while loading the policy from backend service";
            this.handleException(message, e);
        }
        return dto;
    }

    public void removePolicy(PolicyDTO policy) throws AxisFault {
        try {
            this.stub.removePolicy(policy);
        }
        catch (Exception e) {
            String message = "Error while removing the policy from backend service";
            this.handleException(message, e);
        }
    }

    public void updatePolicy(PolicyDTO policy) throws AxisFault {
        try {
            if (policy.getPolicy() != null && policy.getPolicy().trim().length() > 0) {
                policy.setPolicy(policy.getPolicy().trim().replaceAll(">\\s+<", "><"));
            }
            this.stub.updatePolicy(policy);
        }
        catch (Exception e) {
            String message = "Error while updating the policy at the backend service";
            this.handleException(message, e);
        }
    }

    public void addPolicy(PolicyDTO policy) throws AxisFault {
        try {
            policy.setPolicy(policy.getPolicy().trim().replaceAll(">\\s+<", "><"));
            this.stub.addPolicy(policy);
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.handleException(message, e);
        }
    }

    public void uploadPolicy(String content) throws AxisFault {
        PolicyDTO dto = new PolicyDTO();
        dto.setPolicy(content);
        dto.setPolicy(dto.getPolicy().trim().replaceAll(">\\s+<", "><"));
        try {
            this.stub.addPolicy(dto);
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.handleException(message, e);
        }
    }

    public void importPolicyFromRegistry(String policyRegistryPath) throws AxisFault {
        try {
            this.stub.importPolicyFromRegistry(policyRegistryPath);
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.handleException(message, e);
        }
    }

    public void clearDecisionCache() throws AxisFault {
        try {
            this.stub.clearDecisionCache();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.handleException(message, e);
        }
    }

    public void clearAttributeCache() throws AxisFault {
        try {
            this.stub.clearAllAttributeCaches();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.handleException(message, e);
        }
    }

    public String[] getEntitlementPolicyDataFromRegistry(String resourceName) throws AxisFault {
        try {
            return this.stub.getEntitlementPolicyDataFromRegistry(resourceName);
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.handleException(message, e);
            return null;
        }
    }

    public String[] getAllPolicyIds() throws AxisFault {
        try {
            return this.stub.getAllPolicyIds();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.handleException(message, e);
            return null;
        }
    }

    public String getGlobalPolicyAlgorithm() throws AxisFault {
        try {
            return this.stub.getGlobalPolicyAlgorithm();
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public void setGlobalPolicyAlgorithm(String policyAlgorithm) throws AxisFault {
        try {
            this.stub.setGlobalPolicyAlgorithm(policyAlgorithm);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    private List parseRequest(ServletRequestContext requestContext) throws FileUploadException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        return upload.parseRequest((RequestContext)requestContext);
    }

    public EntitledResultSetDTO getEntitledAttributes(String subjectName, String resourceName, String subjectId, String action, boolean enableChildSearch, boolean useApplicablePolices) throws AxisFault {
        try {
            return this.stub.getEntitledAttributes(subjectName, resourceName, subjectId, action, enableChildSearch, useApplicablePolices);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public PolicyAttributeDTO[] getPolicyAttributeValues() throws AxisFault {
        try {
            return this.stub.getPolicyAttributeValues();
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

